<?php
   require_once("../session_check.php");
    require_once("../../classes/main_classes.php");

    //OBJECTS
    $retrieveObj=new RETRIEVE();
    $rowcountObj=new ROWCOUNT();
    $allrowcountObj=new ALLROWCOUNT();

    $get_contact_us=$retrieveObj->retriever("contact_us ORDER BY c_id DESC LIMIT 5","*","fetchAll");
    $get_contact_us_count=$allrowcountObj->allrowcounter("contact_us","*");

    $get_enquiries=$retrieveObj->retriever("enquiries ORDER BY e_id DESC LIMIT 5","*","fetchAll");
    $get_enquiries_count=$allrowcountObj->allrowcounter("enquiries","*");
?>

<!-- Page Heading -->
<div class="px-2 py-3 mb-4" style="background-color: white;">
  <h4 class="lead bg-white mb-0">
    <span class="fas fa-fw fa-tachometer-alt"></span>
    Dashboard
  </h4>
</div>

<!-- Content Row -->
<div class="row">

  <!-- Earnings (Monthly) Card Example -->
  <div class="col-xl-4 col-md-4 mb-4">
    <div class="card border-left-primary shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
             Users
            </div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">
               <?php echo $allrowcountObj->allrowcounter("users","*"); ?>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-users fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Earnings (Monthly) Card Example -->
  <div class="col-xl-4 col-md-4 mb-4">
    <div class="card border-left-success shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Enquiries</div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">
              <?php echo $allrowcountObj->allrowcounter("enquiries","*"); ?>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-info-circle fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Earnings (Monthly) Card Example -->
  <div class="col-xl-4 col-md-4 mb-4">
    <div class="card border-left-info shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Contact Messages</div>
            <div class="row no-gutters align-items-center">
              <div class="col-auto">
                <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">
                  <?php echo $allrowcountObj->allrowcounter("contact_us","*"); ?>
                </div>
              </div>
            </div>
          </div>
          <div class="col-auto">
            <i class="fas fa-envelope fa-2x text-gray-300"></i>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Content Row -->

<div class="row">

  <!-- Area Chart -->
  <div class="col-xl-8 col-lg-7">
    
  </div>

  <!-- Pie Chart -->
  <div class="col-xl-4 col-lg-5">
    
  </div>
</div>

<!-- Content Row -->
<div class="row">

  <!-- Content Column -->
  <div class="col-lg-6 mb-4">
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold text-primary">Recent contacts</h6>
        </div>
        <div class="card-body">
          <div class="table-responsive">
              <?php
                if($get_contact_us!="1020"){
              ?>
                <table class="table table-striped">
              <?php
                  foreach ($get_contact_us as $contact_us) {
              ?>
                    <tr class="hand_cursor" onclick="not_contact_us_details_view(<?php echo $contact_us->c_id ?>)">
                      <td>
                        <span><?php echo $contact_us->name; ?></span><br>
                        <span class="text-muted">
                          <?php echo $contact_us->email; ?>
                        </span>
                      </td>
                    </tr>
              <?php
                  }
              ?>
                </table>
              <?php
                }else{
                  echo "<p class='alert alert-info text-center'>There are no contacts currently.</p>";
                }
              ?>    
          </div>
        </div>
        <?php
          if($get_contact_us_count>5){
        ?>
            <div class="text-center card-footer">
              <a href="#" onclick="contact_us_view()">View All</a>
            </div>
        <?php
          }
        ?>
      </div>

  </div>

  <!-- Content Column -->
  <div class="col-lg-6 mb-4">
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold text-primary">Recent enquiries</h6>
        </div>
        <div class="card-body">
          <div class="table-responsive">
              <?php
                if($get_enquiries!="1020"){
              ?>
                <table class="table table-striped">
              <?php
                  foreach ($get_enquiries as $enquiries) {
              ?>
                    <tr class="hand_cursor" onclick="not_enquiries_details_view(<?php echo $enquiries->e_id ?>)">
                      <td>
                        <strong class="text-uppercase"><?php echo $enquiries->e_type; ?></strong><br>
                        <span><?php echo $enquiries->e_fullname; ?></span><br>
                        <span class="text-muted">
                          <?php echo $enquiries->e_email; ?>
                        </span>
                      </td>
                    </tr>
              <?php
                  }
              ?>
                </table>
              <?php
                }else{
                  echo "<p class='alert alert-info text-center'>There are no enquiries currently.</p>";
                }
              ?>    
          </div>
        </div>
        <?php
          if($get_enquiries_count>5){
        ?>
            <div class="text-center card-footer">
              <a href="#" onclick="contact_us_view()">View All</a>
            </div>
        <?php
          }
        ?>
      </div>

  </div>
</div>
