<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_users=$retrieveObj->retriever("users 
      JOIN user_roles ON user_roles.user_id=users.user_id
      JOIN user_role ON user_roles.role_id=user_role.role_id
      WHERE users.status='active'
      GROUP BY users.user_id ORDER BY users.user_id DESC","DISTINCT *","fetchAll");
?>

<!-- Page Heading -->
<div class="px-2 py-3 mb-4" style="background-color: white;">
  <h4 class="lead bg-white mb-0">
    <span class="fas fa-users"></span>
    Users
  </h4>
</div>

<!-- Content Row -->
<div class="row">
  <div class="col-md-12">
    <p class="font-weight-bold text-right">
      <?php
        if($user_in_type=="su_admin"){
      ?>
        <a href="#!" class="text-primary font-weight-normal mx-2" onclick="add_user_view()"><span class="fas fa-plus"></span> Add user</a>
        <a href="#!" class="text-danger font-weight-normal mx-2" onclick="users_trash_view()"><span class="fas fa-trash"></span> Removed users</a>
      <?php
        }
      ?>
    </p>

    
    
    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">System users</h6>
      </div>
      <div class="card-body">
        <div id="delete_user_response"></div>
        <div class="table-responsive">
          <table class="table mt-4" id="users_table">
            <thead>
              <tr class="">
                        <th scope="col">Profile Image</th>
                        <th scope="col">Firstname</th>
                        <th scope="col">Lastname</th>
                        <th scope="col">Username</th>
                        <th scope="col">Email</th>
                        <th scope="col">User role</th>
                        <th scope="col"></th>
                      </tr>
            </thead>
            <tbody>
              <?php
                          
                if($get_users!="1020"){
                  $element_id="element_id";
                    foreach ($get_users as $user) {
                      $element_id=$element_id."Ot";
              ?>  
                  <tr id="<?php echo $element_id ?>">         
                    <td class="text-center">
                      <?php
                        if(!empty($user->photo)){
                          echo $image='<img class="m-1" style="max-height:40px;" src="../img/profile_pictures/'.$user->photo.'?timestamp'.time().'" alt="Profile img"/>';
                        }else{
                          echo "<span class='fas fa-user fa-2x'></span>";
                        }
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $user->firstname;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $user->lastname;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $user->username;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $user->email;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $user->user_role;
                      ?>
                    </td>
                    <td id="<?php echo $element_id.'Dbtn' ?>">
                    <?php
                      if($user_in_type=="su_admin" and !($user_id==$user->user_id)){
                    ?>
                        <div class="">
                          <button title="Edit" class="btn btn-success hand_cursor" onclick="edit_user_view(<?php echo $user->user_id ?>)"><span class="fas fa-edit"></span> Edit</button>
                          <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                              <input type="hidden" name="delete_user_note" value="<?php echo $user->user_id; ?>">
                              <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_user('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','delete_user_response')" type="submit" title="Delete" class="btn btn-warning text-light hand_cursor"><span class="fas fa-trash"></span> Remove</button>
                          </form>
                          
                        </div>
                    <?php
                      }
                    ?>
                        
                    </td>
                  </tr>
                <?php
                    }
                  }
                ?>
              
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [6]} 
      ]
    });
  })
</script>