<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_users=$retrieveObj->retriever("users 
      JOIN user_roles ON user_roles.user_id=users.user_id
      JOIN user_role ON user_roles.role_id=user_role.role_id
      WHERE users.status='deleted'
      GROUP BY users.user_id ORDER BY users.user_id DESC","DISTINCT *","fetchAll");
?>




<div class="px-2 py-3 mb-4" style="background-color: white;">
  <h4 class="lead bg-white mb-0">
    <span class="fas fa-users"></span>
    Users
  </h4>
  <hr class="m-1 mb-2">
  <p class="mb-0"><a href="#" class="bold" onclick="users_view()">Users</a> <span class="fas fa-angle-right"></span> Removed system users</p>
</div>







<!-- Content Row -->
<div class="row">
  <div class="col-md-12">
    <p class="font-weight-bold text-right">
      <?php
        if($user_in_type=="su_admin"){
      ?>
        <a href="#!" class="text-primary font-weight-normal mx-2" onclick="add_user_view()"><span class="fas fa-plus"></span> Add user</a>
        <a href="#!" class="text-danger font-weight-normal mx-2" onclick="users_trash_view()"><span class="fas fa-trash"></span> Removed users</a>
      <?php
        }
      ?>
    </p>

    
    
    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Removed system users</h6>
      </div>
      <div class="card-body">
        <div id="delete_user_response"></div>
        <div class="table-responsive">
          <table class="table table-head-bg-primary mt-4" id="users_table">
              <thead>
                <tr>
                  <th scope="col">Profile image</th>
                  <th scope="col">Firstname</th>
                  <th scope="col">Lastname</th>
                  <th scope="col">Username</th>
                  <th scope="col">Email</th>
                  <th scope="col">User role</th>
                  <th scope="col"></th>
                </tr>
              </thead>
              <tbody>
                <?php
                            
                  if($get_users!="1020"){
                    $element_id="element_id";
                      foreach ($get_users as $user) {
                        $element_id=$element_id."Ot";
                ?>  
                    <tr id="<?php echo $element_id ?>">         
                      <td class="text-center">
                        <?php
                          if(!empty($user->photo)){
                            echo $image='<img class="m-1" style="max-height:40px;" src="../img/profile_pictures/'.$user->photo.'?timestamp'.time().'" alt="Profile img"/>';
                          }else{
                            echo "<span class='fas fa-user fa-2x'></span>";
                          }
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $user->firstname;
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $user->lastname;
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $user->username;
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $user->email;
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $user->user_role;
                        ?>
                      </td>
                      <td id="<?php echo $element_id.'Dbtn' ?>">
                      <?php
                        if($user_in_type=="su_admin" and !($user_id==$user->user_id)){
                      ?>
                          <div class="">
                            <form id="<?php echo 'R'.$element_id.'formI' ?>" class="mb-0 hand_cursor" style="display: inline;">
                                <input type="hidden" name="restore_user_note" value="<?php echo $user->user_id; ?>">
                                <button id="<?php echo $element_id.'Rbtn' ?>" onclick="restore_user('<?php echo 'R'.$element_id.'formI' ?>','<?php echo $element_id; ?>','delete_user_response')" type="submit" title="Restore" class="btn btn-success hand_cursor"><span class="fas fa-sync"></span> Restore</button>
                            </form>
                            <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                                <input type="hidden" name="permanently_delete_user_note" value="<?php echo $user->user_id; ?>">
                                <button id="<?php echo $element_id.'Rbtn' ?>" onclick="permanently_delete_user('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','delete_user_response')" type="submit" title="Delete" class="btn btn-danger hand_cursor"><span class="fas fa-times "></span> Delete</button>
                            </form>
                            
                          </div>
                      <?php
                        }
                      ?>
                          
                      </td>
                    </tr>
                  <?php
                      }
                    }
                  ?>
                
              </tbody>
            </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [6]} 
      ]
    });
  })
</script>

