/*!
    * Start Bootstrap - Agency v6.0.3 (https://startbootstrap.com/theme/agency)
    * Copyright 2013-2020 Start Bootstrap
    * Licensed under MIT (https://github.com/StartBootstrap/startbootstrap-agency/blob/master/LICENSE)
    */
    (function ($) {
    "use strict"; // Start of use strict

    // Smooth scrolling using jQuery easing
    $('a.js-scroll-trigger[href*="#"]:not([href="#"])').click(function () {
        if (
            location.pathname.replace(/^\//, "") ==
                this.pathname.replace(/^\//, "") &&
            location.hostname == this.hostname
        ) {
            var target = $(this.hash);
            target = target.length
                ? target
                : $("[name=" + this.hash.slice(1) + "]");
            if (target.length) {
                $("html, body").animate(
                    {
                        scrollTop: target.offset().top - 72,
                    },
                    1000,
                    "easeInOutExpo"
                );
                return false;
            }
        }
    });

    // Closes responsive menu when a scroll trigger link is clicked
    $(".js-scroll-trigger").click(function () {
        $(".navbar-collapse").collapse("hide");
    });

    // Activate scrollspy to add active class to navbar items on scroll
    $("body").scrollspy({
        target: "#mainNav",
        offset: 74,
    });

    // Collapse Navbar
    var navbarCollapse = function () {
        if ($("#mainNav").offset().top > 100) {
            $("#mainNav").addClass("navbar-shrink");
            $(".main_nav_link").removeClass("main_nav_link_normal");
            $(".main_nav_link").addClass("main_nav_link_shrink");
            $("#mainNav").addClass("shadow-sm");

            $(".main_nav_link").removeClass("text-light");
            $(".main_nav_link").addClass("text-dark");
        } else {
            $("#mainNav").removeClass("navbar-shrink");
            $(".main_nav_link").removeClass("main_nav_link_shrink");
            $(".main_nav_link").addClass("main_nav_link_normal");
            $("#mainNav").removeClass("shadow-sm");

            $(".main_nav_link").removeClass("text-dark");
            $(".main_nav_link").addClass("text-light");
        }
    };

    if ($(window).width() < 768) {
        $(".main_nav_link").removeClass("text-light");
        $(".main_nav_link").addClass("text-dark");
    }else if($(window).width() < 990) {
        $(".main_nav_link").removeClass("text-light");
        $(".main_nav_link").addClass("text-dark");
    }else{
        $(".main_nav_link").removeClass("text-dark");
        $(".main_nav_link").addClass("text-light");
    }
    $(window).resize(function() {
        if ($(window).width() < 768) {
            $(".main_nav_link").removeClass("text-light");
            $(".main_nav_link").addClass("text-dark");
        }else if($(window).width() < 990) {
            $(".main_nav_link").removeClass("text-light");
            $(".main_nav_link").addClass("text-dark");
        }else{
            $(".main_nav_link").removeClass("text-dark");
            $(".main_nav_link").addClass("text-light");
        }
    });

    // Collapse now if page is not at top
    navbarCollapse();
    // Collapse the navbar when page is scrolled
    $(window).scroll(navbarCollapse);
})(jQuery); // End of use strict
