<?php
	require_once("../../../classes/main_classes.php");

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	$get_sold=$retrieveObj->retriever("realestate 
      JOIN realestate_type ON realestate_type.r_type_id=realestate.r_type_id 
      JOIN realestate_images ON realestate_images.r_id=realestate.r_id 
      
      WHERE realestate_images.image_type='primary_image' and realestate.r_status='sold' GROUP BY realestate.r_id","DISTINCT *","fetchAll");

?>

<p class="text_primary_color font-weight-bold mb-1 d-flex justify-content-between">
	<span>Sold properties</span>
	<span>
		<a data-toggle="modal" data-target="#generateReportModal" class="nav-link fas fa-1x p-2 mb-2" href="#"><span class="text-dark fas fa-file-export"> Export</span></a>
	</span>
</p>
<div class="bg-white rounded p-3 shadow-sm">
	<?php
		$for_pdf='
			<div class="text-center mt-3">
				<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
			</div>
			<div class="text-center mt-3 h3">Sold Properties(REAL ESTATE)</div>
			<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>
			<table class="table" >
			<thead>
	   			<tr>
	   				<td>Image</td>
	   				<td>Type</td>
	   				<td>Address</td>
	   				
	   				
	   				<td>Date sold</td>
	   				<td>Date added</td>
	   			</tr>
	   		</thead>
	   		<tbody>

		';
	?>
   	<table class="table" id="sold_properties_table">
   		<thead>
   			<tr>
   				<td>Image</td>
   				<td>Type</td>
   				<td>Address</td>
   				<td>Sold price</td>
   				
   				
   				<td>Date added</td>
   				<td></td>
   			</tr>
   		</thead>
   		<tbody>
   			<?php
				
                    if($get_sold!="1020"){
                    	$element_id="element_id";
                        foreach ($get_sold as $sold) {
                        	$element_id=$element_id."Ot";
			?>	
					<tr id="<?php echo $element_id ?>">	    		
						<td class="">
							<?php
								echo $image='<img class="m-1" style="max-height:75px;" src="../img/realestates/'.$sold->image.'?timestamp'.time().'"/>';
							?>
						</td>
						<td>
							<?php 
								echo $r_type=$sold->r_type;
							?>
						</td>
						<td>
							<?php 
								echo $r_address=$sold->r_address;
							?>
						</td>
						
						
						<td>
							<?php 
								 echo $r_sold_date=date("d-m-Y H:i:s", strtotime($sold->r_sold_date));
							?>
						</td>
						<td>
							<?php 
								 echo $r_date_added=date("d-m-Y H:i:s", strtotime($sold->r_date_added));
							?>
						</td>
						<td id="<?php echo $element_id.'Dbtn' ?>">
							<?php
								$for_pdf_details_var='
									<div class="text-center mt-3">
										<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
									</div>
									<div class="text-center mt-3 h3">Sold Property(REAL ESTATE)</div>
									<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

									<div class="container">
										<div style="width:100%" style="p-2">
											<img class="" style="height:300px;" src="../img/realestates/'.$sold->image.'?timestamp'.time().'"/>
										</div>
										<div style="width:100%" style="p-2">
											<table class="table table-borderless">
												<tr>
													<td><strong>Real estate type</strong></td>
													<td>'.$r_type.'</td>
												</tr>
												<tr>
													<td><strong>Address</strong></td>
													<td>'.$r_address.'</td>
												</tr>
												
												<tr>
													<td><strong>Date sold</strong></td>
													<td>'.$r_sold_date.'</td>
												</tr>
												<tr>
													<td><strong>Date added</strong></td>
													<td>'.$r_date_added.'</td>
												</tr>
												
												
											</table>
										</div>
										<div class="col-md-12">
											<p><strong>Desctiption</strong></p>
											<p>'.$sold->r_description.'</p>
										</div>
									</div>
								';

								$strI = serialize($for_pdf_details_var);
								$pdfDataDetails = urlencode($strI);

							?>
							<button style="display: inline;" title="Requests" class="btn text-primary" onclick="realestate_enquiries_view(<?php echo $sold->r_id ?>)"><img src="../img/icons/request.png" height="20px"> </button>
							<button class="btn text-primary" onclick="edit_realestate(<?php echo $sold->r_id ?>)"><span class="fas fa-edit"></span> </button>
							<form action="../file_generators/pdf_generator.php" method="POST" target="_blank" style="display: inline;">
				                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
								<input type="hidden" name="downloadBtn">
				                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
				            </form>
				            <form id="<?php echo $element_id.'form' ?>" class="mb-0" style="display: inline;">
				                <input type="hidden" name="remove_realestate_property_note" value="<?php echo $sold->r_id ?>">
				                <button  onclick="remove_realestate_property('<?php echo $element_id.'form' ?>','<?php echo $element_id ?>','remove_realestate_property_response')" type="submit" title="Remove" class="btn"><span class="fas fa-trash text-warning"> </span></button>
				            </form>
						</td>
					</tr>
			<?php
				$for_pdf=$for_pdf."
							<tr>
								<td>".$image."</td>
								<td>".$r_type."</td>
								<td>".$r_address."</td>
								
								<td>".$r_sold_date."</td>
								<td>".$r_date_added."</td>
							</tr>
						";

					}
					$for_pdf=$for_pdf."</tbody></table>";
				}
			?>
   		</tbody>
   	</table>
   	<?php
		
		//generate data sending variables
		$str = serialize($for_pdf);
		$pdfData = urlencode($str);
	?>
</div>
<!--GENERATE REPORTS MODAL-->
<div class='modal fade transparent mt-5' id='generateReportModal' data-keyboard="false" data-backdrop="static" tabindex="-1">
    <div class='modal-dialog shadow-lg rounded' style="max-height: 400px;" >
		<div class='modal-content' >
			<div  class='text-dark modal-header'>
				<button  class='btn btn-danger btn-sm' data-dismiss='modal'>
					&times;
				</button>
			</div>
			<div class='modal-body text-center bg-light'>
				<div class="text-center row">
					<div style="width: 100%" class="text-center">
						<form action="../file_generators/pdf_generator.php" method="POST" target="_blank">
							<input type="hidden" name="exportPdf" value="<?php echo $pdfData ?>">
							<input type="hidden" name="downloadBtn">
							<button class="btn" type="submit" name=""><span class="fas fa-file-pdf fa-8x text-danger"></span></button><br />
							<label class="text-dark bold lead">Pdf</label>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>  
 $(document).ready(function(){  
 	
     var table = $('#sold_properties_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ]
    });
    $("thead").addClass("font-weight-bold"); 
 });  
 </script> 

