<?php
    $session_path="../../../session_check.php";
    $classes="../../../classes/main_classes.php";

    require_once($session_path);
    require_once($classes);

    //OBJECTS
    $retrieveObj=new RETRIEVE();
    $rowcountObj=new ROWCOUNT();
    $updateObj=new UPDATE();
    $insertObj=new INSERT();
    $sendemailObj=new SEND_EMAIL();

	if(isset($_POST["token"])){
        
        $fields_string = "";

        //set POST variables
        //$url = 'https://netsoftmoney.com/gateway/transactions.php';
        $url = 'https://netsoftmoney.com/gateway/transactions_testing.php';
        $fields = array(
            'token' => urlencode($_POST['token'])
        );

        //url-ify the data for the POST
        foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
        rtrim($fields_string, '&');

        //open connection
        $ch = curl_init();

        //set the url, number of POST vars, POST data
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_POST, count($fields));
        curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

        //execute post
        $result = curl_exec($ch);

        //close connection
        curl_close($ch);

        //echo $result;

        //SGW CUSTOM CODE
        if($result=="2029"){
            //get customer info
            $get_customer_info=$retrieveObj->retriever("users","*","user_id",$user_id,"fetch");
            $customer_name=$get_customer_info->firstname." ".$get_customer_info->lastname;
            $customer_email=$get_customer_info->email;
            $customer_phone=$get_customer_info->phone;


            //get admin info
            $get_administrators=$retrieveObj->retriever("users 
                JOIN user_roles ON user_roles.user_id=users.user_id
                JOIN user_role ON user_roles.role_id=user_role.role_id","*","user_role.user_role","admin","fetchAll");

            //payment Info
            $payment_info="
                <br />
                <p>Payment method :NETSOFT MONEY</p>
            ";


            $property_type=$_SESSION["property_type"];
            $property_id=$_SESSION["property_id"];
            $amount_to_be_paid=$_SESSION["amount_to_be_paid"];
            $mailer_r_path="../../../";

            if($property_type=="vehicle"){
                //UPDATE VEHICLE STATUS
                $update_v=$updateObj->updater("vehicle","v_status='sold'","v_id",$property_id);
                if($update_v==1){
                    //insert to sold table
                    $fields=array("user_id","v_id");
                    $data=array($user_id,$property_id);

                    $insertObj->inserter("vehicle_sold",$fields,$data);

                    //send emails
                        //to admin
                        $admin_subject_="NEW VEHICLE PURCHASE";
                        $admin_body_="This is notify you that $customer_name($customer_email) has purchased a vehicle from SGW.
                        ".$payment_info."
                        <br>
                        Please login to your website to see details";
                        foreach ($get_administrators as $administrator) {
                            $admin_email_to=$administrator->email;
                            $sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_,$admin_body_,$admin_email_to);
                        }


                        //to customer
                        $subject_="VEHICLE PURCHASE";
                        $body_="This is to notify you that your vehicle purchase is successful.
                            Login to SGW and go to your dashboard to view details
                            ".$payment_info."
                        ";
                        $email_to=$customer_email;
                        $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);
                }
            }else if($property_type=="auction"){
                //VERIFY THAT THE CUSTOMER WAS THE BEST BIDDER
                $get_bid_info=$retrieveObj->retriever("auction_bid","*","a_id",$property_id,"a_bid_price","DESC","fetch");
                if($get_bid_info->user_id!=$user_id){
                    die("<p class='alert alert-warning'>Something went wrong, it seems you were not the best bidder</p>");
                }
                //GET PROPERTY DETAILS
                $get_property_details=$retrieveObj->retriever("auction","*","a_id",$property_id,"fetch");
                    //get max bid price
                        //get max bid
                        $max_bid="";
                        $get_max_bid=$retrieveObj->retriever("auction_bid","*","a_id",$property_id,"a_bid_price","DESC","fetch");
                        if($get_max_bid!="1020"){
                            $max_bid=$get_max_bid->a_bid_price;
                        }else{
                            $max_bid=$get_property_details->a_bid_start_price;
                        }
                    //commission
                    $commission=$get_property_details->expected_commission_percentage/100*$max_bid;
                    $sold_price=$max_bid;
                //insert to sold table
                $fields=array("user_id","a_id","sold_price","commission");
                $data=array($user_id,$property_id,$sold_price,$commission);

                $insertObj->inserter("auction_sold",$fields,$data);   

                //send emails
                    //to admin
                    $admin_subject_="NEW AUCTION PAYMENT";
                    $admin_body_="This is notify you that $customer_name($customer_email) has has paid for an auction propery from SGW.
                    ".$payment_info."
                    <br>
                    Please login to your website to see details";
                    foreach ($get_administrators as $administrator) {
                        $admin_email_to=$administrator->email;
                        $sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_,$admin_body_,$admin_email_to);
                    }


                    //to customer
                    $subject_="AUCTION PAYMENT";
                    $body_="This is to notify you that your auction property payment is successful.
                        Login to SGW and go to your dashboard to view details
                        ".$payment_info."
                    ";
                    $email_to=$customer_email;
                    $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);
            }else if($property_type=="realestate"){
                //
                $activity=$_SESSION["activity"];
                if($activity=="buy"){
                    $update_v=$updateObj->updater("realestate","r_status='sold'","r_id",$property_id);
                    if($update_v==1){
                        //insert to sold table
                        $fields=array("user_id","r_id");
                        $data=array($user_id,$property_id);

                        $insertObj->inserter("realestate_sold",$fields,$data);

                        //send emails
                            //to admin
                            $admin_subject_="NEW REAL ESTATE PROPERTY PURCHASE";
                            $admin_body_="This is notify you that $customer_name($customer_email) has purchased a realestate property from SGW.
                            ".$payment_info."
                            <br>
                            Please login to your website to see details";
                            foreach ($get_administrators as $administrator) {
                                $admin_email_to=$administrator->email;
                                $sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_,$admin_body_,$admin_email_to);
                            }


                            //to customer
                            $subject_="REAL ESTATE PROPERTY PURCHASE";
                            $body_="This is to notify you that your real estate property purchase is successful.
                                Login to SGW and go to your dashboard to view details
                                ".$payment_info."
                            ";
                            $email_to=$customer_email;
                            $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);
                    }
                }else if($activity=="rent"){

                    $update_v=$updateObj->updater("realestate","r_status='rent'","r_id",$property_id);
                    if($update_v==1){ 
                        $rent_period=addslashes($_POST["rent_period"]);

                        $days=(String)$rent_period*30;
                        $days="+".$days." days";
                        
                        
                        //check if recored already exist
                        $check_r=$retrieveObj->retriever("realestate_rented","*","user_id='$user_id' and r_id",$property_id,"fetch");
                        $rent_start_date=$check_r->r_rent_expirely_date;
                        $r_rent_expirely_date = date('Y-m-d H:i:s', strtotime($rent_start_date. $days));
                        
                        if($check_r!="1020"){
                            $rent_update_data="r_rent_expirely_date='$r_rent_expirely_date', r_rented_status='active', r_rent_expirely_note='not_sent'";
                            $update_rent_ = $updateObj->updater("realestate_rented",$rent_update_data,"user_id='$user_id' and r_id",$property_id);
                            
                            if($update_rent_=="1"){

                            }else{
                                die("Something went wrong, try again later");
                            }
                        }else{
                            die("Something went wrong, try again later");
                        }
                        
                           

                        //send emails
                            //to admin
                            $admin_subject_="NEW REAL ESTATE RENT PAYMENT";
                            $admin_body_="This is notify you that $customer_name($customer_email) has payed rent for a realestate property from SGW.
                            ".$payment_info."
                            <br>
                            Please login to your website to see details";
                            foreach ($get_administrators as $administrator) {
                                $admin_email_to=$administrator->email;
                                $sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_,$admin_body_,$admin_email_to);
                            }


                            //to customer
                            $subject_="REAL ESTATE RENT PAYMENT";
                            $body_="This is to notify you that your real estate property rent payment is successful.
                                Login to SGW and go to your dashboard to view details
                                ".$payment_info."
                            ";
                            $email_to=$customer_email;
                            $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);

                        
                    }
                }else if($activity=="book"){
                    $update_v=$updateObj->updater("realestate","r_status='booked'","r_id",$property_id);
                    if($update_v==1){
                        //$book_start_date=addslashes($_POST["book_start_date"]);
                        $book_period=addslashes($_POST["book_period"]);

                        $days=(String)$book_period;
                        $days="+".$days." days";

                        //check if record already exist
                        $check_r=$retrieveObj->retriever("realestate_booked","*","user_id='$user_id' and r_id",$property_id,"fetch");
                        $book_start_date=$check_r->r_book_date_from;
                        $r_book_date_to = date('Y-m-d H:i:s', strtotime($book_start_date. $days));
                        

                        if($check_r!="1020"){
                            $book_update_data="r_book_date_to='$r_book_date_to', r_booked_date='".date("Y-m-d H:i:s")."' , r_book_status='active', r_book_expirely_note='not_sent'";
                            $update_book = $updateObj->updater("realestate_booked",$book_update_data,"user_id='$user_id' and r_id",$property_id);
                            
                            if($update_book=="1"){

                            }else{
                                die("Something went wrong, try again later");
                            }
                        }else{
                            die("Something went wrong, try again later");
                        }

                        //send emails
                            //to admin
                            $admin_subject_="NEW REAL ESTATE BOOK PAYMENT";
                            $admin_body_="This is notify you that $customer_name($customer_email) has payed for a realestate property from SGW.
                            ".$payment_info."
                            <br>
                            Please login to your website to see details";
                            foreach ($get_administrators as $administrator) {
                                $admin_email_to=$administrator->email;
                                $sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_,$admin_body_,$admin_email_to);
                            }


                            //to customer
                            $subject_="REAL ESTATE Book PAYMENT";
                            $body_="This is to notify you that your real estate property book payment is successful.
                                Login to SGW and go to your dashboard to view details
                                ".$payment_info."
                            ";
                            $email_to=$customer_email;
                            $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);
                }
                }
            }


            //DESTROY SESSIONS
            unset($_SESSION["property_type"]);
            unset($_SESSION["property_id"]);
            unset($_SESSION["amount_to_be_paid"]);
        	header("location:../../../payment_results.php");
        }else{
        	echo $result;
        }

    }

?>