
(function ($) {
	"use strict";

    var current_fs, next_fs, previous_fs;
    var opacity;

    $(".steps").validate({
        errorClass: 'invalid',
        errorElement: 'span',
        errorPlacement: function(error, element) {
            error.insertAfter(element.next('span.error1').children());
        },
        highlight: function(element) {
            $(element).next('span.error1').show();
        },
        unhighlight: function(element) {
            $(element).next('span').hide();
        }
    });
    $(".next").click(function() {
        $(".steps").validate({
            errorClass: 'invalid',
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.insertAfter(element.next('span').children());
            },
            highlight: function(element) {
                $(element).next('span').show();
            },
            unhighlight: function(element) {
                $(element).next('span').hide();
            }
        });
        if ((!$('.steps').valid())) {
            return true;
        }

        current_fs = $(this).parent();
        next_fs = $(this).parent().next();
        $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");
        next_fs.show();
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now) {
                opacity = 1 - now;
                next_fs.css({
                    'opacity': opacity
                });
            },
            duration: 1,
            complete: function() {
                current_fs.hide();
            }
        });
    });
    $(".submit").click(function() {
        $(".steps").validate({
            errorClass: 'invalid',
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.insertAfter(element.next('span').children());
            },
            highlight: function(element) {
                $(element).next('span').show();
            },
            unhighlight: function(element) {
                $(element).next('span').hide();
            }
        });
        if ((!$('.steps').valid())) {
            return true;
        }
        current_fs = $(this).parent();
        next_fs = $(this).parent().next();
        $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");
        next_fs.show();
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now) {
                opacity = 1 - now;
                next_fs.css({
                    'opacity': opacity
                });
            },
            duration: 1,
            complete: function() {
                current_fs.hide();
            }
        });
    });
    $(".previous").click(function() {
        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();
        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");
        previous_fs.show();
        current_fs.animate({

            opacity: 0
        }, {
            step: function(now) {
                opacity = 1 - now;
                previous_fs.css({
                    'opacity': opacity
                });
            },
            duration: 1,
            complete: function() {
                current_fs.hide();
            }
        });
    });

}(jQuery));	