<h2 class="title-bottom-border mb-3">MALAWI COVID-19 UPDATE</h2>
<div class="card-deck">
  <div class="card">
    <div class="card-header text-center bg-danger text-light">CONFIRMED</div>
    <div class="card-body text-center" id="mwCovidConfirmed"></div>
  </div>
  <div class="card">
    <div class="card-header text-center text-light" style="background-color: darkred;">DEATHS</div>
    <div class="card-body text-center" id="mwCovidDeaths"></div>
  </div>
  <div class="card">
    <div class="card-header text-center bg-success text-light">RECOVERED</div>
    <div class="card-body text-center" id="mwCovidRecovered"></div>
  </div>
  <div class="card">
    <div class="card-header text-center bg-warning text-light">ACTIVE</div>
    <div class="card-body text-center" id="mwCovidActive"></div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function(){
    var malawi_covid_update;

    fetch('https://api.covid19api.com/live/country/malawi/status/confirmed/date/2021-01-25T00:00:00Z')
      .then(res => res.json())
      .then(data => malawi_covid_update = data)
      .then(() => $("#mwCovidConfirmed").html(malawi_covid_update[0]["Confirmed"]))
      .then(() => $("#mwCovidDeaths").html(malawi_covid_update[0]["Deaths"]))
      .then(() => $("#mwCovidRecovered").html(malawi_covid_update[0]["Recovered"]))
      .then(() => $("#mwCovidActive").html(malawi_covid_update[0]["Active"]))
  })
    
</script>