 <?php
	include("connection/Functions.php");
	$operation = new Functions();

	//get donations
	$donations = $operation->retrieveSingle("SELECT * FROM `donation_status` ORDER BY ds_id DESC");
	$plants = $operation->retrieveSingle("SELECT * FROM `psl_plant_purchased` ORDER BY ppp_id DESC");
	$news = $operation->retrieveMany("SELECT * FROM `news`  WHERE n_status = 'active' ORDER BY n_id DESC  LIMIT 2");
 ?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="utf-8">
<meta name="description" content="The second wave of the covid-19 pandemic has hit Malawi hard. Hospitals are suffocating, systems are overwhelmed. There is a shortage of cylinders and concentrators – essential for the supply of oxygen to covid patients. Diagnostic kits are also in short supply, as is personal protective equipment. Apart from that, essential medicines are in insufficient amounts. The government is doing the best it can, but all systems are overstretched, and critical gaps have emerged. This calls for all hands on deck. Because of this, citizens came together to crowdfund and cover any gaps that cannot be covered by the government’s efforts.">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="keywords" content="Covid, Malawi, Response, Private, Citizens, Donations, response, Malawi, Corona, Pandemic, Non profit, Oxygen, Cylinder, Hospitals, Pressure, Swing, Absorption, PSA" />
<meta name="author" content="NetSoft Malawi">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Title -->
<title>Covid Response Private Citizens</title>

<!-- Favicon -->
<link rel="shortcut icon" type="image/png" href="assets/images/fevicon1.png">

<!-- Bootstrap CSS -->
<link rel="stylesheet" href="assets/css/bootstrap.min.css">

<!-- Font awesome CSS --
<link rel="stylesheet" href="assets/css/font-awesome.min.css"-->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">

<!-- Animate CSS -->
<link rel="stylesheet" href="assets/css/animate.min.css">

<!-- OwlCarousel CSS -->
<link rel="stylesheet" href="assets/css/owl.carousel.min.css">

<!-- Magnific popup CSS -->
<link rel="stylesheet" href="assets/css/fancybox.min.css">

<!-- Main CSS -->
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="assets/css/universal.css">

<!-- Responsive CSS -->
<link rel="stylesheet" href="assets/css/responsive.css">
<!-- Red color CSS -->
<link rel="stylesheet" href="assets/css/color-red.css">

<!-- jQuery -->
<script src="assets/js/jquery-3.4.1.min.js"></script>
</head>
<body>
<div class="main-wrapper">

  <header class="for-sticky"> 
    <!-- Header area start -->
    <div class="container-fluid">
      <div class="header-block"> 
        <!-- Site logo Start -->
        <div class="logo"> <a href="index.php" title="Covid Response Private Citizens">Covid Response Private Citizens</a> </div>
        <!-- Site logo end --> 
        
        <!-- Main menu start -->
        <nav class="mainmenu home-nav">
          <ul id="navigation">
            <li ><a href="index.php#home" onclick="openPage('home')" title="Home">Home</a></li>
            <li><a href="index.php#about-us" onclick="openPage('about-us')" title="About Us">About Us</a></li>
            <li><a href="index.php#news" onclick="openPage('news')" title="News &amp; Events">News &amp; Events</a></li>
            <li><a href="index.php#contact" onclick="openPage('contact')" title="Contact">Contact</a></li>
            <li><a href="index.php#updates_covid" onclick="openPage('updates_covid')" title="COVID-19 Updates">COVID-19 Updates</a></li>
            <li ><a href="index.php#organizers" onclick="openPage('organizers')" title="Organizers">Organizers</a></li>
            <!--li><a href="index.php#" title="Pages">Pages</a>
              <ul>
                <li><a href="index.php" title="Home with color 1">Home with color 1</a></li>
                <li><a href="home-slider-color-2.php" title="Home Slider with color 2">Home Slider with color 2</a></li>
                <li><a href="bg-video-color-3.php" title="Home bg video with color 3">Home bg video with color 3</a></li>
                <li><a href="rtl-version-color-4.php" title="RTL Version with color 4">RTL Version with color 4</a></li>
                <li><a href="gallery.php" title="Gallery page">Gallery page</a></li>
                <li><a href="donate.php" title="Cause Details with donate">Cause Details with donate</a></li>
              </ul>
            </li-->
          </ul>
        </nav>
        <!-- Main menu end -->
        <div class="header-login-link">
          <ul>
<!--
            <li><a href="#" title="" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><img src="assets/images/flag-1.png" alt=""/> EN</a>
              <ul class="dropdown-menu">
                <li><a href="" title=""><img src="assets/images/flag-1.png" alt=""/> EN</a></li>
                <li><a href="" title=""><img src="assets/images/flag-2.png" alt=""/> TR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-3.png" alt=""/> BR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-4.png" alt=""/> SR</a></li>
              </ul>
            </li>
-->
          </ul>
        </div>
        <div class="header-button"><a href="donate.php" title="">Donate</a></div>
        <div class="mobile-menu-wrapper home-nav"></div>
      </div>
    </div>
    <!-- Header area End --> 
  </header>
  
  <!-- Breadcroumbs start -->
  <div class="page-content-block page-breadcroumb inner-banner-bg-1">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <h1>Donations</h1>
          <a href="index.php" title="Home">Home</a> / Donate </div>
      </div>
    </div>
  </div>
  <!-- Breadcroumbs end --> 
  
  <!-- Cause Details start -->
  <div class="page-content-block">
    <div class="container">
      <div class="row flex-lg-row-reverse"> 
        <!-- Donate start -->
        <div class="col-12 col-lg-5">
          <div class="causes-right">
                        <div class="featured-fund-raise">
              <div class="featured-fund-raise-block">
                <div class="progress ">
                  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 50%"><span></span></div>
                </div>
                <div class="raise-total "> <span class=""><b>K<?=number_format($donations['ds_amount'],2)?></b> raised</span></div>
                
              </div>
            </div>
         
            <div class="donation-form" id="donation-form">
              <form class="steps" accept-charset="UTF-8" enctype="multipart/form-data" id="donate_form">
                <fieldset >
                  <h3 class="title-bottom-border">Select Donation Amount</h3>
                  <div class="donation-block">
                    <div class="row">
					   <div class="payment-logo pl-3">
                      <input type="radio" name="paymentMethod" id="paymentmethod1" class="css-paymentCheck" />
                      <label for="paymentmethod1" class="css-labelPayment"><i class="fab fa-cc-paypal"></i></label>
                    </div>
                    <!--div class="payment-logo">
                      <input type="radio" name="paymentMethod" id="paymentmethod2" class="css-paymentCheck"  checked/>
                      <label for="paymentmethod2" class="css-labelPayment"><i class="fab fa-cc-visa"></i></label>
                    </div-->
					  </div>
                    <div class="donation-amount">
                      <div>$</div>
                      <input type="text" class="donation-amount-input" value="" name="donate_amount" required>
                      <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> Please enter amount </span>
                      <div>.00</div>
                    </div>
                  </div>
                  <div id="donate_response"></div>
                  <!--input type="button" name="next" class="next main-btn" value="Continue" /-->
                  <button class="main-btn" type="submit" onclick="post_donate_amount()"> Continue</button>
                </fieldset>
              </form>
               
                <!--fieldset>
                  <h3 class="title-bottom-border">Fill the information</h3>
                  <div class="total-payment"> Selected Amount: <strong>$15</strong> </div>
                  <div class="reg-form">
                    <div class="form-row">
                      <div class="form-group col-12">
                        <label>First Name</label>
                        <input type="text" class="form-control" value="" placeholder="First Name" required>
                        <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> This field is required </span> </div>
                    </div>
                    <div class="form-row">
                      <div class="form-group col-12">
                        <label>Last Name</label>
                        <input type="text" class="form-control" value="" placeholder="Last Name">
                      </div>
                    </div>
                    <div class="form-row">
                      <div class="form-group col-12">
                        <label>Email</label>
                        <input type="email" class="form-control" value="" placeholder="Email">
                      </div>
                    </div>
                    <div class="form-row">
                      <div class="form-group col-12">
                        <label>Phone</label>
                        <input type="text" class="form-control" value="" placeholder="Phone">
                      </div>
                    </div>
              
                  </div>
                  <input type="button" name="previous" class="previous main-btn" value="Previous" />
                  <input type="button" name="next" class="next main-btn" value="Continue" />
                </fieldset-->
                
                <!--fieldset>
                  <div class="thank-you">
                    <h3>Thank You</h3>
                    <p>Your payment has been proceed successfully</p>
                  </div>
                </fieldset-->
              <!--/form-->
            </div>
          </div>
        </div>
        <!-- Donate end -->
        <div class="col-12 col-lg-7"> 
          <!-- Cause content start -->
          <div class="causes-left">
            <h2>Mission of the Organizing Team</h2>
			  <h5 class="text-primary">To cover gaps that need urgent addressing in the fight against the devastating impact of covid.</h5>
			  <br/>
			  
			  <h3>To contribute, send your donation to:</h3>
			  
			  <img class="img-responsive" src="assets/images/Standard-Bank-Logo.png" height="100px"/>
			  <table>
			  	<tr>
					<th>Account Name: </th>
					<td>Covid Response Private Citizens </td>
				</tr>
				  <tr>
					<th>Account No: </th>
					<td> 9100004236383 (MWK)/9100004236804 (USD)</td>
				</tr>
				 <tr>
					<th>Branch: </th>
					<td> Ginnery Corner </td>
				</tr>
				  
				  <tr>
					<th>Swift Code: </th>
					<td> SBICMWMX </td>
				</tr>
				 <tr>
					<th>Bank Name: </th>
					<td> Standard Bank </td>
				</tr>
				  				  

			  </table>
			  <br/>
			  <h3>OR</h3>
			  <br/>
			  <img class="img-responsive" src="assets/images/nbm.png" height="150px"/>
			  		  <table>
        <table>
			  	<tr>
					<th>Account Name: </th>
					<td>Covid Response Private Citizens </td>
				</tr>
				  <tr>
					<th>Account No: </th>
					<td> 1007175527 </td>
				</tr>
				 <tr>
					<th>Branch: </th>
					<td> Henderson street service centre,  National Bank </td>
				</tr>
				  
				  <tr>
					<th>Swift Code: </th>
					<td> NBMAMWMW </td>
				</tr>
				 <tr>
					<th>Bank Name: </th>
					<td> National Bank of Malawi</td>
				</tr>
        </table>

        <br/>
        <h3>OR</h3>
        <br/>
        <img class="img-responsive" src="assets/images/airtel_money.png" height="150px"/>
              <table>
        <table>
        <tr>
          <th>Phone : </th>
          <td> 0999 30 66 84 or 0999 60 40 48</td>
        </tr>
        </table>

        <br/>
        <h3>OR</h3>
        <br/>
        <img class="img-responsive" src="assets/images/tnm_mpamba.png" height="150px"/>
              <table>
        <tr>
          <th>Phone : </th>
          <td> 0888 30 10 30</td>
        </tr>
          

			  </table>
			  
			  
			  
           
          </div>
          <!-- Cause content end --> 
          
    
        </div>
      </div>
    </div>
  </div>
  <!-- Cause Details end --> 
  <!-- Footer start -->
  <footer class="site-footer"> 
    <!-- Footer Top start -->
    <div class="footer-top-area">
      <div class="container">
        <div class="row flex-lg-row-reverse">
          <div class="col-12 col-lg-9">
            <div class="counter-block">
           
             
              <div class="counter-holder"> <span class="counter-icon"><img src="assets/images/complete-project-icon.png" alt="Supporter" /></span><span>K<?=number_format($donations['ds_amount'])?></span> 
                <h5>Total Amount Raised</h5>
              </div>
			
			<div class="counter-holder"> <span class="counter-icon"><img src="assets/images/supporter-icon.png" alt="Supporter" /></span> <span></span><span class="counter" data-count="<?=$plants['ppp_number']?>"></span>
                <h5>PSA Plants/Cyclinders Purchased</h5>
             </div>
				
				<div class="counter-holder"> <div class="bg-light"><a class="py-2 btn" href="donate.php" title="">Donate</a></div>
              </div>
				
            </div>
          </div>
          <div class="col-12 col-lg-3">
            <div class="social-block">
              <h4>Connect with us</h4>
              <div class="bottom-social"> <a href="https://www.facebook.com/stanley.kenani"><i class="fab fa-facebook-f"></i><span>Facebook</span></a> <a href="https://twitter.com/onjezani"><i class="fab fa-twitter"></i><span>Twitter</span></a> </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
    <!-- footer top end --> 
    
    <!-- copyright start -->
    <div class="footer-bottom-area">
      <div class="container">
        <div class="row">
          <div class="col-12 col-md-6 wow fadeInLeft">&copy; <script>document.write(new Date().getFullYear());</script> <span>Covid Response Private Citizens</span>.All Rights Reserved</div>
          <div class="col-12 col-md-6 text-right wow ">Design &amp; Development By: <a href="https://netsoftmw.com/" title="NetSoft Malawi" target="_blank">NetSoft Malawi</a></div>
        </div>
      </div>
    </div>
    <!-- copyright end --> 
  </footer>
  <!-- Footer end --> 
</div>
<!-- Main Wrapper end -->

<div class="scrollup"><i class="fa fa-angle-up"></i></div>
<!-- Footer end --> 

<script src="assets/js/universal.js"></script> 
<script src="assets/js/js.js"></script> 


<!-- Tether JS --> 
<script src="assets/js/tether.min.js"></script> 

<!-- Popper JS --> 
<script src="assets/js/popper.min.js"></script> 

<!-- Bootstrap JS --> 
<script src="assets/js/bootstrap.min.js"></script> 

<!-- OwlCarousel JS --> 
<script src="assets/js/owl.carousel.min.js"></script> 

<!-- SlickNav JS --> 
<script src="assets/js/jquery.slicknav.min.js"></script> 

<!-- fancybox Popup JS --> 
<script src="assets/js/jquery.fancybox.min.js"></script> 

<!-- WOW JS --> 
<script src="assets/js/wow-1.3.0.min.js"></script> 

<!-- Step Form with validate --> 
<script src="assets/js/jquery.validate.js"></script> 
<script src="assets/js/form-step.js"></script> 

<!-- Youtube JS --> 
<script src="assets/js/youtube-background.js"></script> 

<!-- Coming Soon JS --> 
<script src="assets/js/coming-soon.js"></script> 

<!-- Active JS --> 
<script src="assets/js/active.js"></script>
	<script>
	
		function ll(){
			window.href= "index.php#about";
		}
	</script>

  <script
      src="https://www.paypal.com/sdk/js?client-id=Acd0PHjsyaPHFd6jAdYfZ45yq7q5xu6c3DApTGsTOUUjpbr4ZLcT_Np2x1qgIk_cSA7TrokIB-iRY8iE&currency=USD"> // Required. Replace SB_CLIENT_ID with your sandbox client ID.
    </script>
	
</body>
</html>