<?php

//	header('Content-type: text/plain; charset=utf-8');

	include("connection/Functions.php");
	$operation = new Functions();

	$count = $operation->retrieveMany("SELECT * FROM `news` WHERE n_status = 'active' ORDER BY n_id DESC");
	$news = $operation->retrieveMany("SELECT * FROM `news` WHERE n_status = 'active' ORDER BY n_id DESC");
$donations = $operation->retrieveSingle("SELECT * FROM `donation_status` ORDER BY ds_id DESC");
	$plants = $operation->retrieveSingle("SELECT * FROM `psl_plant_purchased` ORDER BY ppp_id DESC");

function printTruncated($maxLength, $html, $isUtf8=true)
{
    $printedLength = 0;
    $position = 0;
    $tags = array();

    // For UTF-8, we need to count multibyte sequences as one character.
    $re = $isUtf8
        ? '{</?([a-z]+)[^>]*>|&#?[a-zA-Z0-9]+;|[\x80-\xFF][\x80-\xBF]*}'
        : '{</?([a-z]+)[^>]*>|&#?[a-zA-Z0-9]+;}';

    while ($printedLength < $maxLength && preg_match($re, $html, $match, PREG_OFFSET_CAPTURE, $position))
    {
        list($tag, $tagPosition) = $match[0];

        // Print text leading up to the tag.
        $str = substr($html, $position, $tagPosition - $position);
        if ($printedLength + strlen($str) > $maxLength)
        {
            print(substr($str, 0, $maxLength - $printedLength));
            $printedLength = $maxLength;
            break;
        }

        print($str);
        $printedLength += strlen($str);
        if ($printedLength >= $maxLength) break;

        if ($tag[0] == '&' || ord($tag) >= 0x80)
        {
            // Pass the entity or UTF-8 multibyte sequence through unchanged.
            print($tag);
            $printedLength++;
        }
        else
        {
            // Handle the tag.
            $tagName = $match[1][0];
            if ($tag[1] == '/')
            {
                // This is a closing tag.

                $openingTag = array_pop($tags);
                assert($openingTag == $tagName); // check that tags are properly nested.

                print($tag);
            }
            else if ($tag[strlen($tag) - 2] == '/')
            {
                // Self-closing tag.
                print($tag);
            }
            else
            {
                // Opening tag.
                print($tag);
                $tags[] = $tagName;
            }
        }

        // Continue after the tag.
        $position = $tagPosition + strlen($tag);
    }

    // Print any remaining text.
    if ($printedLength < $maxLength && $position < strlen($html))
        print(substr($html, $position, $maxLength - $printedLength));

    // Close any open tags.
    while (!empty($tags))
        printf('</%s>', array_pop($tags));
}



	
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="utf-8">
<meta name="description" content="The second wave of the covid-19 pandemic has hit Malawi hard. Hospitals are suffocating, systems are overwhelmed. There is a shortage of cylinders and concentrators – essential for the supply of oxygen to covid patients. Diagnostic kits are also in short supply, as is personal protective equipment. Apart from that, essential medicines are in insufficient amounts. The government is doing the best it can, but all systems are overstretched, and critical gaps have emerged. This calls for all hands on deck. Because of this, citizens came together to crowdfund and cover any gaps that cannot be covered by the government’s efforts.">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="keywords" content="Covid, Malawi, Response, Private, Citizens, Donations, response, Malawi, Corona, Pandemic, Non profit, Oxygen, Cylinder, Hospitals, Pressure, Swing, Absorption, PSA" />
<meta name="author" content="NetSoft Malawi">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Title -->
<title>Covid Response Private Citizens</title>

<!-- Favicon -->
<link rel="shortcut icon" type="image/png" href="assets/images/fevicon1.png">

<!-- Bootstrap CSS -->
<link rel="stylesheet" href="assets/css/bootstrap.min.css">

<!-- Font awesome CSS --
<link rel="stylesheet" href="assets/css/font-awesome.min.css"-->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">

<!-- Animate CSS -->
<link rel="stylesheet" href="assets/css/animate.min.css">

<!-- OwlCarousel CSS -->
<link rel="stylesheet" href="assets/css/owl.carousel.min.css">

<!-- Magnific popup CSS -->
<link rel="stylesheet" href="assets/css/fancybox.min.css">

<!-- Main CSS -->
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="news.css">

<!-- Responsive CSS -->
<link rel="stylesheet" href="assets/css/responsive.css">
<!-- Red color CSS -->
<link rel="stylesheet" href="assets/css/color-red.css">
<link rel="stylesheet" href="assets/datatables/dataTables.bootstrap4.min.css">

<!-- jQuery -->
<script src="assets/js/jquery-3.4.1.min.js"></script>
</head>
<body>
<div class="main-wrapper">

  <header class="for-sticky"> 
    <!-- Header area start -->
    <div class="container-fluid">
      <div class="header-block"> 
        <!-- Site logo Start -->
        <div class="logo"> <a href="index.php" title="Covid Response Private Citizens">Covid Response Private Citizens</a> </div>
        <!-- Site logo end --> 
        
        <!-- Main menu start -->
        <nav class="mainmenu home-nav">
          <ul id="navigation">
            <li ><a href="index.php#home" onclick="openPage('home')" title="Home">Home</a></li>
            <li><a href="index.php#about-us" onclick="openPage('about-us')" title="About Us">About Us</a></li>
            <li><a href="index.php#news" onclick="openPage('news')" title="News &amp; Events">News &amp; Events</a></li>
            <li><a href="index.php#contact" onclick="openPage('contact')" title="Contact">Contact</a></li>
            <li><a href="index.php#updates_covid" onclick="openPage('updates_covid')" title="COVID-19 Updates">COVID-19 Updates</a></li>
            <li ><a href="index.php#organizers" onclick="openPage('organizers')" title="Organizers">Organizers</a></li>
            <!--li><a href="index.php#" title="Pages">Pages</a>
              <ul>
                <li><a href="index.php" title="Home with color 1">Home with color 1</a></li>
                <li><a href="home-slider-color-2.php" title="Home Slider with color 2">Home Slider with color 2</a></li>
                <li><a href="bg-video-color-3.php" title="Home bg video with color 3">Home bg video with color 3</a></li>
                <li><a href="rtl-version-color-4.php" title="RTL Version with color 4">RTL Version with color 4</a></li>
                <li><a href="gallery.php" title="Gallery page">Gallery page</a></li>
                <li><a href="donate.php" title="Cause Details with donate">Cause Details with donate</a></li>
              </ul>
            </li-->
          </ul>
        </nav>
        <!-- Main menu end -->
        <div class="header-login-link">
          <ul>
<!--
            <li><a href="#" title="" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><img src="assets/images/flag-1.png" alt=""/> EN</a>
              <ul class="dropdown-menu">
                <li><a href="" title=""><img src="assets/images/flag-1.png" alt=""/> EN</a></li>
                <li><a href="" title=""><img src="assets/images/flag-2.png" alt=""/> TR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-3.png" alt=""/> BR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-4.png" alt=""/> SR</a></li>
              </ul>
            </li>
-->
          </ul>
        </div>
        <div class="header-button"><a href="donate.php" title="">Donate</a></div>
        <div class="mobile-menu-wrapper home-nav"></div>
      </div>
    </div>
    <!-- Header area End --> 
  </header>
  
  <!-- Breadcroumbs start -->
  <div class="page-content-block page-breadcroumb inner-banner-bg-1">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <h1>News</h1>
          <a href="index.php" title="Home">Home</a> / News &amp; Events </div>
      </div>
    </div>
  </div>
  <!-- Breadcroumbs end --> 
  
  <!-- Cause Details start -->
  <div class="page-content-block">
    <div class="">
      <div class=""> 
        <!-- Donate start -->
        <div class="">
          	<!-- details card section starts from here -->
			<section class="details-card">
				<div class="container">
					<div class="row">
						<div class="container">
						<table style="width:100%" class="" id="news_table">
							<?php
							
								if($count >0){
									
//									foreach($news as $row){
										
									
									?>
										<tr>
											<td>
											<div class="row">
												<?php
													foreach($news as $row){
														?>
												
														<div class="col-md-4 mt-3">
														<div class="card-content">
															<div class="card-img">
																<img src="assets/images/news/<?=$row['n_image']?>" alt="">
															</div>
															<div class="card-desc">
																<h3 style="overflow: hidden;text-overflow: ellipsis;display: -webkit-box;  -webkit-box-orient: vertical;  -webkit-line-clamp: 2; "><?=$row['n_title']?></h3>
																<div  style="height:150px"  class="">
																	<?php 
															
//																	$in = mb_strimwidth($row['n_body'], 0, 100, "...");
//																		strlen($in) > 50 ? substr($in,0,50)."..." : $in;
//																		echo $in;
															echo printTruncated(100, $row['n_body']);
																	?>
																	<p></p>
																<a href="single_article.php?view=<?=$row['n_id']?>" class="btn-card">Read</a> 
																</div>  
															</div>
														</div>
													</div>
														<?php
													}
												
												?>
											
												</div>
											</td>

										</tr>
										
							
									<?php
//									}	
								}else{
									echo "<tr><td></td></tr>";
								}
							?>
							
						
						</table>
						
					</div>
					</div>
				</div>
			</section>
<!-- details card section starts from here -->
        </div>
     
      </div>
    </div>
  </div>
  <!-- Cause Details end --> 
  
  <!-- Footer start -->
  <footer class="site-footer"> 
    <!-- Footer Top start -->
    <div class="footer-top-area">
      <div class="container">
        <div class="row flex-lg-row-reverse">
          <div class="col-12 col-lg-9">
            <div class="counter-block">
           
             
              <div class="counter-holder"> <span class="counter-icon"><img src="assets/images/complete-project-icon.png" alt="Supporter" /></span><span>K<?=number_format($donations['ds_amount'])?></span> 
                <h5>Total Amount Raised</h5>
              </div>
			
			<div class="counter-holder"> <span class="counter-icon"><img src="assets/images/supporter-icon.png" alt="Supporter" /></span> <span></span><span class="counter" data-count="<?=$plants['ppp_number']?>"></span>
                <h5>PSA Plants/Cyclinders Purchased</h5>
             </div>
				
				<div class="counter-holder"> <div class="bg-light"><a class="py-2 btn" href="donate.php" title="">Donate</a></div>
              </div>
				
            </div>
          </div>
          <div class="col-12 col-lg-3">
            <div class="social-block">
              <h4>Connect with us</h4>
              <div class="bottom-social"> <a href="https://www.facebook.com/stanley.kenani"><i class="fab fa-facebook-f"></i><span>Facebook</span></a> <a href="https://twitter.com/onjezani"><i class="fab fa-twitter"></i><span>Twitter</span></a> </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
    <!-- footer top end --> 
    
    <!-- copyright start -->
    <div class="footer-bottom-area">
      <div class="container">
        <div class="row">
          <div class="col-12 col-md-6 wow fadeInLeft">&copy; <script>document.write(new Date().getFullYear());</script> <span>Covid Response Private Citizens</span>.All Rights Reserved</div>
          <div class="col-12 col-md-6 text-right wow ">Design &amp; Development By: <a href="https://netsoftmw.com/" title="NetSoft Malawi" target="_blank">NetSoft Malawi</a></div>
        </div>
      </div>
    </div>
    <!-- copyright end --> 
  </footer>
  <!-- Footer end --> 
</div>
<!-- Main Wrapper end -->

<script src="assets/js/universal.js"></script> 

<div class="scrollup"><i class="fa fa-angle-up"></i></div>
<!-- Footer end --> 

<!-- Tether JS --> 
<script src="assets/js/tether.min.js"></script> 

<!-- Popper JS --> 
<script src="assets/js/popper.min.js"></script> 

<!-- Bootstrap JS --> 
<script src="assets/js/bootstrap.min.js"></script> 

<!-- OwlCarousel JS --> 
<script src="assets/js/owl.carousel.min.js"></script> 

<!-- SlickNav JS --> 
<script src="assets/js/jquery.slicknav.min.js"></script> 

<!-- fancybox Popup JS --> 
<script src="assets/js/jquery.fancybox.min.js"></script> 

<!-- WOW JS --> 
<script src="assets/js/wow-1.3.0.min.js"></script> 

<!-- Step Form with validate --> 
<script src="assets/js/jquery.validate.js"></script> 
<script src="assets/js/form-step.js"></script> 

<!-- Youtube JS --> 
<script src="assets/js/youtube-background.js"></script> 

<!-- Coming Soon JS --> 
<script src="assets/js/coming-soon.js"></script> 

<!-- Active JS --> 
<script src="assets/js/active.js"></script>
<script src="assets/datatables/jquery.dataTables.min.js"></script>
<script src="assets/datatables/dataTables.bootstrap4.min.js"></script>
	<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#news_table').DataTable({
		
      columnDefs: [
        {bSortable: false, targets: [0]}
	  ]
    });
  })
</script>

</body>
</html>