<?php
    session_start();
    include("connection/Functions.php");
	$operation = new Functions();
    if(!isset($_SESSION['user']) || empty($_SESSION['user'])){
        header("location:login.php");
        die();
    }

    $user_id = $_SESSION['user'];
    $user = $operation->retrieveSingle("SELECT *FROM users WHERE user_id = '$user_id'");
    $user_role = $user['user_role'];

    $countStudents = $operation->countAll("SELECT *FROM users WHERE user_role = 'student'");
    $countStaff = $operation->countAll("SELECT *FROM users WHERE user_role = 'visitor_staff'");
    $countUsers = $operation->countAll("SELECT *FROM users");
    $countMeals = $operation->countAll("SELECT *FROM meals");
    $countOrders = $operation->countAll("select YEAR(date_created) from orders WHERE YEAR(date_created) = YEAR(CURRENT_DATE)");
    $sumSales = $operation->retrieveSingle("SELECT SUM(amount) AS total FROM `transactions` WHERE trans_type = 2");
    $totalSales = $sumSales['total'];

  //get users
    $getUsers = $operation->retrieveMany("SELECT *FROM users WHERE user_id <> '$user_id'");
    $getOrders = $operation->retrieveMany("SELECT *FROM orders
    INNER JOIN users ON users.user_id = orders.user_id
    INNER JOIN menu_items ON menu_items.menu_id = orders.menu_id
    ORDER BY order_id DESC LIMIT 5");

    //get meals
    $getMeals = $operation->retrieveMany("SELECT * FROM `menu_items` INNER JOIN meals ON menu_items.meal_id = meals.meal_id ");
    
    $getAddedMeals = $operation->retrieveMany("SELECT * FROM `meals`");
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
	<title>DYUNI-Cafe Meals</title>
	<meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i">
	<link rel="stylesheet" href="assets/css/ready.css">
	<link rel="stylesheet" href="assets/css/demo.css">
	<link rel="stylesheet" href="assets/croppie/croppie.css">
	<link rel="stylesheet" href="assets/datatable/datatables.min.css">
    <link href="assets/select2/select2.css" rel="stylesheet" /> 

 
</head>
<body>
	<div class="wrapper">
		<div class="main-header">
			<div class="logo-header">
				<a href="index.php" class="logo " >
					DYUNI-CAFE DASH 
				</a>
				<button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse" data-target="collapse" aria-controls="sidebar" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<button class="topbar-toggler more"><i class="la la-ellipsis-v"></i></button>
			</div>
			<nav class="navbar navbar-header navbar-expand-lg">
				<div class="container-fluid">
					
					
					<ul class="navbar-nav topbar-nav ml-md-auto align-items-center">
				
						
						<li class="nav-item dropdown">
							<a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#" aria-expanded="false">
                                
                                <?php
                                if($user['img_url'] != ''){
                                    echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/'.$user['img_url'].'"/>';
                                }else{
                                    echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/no_profile.jpeg"/>';
                                }
                            ?>
                               
                                <span ><?=$user['fullname']?></span> </a>
							<ul class="dropdown-menu dropdown-user">
								<li>
									<div class="user-box">
										<div class="u-img">
                                            <?php
                                                if($user['img_url'] != ''){
                                                    echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
                                                }else{
                                                    echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
                                                }
                                            ?>
                                        </div>
										<div class="u-text">
											<h4><?=$user['fullname']?></h4>
											<p class="text-muted"><?=$user['email']?></p><a data-toggle='modal' data-target='#modalUser<?=$user_id?>' href="#" class="btn btn-rounded btn-danger btn-sm">View Profile</a></div>
										</div>
									</li>
									
									<div class="dropdown-divider"></div>
									<a class="dropdown-item" href="logout.php"><i class="fa fa-power-off"></i> Logout</a>
                                
								</ul>
								<!-- /.dropdown-user -->
                        </li></ul>
					</div>
				</nav>
			</div>
			<div class="sidebar">
				<div class="scrollbar-inner sidebar-wrapper">
					<div class="user">
						<div class="photo">
							 <?php
                                  if($user['img_url'] != ''){
                                      echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
                                  }else{
                                      echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
                                  }
                              ?>
						</div>
						<div class="info">
							<a class="" data-toggle="collapse" href="#collapseExample" aria-expanded="true">
								<span>
									<?=$user['fullname']?>
									<span class="user-level"><?=$user['user_role']?></span>
									<span class="caret"></span>
								</span>
							</a>
							<div class="clearfix"></div>

							<div class="collapse in" id="collapseExample" aria-expanded="true" style="">
								<ul class="nav">
									<li>
										<a href="#profile">
											<span class="link-collapse">My Profile</span>
										</a>
									</li>
									
									<li>
										<a href="#settings">
											<span class="link-collapse">Logout</span>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<ul class="nav">
						<li class="nav-item ">
							<a href="index.php">
								<i class="la la-dashboard"></i>
								<p>Dashboard</p>
							</a>
						</li>
						
						<li class="nav-item">
							<a href="users.php">
								<i class="la la-users"></i>
								<p>Users</p>
								<span class="badge badge-count"><?=$countUsers?></span>
							</a>
						</li>
						
						<li class="nav-item">
							<a href="orders.php">
								<i class="la la-table"></i>
								<p>Orders</p>
								<span class="badge badge-count"><?=$countOrders?></span>
							</a>
						</li>
						
						
						<li class="nav-item active">
							<a href="meals.php">
								<i class="la la-cutlery"></i>
								<p>Meals</p>
								<span class="badge badge-count"><?=$countMeals?></span>
							</a>
						</li>
						
						
					</ul>
				</div>
			</div>
			<div class="main-panel">
				<div class="content">
              

					<div class="container-fluid">
						<h4 class="page-title">Menu Items</h4>
						<div class="row">
						
							<div class="col-md-12">
								<div class="card">
									<div class="card-header">
										<div class="card-title"></div>
										
                                        <a  class="btn btn-warning pull-right" href="meals.php" data- role="button"><i class="la la-book text-3 mr-1"></i>Meals</a>
                                        
										<a  class="btn btn-warning pull-right mx-3" href="#add-admin" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="la la-plus text-3 mr-1"></i>Add Menu Item</a>

									</div>
									<div class="card-body">
										<table id="meals_tbl" class="table table-hover">
											<thead>
												<tr>
													<th scope="col"></th>
													<th scope="col">Name</th>
													<th scope="col">Meal Type</th>
													<th scope="col">Price (MWK)</th>
													<th scope="col">Item Expiry Date</th>
													<th scope="col">Action</th>
												</tr>
											</thead>
											<tbody>
												<?php
													foreach($getMeals as $row){
                                                        $sele=$row['meal_id'];
                                                        $type=$row['meal_type'];
														echo '			
														<tr>
															<td><img src=assets/img/meals/'.$row['image_url'].' height="100px" /></td>
															<td>'.$row['meal_name'].'</td>
															<td>'.$row['meal_type'].'</td>
															<td>'.number_format($row['meal_price'],2).'</td>
                                                            <td>'.$row['menu_expiry_date'].'</td>
															<td>
																<div class="form-button-action">
																	<a onclick="setUpdateMenu(\''.$row['menu_id'].'\')" href="#view-meal'.$row['menu_id'].'" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button" data-toggle="tooltip" title="View" class="btn btn-link btn-simple-primary">
                                                                  <i class="la la-eye"></i>
                                                              </a>
																</div>

																<div class="form-button-action">
																	<button onclick="openDeleteMealModal(\''.$row['menu_id'].'\')" type="button" data-toggle="tooltip" title="View" class="btn btn-link btn-simple-danger">
																		<i class="la la-trash"></i>
																	</button>
																</div>


															</td>
														</tr>
                                                        
                                            <div id="view-meal'.$row['menu_id'].'" class="modal fade " role="dialog" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                  <div class="modal-content">
                                                    <div class="modal-header">
                                                      <h5 class="modal-title font-weight-400">VIEW MENU DETAILS</h5>
                                                      <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
                                                    </div>

                                                    <div class="modal-body p-4">


                                                      <div class="row">
                                                          <div class="col-12">
                                                            <img height="100px" src="assets/img/meals/'.$row['image_url'].'"/>
                                                          </div>
                                                      </div>
                                                      ';?>
                                            <form id="updateMenuForm<?=$row['menu_id']?>" method="post">
                                                <input type="hidden" name="emeal_id" id="emeal_id" value="<?=$row['menu_id']?>"/>
              <div class="row">
                <div class="col-12 col-sm-6">
                  <div class="form-group">
                    <label for="firstName">Meal Name</label>
              
                    <select style="width:100%;" class="form-control" data-bv-field="firstName" id='selUser<?=$row['menu_id']?>' required name="emeal_id" >
                         <option  selected disabled>-Select Meal-</option> 
                        <?php
                            foreach($getAddedMeals as $roww){
                                $delected = '';
                                if($sele == $roww['meal_id']){
                                    $delected = "selected";
                                }
                             
                                ?>
                               <option <?=$delected?> value="<?=$roww['meal_id']?>"><?=$roww['meal_name']?> - K<?=number_format($roww['meal_price'],2)?></option>
                        <?php
                            }

                        ?>
                    </select>
                  </div>

                </div>

              <div class="col-12 col-sm-6">
                  <div class="form-group">
                    <label for="firstName">Meal Type</label>
                    <select class="form-control" name="emeal_type" id="meal_type<?=$row['menu_id']?>" required>
                        <?php
                                $type_selected = "";
                                if("Breakfast" == $row['meal_type']){
                                   ?>
                                    <option selected value="Breakfast">Breakfast</option>
                                    <option value="Lunch">Lunch</option>
                                    <option  value="Supper">Supper</option>
                                    <option  value="Special Meal">Special Meal</option>
                                    <?php
                                }elseif("Lunch" == $row['meal_type']){
                                    ?>
                                    <option  value="Breakfast">Breakfast</option>
                                    <option selected value="Lunch">Lunch</option>
                                    <option  value="Supper">Supper</option>
                                    <option  value="Special Meal">Special Meal</option>
                                    <?php
                                }elseif("Supper" == $row['meal_type']){
                                    ?>
                                    <option  value="Breakfast">Breakfast</option>
                                    <option value="Lunch">Lunch</option>
                                    <option selected value="Supper">Supper</option>
                                    <option  value="Special Meal">Special Meal</option>
                                    <?php
                                }elseif("Special Meal" == $row['meal_type']){
                                    ?>
                                    <option value="Breakfast">Breakfast</option>
                                    <option value="Lunch">Lunch</option>
                                    <option  value="Supper">Supper</option>
                                    <option selected value="Special Meal">Special Meal</option>
                                    <?php
                                }
                        
                        ?>
                       
                    </select>
                  </div>
              </div>
                  
            <div class="col-12 col-sm-6">
                
                  <div class="form-group">
                    <label for="firstName">Menu Expiry Date</label>
                   <input value="<?=$row['menu_expiry_date']?>" type="date" data-bv-field="firstName" name="emenu_expiry" id="menu_expiry<?=$row['menu_id']?>" required class="form-control"/>
                  </div>
              </div>
                  
                  <input type="hidden" name="menu_id" id="menu_id<?=$row['menu_id']?>" required/>
			<div class="col-12 col-sm-6">
                
                <div class="form-group">
                    <label for="firstName"></label>
                      <button  data-bv-field="firstName" id="addUserBtn<?=$row['menu_id']?>" class="btn btn-warning crop_image btn-block mt-2" type="submit">Update Menu Item</button>
                </div>
            </div>
               </div>
              
            </form><?php echo '
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                                        
                                                        ';
													}
												
												?>
										
											</tbody>
										</table>
									</div>
								</div>
	
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>


	
	  
  <div id="add-admin" class="modal fade " role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title font-weight-400">NEW MEAL MENU</h5>
            <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
          </div>
          <div class="modal-body p-4">
             
            
            <form id="addMenuForm" method="post">
              <div class="row">
                <div class="col-12 col-sm-6">
                  <div class="form-group">
                    <label for="firstName">Meal Name</label>
              
                    <select style="width:100%;" class="form-control" data-bv-field="firstName" id='selUser' required name="meal_id" >
                         <option  selected disabled>-Select Meal-</option> 
                        <?php
                            foreach($getAddedMeals as $row){
                                ?>
                               <option value="<?=$row['meal_id']?>"><?=$row['meal_name']?> - K<?=number_format($row['meal_price'],2)?></option>
                        <?php
                            }

                        ?>
                    </select>
                  </div>

                </div>

              <div class="col-12 col-sm-6">
                
                  <div class="form-group">
                    <label for="firstName">Meal Type</label>
                    <select class="form-control" name="meal_type" id="meal_type" required>
                        <option selected disabled >-Select Meal Type-</option>
                        <option value="Breakfast">Breakfast</option>
                        <option value="Lunch">Lunch</option>
                        <option value="Supper">Supper</option>
                        <option value="Special Meal">Special Meal</option>
                    </select>
                  </div>
              </div>
                  
            <div class="col-12 col-sm-6">
                
                  <div class="form-group">
                    <label for="firstName">Menu Expiry Date</label>
                   <input type="date" data-bv-field="firstName" name="menu_expiry" id="menu_expiry" required class="form-control"/>
                  </div>
              </div>
			<div class="col-12 col-sm-6">
                
                <div class="form-group">
                    <label for="firstName"></label>
                      <button  data-bv-field="firstName" id="addUserBtn" class="btn btn-warning crop_image btn-block mt-2" type="submit">Add Menu Item</button>
                </div>
            </div>
               </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
   
<div id="deleteMeal" class="modal fade " role="dialog" aria-hidden="true">
      <div class="modal-dialog " role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title font-weight-400">DELETE MENU ITEM</h5>
            <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
          </div>
          <div class="modal-body p-4">
              <div id="deleteResponse" style="width:100%;"></div>
            
            <form id="deleteMenuForm" method="post">
                <input required type="hidden" id="del_menu_id" name="del_menu_id" />
                <p>Are you sure to delete?</p>
                <div class="row">
                    <div class="col-md-6">
                        <button onclick="closeDeleteModal()" class="btn btn-warning btn-block mt-2" type="button">No</button>
                    </div>
                    <div class="col-md-6">
                        <button  id="addSliderBtn" class="btn btn-danger btn-block mt-2" type="submit">Yes</button>
                    </div>
                </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
  
    
    
</body>
<script src="assets/js/core/jquery.3.2.1.min.js"></script>
  <script src="assets/datatable/datatables.min.js"></script>

<script src="assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
<script src="assets/js/core/popper.min.js"></script>
<script src="assets/js/core/bootstrap.min.js"></script>
<script src="assets/js/plugin/chartist/chartist.min.js"></script>
<script src="assets/js/plugin/chartist/plugin/chartist-plugin-tooltip.min.js"></script>
<script src="assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>
<script src="assets/js/plugin/bootstrap-toggle/bootstrap-toggle.min.js"></script>
<script src="assets/js/plugin/jquery-mapael/jquery.mapael.min.js"></script>
<script src="assets/js/plugin/jquery-mapael/maps/world_countries.min.js"></script>
<script src="assets/js/plugin/chart-circle/circles.min.js"></script>
<script src="assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>
<script src="assets/js/ready.min.js"></script>
<script src="assets/croppie/croppie.js"></script>
<script src="assets/select2/select2.js"></script>
<script src="assets/js/js.js"></script>
<script>
function openDeleteMealModal(id){
    $("#deleteMeal").modal('toggle');
    $("#del_menu_id").val(id);
}
    function closeDeleteModal(){
        $("#deleteMeal").modal('toggle');
        document.getElementById("deleteMealForm").reset();//empty the form
    }
    


  $(document).ready(function(){
 
      	
    var table = $('#meals_tbl').DataTable({
      columnDefs: [
        {bSortable: false, targets: [0,3]} 
      ] ,
       "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
      dom: 'Bfrtip',
      buttons: [
          'colvis',
          'csv',
          'pdf'
      ]


    });
	
      
      
  // Initialize select2
  $("#selUser").select2();

  // Read selected option
  $('#but_read').click(function(){
    var username = $('#selUser option:selected').text();
    var userid = $('#selUser').val();

    $('#result').html("id : " + userid + ", name : " + username);

  });
});
</script>

</html>