<?php
    session_start();
    include("connection/Functions.php");
	$operation = new Functions();
    if(!isset($_SESSION['user']) || empty($_SESSION['user'])){
        header("location:login.php");
        die();
    }

    $user_id = $_SESSION['user'];
    $user = $operation->retrieveSingle("SELECT *FROM users WHERE user_id = '$user_id'");
    $user_role = $user['user_role'];

    $countStudents = $operation->countAll("SELECT *FROM users WHERE user_role = 'student'");
    $countStaff = $operation->countAll("SELECT *FROM users WHERE user_role = 'visitor_staff'");
    $countUsers = $operation->countAll("SELECT *FROM users");
    $countMeals = $operation->countAll("SELECT *FROM meals");
    $countOrders = $operation->countAll("select YEAR(date_created) from orders WHERE YEAR(date_created) = YEAR(CURRENT_DATE)");
    $sumSales = $operation->retrieveSingle("SELECT SUM(amount) AS total FROM `transactions` WHERE trans_type = 2");
    $totalSales = $sumSales['total'];

  //get users
    $getUsers = $operation->retrieveMany("SELECT *FROM users WHERE user_id <> '$user_id'");
    $getOrders = $operation->retrieveMany("SELECT *FROM orders
    INNER JOIN users ON users.user_id = orders.user_id
    INNER JOIN menu_items ON menu_items.menu_id = orders.menu_id
    ORDER BY order_id DESC LIMIT 5");

    //get meals
    $getMeals = $operation->retrieveMany("SELECT * FROM `meals` ");
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
	<title>DYUNI-Cafe Meals</title>
	<meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i">
	<link rel="stylesheet" href="assets/css/ready.css">
	<link rel="stylesheet" href="assets/css/demo.css">
	<link rel="stylesheet" href="assets/croppie/croppie.css">
	<link rel="stylesheet" href="assets/datatable/datatables.min.css">

 
</head>
<body>
	<div class="wrapper">
		<div class="main-header">
			<div class="logo-header">
				<a href="index.php" class="logo " >
					DYUNI-CAFE DASH 
				</a>
				<button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse" data-target="collapse" aria-controls="sidebar" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<button class="topbar-toggler more"><i class="la la-ellipsis-v"></i></button>
			</div>
			<nav class="navbar navbar-header navbar-expand-lg">
				<div class="container-fluid">
					
					
					<ul class="navbar-nav topbar-nav ml-md-auto align-items-center">
				
						
						<li class="nav-item dropdown">
							<a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#" aria-expanded="false">
                                
                                <?php
                                if($user['img_url'] != ''){
                                    echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/'.$user['img_url'].'"/>';
                                }else{
                                    echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/no_profile.jpeg"/>';
                                }
                            ?>
                               
                                <span ><?=$user['fullname']?></span> </a>
							<ul class="dropdown-menu dropdown-user">
								<li>
									<div class="user-box">
										<div class="u-img">
                                            <?php
                                                if($user['img_url'] != ''){
                                                    echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
                                                }else{
                                                    echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
                                                }
                                            ?>
                                        </div>
										<div class="u-text">
											<h4><?=$user['fullname']?></h4>
											<p class="text-muted"><?=$user['email']?></p><a data-toggle='modal' data-target='#modalUser<?=$user_id?>' href="#" class="btn btn-rounded btn-danger btn-sm">View Profile</a></div>
										</div>
									</li>
									
									<div class="dropdown-divider"></div>
									<a class="dropdown-item" href="logout.php"><i class="fa fa-power-off"></i> Logout</a>
                                
								</ul>
								<!-- /.dropdown-user -->
                        </li></ul>
					</div>
				</nav>
			</div>
			<div class="sidebar">
				<div class="scrollbar-inner sidebar-wrapper">
					<div class="user">
						<div class="photo">
							 <?php
                                  if($user['img_url'] != ''){
                                      echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
                                  }else{
                                      echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
                                  }
                              ?>
						</div>
						<div class="info">
							<a class="" data-toggle="collapse" href="#collapseExample" aria-expanded="true">
								<span>
									<?=$user['fullname']?>
									<span class="user-level"><?=$user['user_role']?></span>
									<span class="caret"></span>
								</span>
							</a>
							<div class="clearfix"></div>

							<div class="collapse in" id="collapseExample" aria-expanded="true" style="">
								<ul class="nav">
									<li>
										<a href="#profile">
											<span class="link-collapse">My Profile</span>
										</a>
									</li>
									
									<li>
										<a href="#settings">
											<span class="link-collapse">Logout</span>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<ul class="nav">
						<li class="nav-item ">
							<a href="index.php">
								<i class="la la-dashboard"></i>
								<p>Dashboard</p>
							</a>
						</li>
						
						<li class="nav-item">
							<a href="users.php">
								<i class="la la-users"></i>
								<p>Users</p>
								<span class="badge badge-count"><?=$countUsers?></span>
							</a>
						</li>
						
						<li class="nav-item">
							<a href="orders.php">
								<i class="la la-table"></i>
								<p>Orders</p>
								<span class="badge badge-count"><?=$countOrders?></span>
							</a>
						</li>
						
						
						<li class="nav-item active">
							<a href="meals.php">
								<i class="la la-cutlery"></i>
								<p>Meals</p>
								<span class="badge badge-count"><?=$countMeals?></span>
							</a>
						</li>
						
						
					</ul>
				</div>
			</div>
			<div class="main-panel">
				<div class="content">
					<div class="container-fluid">
						<h4 class="page-title">Meals</h4>
						<div class="row">
						
							<div class="col-md-12">
								<div class="card">
									<div class="card-header">
										<div class="card-title"></div>
										
                                        <a  class="btn btn-warning pull-right" href="menus.php" data- role="button"><i class="la la-book text-3 mr-1"></i>Menus</a>
                                        
										<a  class="btn btn-warning pull-right mx-3" href="#add-admin" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="la la-plus text-3 mr-1"></i>Add Meal</a>

									</div>
									<div class="card-body">
										<table id="meals_tbl" class="table table-hover">
											<thead>
												<tr>
													<th scope="col"></th>
													<th scope="col">Name</th>
													<th scope="col">Price (MWK)</th>
													<th scope="col">Action</th>
												</tr>
											</thead>
											<tbody>
												<?php
													foreach($getMeals as $row){
														echo '			
														<tr>
															<td><img src=assets/img/meals/'.$row['image_url'].' height="100px" /></td>
															<td>'.$row['meal_name'].'</td>
															<td>'.number_format($row['meal_price'],2).'</td>
															<td>
																<div class="form-button-action">
																	<a onclick="setUpdateMeal(\''.$row['meal_id'].'\')" href="#view-meal'.$row['meal_id'].'" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button" data-toggle="tooltip" title="View" class="btn btn-link btn-simple-primary">
                                                                  <i class="la la-eye"></i>
                                                              </a>
																</div>

																<div class="form-button-action">
																	<button onclick="openDeleteMealModal(\''.$row['meal_id'].'\')" type="button" data-toggle="tooltip" title="View" class="btn btn-link btn-simple-danger">
																		<i class="la la-trash"></i>
																	</button>
																</div>


															</td>
														</tr>
                                                        
                                            <div id="view-meal'.$row['meal_id'].'" class="modal fade " role="dialog" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                  <div class="modal-content">
                                                    <div class="modal-header">
                                                      <h5 class="modal-title font-weight-400">VIEW MEAL</h5>
                                                      <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
                                                    </div>

                                                    <div class="modal-body p-4">


                                                      <div class="row">
                                                          <div class="col-12">
                                                            <img height="100px" src="assets/img/meals/'.$row['image_url'].'"/>
                                                          </div>
                                                      </div>
                                                      <div id="pictureForm1'.$row['meal_id'].'">
                                                      <form id="editMealForm'.$row['meal_id'].'" method="post">
                                                            <div class="row">
                                                                <div class="col-12 col-sm-6">
                                                                  <div class="form-group">
                                                                    <label for="firstName">Meal Name</label>
                                                                    <input type="text" class="form-control" data-bv-field="firstName" id="meal_name'.$row['meal_id'].'" name="emeal_name" value="'.$row['meal_name'].'" required placeholder="Meal Name" />
                                                                  </div>

                                                                </div>

                                                              <div class="col-12 col-sm-6">

                                                                  <div class="form-group">
                                                                    <label for="firstName">Price (MWK)</label>
                                                                    <input type="text" class="form-control" data-bv-field="firstName" onkeypress="return isNumberKey(event)"  id="meal_price'.$row['meal_id'].'" name="emeal_price" required value="'.$row['meal_price'].'" placeholder="Price" />
                                                                  </div>
                                                              </div>

                                                           <input type="hidden"  name="emeal_id" value="'.$row['meal_id'].'" />
                                                           
                                                            <div class="col-12 col-sm-6">

                                                                <div class="form-group">
                                                                     <button  onclick="updateMeal(\''.$row['meal_id'].'\')" id="btn_update'.$row['meal_id'].'" class="btn btn-warning  btn-block mt-2" type="submit">Update Meal</button>
                                                                </div>
                                                            </div>
                                                           <div class="col-12 col-sm-6">

                                                                <div class="form-group">
                                                                     <button onclick="showChangePicture(\''.$row['meal_id'].'\')" class="btn btn-secondary btn-block mt-2" type="button">Change Picture</button>
                                                                </div>
                                                            </div>
                                                             
                                                          </div>
                                                        
                                                      </form>
                                                        
                                                 </div>
                                                 <div style="display:none;" id="pictureForm'.$row['meal_id'].'">
                                                 
                                                      <form id="editPictureForm'.$row['meal_id'].'" method="post">
                                                       <div class="col-12 ">

                                                            <div class="form-group">
                                                                    <label for="firstName">Picture</label>
                                                                    <input type="file" class="form-control" data-bv-field="firstName" id="meal_pic'.$row['meal_id'].'" accept="image/*" name="meal_pic" required placeholder="Picture" />
                                                                  </div>
                                                              </div>
                                                         <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer'.$row['meal_id'].'" style="display: none;">
                                                                <div class="row">
                                                                    <div class="col-md-12 text-center">
                                                                      <div id="image_demo'.$row['meal_id'].'" style="width:100%; margin-top:30px"></div>
                                                                    </div>

                                                                </div>
                                                              </div>  
                                                      <div class="row">  
                                                        <div class="col-12 col-sm-6">

                                                                <div class="form-group">
                                                                     <button style="display: none;"  id="btn_add'.$row['meal_id'].'" class="btn btn-warning  crop_image btn-block mt-2" type="button">Change picture</button>
                                                                </div>
                                                            </div>
                                                           <div class="col-12 col-sm-6">

                                                                <div class="form-group">
                                                                     <button onclick="hideChangePicture(\''.$row['meal_id'].'\')" class="btn btn-secondary btn-block mt-2" type="button">Hide Change Picture</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                      </form>
                                                    </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                                        
                                                        ';
													}
												
												?>
										
											</tbody>
										</table>
									</div>
								</div>
	
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>


	
	  
  <div id="add-admin" class="modal fade " role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title font-weight-400">NEW MEAL</h5>
            <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
          </div>
          <div class="modal-body p-4">
              <div id="adminResponse" style="width:100%;"></div>
            
            <form id="addmealForm" method="post">
              <div class="row">
                <div class="col-12 col-sm-6">
                  <div class="form-group">
                    <label for="firstName">Meal Name</label>
                    <input type="text" class="form-control" data-bv-field="firstName" id="meal_name" name="meal_name" required placeholder="Meal Name" />
                  </div>

                </div>

              <div class="col-12 col-sm-6">
                
                  <div class="form-group">
                    <label for="firstName">Price (MWK)</label>
                    <input type="text" class="form-control" onkeypress="return isNumberKey(event)" data-bv-field="firstName" id="meal_price" name="meal_price" required placeholder="Price" />
                  </div>
              </div>
                  
            <div class="col-12 ">
                
                  <div class="form-group">
                    <label for="firstName">Picture</label>
                    <input type="file" class="form-control" data-bv-field="firstName" id="meal_pic" accept="image/*" name="meal_pic" required placeholder="Picture" />
                  </div>
              </div>
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
                <div class="row">
                    <div class="col-md-12 text-center">
                      <div id="image_demo" style="width:100%; margin-top:30px"></div>
                    </div>

                </div>
              </div>  
				
			
				  
				  
               </div>
              <button style="display:none;"  id="btn_add" class="btn btn-warning crop_image btn-block mt-2" type="button">Add Meal</button>
            </form>
          </div>
        </div>
      </div>
    </div>
   
<div id="deleteMeal" class="modal fade " role="dialog" aria-hidden="true">
      <div class="modal-dialog " role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title font-weight-400">DELETE MEAL</h5>
            <button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
          </div>
          <div class="modal-body p-4">
              <div id="deleteResponse" style="width:100%;"></div>
            
            <form id="deleteMealForm" method="post">
                <input required type="hidden" id="meal_id" name="meal_id" />
                <p>Are you sure to delete?</p>
                <div class="row">
                    <div class="col-md-6">
                        <button onclick="closeDeleteModal()" class="btn btn-warning btn-block mt-2" type="button">No</button>
                    </div>
                    <div class="col-md-6">
                        <button  id="addSliderBtn" class="btn btn-danger btn-block mt-2" type="submit">Yes</button>
                    </div>
                </div>
              
            </form>
          </div>
        </div>
      </div>
    </div>
  
    
    
</body>
<script src="assets/js/core/jquery.3.2.1.min.js"></script>
  <script src="assets/datatable/datatables.min.js"></script>

<script src="assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
<script src="assets/js/core/popper.min.js"></script>
<script src="assets/js/core/bootstrap.min.js"></script>
<script src="assets/js/plugin/chartist/chartist.min.js"></script>
<script src="assets/js/plugin/chartist/plugin/chartist-plugin-tooltip.min.js"></script>
<script src="assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>
<script src="assets/js/plugin/bootstrap-toggle/bootstrap-toggle.min.js"></script>
<script src="assets/js/plugin/jquery-mapael/jquery.mapael.min.js"></script>
<script src="assets/js/plugin/jquery-mapael/maps/world_countries.min.js"></script>
<script src="assets/js/plugin/chart-circle/circles.min.js"></script>
<script src="assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>
<script src="assets/js/ready.min.js"></script>
<script src="assets/croppie/croppie.js"></script>
<script src="assets/js/js.js"></script>
<script>
function openDeleteMealModal(id){
    $("#deleteMeal").modal('toggle');
    $("#meal_id").val(id);
}
    function closeDeleteModal(){
        $("#deleteMeal").modal('toggle');
        document.getElementById("deleteMealForm").reset();//empty the form
    }
    
    function showChangePicture(id){
        $("#pictureForm1"+id).hide(1000);
        $("#pictureForm"+id).show(1100);
        
    }
    
    function hideChangePicture(id){
        $("#pictureForm1"+id).show(1100);
        $("#pictureForm"+id).hide(1000);
    }
    
$(document).ready(function(){
	//notification variables
	var placementFrom = "top";
	var placementAlign = "right";
	var style = "withicon";
	var content = {};

	
    var table = $('#meals_tbl').DataTable({
      columnDefs: [
        {bSortable: false, targets: [0,3]} 
      ] ,
       "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
      dom: 'Bfrtip',
      buttons: [
          'colvis',
          'csv',
          'pdf'
      ]


    });
	
	var image_crop = $('#image_demo').croppie({
		enableExif: true,
		viewport: {
		  width:200,
		  height:125,
		  type:'square' //circle
		},
		boundary:{
		  width:300,
		  height:300
		},
		showZoomer: false,
    enableResize: true,
    enableOrientation: true,
    mouseWheelZoom: 'ctrl'
	  });
	
	 $('#meal_pic').on('change', function(){
		var reader = new FileReader();
		reader.onload = function (event) {
		  image_crop.croppie('bind', {
			url: event.target.result
		  }).then(function(){
//			console.log('jQuery bind complete');
		  });
		}
		reader.readAsDataURL(this.files[0]);
		$('#uploadimageContainer').show();
		$('#btn_add').show();
	  });

	$('#btn_add').click(function(event){
		upload_btn_action=$(this).text();
		image_crop.croppie('result', {
		  type: 'canvas',
		  size: "original", 
		  format: "png",
		  quality: 1
		}).then(function(response){
			//get meal name and meal price
			var meal_price  = $("#meal_price").val();
			var meal_name  = $("#meal_name").val();
			if(meal_price !== "" && meal_name !==""){
				$("#btn_add").html('<span class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></span> Adding...');
				$.ajax({
					url:"process/meals.php",
					type: "POST",
					data:{"picture": response,"meal_price":meal_price,"meal_name":meal_name},

					cache: false,

					success:function(dataResult)
					{ 
						console.log(dataResult);
						
						var data = JSON.parse(dataResult);
						$("#btn_add").html('Add Meal');
						  $('#uploadimageContainer').hide();
							$('#btn_add').hide();
					  if(data.code==1){
						  //Uploaded and finish
							 var state = "success";
							  content.message = data.msg;
							  content.title = 'Add Meal';
							  if (style == "withicon") {
								  content.icon = 'la la-bell';
							  } else {
								  content.icon = 'none';
							  }
							  content.url = 'meals.php';
							  content.target = '_blank';

							  $.notify(content,{
								  type: state,
								  placement: {
									  from: placementFrom,
									  align: placementAlign
								  },
								  time: 800,
							  });
						
							$("#add-admin").modal("toggle");
						  	 document.getElementById("addmealForm").reset();//empty the form
						  
						   setTimeout(function(){ 
							  window.location = "meals";
							}, 800);
					  }else{
						  	var state = "danger";
							  content.message = data.msg;
							  content.title = 'Add Meal';
							  if (style == "withicon") {
								  content.icon = 'la la-bell';
							  } else {
								  content.icon = 'none';
							  }
							  content.url = 'meals.php';
							  content.target = '_blank';

							  $.notify(content,{
								  type: state,
								  placement: {
									  from: placementFrom,
									  align: placementAlign
								  },
								  time: 800,
							  });
							$("#add-admin").modal("toggle");
						  	 document.getElementById("addmealForm").reset();//empty the form
					  }

					}
				  });
			}else{
				var state = "danger";
				  content.message = "Fill all fields";
				  content.title = 'Add Meal';
				  if (style == "withicon") {
					  content.icon = 'la la-bell';
				  } else {
					  content.icon = 'none';
				  }
				  content.url = 'meals.php';
				  content.target = '_blank';

				  $.notify(content,{
					  type: state,
					  placement: {
						  from: placementFrom,
						  align: placementAlign
					  },
					  time: 800,
				  });
				$("#add-admin").modal("toggle");
				
				
			}
	
			
		})
        event.preventDefault();
    event.stopImmediatePropagation();
	  });

	
});
    
function setUpdateMeal(id){
    var image_crop = $('#image_demo'+id).croppie({
		enableExif: true,
		viewport: {
		  width:200,
		  height:125,
		  type:'square' //circle
		},
		boundary:{
		  width:300,
		  height:300
		},
		showZoomer: false,
    enableResize: true,
    enableOrientation: true,
    mouseWheelZoom: 'ctrl'
	  });
	
	 $('#meal_pic'+id).on('change', function(){
		var reader = new FileReader();
		reader.onload = function (event) {
		  image_crop.croppie('bind', {
			url: event.target.result
		  }).then(function(){
//			console.log('jQuery bind complete');
		  });
		}
		reader.readAsDataURL(this.files[0]);
		$('#uploadimageContainer'+id).show();
		$('#btn_add'+id).show();
	  });

	$('#btn_add'+id).click(function(event){
		upload_btn_action=$(this).text();
		image_crop.croppie('result', {
		  type: 'canvas',
		  size: "original", 
		  format: "png",
		  quality: 1
		}).then(function(response){
			//get meal name and meal price
            $("#btn_add"+id).html('<span class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></span> Updating...');
				$.ajax({
					url:"process/meals.php",
					type: "POST",
					data:{"pictureEdit": response, "eidpic":id},

					cache: false,

					success:function(dataResult)
					{ 
						
						var data = JSON.parse(dataResult);
						$("#btn_add"+id).html('Update Meal');
						  $('#uploadimageContainer'+id).hide();
							$('#btn_add'+id).hide();
					  if(data.code==1){
						  //Uploaded and finish
							 var state = "success";
							  content.message = data.msg;
							  content.title = 'Update Meal';
							  if (style == "withicon") {
								  content.icon = 'la la-bell';
							  } else {
								  content.icon = 'none';
							  }
							  content.url = 'meals.php';
							  content.target = '_blank';

							  $.notify(content,{
								  type: state,
								  placement: {
									  from: placementFrom,
									  align: placementAlign
								  },
								  time: 800,
							  });
						
							$("#view-meal"+id).modal("toggle");
						  	 document.getElementById("editMealForm"+id).reset();//empty the form
						  
						   setTimeout(function(){ 
							  window.location = "meals";
							}, 800);
					  }else{
						  	var state = "danger";
							  content.message = data.msg;
							  content.title = 'Update Meal';
							  if (style == "withicon") {
								  content.icon = 'la la-bell';
							  } else {
								  content.icon = 'none';
							  }
							  content.url = 'meals.php';
							  content.target = '_blank';

							  $.notify(content,{
								  type: state,
								  placement: {
									  from: placementFrom,
									  align: placementAlign
								  },
								  time: 800,
							  });
							$("#view-meal"+id).modal("toggle");
						  	 document.getElementById("editMealForm"+id).reset();//empty the form
					  }

					}
				  });
	
		})
	  });

}
function updateMeal(id){
    $("#editMealForm"+id).on('submit',function(e){
   var form_data = $(this).serialize();
    
    var meal_name = $("#meal_name"+id).val();
    var meal_price = $("#meal_price"+id).val();

    if(meal_name !== '' && meal_price !== '' ){
          $("#btn_update"+id).html('<span class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></span> Updating...');
           $.ajax({ //make ajax request to cart_process.php
              url: "process/meals.php",
                  type: "POST",
                  //dataType:"json", //expect json value from server
                  data: form_data
              }).done(function(dataResult){ //on Ajax success
                console.log(dataResult);
                $("#btn_update"+id).html('Update Meal');
                var data = JSON.parse(dataResult);
             
                document.getElementById("editMealForm"+id).reset();//empty the form
                $("#view-meal"+id).modal('toggle');
             
                if(data.code == 1){
                  var state = "success";
                  content.message = data.msg;
                  content.title = 'Update Meal';
                  if (style == "withicon") {
                      content.icon = 'la la-bell';
                  } else {
                      content.icon = 'none';
                  }
                  content.url = 'meals.php';
                  content.target = '_blank';

                  $.notify(content,{
                      type: state,
                      placement: {
                          from: placementFrom,
                          align: placementAlign
                      },
                      time: 800,
                  });
                   setTimeout(function(){
                     window.location = "meals";
                   },800);
                  
                }else if(data.code == 2){
                    var state = "danger";
                    content.message = data.msg;
                    content.title = 'Update Meal';
                    if (style == "withicon") {
                        content.icon = 'la la-bell';
                    } else {
                        content.icon = 'none';
                    }
                    content.url = 'meals.php';
                    content.target = '_blank';

                    $.notify(content,{
                        type: state,
                        placement: {
                            from: placementFrom,
                            align: placementAlign
                        },
                        time: 800,
                    });
                }else{
                  var state = "danger";
                  content.message = "An unknown error occured, try again later!";
                  content.title = 'Update Meal';
                  if (style == "withicon") {
                      content.icon = 'la la-bell';
                  } else {
                      content.icon = 'none';
                  }
                  content.url = 'meals.php';
                  content.target = '_blank';

                  $.notify(content,{
                      type: state,
                      placement: {
                          from: placementFrom,
                          align: placementAlign
                      },
                      time: 800,
                  });
                }
                  document.getElementById("editMealForm"+id).reset();//empty the form
                $("#view-meal"+id).modal('toggle');
             
           });

    }else{
                $("#view-meal"+id).modal('toggle');
             
        var state = "danger";
        content.message = "All fields are required";
        content.title = 'Update Meal';
        if (style == "withicon") {
            content.icon = 'la la-bell';
        } else {
            content.icon = 'none';
        }
        content.url = 'meals.php';
        content.target = '_blank';

        $.notify(content,{
            type: state,
            placement: {
                from: placementFrom,
                align: placementAlign
            },
            time: 1000,
        });
      
                $("#view-meal"+id).modal('toggle');
             
    }
  
 
    e.preventDefault();
    e.stopImmediatePropagation();
});

}    
    
</script>

</html>