<?php
session_start();
include("connection/Functions.php");
$operation = new Functions();
if(!isset($_SESSION['user']) || empty($_SESSION['user'])){
	header("location:login.php");
	die();
}

$user_id = $_SESSION['user'];
$user = $operation->retrieveSingle("SELECT *FROM users WHERE user_id = '$user_id'");

$today = date("Y-m-d");
$countActiveRecruitments = $operation->countAll("SELECT * FROM `recruitment_positions` WHERE dateline >= curdate()");



$countStudents = $operation->countAll("SELECT *FROM users ");
$countStaff = $operation->countAll("SELECT *FROM staff");
$countUsers = $operation->countAll("SELECT *FROM users");
$countNews = $operation->countAll("SELECT *FROM news");
$countProjects = $operation->countAll("select * from projects");
$countPublications = $operation->countAll("select * from publications");
$countSeminarPresentations = $operation->countAll("select * from seminar_presentations");
$countCapacityBuildingSessions = $operation->countAll("select * from capacity_building_sessions");
$countResearch = $operation->countAll("select * from research_areas");
$countGallery = $operation->countAll("SELECT * FROM `photo_gallery` ");

  //get users
$getUsers = $operation->retrieveMany("SELECT *FROM users WHERE user_id <> '$user_id' LIMIT 5");
$getResearch = $operation->retrieveMany("SELECT *FROM research_areas INNER JOIN research_areas_category ON research_areas.category_id = research_areas_category.category_id");
$getStaff = $operation->retrieveMany("SELECT *FROM staff");

    //get categories
$getCategories = $operation->retrieveMany("SELECT * FROM `research_areas_category` ");
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
	<title>IPOR Dashboard</title>
	<meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i">
	<link rel="stylesheet" href="assets/css/ready.css">
	<link rel="stylesheet" href="assets/css/demo.css">
	<link rel="stylesheet" href="assets/croppie/croppie.css">
	<link rel="stylesheet" href="assets/datatable/datatables.min.css">
	<link rel="stylesheet" href="assets/simditor/styles/simditor.css">

	<!-- summernote -->
	<link rel="stylesheet" href="assets/summernote/summernote-bs4.min.css">
</head>
<body>
	<div class="wrapper">
		<div class="main-header">
			<div class="logo-header">
				<a href="index.php" class="logo " >
					IPOR-DASHBOARD
				</a>
				<button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse" data-target="collapse" aria-controls="sidebar" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>
				<button class="topbar-toggler more"><i class="la la-ellipsis-v"></i></button>
			</div>
			<nav class="navbar navbar-header navbar-expand-lg">
				<div class="container-fluid">
					
					
					<ul class="navbar-nav topbar-nav ml-md-auto align-items-center">

						
						<li class="nav-item dropdown">
							<a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#" aria-expanded="false">

								<?php
								if($user['img_url'] != ''){
									echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/'.$user['img_url'].'"/>';
								}else{
									echo '<img height="50px" alt="user-img" width="50" class="img-circle" src="assets/img/users/no_profile.jpeg"/>';
								}
								?>

								<span ><?=$user['fullname']?></span> </a>
								<ul class="dropdown-menu dropdown-user">
									<li>
										<div class="user-box">
											<div class="u-img">
												<?php
												if($user['img_url'] != ''){
													echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
												}else{
													echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
												}
												?>
											</div>
											<div class="u-text">
												<h4><?=$user['fullname']?></h4>
												<p class="text-muted"><?=$user['email']?></p><a data-toggle='modal' data-target='#modalUser<?=$user_id?>' href="#" class="btn btn-rounded btn-danger btn-sm">View Profile</a></div>
											</div>
										</li>

										<div class="dropdown-divider"></div>
										<a class="dropdown-item" href="logout.php"><i class="fa fa-power-off"></i> Logout</a>

									</ul>
									<!-- /.dropdown-user -->
								</li></ul>
							</div>
						</nav>
					</div>
					<div class="sidebar">
						<div class="scrollbar-inner sidebar-wrapper">
							<div class="user">
								<div class="photo">
									<?php
									if($user['img_url'] != ''){
										echo '<img height="100px" src="assets/img/users/'.$user['img_url'].'"/>';
									}else{
										echo '<img height="100px" src="assets/img/users/no_profile.jpeg"/>';
									}
									?>
								</div>
								<div class="info">
									<a class="" data-toggle="collapse" href="#collapseExample" aria-expanded="true">
										<span>
											<?=$user['fullname']?>

											<?php
											if($user['user_role'] == 1){
												echo '<span class="user-level">Director</span>';
											}elseif($user['user_role'] == 2){
												echo '<span class="user-level">IT Personel</span>';
											}elseif($user['user_role'] == 3){
												echo '<span class="user-level">Executive Officer</span>';
											}elseif($user['user_role'] == 4){
												echo '<span class="user-level">Administration</span>';
											}elseif($user['user_role'] == 5){
												echo '<span class="user-level">Finance Manager</span>';
											}elseif($user['user_role'] == 6){
												echo '<span class="user-level">Communication Officer</span>';
											}


											?>

											<span class="caret"></span>
										</span>
									</a>
									<div class="clearfix"></div>

									<div class="collapse in" id="collapseExample" aria-expanded="true" style="">
										<ul class="nav">
											<li>
												<a  data-toggle='modal' data-target='#modalUser<?=$user_id?>' href="#">
													<span class="link-collapse">My Profile</span>
												</a>
											</li>

											<li>
												<a href="logout.php">
													<span class="link-collapse">Logout</span>
												</a>
											</li>
										</ul>
									</div>
								</div>
							</div>
							<?php include("side_bar.php"); ?>
							<!--<ul class="nav">
								<li class="nav-item ">
									<a href="index.php">
										<i class="la la-dashboard"></i>
										<p>Dashboard</p>
									</a>
								</li>
								<?php 
								if ($user['user_role']==1 || $user['user_role']==2 || $user['user_role']==6) {
									if ($user['user_role'] == 6) {
										?>
										<li class="nav-item ">
											<a href="users.php">
												<i class="la la-user"></i>
												<p>Users</p>
												<span class="badge badge-count"><?=$countUsers?></span>
											</a>
										</li>

										<li class="nav-item">
											<a href="staff.php">
												<i class="la la-users"></i>
												<p>Staff</p>
												<span class="badge badge-count"><?=$countStaff?></span>
											</a>
										</li>


										<li class="nav-item">
											<a href="news.php">
												<i class="la la-hacker-news"></i>
												<p>News</p>
												<span class="badge badge-count"><?=$countNews?></span>
											</a>
										</li>

										<li class="nav-item">
											<a href="projects.php">
												<i class="la la-briefcase"></i>
												<p>Projects</p>
												<span class="badge badge-count"><?=$countProjects?></span>
											</a>
										</li>


										<li class="nav-item">
											<a href="publications.php">
												<i class="la la-wikipedia-w"></i>
												<p>Publications</p>
												<span class="badge badge-count"><?=$countPublications?></span>
											</a>
										</li>
										<li class="nav-item active">
											<a href="focus.php">
												<i class="la la-book"></i>
												<p>Focus Areas</p>
												<span class="badge badge-count"><?=$countResearch?></span>
											</a>

											<li class="nav-item">
												<a href="gallery.php">
													<i class="la la-photo"></i>
													<p>Photo Gallery</p>
													<span class="badge badge-count"><?=$countGallery?></span>
												</a>
											</li>
											<?php
										}else{
											?>
											<li class="nav-item ">
												<a href="users.php">
													<i class="la la-user"></i>
													<p>Users</p>
													<span class="badge badge-count"><?=$countUsers?></span>
												</a>
											</li>

											<li class="nav-item">
												<a href="staff.php">
													<i class="la la-users"></i>
													<p>Staff</p>
													<span class="badge badge-count"><?=$countStaff?></span>
												</a>
											</li>


											<li class="nav-item">
												<a href="news.php">
													<i class="la la-hacker-news"></i>
													<p>News</p>
													<span class="badge badge-count"><?=$countNews?></span>
												</a>
											</li>

											<li class="nav-item">
												<a href="projects.php">
													<i class="la la-briefcase"></i>
													<p>Projects</p>
													<span class="badge badge-count"><?=$countProjects?></span>
												</a>
											</li>


											<li class="nav-item">
												<a href="publications.php">
													<i class="la la-wikipedia-w"></i>
													<p>Publications</p>
													<span class="badge badge-count"><?=$countPublications?></span>
												</a>
											</li>
											<li class="nav-item active">
												<a href="focus.php">
													<i class="la la-book"></i>
													<p>Focus Areas</p>
													<span class="badge badge-count"><?=$countResearch?></span>
												</a>
											</li>
											<li class="nav-item">
												<a href="recruitment.php">
													<i class="la la-briefcase"></i>
													<p>Recruitment</p>
													<span class="badge badge-count"><?=$countActiveRecruitments?></span>
												</a>
											</li>
											<li class="nav-item">
												<a href="gallery.php">
													<i class="la la-photo"></i>
													<p>Photo Gallery</p>
													<span class="badge badge-count"><?=$countGallery?></span>
												</a>
											</li>
											<?php
										}
										?>

										<?php
									}else{
										?>                        

										<li class="nav-item">
											<a href="recruitment.php">
												<i class="la la-briefcase"></i>
												<p>Recruitment</p>
												<span class="badge badge-count"><?=$countActiveRecruitments?></span>
											</a>
										</li>

										<?php
									}

									?>

								</ul>-->
							</div>
						</div>

						<div class="main-panel">
							<div class="content">
								<div class="container-fluid">
									<h4 class="page-title">Focus Areas</h4>
									<div class="row">

										<div class="col-md-12">
											<div class="card">
												<div class="card-header">
													<div class="card-title"></div>

													<a  class="btn btn-warning pull-right" href="#add-admin" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="la la-plus text-3 mr-1"></i>Add Focus Area</a>

													<?php
										// check if added or not
													if ($operation->countAll("SELECT * FROM `focus_area_desc` ") == 0) {
													?><a  class="btn btn-warning pull-left" href="#add-focu-area" data-toggle="modal"  role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="la la-info text-3 mr-1"></i>Add Focus Areas Desc</a>
													<?php 
												}else{
												?><a  class="btn btn-secondary pull-left" href="#add-focu-area" data-toggle="modal"  role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="la la-info text-3 mr-1"></i>Update Focus Areas Desc</a>
												<?php 
											}
											?>

											<a  class="btn btn-warning pull-right mx-2" href="focus_category.php" >Focus Area Categories</a>

										</div>
										<div class="card-body">
											<table class="table table-hover" id="user_tbl">
												<thead>
													<tr>
														<th scope="col"></th>
														<th scope="col">Title</th>
														<th scope="col">File</th>
														<th scope="col">Action</th>
													</tr>
												</thead>
												<tbody>

													<?php
													foreach($getResearch as $row){
														$img = '';
														$status ='';


														if($row['research_status'] == '1'){
															$status = '<a href="../images/research/'.$row['research_file'].'">Download</a>';
														}else{
															$status = "<i class='la la-exclamation text-danger'></i>";
														}
                                                  //sort out user role

														$btn_del = '';
														$categories = '';
														$btn_sus = '';

														$categories .= '
														<option selected value = '.$row['category_id'].'>
														'.$row['category_name'].'</option>';

														foreach($getCategories as $row1){
															$categories .= '
															<option value='.$row1['category_id'].'>'.$row1['category_name'].'</option>';
														}


														$btn_del = '<div class="col-12 col-sm-6">
														<button data-dismiss="modal" onclick="getDeleteNews(\''.$row['research_area_id'].'\')"  id="btn_e_del'.$row['research_area_id'].'" class="btn btn-danger btn-block mt-2" type="button">Delete </button>
														</div>';





														if($row['img_url'] != ''){
															$img = '<img height=80px" src="../images/research/'.$row['img_url'].'"/>';
														}else{
															$img = '<img height="50px" src="assets/img/users/no_profile.jpeg"/>';
														}

														echo '
														<tr >
														<td>'.$img.'</td>
														<td>'.$row['research_name'].' - '.$row['category_name'].'</td>
														<td>'.$status.'</td>
														<td>
														<div class="form-button-action">
														<a href="#view-user'.$row['research_area_id'].'" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button" data-toggle="tooltip" title="View" class="btn btn-link btn-simple-primary">
														<i class="la la-eye"></i>
														</a>
														</div>

														<div class="form-button-action">
														<a onclick="setUpdateMeal(\''.$row['research_area_id'].'\')" href="#view-meal'.$row['research_area_id'].'" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button" data-toggle="tooltip" title="Change Picture" class="btn btn-link btn-simple-primary">
														<i class="la la-photo"></i>
														</a>
														</div>
														<div class="form-button-action">
														<a onclick="setUpdateAttachment(\''.$row['research_area_id'].'\')" href="#view-attachment" data-toggle="modal"  role="button" id="addAdmin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button" data-toggle="tooltip" title="Add/Change Attachment" class="btn btn-link btn-simple-primary">
														<i class="la la-book"></i>
														</a>
														</div>

														</td>
														</tr>

														<div id="view-user'.$row['research_area_id'].'" class="modal fade " role="dialog" aria-hidden="true">
														<div class="modal-dialog modal-lg" role="document">
														<div class="modal-content">
														<div class="modal-header">
														<h5 class="modal-title font-weight-400">VIEW RESEARCH AREA</h5>
														<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
														</div>

														<div class="modal-body p-4">


														<div class="row">
														<div class="col-12">

														'.$img.'
														</div>
														</div>
														<div id="adminResponse" style="width:100%;"></div>

														<form id="editResearchForm'.$row['research_area_id'].'" method="post">
														<div class="row">
														<div class="col-12 ">
														<div class="form-group">
														<label for="firstName">Title</label>
														<input type="text" class="form-control" data-bv-field="firstName" id="etitle'.$row['research_area_id'].'" name="etitle" required placeholder="Title" value="'.$row['research_name'].'" />
														</div>

														</div>

														<div class="col-12 ">
														<div class="form-group">
														<label for="firstName">Category Name</label>
														<se
														</div>

														</div>

														<input type="hidden" id="e_news_id'.$row['research_area_id'].'" name="e_news_id" value="'.$row['research_area_id'].'"/>
														<div class="col-12 ">

														<select class="form-control" name="cat_name_e" id="cat_name_e'.$row['category_id'].'" required>
														'.$categories.'
														</select> 
														</div>
														</div>

														<div class="row">
														<div class="col-12 col-sm-6">
														<button onclick="editResearch(\''.$row['research_area_id'].'\')"  id="editUserBtn'.$row['research_area_id'].'" class="btn btn-warning btn-block mt-2 " type="submit">Update </button>
														</div>

														'.$btn_del.'
														</div>

														</form>
														</div>
														</div>
														</div>
														</div>
														</div>
														<div id="view-meal'.$row['research_area_id'].'" class="modal fade " role="dialog" aria-hidden="true">
														<div class="modal-dialog modal-lg" role="document">
														<div class="modal-content">
														<div class="modal-header">
														<h5 class="modal-title font-weight-400">CHANGE PICTURE</h5>
														<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
														</div>

														<div class="modal-body p-4">


														<div class="row">
														<div class="col-12">
														'.$img.'
														</div>
														</div>

														<div  id="pictureForm'.$row['research_area_id'].'">

														<form id="editPictureForm'.$row['research_area_id'].'" method="post">
														<div class="col-12 ">

														<div class="form-group">
														<label for="firstName">Picture</label>
														<input type="file" class="form-control" data-bv-field="firstName" id="meal_pic'.$row['research_area_id'].'" accept="image/*" name="meal_pic" required placeholder="Picture" />
														</div>
														</div>
														<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer'.$row['research_area_id'].'" style="display: none;">
														<div class="row">
														<div class="col-md-12 text-center">
														<div id="image_demo'.$row['research_area_id'].'" style="width:100%; margin-top:30px"></div>
														</div>

														</div>
														</div>  
														<div class="row">  
														<div class="col-12 col-sm-6">

														<div class="form-group">
														<button style="display: none;"  id="btn_add'.$row['research_area_id'].'" class="btn btn-warning  crop_image btn-block mt-2" type="button">Change picture</button>
														</div>
														</div>

														</form>
														</div>
														</div>
														</div>
														</div>
														</div>


														';
													}
													?>
												</tbody>
											</table>
										</div>
									</div>

								</div>
							</div>
						</div>
					</div>

				</div>
			</div>




			<div id="add-admin" class="modal fade " role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title font-weight-400">NEW FOCUS AREA</h5>
							<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
						</div>
						<div class="modal-body p-4">

							<form id="addNewsForm" method="post">
								<div class="row">
									<div class="col-12 ">
										<div class="form-group">
											<label for="firstName">Title</label>
											<input type="text" class="form-control" data-bv-field="firstName" id="title" name="title"  required placeholder="Title" />
										</div>

									</div>

									<div class="col-12 ">
										<div class="form-group">
											<label for="firstName">Category</label>
											<select class="form-control" name="cat_name" id="cat_name" required>
												<option>-Select-</option>
												<?php
												foreach($getCategories as $row){
													echo '<option value='.$row['category_id'].'>'.$row['category_name'].'</option>';
												}
												?>
											</select>
										</div>

									</div>


									<div class="col-12 ">

										<div class="form-group">
											<label for="firstName">Picture</label>
											<input type="file" class="form-control" data-bv-field="firstName" id="meal_pic" accept="image/*" name="meal_pic" required placeholder="Picture" />
										</div>
									</div>


									<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
										<div class="row">
											<div class="col-md-12 text-center">
												<div id="image_demo" style="width:100%; margin-top:30px"></div>
											</div>

										</div>
									</div>  

								</div>
								<button style="display:none;"  id="btn_add" class="btn btn-warning crop_image btn-block  mt-2" type="button">Next </button>
							</form>

							<form id="addResearchAttachmentForm" method="post" style="display:none;">
								<div class="row">
									<div class="col-12 ">
										<div class="form-group">
											<label for="firstName">Attachment</label>
											<input type="file" class="form-control" data-bv-field="firstName" id="attachment" accept="application/pdf" name="attachment" required placeholder="Attachment" />
										</div>
									</div>
									<input type="hidden" name="post_attachment" id="post_attachment" required/>

									<div class="col-12 col-sm-6">
										<div class="form-group">
											<button id="btn_add_attachment" class="btn btn-warning btn-block px-5 mt-2 px-5" type="submit">Finish </button>
										</div>
									</div>
								</div>
							</form>

						</div>
					</div>
				</div>
			</div>

			<div id="view-attachment" class="modal fade " role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title font-weight-400">RESEARCH AREA ATTACHMENT</h5>
							<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
						</div>
						<div class="modal-body p-4">

							<form id="addAttachmentForm22" method="post" >
								<div class="row">
									<div class="col-12 ">
										<div class="form-group">
											<label for="firstName">Attachment</label>
											<input type="file" class="form-control" data-bv-field="firstName" id="attachments" accept="application/pdf" name="attachment" required placeholder="Attachment" />
										</div>
									</div>
									<input type="hidden" name="post_attachment" id="post_attachment1" required/>

									<div class="col-12 col-sm-6">
										<div class="form-group">
											<button id="btn_add_attachment2" class="btn btn-warning btn-block px-5 mt-2 px-5" type="submit">Save </button>
										</div>
									</div>
								</div>
							</form>

						</div>
					</div>
				</div>
			</div>


			<div id="deleteUserModal" class="modal fade " role="dialog" aria-hidden="true">
				<div class="modal-dialog " role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title font-weight-400" id="title">DELETE RESEARCH AREA</h5>
							<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
						</div>
						<div class="modal-body p-4">

							<form id="deleteResearchForm" method="post">
								<input type="hidden" id="delUser" name="delUser"/>
								<p id="msg">Are you sure you want to delete this research area?</p>
								<div class="row">

									<div class="col-6 col-sm-3">
										<div class="form-group">
											<button type="submit" id="delBtn" class="btn btn-danger" > Yes </button>
										</div>
									</div>
									<div class="col-6 col-sm-3">
										<div class="form-group">
											<button type="button" class="btn btn-warning" data-dismiss="modal" aria-label="Close"> Cancel </button>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>


			<!--edit my profile-->
			<div class="modal fade" id="modalUser<?=$user_id?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title " id="exampleModalLabel">Edit My Profile</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<form action="" method="post" id="editProfForm">
							<input type="hidden" id="eUid" name="eUid" value="<?=$user_id?>" />
							<div class="modal-body">
								<div class="form-group">
									<label for="email">Fullname</label>
									<input type="text" required class="form-control" name="efullname" id="efullname" placeholder="Enter Fullname" value="<?=$user['fullname']?>">
								</div>
								<div class="form-group">
									<label for="email">Email Address</label>
									<input type="email" required class="form-control" name="eemail" id="eemail" placeholder="Enter Email" value="<?=$user['email']?>" />
								</div>
								<div class="form-group">
									<label for="email">Phone Number</label>
									<input type="tel" required class="form-control" name="ephone" id="ephone" placeholder="Enter Phone Number" value="<?=$user['phone']?>" />
								</div>
								<div class="form-group">
									<label for="password">Password</label>
									<input type="password" class="form-control" id="epassword" name="epassword" placeholder="Password">
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
								<button type="submit" id="editUserBtn" class="btn btn-danger">Save changes</button>
							</div>
						</form>
					</div>
				</div>
			</div>

			<div id="add-focu-area" class="modal fade " role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title font-weight-400">FOCUS AREA DESC.</h5>
							<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
						</div>
						<div class="modal-body p-4">
							<?php
										// check if added or not
							if ($operation->countAll("SELECT * FROM `focus_area_desc` ") == 0) {
								?>
								<form id="addFocusAreaDescForm" method="post">
									<div class="row">
										<div class="col-12 ">
											<div class="form-group">
												<label for="firstName">Focus Area Description</label>
												<textarea id="focus_area_desc" name="focus_area_desc" required placeholder="Focus Area Description" class="form-control" data-bv-field="firstName" rows="2"></textarea>
											</div>
										</div> 
									</div>
									<button  id="btn_addw" class="btn btn-warning btn-block px-5 mt-2" type="submit">Add Focus Areas Desc.</button>
								</form>

								<?php
							}else{
								$getDesc = $operation->retrieveSingle("SELECT * FROM `focus_area_desc` ORDER BY desc_id DESC");
								?>
								<form id="editFocusAreaDescForm" method="post">
									<div class="row">
										<div class="col-12 ">
											<div class="form-group">
												<label for="firstName">Update Focus Area Description</label>
												<textarea id="efocus_area_desc" name="efocus_area_desc" required placeholder="Focus Area Description" class="form-control" data-bv-field="firstName" rows="2"><?=$getDesc['description']?></textarea>
											</div>
										</div> 
									</div>
									<input type="hidden" name="desc_id" id="desc_id" value="<?=$getDesc['desc_id']?>">

									<div class="row">
										<div class="col-12 col-md-6">
											<button  id="ebtn_add" class="btn btn-warning btn-block px-5 mt-2" type="submit">Update Focus Areas Desc.</button>

										</div>
										<div class="col-12 col-md-6">
											<a onclick="getDeleteFocusArea('<?=$getDesc['desc_id']?>')" href="#add-focu-area" data-toggle="modal"  role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="btn btn-danger btn-block px-5 mt-2" type="button">Delete Focus Areas Desc.</a>

										</div>
									</div>

									

									
								</form>
								<?php

							}

							?>




						</div>
					</div>
				</div>
			</div>

			<div id="deleteUFocusModal" class="modal fade " role="dialog" aria-hidden="true">
				<div class="modal-dialog " role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title font-weight-400" id="title">DELETE FOCUS AREAS DESC.</h5>
							<button type="button" class="close font-weight-400" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
						</div>
						<div class="modal-body p-4">

							<form id="deleteFocusAreaDescForm" method="post">
								<input type="hidden" id="delDesc" name="delDesc"/>
								<p id="msg">Are you sure you want to delete this focus area description?</p>
								<div class="row">

									<div class="col-6 col-sm-3">
										<div class="form-group">
											<button  type="submit" id="btn_del2" class="btn btn-danger" > Yes </button>
										</div>
									</div>
									<div class="col-6 col-sm-3">
										<div class="form-group">
											<button type="button" class="btn btn-warning" data-dismiss="modal" aria-label="Close"> Cancel </button>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>


		</body>

		<script src="assets/js/core/jquery.3.2.1.min.js"></script>
		<script src="assets/datatable/datatables.min.js"></script>
		<!--    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>-->
		<!--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>-->
		<!--<script type="text/javascript" src="https://cdn.datatables.net/v/bs4/jq-3.3.1/dt-1.10.23/b-1.6.5/b-colvis-1.6.5/b-flash-1.6.5/b-html5-1.6.5/b-print-1.6.5/r-2.2.7/datatables.min.js"></script>-->
		<script src="assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
		<script src="assets/js/core/popper.min.js"></script>
		<script src="assets/js/core/bootstrap.min.js"></script>
		<script src="assets/js/plugin/chartist/chartist.min.js"></script>
		<script src="assets/js/plugin/chartist/plugin/chartist-plugin-tooltip.min.js"></script>
		<script src="assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>
		<script src="assets/js/plugin/bootstrap-toggle/bootstrap-toggle.min.js"></script>
		<!-- Summernote -->
		<script src="assets/summernote/summernote-bs4.min.js"></script>

		<script src="assets/js/plugin/jquery-mapael/jquery.mapael.min.js"></script>
		<script src="assets/js/plugin/jquery-mapael/maps/world_countries.min.js"></script>
		<script src="assets/js/plugin/chart-circle/circles.min.js"></script>
		<script src="assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>
		<script src="assets/js/ready.min.js"></script>
		<script src="assets/croppie/croppie.js"></script>
		<script type="text/javascript" src="assets/simditor/scripts/module.js"></script>
		<script type="text/javascript" src="assets/simditor/scripts/hotkeys.js"></script>
		<script type="text/javascript" src="assets/simditor/scripts/uploader.js"></script>
		<script type="text/javascript" src="assets/simditor/scripts/simditor.js"></script>
		<script src="assets/js/js.js"></script>


		<script>
			$('textarea').summernote()
			function setUpdateAttachment(id){
				$("#post_attachment1").val(id);
			}
			function getDeleteFocusArea(id){
				$("#delDesc").val(id);
				$("#add-focu-area").modal('toggle');
				$("#deleteUFocusModal").modal('toggle');
			}


			function getDeleteNews(id){
				$("#delUser").val(id);
				$("#view-user"+id).modal('toggle');
				$("#deleteUserModal").modal('toggle');
			}

			function setUpdateMeal(id){
				var image_crop = $('#image_demo'+id).croppie({
					enableExif: true,
					viewport: {
						width:750,
						height:300,
		  type:'square' //circle
		},
		boundary:{
			width:750,
			height:300
		},
		showZoomer: false,
		enableResize: true,
		enableOrientation: true,
		mouseWheelZoom: 'ctrl'
	});

				$('#meal_pic'+id).on('change', function(){
					var reader = new FileReader();
					reader.onload = function (event) {
						image_crop.croppie('bind', {
							url: event.target.result
						}).then(function(){
//			console.log('jQuery bind complete');
});
					}
					reader.readAsDataURL(this.files[0]);
					$('#uploadimageContainer'+id).show();
					$('#btn_add'+id).show();
				});

				$('#btn_add'+id).click(function(event){
					upload_btn_action=$(this).text();
					image_crop.croppie('result', {
						type: 'canvas',
						size: "original", 
						format: "png",
						quality: 1
					}).then(function(response){
			//get meal name and meal price
			$("#btn_add"+id).html('<span class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></span> Updating...');
			$.ajax({
				url:"process/research.php",
				type: "POST",
				data:{"img_update": response, "img_id":id},

				cache: false,

				success:function(dataResult)
				{ 
					console.log(dataResult)
					var data = JSON.parse(dataResult);
					$("#btn_add"+id).html('Change Picture');
					$('#uploadimageContainer'+id).hide();
					$('#btn_add'+id).hide();
					if(data.code==1){
						  //Uploaded and finish
						  var state = "success";
						  content.message = data.msg;
						  content.title = 'Update Research Area Picture';
						  if (style == "withicon") {
						  	content.icon = 'la la-bell';
						  } else {
						  	content.icon = 'none';
						  }
						  content.url = 'research.php';
						  content.target = '_blank';

						  $.notify(content,{
						  	type: state,
						  	placement: {
						  		from: placementFrom,
						  		align: placementAlign
						  	},
						  	time: 800,
						  });

						  $("#view-meal"+id).modal("toggle");
						  	 document.getElementById("editPictureForm"+id).reset();//empty the form

						  	 setTimeout(function(){ 
						  	 	window.location = "research";
						  	 }, 800);
						  	}else{
						  		var state = "danger";
						  		content.message = data.msg;
						  		content.title = 'Update Research Area Picture';
						  		if (style == "withicon") {
						  			content.icon = 'la la-bell';
						  		} else {
						  			content.icon = 'none';
						  		}
						  		content.url = 'research.php';
						  		content.target = '_blank';

						  		$.notify(content,{
						  			type: state,
						  			placement: {
						  				from: placementFrom,
						  				align: placementAlign
						  			},
						  			time: 800,
						  		});
						  		$("#view-meal"+id).modal("toggle");
						  	 document.getElementById("editPictureForm"+id).reset();//empty the form
						  	}

						  }
						});

		})
				});

			}



			$(document).ready(function(){
	//notification variables
	var placementFrom = "top";
	var placementAlign = "right";
	var style = "withicon";
	var content = {};

	
	var table = $('#user_tbl').DataTable({
		columnDefs: [
		{bSortable: false, targets: [0]} 
		] ,
		"lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
		dom: 'Bfrtip',
		buttons: [
		'colvis',
		'csv',
		'pdf'
		]


	});
	
	var image_crop = $('#image_demo').croppie({
		enableExif: true,
		viewport: {
			width:750,
			height:300,
		  type:'square' //circle
		},
		boundary:{
			width:750,
			height:300
		},
		showZoomer: false,
		enableResize: true,
		enableOrientation: true,
		mouseWheelZoom: 'ctrl'
	});
	
	$('#meal_pic').on('change', function(){
		var reader = new FileReader();
		reader.onload = function (event) {
			image_crop.croppie('bind', {
				url: event.target.result
			}).then(function(){
//			console.log('jQuery bind complete');
});
		}
		reader.readAsDataURL(this.files[0]);
		$('#uploadimageContainer').show();
		$('#btn_add').show();
	});

	$('#btn_add').click(function(event){
		upload_btn_action=$(this).text();
		image_crop.croppie('result', {
			type: 'canvas',
			size: "original", 
			format: "png",
			quality: 1
		}).then(function(response){
			//get meal name and meal price
			var titlex  = $("#title").val();
			var cat_name = $("#cat_name").val();

			if(title !== ""){
				$("#btn_add").html('<span class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></span> Adding...');
				$.ajax({
					url:"process/research.php",
					type: "POST",
					data:{"img": response,"title":titlex,"cat_name":cat_name},

					cache: false,

					success:function(dataResult)
					{ 
						console.log(dataResult);
						
						var data = JSON.parse(dataResult);
						$("#btn_add").html('Next');
						$('#uploadimageContainer').hide();
						$('#btn_add').hide();
						if(data.code==1){
						  //Uploaded and finish
						  var state = "success";
						  content.message = data.msg;
						  content.title = 'Add Research';
						  if (style == "withicon") {
						  	content.icon = 'la la-bell';
						  } else {
						  	content.icon = 'none';
						  }
						  content.url = 'focus.php';
						  content.target = '_blank';

						  $.notify(content,{
						  	type: state,
						  	placement: {
						  		from: placementFrom,
						  		align: placementAlign
						  	},
						  	time: 800,
						  });

//							$("#add-admin").modal("toggle");
						  	 document.getElementById("addNewsForm").reset();//empty the form

//						   setTimeout(function(){ 
//							  window.location = "staff";
$("#post_attachment").val(data.id);
$("#addNewsForm").hide(500);
$("#addResearchAttachmentForm").show(800);
//							}, 500);
}else{
	var state = "danger";
	content.message = data.msg;
	content.title = 'Add Research';
	if (style == "withicon") {
		content.icon = 'la la-bell';
	} else {
		content.icon = 'none';
	}
	content.url = 'focus.php';
	content.target = '_blank';

	$.notify(content,{
		type: state,
		placement: {
			from: placementFrom,
			align: placementAlign
		},
		time: 800,
	});
	$("#add-admin").modal("toggle");
						  	 document.getElementById("addNewsForm").reset();//empty the form
						  	}

						  }
						});
			}else{
				var state = "danger";
				content.message = "Fill all fields";
				content.title = 'Add Research';
				if (style == "withicon") {
					content.icon = 'la la-bell';
				} else {
					content.icon = 'none';
				}
				content.url = 'focus.php';
				content.target = '_blank';

				$.notify(content,{
					type: state,
					placement: {
						from: placementFrom,
						align: placementAlign
					},
					time: 800,
				});
				$("#add-admin").modal("toggle");
				document.getElementById("addNewsForm").reset();//empty the form
				
			}

			
		})
		event.preventDefault();
		event.stopImmediatePropagation();
	});

	
});

</script>
</html>