<!--

File Name: index.php

Author Name: Vitumbiko Mafeni

Author URI: https://www.linkedin.com/in/vitu-mafeni-074940173/

License URI: https://www.linkedin.com/in/vitu-mafeni-074940173/-->

<?php

include("admin/connection/Functions.php");

$operation = new Functions();

require_once("classes/main_classes.php");
$retrieveObj=new RETRIEVE();
$getHomeAbout=$retrieveObj->retriever("about","*","about_id_name","home_about","fetch");
$getMissionAbout=$retrieveObj->retriever("about","*","about_id_name","mission","fetch");

//get recent news

$getNews = $operation->retrieveMany("SELECT *FROM news ORDER BY news_id DESC LIMIT 2");



//get focus areas

$countFocusAreas = $operation->countAll("SELECT * FROM `research_areas_category` ");

$getFocusAreas = $operation->retrieveMany("SELECT * FROM `research_areas_category` ORDER BY category_id DESC");



//get slides

$getCarousels = $operation->retrieveMany("SELECT * FROM `homepage_carousel` ORDER BY carousel_id DESC");



?>

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">



    <meta name="description"

          content="The Institute of Public Opinion and Research (IPOR) is a research firm pro that specializes in surveys and Social Science research, advisory and consulting services.  based in the University Town of Zomba in southern Malawi, we are a leading research firm in conducting and presenting high quality and trusted data to our clients in opinion surveys, marketing research, advisory and consulting services. Founded in 2014, IPOR is a partnership between two scholars based at Chancellor College, University of Malawi"/>

    <meta name="keywords" content="Institute of Public Opinion and Research IPOR"/>

    <meta name="author" content="Vitumbiko Mafeni"/>





    <link rel="icon" href="images/icons/favicon.png"/>

    <title>IPOR</title>



    <!-- Bootstrap core CSS -->

    <link href="css/bootstrap.min.css" rel="stylesheet">

    <link href="font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>

    <!-- Custom styles for this template -->

    <link href="css/style.css?<?php echo time() ?>" rel="stylesheet">

    <link href="fonts/antonio-exotic/stylesheet.css" rel="stylesheet">

    <link rel="stylesheet" href="css/lightbox.min.css">

    <link href="css/responsive.css" rel="stylesheet">





    <link href="lib/nivo-slider/css/nivo-slider.css" rel="stylesheet">

    <link href="lib/owlcarousel/owl.carousel.css" rel="stylesheet">

    <link href="lib/owlcarousel/owl.transitions.css" rel="stylesheet">

    <link href="lib/animate/animate.min.css" rel="stylesheet">

    <link href="lib/venobox/venobox.css" rel="stylesheet">

    <!-- Nivo Slider Theme -->

    <link href="css/nivo-slider-theme.css" rel="stylesheet">

    <link href="css/slider.css" rel="stylesheet">





    <!--        <script src="js/jquery.min.js" type="text/javascript"></script>-->

    <!--        <script src="js/bootstrap.min.js" type="text/javascript"></script>-->

    <!--        <script src="js/lightbox-plus-jquery.min.js" type="text/javascript"></script>-->

    <!--        <script src="js/instafeed.min.js" type="text/javascript"></script>-->

    <style>

        .dropdown:hover .dropdown-menu {

            display: block;

            z-index: 1000;

        }



        .dropdown-menu {

            margin-top: 0;

        }



        ul#menu li {

            display: inline;

            margin-right: 10px;

        }



        .ffs li a:hover {

            color: red;

        }





    </style>


    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-C6MC753Y34"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-C6MC753Y34');
    </script>
</head>

<body>

<?php include("topbar.php"); ?>



<div id="page">

    <header class="header-container">

        <div class="container">

            <div class="top-row">

                <div class="row">

                    <div class="col-md-2 col-sm-6 col-xs-6">

                        <div id="logo">

                            <a href="index.php"><img height="40px" src="images/logos/logo.png" alt=""></a>

                            <a href="index.php"><span></span>IPOR</a>

                        </div>

                    </div>

                    <div class="col-md-1 col-lg-1"></div>

                    <div class="col-md-10 col-sm-12 col-xs-12 remove-padd">



                        <nav class="navbar navbar-default">

                            <div class="navbar-header page-scroll">

                                <button data-target=".navbar-ex1-collapse" data-toggle="collapse" class="navbar-toggle"

                                        type="button">

                                    <span class="sr-only">Toggle navigation</span>

                                    <span class="icon-bar"></span>

                                    <span class="icon-bar"></span>

                                    <span class="icon-bar"></span>

                                </button>



                            </div>

                            <div class="collapse navigation navbar-collapse navbar-ex1-collapse remove-space">

                                <ul class="list-unstyled nav1 cl-effect-10">





                                    <li class="dropdown">

                                        <a data-hover="About &#xf107;" class="dropdown-toggle fa" data-toggle="dropdown"

                                           role="button" aria-haspopup="true" aria-expanded="false">

                                            <span class="fa">About &#xf107;</span></a>



                                        <ul class="dropdown-menu ffs">



                                            <li><a style="background: #fff;" href="about.php">About IPOR</a></li>

                                            <li><a style="background: #fff;" href="staff.php">IPOR Staff</a></li>

                                            <li><a style="background: #fff;" href="board_of_governance.php">Board of Governance</a></li>

                                            <!--<li><a style="background: #fff;" href="board_fellows.php?q=Board Member">Board

                                                    Members</a></li>

                                            <li><a style="background: #fff;"

                                                   href="board_fellows.php?q=Adjunct Research Fellows">Adjunct Research

                                                    Fellows</a></li>
                                            
                                            <li><a style="background: #fff;" href="board_fellows.php?q=Interns">Interns</a></li>-->
                                        </ul>

                                    </li>

                                    <li><a style="" class="" data-hover="Focus Areas" href="focus_areas.php"><span>Focus Areas</span></a>
                                    <li><a style="" class="" data-hover="News" href="news.php"><span>News</span></a>

                                    </li>

                                    <li><a data-hover="Projects " href="projects.php"><span>Projects</span></a></li>





                                    <li class="dropdown">

                                        <a data-hover="Resources &#xf107;" class="dropdown-toggle fa "

                                           data-toggle="dropdown" role="button" aria-haspopup="true"

                                           aria-expanded="false">

                                            <span class="fa">Resources &#xf107;</span></a>



                                        <ul class="dropdown-menu ffs">



                                            <!--<li><a style="background: #fff;" href="news.php">News</a></li>-->





                                            <li><a style="background: #fff;" href="publications.php">Publications</a></li>

                                            <li><a style="background: #fff;" href="seminar_presentations.php">Seminar Presentations</a></li>

                                            <li><a style="background: #fff;" href="inhouse_capacity_building.php">In-house capacity Building Sessions</a></li>

                                            <li><a style="background: #fff;" href="gallery.php">Photo Gallery</a></li>



                                        </ul>

                                    </li>





                                    <li class="dropdown">

                                        <a data-hover="E Chiwayula Trust &#xf107;" class="dropdown-toggle fa"

                                           data-toggle="dropdown" role="button" aria-haspopup="true"

                                           aria-expanded="false">

                                            <span class="fa">E Chiwayula Trust &#xf107;</span></a>



                                        <ul class="dropdown-menu ffs">



                                            <li><a style="background: #fff;" href="edward.php">Background</a></li>





                                            <li><a style="background: #fff;" href="beneficiaries.php">Beneficiaries</a>

                                            </li>





                                        </ul>

                                    </li>



                                    <?php



                                    $getRecruitments = $operation->retrieveMany("SELECT * FROM `recruitment_positions` WHERE dateline >= curdate()");

                                    $countActiveRecruitments = $operation->countAll("SELECT * FROM `recruitment_positions` WHERE dateline >= curdate()");

                                    if ($countActiveRecruitments > 0) {

                                        echo ' <li><a data-hover="Opportunities " href="opportunities.php"><span>Opportunities</span></a></li>';

                                    }

                                    ?>

                                </ul>



                            </div>

                        </nav>

                    </div>



                </div>

            </div>

        </div>

        <div style="display: none;">

<a href="https://filmexxx.live" title="xxx">xxx</a>

<style>
    /*.carousel-inner {
      height: 400px;
    }*/
    .carousel-item {
      background-size: cover;
      background-position: center;
      height: 100%;
    }
    .carousel-caption div{
      margin-bottom:64px;margin-top:16px; text-align:center;
    }
    .carousel-caption div div h3{
        font-size:36px;
        display:inline;
        font-weight:bold;
    }
    .carousel-caption div div h5{
        font-size:24px;
        display:inline;
    }
    .carousel-caption div div {
      bottom: 20px;
      left: 20px;
      right: 20px;
      text-align: left;
      background-color: rgba(0, 0, 0, 0.6);
      padding: 16px 32px;
      color: #fff;
      text-align:center;
    }
    .carousel-control span{
        background-color:rgba(0, 0, 0, 0.5) !important;
        padding:48px 32px 32px 32px !important;
    }
    .carousel-control span i{
        color:white !important;
    }
    .carousel-inner .item{
        height:75vh;background-size:cover;background-position:center;
    }

    .carousel-inner .item::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(to bottom, rgba(0, 0, 0, 0), rgba(0, 0, 0, 0.4));
    }
  </style>

</div>

    </header>


        



    <!-- Start Slider Area -->
    <div id="home">
        <div id="myCarousel" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <?php
                    $loopcount=0;
                    foreach ($getCarousels as $row) {
                ?>
                        <li data-target="#myCarousel" data-slide-to="<?php echo $loopcount ?>" class="<?php if($loopcount==0){echo " active ";} ?>"></li>
                <?php
                        $loopcount+=1;
                    }
                ?>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner">
                <?php
                    $loopcount=0;
                    foreach ($getCarousels as $row) {
                ?>
                        <div class="item <?php if($loopcount==0){echo " active ";} ?>" style="background-image: url('images/<?php echo $row['img_url'] ?>')">
                            <div class="carousel-caption">
                                <div>
                                    <div>
                                        <?php 
                                            if(!empty($row['title'])){
                                        ?>
                                                <h3><?= $row['title'] ?></h3><br>
                                        <?php
                                            }
                                        ?>
                                        
                                        <?php if(!empty($row['subtitle']) and !empty($row['title'])){echo "<br>";} ?>
                                        <h5><?= $row['subtitle'] ?></h5>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                <?php
                        $loopcount+=1;
                    }
                ?>

            <!-- Controls -->
            <a class="left carousel-control" href="#myCarousel" data-slide="prev">
              <span><i class="fa fa-angle-left fa-3x text-light"></i></span>
            </a>
            <a class="right carousel-control" href="#myCarousel" data-slide="next">
              <span><i class="fa fa-angle-right fa-3x text-light"></i></span>
            </a>
        </div>
    </div>
    <!-- End Slider Area -->





    <!--            about section-->

    <div class="clearfix"></div>



    <section id="about-section" class="resort-overview-block" style="margin-top:0px !important;">

        <div class="container">

            <div class="row">

                <div class="col-md-4 col-sm-12 col-xs-12 remove-padd-right">

                    <div class="row">

                        <h3>About Us</h3>

                    </div>

                    <div class="abt-sec" style="margin-top: 15px">
                        <?php if($getHomeAbout!="1020"){echo $getHomeAbout->about_content;} ?>
                        <!--<p class="text-justify">

                            Established in 2013, the Institute of Public Opinion and Research (IPOR) is a research

                            organization providing Social Science research, advisory and consulting services, based in

                            the University town of Zomba, Malawi.



                            To date, we have conducted several assignments for our clients which have included local and

                            international universities, local non-governmental organizations and international research

                            firms.



                            Among other things, we collect, analyze and report on data; and provide advisory and

                            consulting services for our clients. Drawing from our team of renowned and experienced

                            researchers, we believe in delivering quality for every assignment that we undertake, big or

                            small. We are indeed a centre of excellence in Social Science research, advisory and

                            consulting.

                        </p>-->

                    </div>

                </div>

                <div class="clear"></div>



                <div class="col-md-4 col-sm-12 col-xs-12 remove-padd-left">

                    <div class="row">

                        <div class="col-md-2">

                        </div>

                        <div class="col-md-2">

                            <img class="" style="margin-top: 70px;margin-bottom: 50px;" height="170px"

                                 src="images/logos/logo.png"/>

                        </div>



                    </div>



                </div>

                <div class="clear"></div>



                <div class="col-md-4 col-sm-12 col-xs-12 remove-padd-left">

                    <div class="row">

                        <h3>Our Mission</h3>

                    </div>

                    <div class="abt-sec" style="margin-top: 15px">
                        <?php if($getMissionAbout!="1020"){echo $getMissionAbout->about_content;} ?>
                        <!--<p class="text-justify">

                            To offer high quality advisory services and conduct excellent and independent research

                            designed to produce new knowledge and transformative insights as the basis for innovative

                            and practical policy interventions that promote the well-being of societies, especially in

                            the developing world

                        </p>-->

                    </div>

                </div>

                <div class="clear"></div>

            </div>

        </div>

    </section>

    <!--            end about section-->



    <!--            projects section-->





    <div class="clearfix"></div>

    <section class="resort-overview-block">

        <div class="container">

            <div class="row">

                <div class=" col-12">

                    <h2 class="text-center mb-5">Recent News</h2>

                    <br/>

                    <br/>

                </div>



                <?php

                foreach ($getNews as $row) {

                    $date1 = date_create($row['date_created']);

                    $dt1 = date_format($date1, "M d, Y ");

                    $dt2 = date_format($date1, "H:i ");

                    $img = '';

                    if ($row['img_url'] != '') {

                        $img = '<a href="single-blog.php?news=' . $row['news_id'] . '"><img alt="image" class="img-responsive" src="images/news/' . $row['img_url'] . '"></a>';

                    } else {

                        $img = '<a href="single-blog.php?news=' . $row['news_id'] . '"><img alt="image" class="img-responsive" src="images/images/no_image.png"></a>';

                    }

                    ?>

                    <div class="col-md-6 col-sm-12 col-xs-12 ">

                        <div class="side-A">

                            <div class="product-thumb">

                                <div class="image">

                                    <?= $img ?>

                                </div>

                            </div>

                        </div>

                        <div class="side-B">

                            <div class="product-desc-side">

                                <h3 style="
                                  
                                 ">

                                    <a style="" href="single-blog.php?news=<?= $row['news_id'] ?>"><?= $row['title'] ?></a>
                                    </h3>

                                <br/><b>Posted on <?= $dt1 ?> at <?= $dt2 ?></b><br/>

                                <span><?= $operation->printTruncated(100, $row['content']); ?>...</span><br/>

                                <div class="links"><a href="single-blog.php?news=<?= $row['news_id'] ?>">Read more</a>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="clear"></div>



                    <?php

                }

                ?>





            </div>

            <br/>

            <div class="row">

                <div class=" col-md-2"></div>

                <div class=" col-md-8">



                    <a style="height:50px;" class="twitter-timeline"

                       data-chrome="noheader nofooter noborders transparent" data-tweet-limit="1" data-height="5000"

                       href="https://twitter.com/IPORMalawi?ref_src=twsrc%5Etfw">Our Tweets</a>

                    <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>

                </div>

                <div class=" col-md-2"></div>



            </div>

        </div>

    </section>

    <!--end projects section-->





    <!--edward block-->

    <section class="vacation-offer-block">

        <div class="vacation-offer-bgbanner">

            <div class="container">

                <div class="row">

                    <div class="col-md-12 col-sm-12 col-xs-12">

                        <!--                                <div class="col-md-4 col-sm-12 col-xs-12">-->

                        <img class="" src="images/images/edward.jpg"/>

                        <!--                                </div>-->

                        <div class="col-md-8 col-sm-12 col-xs-12">

                            <!--                                    <div class="row">-->

                            <h2 style="display:block; margin:auto; " class="">The Edward Chiwayula Trust Fund</h2>

                            <br/>

                            <!--                                    </div>-->

                            <p class="text-justify" style="padding-right:5%;width:100%;word-wrap: break-word;">

                                Before his sudden and untimely passing on April 17th, 2016, the late Edward Chiwayula

                                was working as an enumerator on the Governance and Local Development Project, a

                                collaborative venture between IPOR, the Program on Gover...

                            </p>

                            <br/>

                            <div class="links"><a href="single-blog.php">Read more</a></div>



                        </div>



                    </div>

                </div>

            </div>

        </div>

    </section>

    <!--End-->



    <!--partner block--->

    <!--

                <section class="service-block">

                    <div class="container">

                        <div class="row">

                            <div class="col-md-12 col-sm-12 col-xs-12">

                                <h2 class="text-center " style="margin-bottom: 15px">Partner Institutions</h2>

                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-2 col-sm-2 col-xs-6 width-50">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/afrobarometer.png">

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-2 col-sm-2 col-xs-6 width-50">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/cdd.png">

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-2 col-sm-2 col-xs-6 mt-25">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/gld.png">

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-2 col-sm-2 col-xs-6 mt-25">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/hatchile.png">

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-2 col-sm-2 col-xs-6 mt-25">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/mcsatchi.jpg">

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-2 col-sm-2 col-xs-6 mt-25">

                                <div class="service-details text-center">

                                    <div class="service-image">

                                        <img alt="image" class="img-responsive" src="images/logos/unima.png">

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </section>

    -->





    <?php

    $ss = "SELECT * FROM `partners` ORDER BY partner_id DESC";

    $countPartners = $operation->countAll($ss);

    $getPartners = $operation->retrieveMany($ss);

    if ($countPartners > 0) {



        ?>



        <div class="container" style="margin-top:50px;">

            <h2 class="text-center " style="margin-bottom:50px;">Our Partners</h2>

            <section class="customer-logos slider">

                <?php

                foreach ($getPartners as $row) {

                    echo '

                      <div class="slide">

                        <a href="' . $row['link'] . '" target="_blank">

                          <img class="image-responsive" src="images/logos/' . $row['img_url'] . '">

                          </a>

                      </div>';

                }



                ?>





            </section>

        </div>

        <?php



    }

    ?>





    <!---footer--->

    <?php include("footer.php"); ?>



    <!--back to top--->

    <a style="display: none;" href="javascript:void(0);" class="scrollTop back-to-top" id="back-to-top">

        <span><i aria-hidden="true" class="fa fa-angle-up fa-lg"></i></span>

        <span>Top</span>

    </a>



</div>





</body>

<script src="js/jquery.min.js"></script>

<script src="js/bootstrap.min.js"></script>

<script src="lib/owlcarousel/owl.carousel.min.js"></script>



<script src="lib/nivo-slider/js/jquery.nivo.slider.js" type="text/javascript"></script>

<script src="lib/venobox/venobox.min.js"></script>

<script src="js/custom.js" type="text/javascript"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.6.0/slick.js"></script>

<script>



    $(document).ready(function () {

        $(".dropdown").hover(function () {

            var dropdownMenu = $(this).children(".dropdown-menu");

            if (dropdownMenu.is(":visible")) {

                dropdownMenu.parent().toggleClass("open");

            }

        });





        //---------------------------------------------

        //Nivo slider

        //---------------------------------------------

        $('#ensign-nivoslider').nivoSlider({

            effect: 'random',

            slices: 15,

            boxCols: 12,

            boxRows: 8,

            animSpeed: 700,

            pauseTime: 7000,

            startSlide: 0,

            directionNav: false,

            controlNavThumbs: false,

            pauseOnHover: true,

            manualAdvance: false,

        });



        /*----------------------------

         Scrollspy js

        ------------------------------ */

        var Body = $('body');

        Body.scrollspy({

            target: '.navbar-collapse',

            offset: 80

        });



        /*---------------------

          Venobox

        --------------------- */

        var veno_box = $('.venobox');

        veno_box.venobox();

    });     </script>

<script>

    $(document).ready(function () {

        $(window).scroll(function () {

            if ($(this).scrollTop() > 100) {

                $('#back-to-top').fadeIn();

            } else {

                $('#back-to-top').fadeOut();

            }

        });

        $('#back-to-top').click(function () {

            $("html, body").animate({scrollTop: 0}, 600);

            return false;

        });



    });



    $(document).ready(function () {

        $('.customer-logos').slick({

            slidesToShow: 6,

            slidesToScroll: 1,

            autoplay: true,

            autoplaySpeed: 2500,

            arrows: false,

            dots: false,

            pauseOnHover: false,

            responsive: [{

                breakpoint: 768,

                settings: {

                    slidesToShow: 4

                }

            }, {

                breakpoint: 520,

                settings: {

                    slidesToShow: 3

                }

            }]

        });

    });

</script>





</html>

