<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_subscription="";
  $selected_status="";
  if(isset($_POST["selected_status"]) and !empty($_POST["selected_status"]) and $_POST["selected_status"]!="all"){
    $selected_status=addslashes($_POST["selected_status"]);
    $get_subscription = $retrieveObj->retriever("subscription
      JOIN subscription_plan ON subscription_plan.sp_id = subscription.sp_id
      JOIN Schools ON Schools.SchoolID = subscription.SchoolID
      WHERE subscription.subscription_status='$selected_status'","*","fetchAll");
  }else{
    $get_subscription=$retrieveObj->retriever("subscription
      JOIN subscription_plan ON subscription_plan.sp_id = subscription.sp_id
      JOIN Schools ON Schools.SchoolID = subscription.SchoolID","*","fetchAll");
  }
?>

<div class="page-header flex-wrap">
  <h3 class="page-title "> 
    Subscriptions
  </h3>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header bg-white px-0 border_0">
          <div class="font-weight-bold">Subscriptions</div>
          <div class="row">
            <div class="col-md-12 my-2 pt-1">
              <div class="row">
                <div class="col-12 col-sm-4 col-md-3 col-lg-2">
                  <select class="form-control form-control-sm" name="selected_status" id="selected_status" onchange="subscription_view()">
                    <option selected value="all">All subscriptions</option>
                    <option value="active">Active</option>
                    <option value="expired">Expired</option>
                  </select>
                </div>
                <div class="col-12 col-sm-8 col-md-9 col-lg-10 text-left text-sm-left text-md-right text-lg-right">
                  <?php
                    if($user_in_type=="su_admin"){
                  ?>
                    <a href="#add-user-view" onclick="add_subscription_view()" class="btn btn-sm btn-primary my-1"><span class="fas fa-plus"></span> Add subscription</a>
                    <a href="#subscription-plans-view" onclick="subscription_plans_view()" class="btn btn-sm btn-primary my-1"><span class="fas fa-rocket"></span> Subscription plans</a>
                  <?php
                    }
                  ?>
                </div>
              </div>
                
            </div>
            <div class="col-md-12" id="subscriptions_response"></div>
          </div>
        </div>
        <div class="table-responsive p-2">
            <table class="table align-items-center table-flush" id="subscription_table">
          <thead class="thead-light">
              <tr>        
                <th scope="col">School Name</th>
                <th scope="col">Subcription Name</th>
                <th scope="col">Subcription from</th>
                <th scope="col">Subcription to</th>
                <th scope="col">Status</th>
                <th scope="col">Options</th>
              </tr>
            </thead>
            <tbody>
              <?php 
                if($get_subscription!="1020"){
                  $element_id="element_id";
                    foreach ($get_subscription as $subscription) {
                      $element_id=$element_id."Ot";

                      //$get_user_roles=$retrieveObj->retriever("user_roles JOIN user_role ON user_roles.role_id=user_role.role_id","*","user_id",$user->user_id,"fetchAll");
              ?>  
                  <tr id="<?php echo $element_id ?>">         
                    <td>
                      <?php 
                        echo $subscription->SchoolName;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $subscription->sp_name;
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo date("d-m-Y", strtotime($subscription->subscription_from))."<br> @".date("H:i A", strtotime($subscription->subscription_from));
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo date("d-m-Y", strtotime($subscription->subscription_to))."<br> @".date("H:i A", strtotime($subscription->subscription_to));
                      ?>
                    </td>
                    <td>
                      <?php 
                        echo $subscription->subscription_status;
                      ?>
                    </td>
                    <td id="<?php echo $element_id.'Dbtn' ?>">
                      <div class="">
                        <button title="Edit" class="btn btn-sm hand_cursor text-light bg_primary_dark" onclick="subscription_details_view(<?php echo $subscription->subscription_id ?>)"><span class="fas fa-info"></span> Details</button>
                      </div>
                    </td>
                  </tr>
                <?php
                    }
                  }
                ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>


<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#subscription_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [5]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });
  })
</script>