<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_schools=$retrieveObj->retriever("Schools ORDER BY SchoolName ASC","*","fetchAll");

  $get_subscription_plans=$retrieveObj->retriever("subscription_plan ORDER BY sp_display_order ASC","*","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title "> 
    Subscriptions
  </h3>
  <p class="mt-1">
    <a href="#subscriptions-view" onclick="subscription_view()" class="text_cprimary_color"><u>Subscriptions</u></a> >
      <span>Add subscription</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header bg-white px-0 border_0">
          <div class="font-weight-bold">Add subscription</div>
        </div>
        <div class="table-responsive p-2">
            <form id="add_subscription_form" class="row">
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="SchoolName">School Name</label>
                <?php 
                  if($get_schools!="1020"){
                ?>
                    <select class="form-control" name="SchoolName" id="SchoolName">
                      <option selected disabled>Select School Name</option>
                      <?php 
                        foreach ($get_schools as $school) {
                      ?>
                          <option value="<?php echo $school->SchoolID ?>"><?php echo $school->SchoolName ?></option>
                      <?php
                        }
                      ?>
                    </select>
                <?php
                  }else{
                ?>
                    <div class="alert alert-info">No Schools found</div>
                <?php
                  }
                ?>
                    
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="sp_id">Subscription Plan</label>
                <?php 
                  if($get_subscription_plans!="1020"){
                ?>
                    <select class="form-control" name="sp_id" id="sp_id">
                      <option selected disabled>Select Subscription Plan</option>
                      <?php 
                        foreach ($get_subscription_plans as $subscription_plan) {
                      ?>
                          <option value="<?php echo $subscription_plan->sp_id ?>"><?php echo $subscription_plan->sp_name ?></option>
                      <?php
                        }
                      ?>
                    </select>
                <?php
                  }else{
                ?>
                    <div class="alert alert-info">No subscription plans found.</div>
                <?php
                  }
                ?>
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="subscription_from">Subscription From</label>
                <input class="form-control" type="date" name="subscription_from" id="subscription_from">
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="subscription_to">Subscription To</label>
                <input class="form-control" type="date" name="subscription_to" id="subscription_to">
              </div>
              <div class="col-md-12 my-2" id="add_subscription_response">
                
              </div>
              <div class="col-md-12 my-2 text-center">
                <input type="hidden" name="add_subscription_note">
                <button type="submit" class="btn btn-primary btn-block enter-btn" onclick="add_subscription()"><span class="fas fa-plus"></span> Add</button>
              </div>
            </form>
        </div>
      </div>
    </div>
  </div>
</div>





<script type="text/javascript">
  var editor = new Simditor({
    textarea: $('#sp_description'),
    upload: false
    
  });
</script>


<script type="text/javascript">
  $(function () {
    $('[data-toggle="popover"]').popover()
  })
  $('body').on('click', function (e) {
      //did not click a popover toggle or popover
      if ($(e.target).data('toggle') !== 'popover'
          && $(e.target).parents('.popover.in').length === 0) { 
          $('[data-toggle="popover"]').popover('hide');
      }
  });
</script>

<script type="text/javascript">
  $(document).ready(function () {
    //$("#selected_role").select2();
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      },
      "order": [[ 3, "asc" ]]
    });
  })
</script>