<?php
    use Shuchkin\SimpleXLSX;
    require_once("../session_check.php");
    require_once("../../classes/main_classes.php");
    require_once("../../classes/main_functions.php");

    if($sign_in_status=="out"){
       die("<p class='alert alert-warning'>Access denied, this maybe because the login session has expired. Please try refleshing the page.<p>");
    }

    //OBJECTS
    $retrieveObj=new RETRIEVE();
    $rowcountObj=new ROWCOUNT();
    $allrowcountObj=new ALLROWCOUNT();
    $insertObj=new INSERT();
    $updateObj=new UPDATE();
    $deleteObj=new DELETE();

    //USER SIGN OUT
    if(isset($_POST["logout_note"])){
      try{
        unset($_SESSION["user_details"]);
        session_destroy();
        echo 1;
      }catch(Exception $e){
        echo 0;
      }
    }

    
   //ADD STUDENT
   if(isset($_POST["add_student_note"])){
      $add_students_result=0;
      if(isset($_FILES["add_students_excel"])){
        $students_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["add_students_excel"]["tmp_name"]) ) {
          $students_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($students_array)<3){
          die("<p class='alert alert-warning'>Please add at least one student in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        $row = 1;
        //VALIDATE EXCEL
          $add_students_loopcount=0;
          foreach ($students_array as $data) {
              $add_students_loopcount+=1;
              if($add_students_loopcount==1){
                //validate info line
                if(empty($data[0]) or trim($data[0]) !="STUDENT ADDITION TEMPLATE (Please do not delete any row or swap any rows)"){
                  die("<p class='alert alert-warning'>Please use a valid excel template downloaded here.<p>");
                }
                continue;
              }else if($add_students_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="Username" or
                  trim($data[1])!="Firstname" or
                  trim($data[2])!="Lastname" or
                  trim($data[3])!="Middlenames" or
                  trim($data[4])!="Gender(M/F)" or
                  trim($data[5])!="Date of Birth (yyyy-mm-dd)" or
                  trim($data[6])!="Village" or
                  trim($data[7])!="TA" or
                  trim($data[8])!="District" or
                  trim($data[9])!="Enrollment Year(e.g 2010)" or
                  trim($data[10])!="Form of Entry" or
                  trim($data[11])!="Term of Entry" or
                  trim($data[12])!="Current Form" or
                  trim($data[13])!="Student Type" 
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter username for student on line $add_students_loopcount.<p>");
              }else if(empty($data[1])){
                die("<p class='alert alert-warning'>Enter firstname for student on line $add_students_loopcount.<p>");
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter lastname for student on line $add_students_loopcount.<p>");
              }else if(empty($data[3])){
                //pass on middlename
              }else if(empty($data[4])){
                die("<p class='alert alert-warning'>Enter gender for student on line $add_students_loopcount.<p>");
              }else if($data[4]!="M" and $data[4]!="F"){
                die("<p class='alert alert-warning'>Enter a valid gender(M/F) for student on line $add_students_loopcount.<p>");
              }else if(empty($data[5])){
                die("<p class='alert alert-warning'>Enter date of birth for student on line $add_students_loopcount.<p>");
              }else if(empty($data[6])){
                //pass on village
              }else if(empty($data[7])){
                //pass on TA
              }else if(empty($data[8])){
                //pass on District
              }else if(empty($data[9])){
                die("<p class='alert alert-warning'>Enter enrollment year for student on line $add_students_loopcount.<p>");
              }else if(empty($data[10])){
                die("<p class='alert alert-warning'>Enter form of entry for student on line $add_students_loopcount.<p>");
              }else if(empty($data[11])){
                //pass form term of entry
              }else if(empty($data[12])){
                die("<p class='alert alert-warning'>Enter current form for student on line $add_students_loopcount.<p>");
              }else if(empty($data[13])){
                die("<p class='alert alert-warning'>Enter student type form for student on line $add_students_loopcount.<p>");
              }

              //validate username
              if(!empty($data[0])){
                $check_username=$rowcountObj->rowcounter("Users","*","Username",$data[0]);
                if($check_username>0){
                  die("<p class='alert alert-warning'>Username \"".$data[0]."\" for the student at line on line $add_students_loopcount, is already in use by another user.<p>");
                }
              }

              //validate dob
              if(!empty($data[5])){
                $test_date = $data[5];
                $test_date = new DateTime($test_date);
                $test_date=$test_date->format('Y-m-d');
                $test_arr  = explode('-', $test_date);
                if (checkdate($test_arr[1], $test_arr[0], $test_arr[2])) {
                    die("<p class='alert alert-warning'>Enter a valid date on line $add_students_loopcount.<p>");
                }
              }

              

              //validate enrollment year
              if(!empty($data[9])){
                if($data[9]>date("Y")){
                  die("<p class='alert alert-warning'>Enter a valid enrollment year on line $add_students_loopcount.<p>");
                }
              }

              //validate term of entry
              if(!empty($data[10])){
                if($data[10]<1 or $data[10]>6){
                  die("<p class='alert alert-warning'>Enter a valid form of entry for student on line $add_students_loopcount.<p>");
                }
              }

              //validate enrollment year
              if(!empty($data[11])){
                if($data[11]<1 or $data[11]>3){
                  die("<p class='alert alert-warning'>Enter a valid term of entry for student on line $add_students_loopcount.<p>");
                }
              }

              //validate current form
              if(!empty($data[12])){
                if($data[12]<1 or $data[12]>6){
                  die("<p class='alert alert-warning'>Enter a valid current form for student on line $add_students_loopcount.<p>");
                }
              }

              //validate student type
              if(!empty($data[13])){
                if($data[13]!="Day" and $data[13]!="Night"){
                  die("<p class='alert alert-warning'>Enter a valid student type for student on line $add_students_loopcount.<p>");
                }
              }
          }
        /*VALIDATE EXCEL*/

        //ADD STUDENTS
        $add_students_loopcount=0;
        foreach ($students_array as $data) {
            $add_students_loopcount+=1;
            if($add_students_loopcount<=2){
              continue;
            }
            
            $username=addslashes($data[0]);
            $firstname=addslashes($data[1]);
            $lastname=addslashes($data[2]);
            $middlenames=addslashes($data[3]);
            $gender=addslashes($data[4]);
            $date_of_birth=addslashes($data[5]);

            $village = addslashes($data[6]);
            $TA = addslashes($data[7]);
            $district = addslashes($data[8]);
            $enrollment_year = addslashes($data[9]);
            $form_of_entry = addslashes($data[10]);
            $term_of_entry = addslashes($data[11]);
            $current_form = addslashes($data[12]);
            $student_type = addslashes($data[13]);

            $fields=array("Username","Firstname","Lastname","Middlenames","Gender","DateOfBirth","Village","TraditionalAuthority","District");
            $data=array($username,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$village,$TA,$district);

            $fields2=array("EnrollmentYear","TermOfEntry","FormOfEntry","StudentType","CurrentForm");
            $data2=array($enrollment_year,$term_of_entry,$form_of_entry,$student_type,$current_form);

            $add_students_result=add_student_helper($fields,$data,$fields2,$data2,$_SESSION["user_details"]["SchoolID"]);
          
        }
        //ADD STUDENTS

      }else{
          if(empty($_POST["username"])){
             die("<p class='alert alert-warning'>Enter username.<p>");
          }else if(empty($_POST["firstname"])){
             die("<p class='alert alert-warning'>Enter firstname.<p>");
          }else if(empty($_POST["lastname"])){
             die("<p class='alert alert-warning'>Enter lastname.<p>");
          }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
             die("<p class='alert alert-warning'>Select gender.<p>");
          }else if(empty($_POST["date_of_birth"])){
             die("<p class='alert alert-warning'>Enter date of birth.<p>");
          }else if(empty($_POST["enrollment_year"])){
             die("<p class='alert alert-warning'>Enter enrollment year.<p>");
          }else if(empty($_POST["current_form"])){
             die("<p class='alert alert-warning'>Enter current form.<p>");
          }else if(empty($_POST["student_type"])){
             die("<p class='alert alert-warning'>Enter student type.<p>");
          }

          $username=addslashes($_POST["username"]);
          $firstname=addslashes($_POST["firstname"]);
          $lastname=addslashes($_POST["lastname"]);
          $StudentIdNumber=addslashes($_POST["StudentIdNumber"]);
          $middlenames=addslashes($_POST["middlenames"]);
          $gender=addslashes($_POST["gender"]);
          $date_of_birth=addslashes($_POST["date_of_birth"]);
          $enrollment_year = addslashes($_POST["enrollment_year"]);
          $current_form = addslashes($_POST["current_form"]);
          $form_of_entry = addslashes($_POST["form_of_entry"]);
          $student_type = addslashes($_POST["student_type"]);

          $fields=array("Username","Firstname","Lastname","Middlenames","Gender","DateOfBirth");
          $data=array($username,$firstname,$lastname,$middlenames,$gender,$date_of_birth);

          $fields2=array("StudentIdNumber","EnrollmentYear","FormOfEntry","StudentType","CurrentForm");
          $data2=array($StudentIdNumber,$enrollment_year,$form_of_entry,$student_type,$current_form);

          $add_students_result=add_student_helper($fields,$data,$fields2,$data2,$_SESSION["user_details"]["SchoolID"]);
      }

      if($add_students_result=="entry_exists"){
        die("<p class='alert alert-warning'>The username entered is already in use by another user.<p>");
      }else if($add_students_result>0){
        echo 1;
      }



      /*$village = addslashes($_POST["village"]);
      $TA = addslashes($_POST["TA"]);
      $district = addslashes($_POST["district"]);
      $enrollment_year = addslashes($_POST["enrollment_year"]);
      $form_of_entry = addslashes($_POST["form_of_entry"]);
      $term_of_entry = addslashes($_POST["term_of_entry"]);
      $current_form = addslashes($_POST["current_form"]);
      $student_type = addslashes($_POST["student_type"]);*/

      //INSERT TO USERS
        /*$fields=array("Username","Firstname","Lastname","Middlenames","Gender","DateOfBirth","Village","TraditionalAuthority","District","EnrollmentYear","TermOfEntry","FormOfEntry","StudentType","CurrentForm");
        $data=array($username,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$village,$TA,$district,$enrollment_year,$term_of_entry,$form_of_entry,$student_type,$current_form);

        
        $insert=$insertObj->inserter("Users",$fields,$data);

        if($insert=="1"){
           $get_recent_inserted_student=$retrieveObj->retriever("Users WHERE username='$username' ORDER BY UserId DESC","*","fetch");

           //INSERT USER TYPE
           $get_user_type=$retrieveObj->retriever("UserType","UserTypeId","UserType","student","fetch");
           if($get_user_type=="1020"){
              echo 0;
              die();
           }
           $fields1=array("UserId","UserTypeId");
           $data1=array($get_recent_inserted_student->UserId,$get_user_type->UserTypeId);

           $insert1=$insertObj->inserter("UserTypes",$fields1,$data1);

           if($insert1=="1"){
              //get user type id
              $fields2=array("UserId","SchoolID");
              $data2=array($get_recent_inserted_student->UserId,$_SESSION["user_details"]["SchoolID"]);

              $insert2=$insertObj->inserter("Students",$fields2,$data2);

              if($insert2=="1"){
                 echo 1;
              }else{
                 echo 0;
              }
           }else{
              echo 0;
           }     
        }else{
           echo 0;
        }*/
   }

   //ADD STAFF
   if(isset($_POST["add_staff_note"])){
      $add_staff_result=0;

      if(isset($_FILES["add_staff_excel_"])){
        $staff_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["add_staff_excel_"]["tmp_name"]) ) {
          $staff_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($grades_array)<3){
          die("<p class='alert alert-warning'>Please add at least one staff in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        //VALIDATE EXCEL
          $add_staff_loopcount=0;
          foreach ($staff_array as $data) {
              $add_staff_loopcount+=1;
              if($add_staff_loopcount==1){
                //validate info line
                if(empty($data[0]) or trim($data[0]) !="STAFF ADDITION TEMPLATE (Please do not delete any row or swap any rows)"){
                  die("<p class='alert alert-warning'>Please use a valid excel template downloaded here.<p>");
                }
                continue;
              }else if($add_staff_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="Username" or
                  trim($data[1])!="Firstname" or
                  trim($data[2])!="Lastname" or
                  trim($data[3])!="Middlenames" or
                  trim($data[4])!="Title" or
                  trim($data[5])!="Gender(M/F)" or
                  trim($data[6])!="Date of Birth (yyyy-mm-dd)" or
                  trim($data[7])!="Village" or
                  trim($data[8])!="TA" or
                  trim($data[9])!="District" or
                  trim($data[10])!="Position" or
                  trim($data[11])!="Highest Qualification" or
                  trim($data[12])!="Date Start Employment" or
                  trim($data[13])!="Date End Employment" 
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter username for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[1])){
                die("<p class='alert alert-warning'>Enter firstname for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter lastname for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[3])){
                //pass on middlename
              }else if(empty($data[4])){
                die("<p class='alert alert-warning'>Enter title for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[5])){
                die("<p class='alert alert-warning'>Enter gender for staff on line $add_staff_loopcount.<p>");
              }else if($data[5]!="M" and $data[5]!="F"){
                die("<p class='alert alert-warning'>Enter a valid gender(M/F) for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[6])){
                die("<p class='alert alert-warning'>Enter date of birth for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[7])){
                //pass on village
              }else if(empty($data[8])){
                //pass on TA
              }else if(empty($data[9])){
                //pass on District
              }else if(empty($data[10])){
                die("<p class='alert alert-warning'>Enter position for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[11])){
                die("<p class='alert alert-warning'>Enter highest qualification for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[12])){
                //pass date started employment
              }else if(empty($data[13])){
                //pass date end employment
              }

              //validate username
              if(!empty($data[0])){
                $check_username=$rowcountObj->rowcounter("Users","*","Username",$data[0]);
                if($check_username>0){
                  die("<p class='alert alert-warning'>Username \"".$data[0]."\" for the staff at line on line $add_staff_loopcount, is already in use by another user.<p>");
                }
              }

              //validate dob
              if(!empty($data[5])){
                $test_date = $data[5];
                $test_date = new DateTime($test_date);
                $test_date=$test_date->format('Y-m-d');
                $test_arr  = explode('-', $test_date);
                if (checkdate($test_arr[1], $test_arr[0], $test_arr[2])) {
                    die("<p class='alert alert-warning'>Enter a valid date on line $add_students_loopcount.<p>");
                }
              }

              //validate position
              if(!empty($data[10])){
                if(
                  $data[10]!="School Owner" and
                  $data[10]!="Head Master" and
                  $data[10]!="Deputy Head Master" and
                  $data[10]!="Teacher" and
                  $data[10]!="Accountant" and
                  $data[10]!="Cleaner" and
                  $data[10]!="Guard"
                ){
                  die("<p class='alert alert-warning'>Enter a valid position on line $add_staff_loopcount.<p>");
                }
              }

              //validate start employment
              if(!empty($data[12])){
                $test_date = $data[12];
                $test_arr  = explode('/', $test_date);
                if (checkdate($test_arr[1], $test_arr[2], $test_arr[0])) {
                    die("<p class='alert alert-warning'>Enter a valid date start employment (YYYY/MM/DD) on line $add_staff_loopcount.<p>");
                }
              }

              //validate start employment
              if(!empty($data[13])){
                $test_date = $data[13];
                $test_arr  = explode('/', $test_date);
                if (checkdate($test_arr[1], $test_arr[2], $test_arr[0])) {
                    die("<p class='alert alert-warning'>Enter a valid date end employment (YYYY/MM/DD) on line $add_staff_loopcount.<p>");
                }
              }
          }
        /*VALIDATE EXCEL*/


         
        //ADD STAFF
          $add_staff_loopcount=0;
          foreach ($staff_array as $data) {
              $add_staff_loopcount+=1;
              if($add_staff_loopcount<=2){
                continue;
              }

              $username=addslashes($data[0]);
              $firstname=addslashes($data[1]);
              $lastname=addslashes($data[2]);
              $middlenames=addslashes($data[3]);
              $title=addslashes($data[4]);
              $gender=addslashes($data[5]);
              $date_of_birth=addslashes($data[6]);
              $village=addslashes($data[7]);
              $TA = addslashes($data[8]);
              $district = addslashes($data[9]);
              $position=addslashes($data[10]);
              $highest_qualification=addslashes($data[11]);
              $start_employment=addslashes($data[12]);
              $end_employment=addslashes($data[13]);

              $fields=array("Username","Firstname","Lastname","Middlenames","Title","Gender","DateOfBirth","Village","TraditionalAuthority","District");
              $data=array($username,$title,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$village,$TA,$district);

              $fields2=array("Position","HighestQualification","DateStartEmployment","DateEndEmployment");
              $data2=array($position,$highest_qualification,$start_employment,$end_employment);

              $add_staff_result=add_staff_helper($fields,$data,$fields2,$data2,$_SESSION["user_details"]["SchoolID"]);
          }
           
        
      }else{
        if(empty($_POST["username"])){
           die("<p class='alert alert-warning'>Enter username.<p>");
        }else if(empty($_POST["title"])){
           die("<p class='alert alert-warning'>Enter title.<p>");
        }else if(empty($_POST["firstname"])){
           die("<p class='alert alert-warning'>Enter firstname.<p>");
        }else if(empty($_POST["lastname"])){
           die("<p class='alert alert-warning'>Enter lastname.<p>");
        }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
           die("<p class='alert alert-warning'>Select gender.<p>");
        }else if(empty($_POST["date_of_birth"])){
           die("<p class='alert alert-warning'>Enter date of birth.<p>");
        }

        $username=addslashes($_POST["username"]);
        $title=addslashes($_POST["title"]);
        $firstname=addslashes($_POST["firstname"]);
        $lastname=addslashes($_POST["lastname"]);
        $position=addslashes($_POST["position"]);
        $middlenames=addslashes($_POST["middlenames"]);
        $gender=addslashes($_POST["gender"]);
        $date_of_birth=addslashes($_POST["date_of_birth"]);
        $highest_qualification=addslashes($_POST["highest_qualification"]);

        $fields=array("Username","Title","Firstname","Lastname","Middlenames","Gender","DateOfBirth");
        $data=array($username,$title,$firstname,$lastname,$middlenames,$gender,$date_of_birth);

        $fields2=array("HighestQualification","Position");
        $data2=array($highest_qualification,$position);

        $add_staff_result=add_staff_helper($fields,$data,$fields2,$data2,$_SESSION["user_details"]["SchoolID"]);
      }

      if($add_staff_result=="entry_exists"){
        die("<p class='alert alert-warning'>The username entered is already in use by another user.<p>");
      }else if($add_staff_result>0){
        echo 1;
      }



      /*if(empty($_POST["username"])){
         die("<p class='alert alert-warning'>Enter username.<p>");
      }else if(empty($_POST["title"])){
         die("<p class='alert alert-warning'>Enter title.<p>");
      }else if(empty($_POST["firstname"])){
         die("<p class='alert alert-warning'>Enter firstname.<p>");
      }else if(empty($_POST["lastname"])){
         die("<p class='alert alert-warning'>Enter lastname.<p>");
      }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
         die("<p class='alert alert-warning'>Select gender.<p>");
      }else if(empty($_POST["date_of_birth"])){
         die("<p class='alert alert-warning'>Enter date of birth.<p>");
      }

      $username=addslashes($_POST["username"]);
      $title=addslashes($_POST["title"]);
      $firstname=addslashes($_POST["firstname"]);
      $lastname=addslashes($_POST["lastname"]);
      $position=addslashes($_POST["position"]);
      $middlenames=addslashes($_POST["middlenames"]);
      $gender=addslashes($_POST["gender"]);
      $date_of_birth=addslashes($_POST["date_of_birth"]);
      $highest_qualification=addslashes($_POST["highest_qualification"]);

      //INSERT TO USERS
      $fields=array("Username","Title","Firstname","Lastname","Middlenames","Gender","DateOfBirth","HighestQualification");
      $data=array($username,$title,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$highest_qualification);

      add_staff_helper*/


      /*$insert=$insertObj->inserter("Users",$fields,$data);

      if($insert=="1"){
         $get_recent_inserted_staff=$retrieveObj->retriever("Users WHERE Username='$username' ORDER BY UserId DESC","*","fetch");

         //INSERT USER TYPE
         $get_user_type=$retrieveObj->retriever("UserType","UserTypeId","UserType","school_staff","fetch");
         if($get_user_type=="1020"){
            echo 0;
            die();
         }
         $fields1=array("UserId","UserTypeId");
         $data1=array($get_recent_inserted_staff->UserId,$get_user_type->UserTypeId);

         $insert1=$insertObj->inserter("UserTypes",$fields1,$data1);

         if($insert1=="1"){
            //get user type id
            $fields2=array("UserId","SchoolID","Position");
            $data2=array($get_recent_inserted_staff->UserId,$_SESSION["user_details"]["SchoolID"],$position);

            $insert2=$insertObj->inserter("Staff",$fields2,$data2);

            if($insert2=="1"){
               echo 1;
            }else{
               echo 0;
            }
         }else{
            echo 0;
         }     
      }else{
         echo 0;
      }*/
   }

   //EDIT STUDENT
   if(isset($_POST["edit_student_note"])){
      if(empty($_POST["username"])){
         die("<p class='alert alert-warning'>Enter username.<p>");
      }else if(empty($_POST["firstname"])){
         die("<p class='alert alert-warning'>Enter firstname.<p>");
      }else if(empty($_POST["lastname"])){
         die("<p class='alert alert-warning'>Enter lastname.<p>");
      }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
         die("<p class='alert alert-warning'>Select gender.<p>");
      }else if(empty($_POST["date_of_birth"])){
         die("<p class='alert alert-warning'>Enter date of birth.<p>");
      }

      $username=addslashes($_POST["username"]);
      $firstname=addslashes($_POST["firstname"]);
      $lastname=addslashes($_POST["lastname"]);
      $StudentIdNumber=addslashes($_POST["StudentIdNumber"]);
      $middlenames=addslashes($_POST["middlenames"]);
      $gender=addslashes($_POST["gender"]);
      $date_of_birth=addslashes($_POST["date_of_birth"]);
      $StudentUserId=$_POST["edit_student_note"];

      //UPDATE TO USERS
      $data="username='$username',firstname='$firstname',lastname='$lastname',middlenames='$middlenames',gender='$gender',DateOfBirth='$date_of_birth'";

      $update=$updateObj->updater("Users",$data,"UserId",$StudentUserId);

      if($update=="1"){
        $data2="StudentIdNumber='$StudentIdNumber'";
        $update2=$updateObj->updater("Students",$data2,"UserId",$StudentUserId);

        if($update2=="1"){
          echo 1;
        }else{
          echo 0;
        }
      }else{
         echo 0;
      }
   }

   //EDIT STAFF
   if(isset($_POST["edit_staff_note"])){
      if(empty($_POST["username"])){
         die("<p class='alert alert-warning'>Enter username.<p>");
      }else if(empty($_POST["title"])){
         die("<p class='alert alert-warning'>Enter title.<p>");
      }else if(empty($_POST["firstname"])){
         die("<p class='alert alert-warning'>Enter firstname.<p>");
      }else if(empty($_POST["lastname"])){
         die("<p class='alert alert-warning'>Enter lastname.<p>");
      }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
         die("<p class='alert alert-warning'>Select gender.<p>");
      }else if(empty($_POST["date_of_birth"])){
         die("<p class='alert alert-warning'>Enter date of birth.<p>");
      }

      $username=addslashes($_POST["username"]);
      $title=addslashes($_POST["title"]);
      $firstname=addslashes($_POST["firstname"]);
      $lastname=addslashes($_POST["lastname"]);
      $position=addslashes($_POST["position"]);
      $middlenames=addslashes($_POST["middlenames"]);
      $gender=addslashes($_POST["gender"]);
      $date_of_birth=addslashes($_POST["date_of_birth"]);
      $highest_qualification=addslashes($_POST["highest_qualification"]);
      $AUserId=addslashes($_POST["edit_staff_note"]);
      $AStaffID=addslashes($_POST["StaffID"]);

      $data="Username='$username',Title='$title',Firstname='$firstname',Lastname='$lastname',Middlenames='$middlenames',Gender='$gender',DateOfBirth='$date_of_birth'";

      
      $update=$updateObj->updater("Users",$data,"UserId",$AUserId);

      if($update=="1"){
         $get_recent_inserted_staff=$retrieveObj->retriever("Users WHERE Username='$username' ORDER BY UserId DESC","*","fetch");

         $data2="Position='$position',HighestQualification='$highest_qualification'";

         $update2=$updateObj->updater("Staff",$data2,"StaffID",$AStaffID);

         if($update2=="1"){
            echo 1;
         }else{
            echo 0;
         }
            
      }else{
         echo 0;
      }
   }

   //ALOCATE A SUBJECT TO TEACHER
    if(isset($_POST["allocate_subject_to_teacher_note"])){
        if(empty($_POST["allocate_subject_to_teacher_note"])){
            die("<p class='alert alert-warning'>Select User</p>");
        }else if(empty($_POST["subject"])){
            die("<p class='alert alert-warning'>Select subject</p>");
        }else if(empty($_POST["form"])){
            die("<p class='alert alert-warning'>Select form</p>");
        }else if(empty($_POST["term"])){
            die("<p class='alert alert-warning'>Select term</p>");
        }else if(empty($_POST["academic_year"])){
            die("<p class='alert alert-warning'>Select academic year</p>");
        }

        $rStaffID=addslashes($_POST["allocate_subject_to_teacher_note"]);
        $subject=addslashes($_POST["subject"]);
        $form=addslashes($_POST["form"]);
        $term=addslashes($_POST["term"]);
        $academic_year=addslashes($_POST["academic_year"]);

        //check if the user is already located to a select subject
        $check_u_m=$rowcountObj->rowcounter("TeacherSubjectAllocation","*","StaffID=$rStaffID and SubjectId",$subject);
        
        if($check_u_m>=1){
            die("<p class='alert alert-warning'>This teacher is already allocated to this subject.</p>");
        }

        $fields=array("SubjectId","StaffID","SchoolID","Form","Term","AcademicYear");
        $data=array($subject,$rStaffID,$_SESSION["user_details"]["SchoolID"],$form,$term,$academic_year);

        $insert=$insertObj->inserter("TeacherSubjectAllocation",$fields,$data);

        if($insert=="1"){
            echo 1;
        }else{
            echo 0;
        }
    }

    //DELETE UNALLOCATE SUBJECT FROM TEACHER
    if(isset($_POST["unallocate_subject_from_teacher_note"])){
      $a_id=addslashes($_POST["unallocate_subject_from_teacher_note"]);

      $delete=$deleteObj->deleter("TeacherSubjectAllocation","SubjectId",$a_id);

      if($delete=="1"){
         echo 1;
      }else{   
         echo 0;
      }
    }

    //REGISTER STUDENTS
    if(isset($_POST["register_students_note"])){
      if(empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form of study.</p>");
      }else if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }
      $students_list=$_POST["register_students_list"];
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=date("Y");

      $already_registered=0;
      $total_registered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Year_Record WHERE StudentId='".$students_list[$i]."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND Year = '$academic_year'  AND FormOfStudy='$form_of_study'","*");
                                        
        if($check_student < 1){
            $fields=array('StudentId','SchoolId','Year','FormOfStudy');
            $data=array($students_list[$i],$_SESSION['user_details']['SchoolID'],$academic_year,$form_of_study);

            $insert=$insertObj->inserter('Student_Year_Record',$fields,$data);
            if($insert=="1"){
              //UPDATE STUDENT CURRENT FORM
              $updateObj->updater('Students',"CurrentForm='$form_of_study'","StudentId",$students_list[$i]);
              $total_registered++;
            }
        }else{
            $already_registered++;
        }
      }

      if($total_registered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_registered student/s have been registered successfully to form $form_of_study. ";
          if($already_registered>0){
            echo "$already_registered student/s were already registered. ";
          }
        echo "</p>";
      }else{
        if($already_registered>0){
          echo "<p class='alert alert-warning'>$already_registered student/s were already registered.</p>";
        }else{
          echo 0;
        }
      }
    }

    //DEREGISTER STUDENTS
    if(isset($_POST["deregister_students_note"])){
      /*if(empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form of study.</p>");
      }*/

      if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }

      $students_list=$_POST["register_students_list"];
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=addslashes($_POST["academic_year"]);

      $already_deregistered=0;
      $total_deregistered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Year_Record WHERE StudentId='".$students_list[$i]."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND Year = '$academic_year' AND FormOfStudy='$form_of_study'","*");
                                        
        if($check_student > 0){
            $delete=$deleteObj->deleter('Student_Year_Record',"FormOfStudy='$form_of_study' and Year='$academic_year' and  StudentId",$students_list[$i]);
            if($delete=="1"){
              $total_deregistered++;
            }
        }else{
            $already_deregistered++;
        }
      }

      if($total_deregistered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_deregistered student/s have been deregistered successfully to form $form_of_study. ";
          if($already_deregistered>0){
            echo "$already_deregistered student/s were already deregistered. ";
          }
        echo "</p>";
      }else{
        if($already_deregistered>0){
          echo "<p class='alert alert-warning'>$already_deregistered student/s were already deregistered.</p>";
        }else{
          echo 0;
        }
      }
    }

    //REGISTER CLASS TO SUBJECT
    if(isset($_POST["register_class_to_subject_note"])){
      if(empty($_POST["subject"])){
        die("<p class='alert alert-warning'>Select subject.</p>");
      }else if(empty($_POST["term"])){
        die("<p class='alert alert-warning'>Select term.</p>");
      }else if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }
      $students_list=$_POST["register_students_list"];
      $subject=addslashes($_POST["subject"]);
      $term=addslashes($_POST["term"]);
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=date("Y");

      $already_registered=0;
      $total_registered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$students_list[$i]."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND AcademicYear = '$academic_year' AND FormOfStudy='$form_of_study' AND SubjectId='$subject' AND Term='$term'","*");
                                        
        if($check_student < 1){
            $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
            $data=array($students_list[$i],$_SESSION['user_details']['SchoolID'],$form_of_study,$academic_year,$term,$subject);

            $insert=$insertObj->inserter('Student_Term_Subjects',$fields,$data);
            if($insert=="1"){
              $total_registered++;
            }
        }else{
            $already_registered++;
        }
      }

      if($total_registered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_registered student/s in class have been registered successfully to the subject. ";
          if($already_registered>0){
            echo "$already_registered student/s in class were already registered to the subject. ";
          }
        echo "</p>";
      }else{
        if($already_registered>0){
          echo "<p class='alert alert-warning'>$already_registered student/s in class were already registered to the subject.</p>";
        }else{
          echo 0;
        }
      }
    }

    //REGISTER STUDENT TO SUBJECT
    if(isset($_POST["register_student_subject_note"]) and $_POST["rssn"]!="all"){
      if(empty($_POST["SubjectId"]) or empty($_POST["StudentId"])){
        die("<p class='alert alert-warning'>Something went wrong, please try again later.</p>");
      }
      $student=$_POST["StudentId"];
      $subject=addslashes($_POST["SubjectId"]);
      $register_status=addslashes($_POST["register_student_subject_note"]);
      $Form=addslashes($_POST["Form"]);
      $Term=addslashes($_POST["Term"]);

      $getStudentInfo=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId","*","StudentId",$student,"fetch");
      $getSubjectInfo=$retrieveObj->retriever("Subjects","*","SubjectId",$subject,"fetch");

      if($getStudentInfo=="1020"){
        die(0);
      }
      //$term=$getStudentInfo->TermOfStudy;
      $form_of_study=$Form;
      $academic_year=date("Y");

      $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$student."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND AcademicYear = '$academic_year' AND Term='$Term' AND FormOfStudy='$form_of_study' AND SubjectId='$subject'","*");
      if($register_status=="on"){ //register student to subject                            
        if($check_student < 1){
            $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
            $data=array($student,$_SESSION['user_details']['SchoolID'],$form_of_study,$academic_year,$Term,$subject);

            $insert=$insertObj->inserter('Student_Term_Subjects',$fields,$data);
            if($insert=="1"){
              echo "<p class='alert alert-success'>".$getStudentInfo->Firstname." is now registered to ".$getSubjectInfo->SubjectName.".</p>";
            }
        }else{ 
            echo "<p class='alert alert-warning'>".$getStudentInfo->Firstname." is already registered to ".$getSubjectInfo->SubjectName.".</p>";
        }
      }else{  //deregister student to subject
        if($check_student > 0){
            $delete=$deleteObj->deleter('Student_Term_Subjects',"FormOfStudy='$form_of_study' and AcademicYear='$academic_year' and SubjectId='$subject' and Term='$Term' and  StudentId",$student);
            if($delete=="1"){
              echo "<p class='alert alert-success'>".$getStudentInfo->Firstname." is now deregistered to ".$getSubjectInfo->SubjectName.".</p>";
            }
        }else{
            echo "<p class='alert alert-warning'>".$getStudentInfo->Firstname." is already deregistered to ".$getSubjectInfo->SubjectName.".</p>";
        }
      }
    }

    //REGISTER STUDENT TO SUBJECT
    if(isset($_POST["register_student_subject_note"]) and $_POST["rssn"]=="all"){
      $subject=addslashes($_POST["SubjectId"]);
      $register_status=addslashes($_POST["register_student_subject_note"]);
      $Form=addslashes($_POST["Form"]);
      $Term=addslashes($_POST["Term"]);

      $rssn_result=0;
      $rssn_result_a=0;

      $get_students=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId","*","CurrentForm='$Form' and SchoolID",$_SESSION['user_details']['SchoolID'],"fetchAll");

      foreach ($get_students as $student) {
        $getSubjectInfo=$retrieveObj->retriever("Subjects","*","SubjectId",$subject,"fetch");

        //$term=$getStudentInfo->TermOfStudy;
        $form_of_study=$Form;
        $academic_year=date("Y");

        $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$student->StudentId."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND AcademicYear = '$academic_year' AND Term='$Term' AND FormOfStudy='$form_of_study' AND SubjectId='$subject'","*");
        if($register_status=="on"){ //register student to subject                            
          if($check_student < 1){
              $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
              $data=array($student->StudentId,$_SESSION['user_details']['SchoolID'],$form_of_study,$academic_year,$Term,$subject);

              $insert=$insertObj->inserter('Student_Term_Subjects',$fields,$data);
              if($insert=="1"){
                //echo "<p class='alert alert-success'>".$student->Firstname." is now registered to ".$getSubjectInfo->SubjectName.".</p>";
                $rssn_result+=1;
              }
          }else{ 
              //echo "<p class='alert alert-warning'>".$student->Firstname." is already registered to ".$getSubjectInfo->SubjectName.".</p>";
              $rssn_result_a+=1;
          }
        }else{  //deregister student to subject
          if($check_student > 0){
              $delete=$deleteObj->deleter('Student_Term_Subjects',"FormOfStudy='$form_of_study' and AcademicYear='$academic_year' and SubjectId='$subject' and Term='$Term' and  StudentId",$student->StudentId);
              if($delete=="1"){
                //echo "<p class='alert alert-success'>".$student->Firstname." is now deregistered to ".$getSubjectInfo->SubjectName.".</p>";
                $rssn_result+=1;
              }
          }else{
              //echo "<p class='alert alert-warning'>".$student->Firstname." is already deregistered to ".$getSubjectInfo->SubjectName.".</p>";
              $rssn_result_a+=1;
          }
        }
      }

      if($rssn_result>0){
        echo 1;
      }else if($rssn_result_a>0){
        echo 2;
      }else{
        echo 0;
      }

    }

    //DEREGISTER CLASS TO SUBJECT
    if(isset($_POST["deregister_students_from_subject_note"])){
      if(empty($_POST["subject"])){
        die("<p class='alert alert-warning'>Select subject.</p>");
      }else if(empty($_POST["term"])){
        die("<p class='alert alert-warning'>Select term.</p>");
      }else if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }

      $students_list=$_POST["register_students_list"];
      $subject=addslashes($_POST["subject"]);
      $term=addslashes($_POST["term"]);
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=addslashes($_POST["academic_year"]);

      $already_deregistered=0;
      $total_deregistered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$students_list[$i]."' AND SchoolID='".$_SESSION['user_details']['SchoolID']."' AND SubjectId='$subject' AND Term='$term' AND AcademicYear = '$academic_year' AND FormOfStudy='$form_of_study'","*");
                                        
        if($check_student > 0){
            $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
            $data=array($students_list[$i],$_SESSION['user_details']['SchoolID'],$form_of_study,$academic_year,$term,$subject);

            $delete=$deleteObj->deleter('Student_Term_Subjects',"FormOfStudy='$form_of_study' and AcademicYear='$academic_year' and Term='$term' and SubjectId='$subject' and  StudentId",$students_list[$i]);
            if($delete=="1"){
              $total_deregistered++;
            }
        }else{
            $already_deregistered++;
        }
      }

      if($total_deregistered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_deregistered student/s in class have been deregistered successfully to the subject. ";
          if($already_deregistered>0){
            echo "$already_deregistered student/s in class were already deregistered to the subject. ";
          }
        echo "</p>";
      }else{
        if($already_deregistered>0){
          echo "<p class='alert alert-warning'>$already_deregistered student/s in class were already deregistered to the subject.</p>";
        }else{
          echo 0;
        }
      }
    }

    if(isset($_POST["grade_entry_note"])){
      $result=0;
      $Subject=addslashes($_POST["Subject"]);
      $AcademicYear=addslashes($_POST["AcademicYear"]);
      $FormOfStudy=addslashes($_POST["FormOfStudy"]);
      $Term=addslashes($_POST["Term"]);

      if(isset($_FILES["grade_entry_excel_"])){
        $grades_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["grade_entry_excel_"]["tmp_name"]) ) {
          $grades_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($grades_array)<4){
          die("<p class='alert alert-warning'>Please add at least on student in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        $row = 1;
        //VALIDATE EXCEL
          $add_grades_loopcount=0;
          foreach ($grades_array as $data) {
              $add_grades_loopcount+=1;
              if($add_grades_loopcount==1){
                continue;
              }else if($add_grades_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="GRADES ENTRY TEMPLATE"
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }else if($add_grades_loopcount==3){
                //validate header
                if(
                  trim($data[0])!="StudentIDNumber" or
                  trim($data[1])!="Student Name" or
                  trim($data[2])!="Continuous Assessment" or
                  trim($data[3])!="Final Exam" or
                  trim($data[4])!="Comment"
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter StudentIDNumber for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[1])){
                //pass student name
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter Continuous Assessment for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[3])){
                die("<p class='alert alert-warning'>Enter Final Exam for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[4])){
                //pass comment
              }

              //check if the student is registered to the subject
              $get_student=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId JOIN Student_Term_Subjects ON Student_Term_Subjects.StudentId=Students.StudentId WHERE Student_Term_Subjects.SubjectId='$Subject' AND AcademicYear='$AcademicYear' AND Term='$Term' AND Student_Term_Subjects.FormOfStudy='$FormOfStudy' AND StudentIdNumber='".$data[0]."' AND Student_Term_Subjects.SchoolID='".$_SESSION["user_details"]["SchoolID"]."'","*","fetch");

              if($get_student=="1020"){
                die("<p class='alert alert-warning'>The student on line $add_grades_loopcount is not registered to the selected subject for the particular class and term and year.<p>");
              }
          }
        /*VALIDATE EXCEL*/

        //ADD GRADES
        $add_grades_loopcount=0;
        foreach ($grades_array as $data) {
            $add_grades_loopcount+=1;
            if($add_grades_loopcount<=2){
              continue;
            }
            
            $StudentIDNumber=addslashes($data[0]);
            $ContinuousAssessment=addslashes($data[2]);
            $FinalExam=addslashes($data[3]);
            $Comment=addslashes($data[4]);

            $get_student=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId JOIN Student_Term_Subjects ON Student_Term_Subjects.StudentId=Students.StudentId WHERE Student_Term_Subjects.SubjectId='$Subject' AND AcademicYear='$AcademicYear' AND Term='$Term' AND Student_Term_Subjects.FormOfStudy='$FormOfStudy' AND StudentIdNumber='".$data[0]."' AND Student_Term_Subjects.SchoolID='".$_SESSION["user_details"]["SchoolID"]."'","*","fetch");
            if($get_student=="1020"){
              continue;
            }

            $total_grade=(float)$ContinuousAssessment+(float)$FinalExam;
            
            $data=" ContinuousAssessmentGrade = '$ContinuousAssessment', EndOfSemesterGrade = '$FinalExam', TeacherComments = '$Comment' ,TotalGrade='$total_grade'";

            $update=$updateObj->updater("Student_Term_Subjects",$data,"SchoolID = '".$_SESSION['user_details']['SchoolID']."' AND StudentId = '".$get_student->StudentId."' AND FormOfStudy = '$FormOfStudy' AND AcademicYear = '$AcademicYear' AND Term = '$Term' AND SubjectId",$Subject);

            if($update=="1"){
              $result+=1;
            }
          
        }
        //ADD GRADES

      }else{
        $ContinuousAssessment=$_POST["ContinuousAssessment"];
        $Comment=$_POST["Comment"];
        $FinalExam=$_POST["FinalExam"];
        $StudentId=$_POST["StudentId"];

        for ($i=0; $i < count($FinalExam) ; $i++) { 
          $total_grade=(float)$ContinuousAssessment[$i]+(float)$FinalExam[$i];
          
          $data=" ContinuousAssessmentGrade = '".$ContinuousAssessment[$i]."', EndOfSemesterGrade = '".$FinalExam[$i]."', TeacherComments = '".$Comment[$i]."' ,TotalGrade='".$total_grade."'";

          $update=$updateObj->updater("Student_Term_Subjects",$data,"SchoolID = '".$_SESSION['user_details']['SchoolID']."' AND StudentId = '".$StudentId[$i]."' AND FormOfStudy = '$FormOfStudy' AND AcademicYear = '$AcademicYear' AND Term = '$Term' AND SubjectId",$Subject);

          if($update=="1"){
            $result+=1;
          }
        }
      }

      if($result>0){
        echo 1;
      }else{
        echo 0;
      }
    }

    if(isset($_POST["update_form_fees_note"])){
      if(empty($_POST["FeesAmount"])){
        die("<p class='alert alert-warning'>Enter fees amount</p>");
      }
      $Form=addslashes($_POST["update_form_fees_note"]);
      $FeesAmount=addslashes($_POST["FeesAmount"]);

      //check if already exist
      $check=$rowcountObj->rowcounter("StudentFeesPerTerm","*","FeesAmountForm='$Form' and SchoolId",$_SESSION['user_details']['SchoolID']);

      $update=0;
      if($check<=0){
        $fields=array("SchoolID","FeesAmount","FeesAmountForm");
        $data=array($_SESSION['user_details']['SchoolID'],$FeesAmount,$Form);
        $update=$insertObj->inserter("StudentFeesPerTerm",$fields,$data);
      }else{
        $update=$updateObj->updater("StudentFeesPerTerm","FeesAmount = '$FeesAmount'","FeesAmountForm = '$Form' AND SchoolID",$_SESSION['user_details']['SchoolID']);
      }

      if($update=="1"){
         echo 1; 
      }else{
         echo 0;
      }
    }

    //process subject grades
    if(isset($_POST["process_subject_grade_note"])){
      $current_year=date("Y");
      if(!isset($_POST["form"]) or empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form.</p>");
      }else if(!isset($_POST["term"]) or empty($_POST["term"])){
        die("<p class='alert alert-warning'>Select term.</p>");
      }
      $form=addslashes($_POST["form"]);
      $term=addslashes($_POST["term"]);

      $get_form_grading_type=$retrieveObj->retriever("FormGradingTypes","*","form='$form' and SchoolID",$_SESSION['user_details']['SchoolID'],"fetch");

      if($get_form_grading_type=="1020"){
        echo 0;
        die();
      }

      $term_var="";

      if($term!="all"){
        $term_var.=" AND Term = '$term'  ";
      }

      if($get_form_grading_type->GradingType=="Points"){ 
        //process with points
        $grade_scales = $retrieveObj->retriever("MANEBgrade_scale_points","*","fetchAll");

        if($grade_scales=="1020"){
          die();
        }

        $get_students=$retrieveObj->retriever("Student_Term_Subjects","*","AcademicYear='$current_year' and FormOfStudy='$form' $term_var and SchoolID",$_SESSION['user_details']['SchoolID'],"fetchAll");
        
        if($get_students=="1020"){
          die("<p class='alert alert-warning'>Student information not found in the form and year selected.</p>");
        }

        foreach ($get_students as $student) {
          $get_subjects = $retrieveObj->retriever("Student_Term_Subjects JOIN SUbjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION['user_details']['SchoolID']}' $term_var","*","fetchAll");

          if($get_subjects!="1020"){
            $update=$updateObj->updater("Student_Term_Subjects","LetterGrade = NULL, Points = NULL","AcademicYear = '$current_year' AND FormOfStudy = '$form' $term_var AND SchoolID",$_SESSION['user_details']['SchoolID']);

            if($update=="1"){
              foreach($get_subjects as $subject){
                  if($subject->TotalGrade != NULL){
                      $point = NULL;
                      $point_description = NULL;
                      foreach($grade_scales as $scale){
                        $array = explode("-", $scale->GradeRange);
                        if(sizeof($array) > 1){
                          $min = intval(trim($array[0]));
                          $max = intval(trim($array[1]));
                          
                          if($subject->TotalGrade >= $min && $subject->TotalGrade <= $max){
                              $point = $scale->Points;
                              $point_description = $scale->Description;
                          }
                        }
                      }
                      
                      if($point != NULL){
                          $update=$updateObj->updater("Student_Term_Subjects","Points = '$point'","ID",$subject->ID);
                          if($update=="1"){
                            //echo 1;
                          }else{
                            //echo 0;
                            //die();
                          }
                      }
                      else{
                        die(0);
                      }
                  }else{
                    continue;
                  }

              }
              
            }else{
              die(0);
            }
          }else{
            die("<p class='alert alert-warning'>No Subject Found.</p>");
          }
        }
        echo 1;
      }else{  
        //process with letters
        $grade_scales = $retrieveObj->retriever("MANEBgrade_scale_letter_grades","*","fetchAll");

        if($grade_scales=="1020"){
          die();
        }

        $get_students=$retrieveObj->retriever("Student_Term_Subjects","*","AcademicYear='$current_year' and FormOfStudy='$form' $term_var and SchoolID",$_SESSION['user_details']['SchoolID'],"fetchAll");
        
        if($get_students=="1020"){
          die("<p class='alert alert-warning'>Student information not found in the form and year selected.</p>");
        }

        foreach ($get_students as $student) {
          $get_subjects = $retrieveObj->retriever("Student_Term_Subjects JOIN SUbjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION['user_details']['SchoolID']}' $term_var","*","fetchAll");

          if($get_subjects!="1020"){
            $update=$updateObj->updater("Student_Term_Subjects","LetterGrade = NULL, Points = NULL","AcademicYear = '$current_year' AND FormOfStudy = '$form' $term_var AND SchoolID",$_SESSION['user_details']['SchoolID']);

            if($update=="1"){
              foreach($get_subjects as $subject){
                  if($subject->TotalGrade != NULL){
                      $letter = NULL;
                      $letter_description = NULL;
                      foreach($grade_scales as $scale){
                        $array = explode("-", $scale->GradeRange);
                        if(sizeof($array) > 1){
                          $min = intval(trim($array[0]));
                          $max = intval(trim($array[1]));
                          
                          if($subject->TotalGrade >= $min && $subject->TotalGrade <= $max){
                              $letter = $scale->LetterGrade;
                              $letter_description = $scale->Description;
                          }
                        }
                      }
                      
                      if($letter != NULL){
                          $update=$updateObj->updater("Student_Term_Subjects","LetterGrade = '$letter'","ID",$subject->ID);
                          if($update=="1"){
                            //echo 1;
                          }else{
                            //echo 0;
                            //die();
                          }
                      }
                      else{
                        die(0);
                      }
                  }else{
                      continue;
                  }
                  
              }

            }else{
              die(0);
            }
          }else{
            die("<p class='alert alert-warning'>No Subject Found.</p>");
          }
        }
        echo 1;
      }
    }

    if(isset($_POST["process_term_record_note"])){
      $current_year=date("Y");
      if(!isset($_POST["form"]) or empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form.</p>");
      }else if(!isset($_POST["term"]) or empty($_POST["term"])){
        die("<p class='alert alert-warning'>Select term.</p>");
      }
      $form=addslashes($_POST["form"]);
      $term=addslashes($_POST["term"]);

      $update_syr_result=0;

      $get_form_grading_type=$retrieveObj->retriever("FormGradingTypes","*","form='$form' and SchoolID",$_SESSION['user_details']['SchoolID'],"fetch");

      if($get_form_grading_type=="1020"){
        die("<p class='alert alert-warning'>Grade conversion type not found for the form selected.</p>");
      }
      

      $term_var="";

      if($term!="all"){
        $term_var.=" AND Term = '$term'  ";
      }

      $c_type = $get_form_grading_type->GradingType;
      
      
      if($c_type != ""){
          $get_students=$retrieveObj->retriever("Student_Term_Subjects","*","AcademicYear='$current_year' and FormOfStudy='$form' $term_var and SchoolID",$_SESSION['user_details']['SchoolID'],"fetchAll");
        
          if($get_students=="1020"){
            die("<p class='alert alert-warning'>No registered students found.</p>");
          }
            
          if($c_type == "Points"){
              foreach($get_students as $student){
                  $i = 1;
                  $loop = 1;
                  //echo $student["StudentId"]."=>";
                  if($term == "all"){
                      $loop = 3;
                  }
                  while($i <= $loop){
                      $term_ = "";
                      if($term == "all"){
                          $term_ = $i;
                      }
                      else{
                          $term_ = $term;
                      }
                      
                      $column = "";
                      $result_column = "";
                      if($term_ == 1){
                          $column = " TermOnePoints ";
                          $result_column = " TermOneResult ";
                      }
                      else if($term_ == 2){
                          $column = " TermTwoPoints ";
                          $result_column = " TermTwoResult ";
                      }
                      else if($term_ == 3){
                          $column = " TermThreePoints ";
                          $result_column = " TermThreeResult ";
                      }  
                      
                      //echo " Term $term Points = ";
                      $subjects_sql = $retrieveObj->retriever("Student_Term_Subjects JOIN Subjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION["user_details"]["SchoolID"]}' AND Term = '$term' AND Points IS NOT NULL AND SubjectName != 'English' ORDER BY Points LIMIT 5 ","*","fetchAll");
                      //$subjects_sql = $db_connect->query("SELECT * FROM malawisc_education.Student_Term_Subjects WHERE StudentId = '{$student["StudentId"]}' AND AcademicYear = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND SchoolID = '{$_GET["SIDN"]}' AND Term = '$term' AND Points IS NOT NULL AND Subject != 'English' ORDER BY Points LIMIT 5 ");
                      if($subjects_sql!="1020" and count($subjects_sql)<5){
                          //echo "?, Total Graded Subjects less that 6 for term $term. ";
                          $updateObj->updater("Student_Year_Record SET $result_column = 'INC' WHERE Year = '$year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId = '{$_SESSION["user_details"]["SchoolID"]}'");
                                                   
                          //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $result_column = 'INC' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");                                
                      }
                      else{
                          $english_sql = $retrieveObj->retriever("Student_Term_Subjects JOIN Subjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION["user_details"]["SchoolID"]}' AND Term = '$term' AND Points IS NOT NULL AND SubjectName != 'English' ORDER BY Points LIMIT 1 ","*","fetchAll");

                          //$english_sql = $db_connect->query("SELECT * FROM malawisc_education.Student_Term_Subjects WHERE StudentId = '{$student["StudentId"]}' AND AcademicYear = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND SchoolID = '{$_GET["SIDN"]}' AND Term = '$term' AND Points IS NOT NULL AND Subject = 'English' ORDER BY Points LIMIT 1 ");
                          
                          if($english_sql!="1020"){
                              $english_grade = $english_sql->fetch(PDO::FETCH_BOTH);
                              $points = $english_grade["Points"];
                                    
                              if($english_grade["Points"] <= 8){
                                  $subjects = $subjects_sql->fetchAll();
                                  foreach($subjects as $subject){
                                      $points += $subject["Points"];
                                  }
                                  //echo " $points. ";

                                  //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $column = '{$points}' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");         

                                  $update_syr=$updateObj->updater("Student_Year_Record","$column = '$points'","Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]); 

                                  if($update_syr=="1"){
                                    $update_syr_result+=1;
                                  }                              
                              }
                              else{
                                  $update_syr=$updateObj->updater("Student_Year_Record","$result_column = 'FAIL'","Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]); 

                                  if($update_syr=="1"){
                                    $update_syr_result+=1;
                                  }

                                  //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $result_column = 'FAIL' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");
                              }
                              
                          }
                          else{
                              //echo "?, Does not have english for term $term. ";

                              $update_syr=$updateObj->updater("Student_Year_Record","$result_column = 'INC'","Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]); 

                              if($update_syr=="1"){
                                $update_syr_result+=1;
                              }
                              
                              //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $result_column = 'INC' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");
                          }
                      }
                      
                      $i++;
                  }
                  
                  //echo "<br><br>";
              }
          }else{
              foreach($get_students as $student){
                  $i = 1;
                  $loop = 1;
                  //echo $student["StudentId"]."=>";
                  if($term == "all"){
                      $loop = 3;
                  }
                  for($i=1; $i<= $loop;$i++){
                      $term_ = "";
                      if($term == "all"){
                          $term_ = $i;
                      }
                      else{
                          $term_ = $term;
                      }
                      
                      $column = "";
                      $result_column = "";
                      if($term_ == 1){
                          $column = " TermOneTotalMarks ";
                          $result_column = " TermOneResult ";
                      }
                      else if($term_ == 2){
                          $column = " TermTwoTotalMarks ";
                          $result_column = " TermTwoResult ";
                      }
                      else if($term_ == 3){
                          $column = " TermThreeTotalMarks ";
                          $result_column = " TermThreeResult ";
                      }   
                      
                      //echo " Term $term Total Marks = ";
                      //$subjects_sql = $db_connect->query("SELECT * FROM malawisc_education.Student_Term_Subjects WHERE StudentId = '{$student["StudentId"]}' AND AcademicYear = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND SchoolID = '{$_GET["SIDN"]}' AND Term = '$term' AND LetterGrade IS NOT NULL AND Subject != 'English' ORDER BY LetterGrade LIMIT 5");

                      $subjects_sql = $retrieveObj->retriever("Student_Term_Subjects JOIN Subjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION["user_details"]["SchoolID"]}' AND Term = '$term' AND Points IS NOT NULL AND SubjectName != 'English' ORDER BY Points LIMIT 5 ","*","fetchAll");
                      
                      if($subjects_sql!="1020" and count($subjects_sql)<5){
                          //echo "?, Total Graded Subjects less that 6 for term $term. ";
                          $update_syr=$updateObj->updater("Student_Year_Record","$result_column = 'INC'","Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]);
                          if($update_syr=="1"){
                            $update_syr_result+=1;
                          }
                          //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $result_column = 'INC' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");                                
                      }
                      else{
                          $english_sql = $retrieveObj->retriever("Student_Term_Subjects JOIN Subjects ON Subjects.SubjectId=Student_Term_Subjects.SubjectId WHERE StudentId = '{$student->StudentId}' AND AcademicYear = '$current_year' AND FormOfStudy = '$form' AND SchoolID = '{$_SESSION["user_details"]["SchoolID"]}' AND Term = '$term' AND LetterGrade IS NOT NULL AND SubjectName = 'English' ORDER BY Points LIMIT 1 ","*","fetchAll");

                          //$english_sql = $db_connect->query("SELECT * FROM malawisc_education.Student_Term_Subjects WHERE StudentId = '{$student["StudentId"]}' AND AcademicYear = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND SchoolID = '{$_GET["SIDN"]}' AND Term = '$term' AND LetterGrade IS NOT NULL AND Subject = 'English' ORDER BY Points LIMIT 1 ");
                          
                          
                          if($english_sql!="1020" and count($english_sql) > 0){
                              $english_grade = $english_sql->fetch(PDO::FETCH_BOTH);
                              $total_marks = $english_grade["TotalGrade"];
                              $subjects = $subjects_sql->fetchAll();
                              foreach($subjects as $subject){
                                  $total_marks += $subject["TotalGrade"];
                              }
                              //echo " $total_marks. ";
                              
                              //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $column = '{$total_marks}' WHERE Year = '{$_GET["current_year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'");

                              $update_syr=$updateObj->updater("Student_Year_Record","$column = '$total_marks'"," Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]);

                              if($update_syr=="1"){
                                $update_syr_result+=1;
                              }
                          }
                          else{
                              //echo "?, Does not have english for term $term. ";
                              $update_syr=$updateObj->updater("Student_Year_Record","$result_column = 'INC'"," Year = '$current_year' AND FormOfStudy = '$form' AND StudentId = '{$student->StudentId}' AND SchoolId",$_SESSION["user_details"]["SchoolID"]);
                              if($update_syr=="1"){
                                $update_syr_result+=1;
                              }
                              //$db_connect->exec("UPDATE malawisc_education.Student_Year_Record SET $result_column = 'INC' WHERE Year = '{$_GET["year"]}' AND FormOfStudy = '{$_GET["form"]}' AND StudentId = '{$student["StudentId"]}' AND SchoolId = '{$_GET["SIDN"]}'"); 
                          }
                      }
                  }
                  
                  //echo "<br><br>";
              }                    
          }
        if($update_syr_result>0){
          echo 1;
        }else{
          echo 0;
        }
      }
    }

    //ADD FEES PAYMENT
    if(isset($_POST["add_fees_payment_note"])){
      //VALIDATION
      if(empty($_POST["StudentId"])){
        die("<p class='alert alert-warning'>Select student</p>");
      }else if(empty($_POST["fees_amount"])){
        die("<p class='alert alert-warning'>Enter the amount paid</p>");
      }

      $StudentId=addslashes($_POST["StudentId"]);
      $AmountPaid=addslashes($_POST["fees_amount"]);
      $PaymentNotes=addslashes($_POST["PaymentNotes"]);

      $CurrentForm="";
      $CurrentTerm="";

      $get_student=$retrieveObj->retriever("Students WHERE StudentId='$StudentId'","*","fetch");
      if($get_student!="1020"){
        $CurrentForm=$get_student->CurrentForm;
        $CurrentTerm=$get_student->CurrentTerm;
      }else{
        die(0);
      }

      $fields=array("SchoolID","StudentId","AmountPaid","PaymentForm","PaymentTerm","PaymentNotes");
      $data=array($_SESSION["user_details"]["SchoolID"],$StudentId,$AmountPaid,$CurrentForm,$CurrentTerm,$PaymentNotes);

      $insert=$insertObj->inserter("StudentFeesPayment",$fields,$data);

      if($insert=="1"){
        $get_form_fees=$retrieveObj->retriever("StudentFeesPerTerm","*","FeesAmountForm='$CurrentForm' and SchoolId",$_SESSION['user_details']['SchoolID'],"fetch");
        if($get_form_fees!="1020"){
          //calculate fees
          $get_payments=$retrieveObj->retriever("StudentFeesPayment","*","PaymentForm='$CurrentForm' and PaymentTerm='$CurrentTerm' and StudentId",$StudentId,"fetchAll");
          if($get_payments!="1020"){
            $totalPaid=0;
            foreach ($get_payments as $payment) {
              $totalPaid+=$payment->AmountPaid;
            }

            $FeesBalance=(float)$get_form_fees->FeesAmount-(float)$AmountPaid;

            //check if already exist
            $check=$rowcountObj->rowcounter("StudentFeesStatus","*","StudentId='$StudentId' and SchoolID",$_SESSION['user_details']['SchoolID']);

            if($check<=0){
              $fields=array("SchoolID","StudentId","FeesAmount","FeesPaid","FeesBalance");
              $data=array($_SESSION["user_details"]["SchoolID"],$StudentId,$get_form_fees->FeesAmount,$totalPaid,$FeesBalance);

              $insert=$insertObj->inserter("StudentFeesStatus",$fields,$data);
            }else{
              $update=$updateObj->updater("StudentFeesStatus","FeesPaid='$totalPaid',FeesAmount='".$get_form_fees->FeesAmount."',FeesBalance='$FeesBalance'","StudentId='$StudentId' and SchoolID",$_SESSION['user_details']['SchoolID']);
            }
          }else{
            die(0);
          }

          //insert to fees status
        }else{
          die(0);
        }
        echo 1;
      }else{
        echo 0;
      }
    }

    //ADD FEES PAYMENT
    if(isset($_POST["edit_fees_payment_note"])){
      //VALIDATION
      if(empty($_POST["fees_amount"])){
        die("<p class='alert alert-warning'>Enter the amount paid</p>");
      }

      $StudentFeesPaymentId=addslashes($_POST["edit_fees_payment_note"]);
      $AmountPaid=addslashes($_POST["fees_amount"]);
      $PaymentNotes=addslashes($_POST["PaymentNotes"]);

      $PaymentForm="";
      $PaymentTerm="";

      $get_student=$retrieveObj->retriever("Students JOIN StudentFeesPayment ON StudentFeesPayment.StudentId=StudentFeesPayment.StudentId WHERE StudentFeesPayment.StudentFeesPaymentId='$StudentFeesPaymentId'","*","fetch");
      if($get_student!="1020"){
        $PaymentForm=$get_student->PaymentForm;
        $PaymentTerm=$get_student->PaymentTerm;
      }else{
        die(0);
      }

      $update=$updateObj->updater("StudentFeesPayment","AmountPaid='$AmountPaid',PaymentNotes='$PaymentNotes'","StudentFeesPaymentId",$StudentFeesPaymentId);

      if($update=="1"){
        $get_form_fees=$retrieveObj->retriever("StudentFeesPerTerm","*","FeesAmountForm='$PaymentForm' and SchoolId",$_SESSION['user_details']['SchoolID'],"fetch");
        if($get_form_fees!="1020"){
          //calculate fees
          $get_payments=$retrieveObj->retriever("StudentFeesPayment","*","PaymentForm='$PaymentForm' and PaymentTerm='$PaymentTerm' and StudentId",$get_student->StudentId,"fetchAll");
          if($get_payments!="1020"){
            $totalPaid=0;
            foreach ($get_payments as $payment) {
              $totalPaid+=$payment->AmountPaid;
            }

            $FeesBalance=(float)$get_form_fees->FeesAmount-(float)$AmountPaid;

            //check if already exist
            $check=$rowcountObj->rowcounter("StudentFeesStatus","*","StudentId='".$get_student->StudentId."' and SchoolID",$_SESSION['user_details']['SchoolID']);

            if($check<=0){
              $fields=array("SchoolID","StudentId","FeesAmount","FeesPaid","FeesBalance");
              $data=array($_SESSION["user_details"]["SchoolID"],$get_student->StudentId,$get_form_fees->FeesAmount,$totalPaid,$FeesBalance);

              $insert=$insertObj->inserter("StudentFeesStatus",$fields,$data);
            }else{
              $update=$updateObj->updater("StudentFeesStatus","FeesPaid='$totalPaid',FeesAmount='".$get_form_fees->FeesAmount."',FeesBalance='$FeesBalance'","StudentId='".$get_student->StudentId."' and SchoolID",$_SESSION['user_details']['SchoolID']);
            }
          }else{
            die(0);
          }

          //insert to fees status
        }else{
          die(0);
        }
        echo 1;
      }else{
        echo 0;
      }
    }

    if(isset($_POST["update_grading_method_note"])){
      $GradingType=addslashes($_POST["GradingType"]);
      $Form=addslashes($_POST["update_grading_method_note"]);
      $SchoolID=$_SESSION['user_details']['SchoolID'];

      if(empty($_POST["GradingType"])){
        die("<p class='alert alert-warning'>Select grading type</p>");
      }

      $check_if_exist=$rowcountObj->rowcounter("FormGradingTypes","*","SchoolID",$SchoolID);

      $result=0;
      if($check_if_exist>=1){
        //update
        $result=$updateObj->updater("FormGradingTypes","GradingType='$GradingType'","SchoolID='$SchoolID' and Form",$Form);
      }else{
        //insert
        $fields=array("GradingType","Form","SchoolID");
        $data=array($GradingType,$Form,$SchoolID);

        $result=$insertObj->inserter("FormGradingTypes",$fields,$data);
      }

      if($result>0){
          echo 1;
        }else{
          echo 0;
        }
    }
?>