<?php
    require_once("../session_check.php");
    require_once("../../classes/main_classes.php");

    //OBJECTS
    $retrieveObj=new RETRIEVE();

    $UserType=$_SESSION['user_details']['UserType'];
    $get_profile_info="1020";
    if($UserType=="school_staff"){
        //get user information
        $get_profile_info=$retrieveObj->retriever("Users
            JOIN UserTypes ON UserTypes.UserId=Users.UserId
            JOIN UserType ON UserTypes.UserTypeId=UserType.UserTypeId
            JOIN Staff ON Staff.UserId=Users.UserId
            JOIN Schools ON Schools.SchoolID=Staff.SchoolID
            ","*","Users.UserId",$UserId,"fetch");

    }else if($UserType=="student"){
        //get user information
        $get_profile_info=$retrieveObj->retriever("Users
            JOIN UserTypes ON UserTypes.UserId=Users.UserId
            JOIN UserType ON UserTypes.UserTypeId=UserType.UserTypeId
            JOIN Students ON Students.UserId=Users.UserId
            JOIN Schools ON Schools.SchoolID=Students.SchoolID
            ","*","Users.UserId",$UserId,"fetch");
    }

    if($get_profile_info=="1020"){
        die("<p class='alert alert-warning'>Something went wrong</p>");
    }
?>


<!-- ============================================================== -->
<!-- Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h3 class="text-themecolor m-b-0 m-t-0">Profile</h3>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item active">Profile</li>
        </ol>
    </div>
    <div class="col-md-7 col-4 align-self-center">
        
    </div>
</div>
<!-- ============================================================== -->
<!-- End Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<!-- Row -->
<div class="row">
    <!-- Column -->
    <div class="col-lg-4 col-xlg-3 col-md-5">
        <div class="card">
            <div class="card-block">
                <center class="m-t-30"> 
                    <!--img src="assets/images/users/5.jpg" class="img-circle" width="150" /-->
                    <p class="text-center py-3" id="profilePhotoContainer">
                        <?php
                            $profile_photo="";
                            if($get_profile_info->photo_id==""){
                              $profile_photo="photo".$get_profile_info->UserId.".png";
                                echo '<span class="nav-link" href="#"><i class="fas fa-user fa-3x text-primary hand_cursor" data-toggle="collapse" data-target="#profile_pic_form_container"></i></span>';
                            }else{
                              $profile_photo=$get_profile_info->photo_id;
                                echo '<img id="profile_picture" src="../images/profile_pictures/'.$get_profile_info->photo_id.'?'.date("Y-m-d").time().'" max-height="600px" class="mr-1 shadow rounded-circle thumbnail p-1 hand_cursor" data-toggle="collapse" data-target="#profile_pic_form_container">';
                            }
                        ?>
                    </p>
                    <div class="card-footer collapse" id="profile_pic_form_container">
                        <div id="changePhotoResponse"></div>
                        <input class="" type="file" id="upload_image" name="upload_image">
                    </div>
                    <h4 class="card-title m-t-10"><?php echo $get_profile_info->Firstname." ".$get_profile_info->Lastname ?></h4>
                    <h6 class="card-subtitle">
                        <?php
                            if($get_profile_info->UserType=="school_staff"){
                                echo "School Staff";
                            }else if($get_profile_info->UserType=="Student"){
                                echo "Student";
                            }else{
                                echo $get_profile_info->UserType;
                            }
                        ?>
                    </h6>
                    
                </center>
            </div>
        </div>
        <div class="card">
            <div class="card-header text-center bg-light">
                Update Password
            </div>
            <div class="card-body">
                <form class="form-horizontal form-material" id="change_password_form">
                    <div class="form-group">
                        <label class="col-md-12">Current Password :</label>
                        <div class="col-md-12">
                            <input type="password" placeholder="********" class="form-control form-control-line" name="Cpassword" id="Cpassword">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">New Password :</label>
                        <div class="col-md-12">
                            <input type="password" placeholder="********" class="form-control form-control-line" name="Npassword" id="Npassword">
                        </div>
                    </div>
                    <div class="form-group mb-3">
                        <label class="col-md-12">Re-enter Password :</label>
                        <div class="col-md-12">
                            <input type="password" placeholder="********" class="form-control form-control-line" name="Rpassword" id="Rpassword">
                        </div>
                    </div>
                    <div class="px-3 pb-3" id="change_password_response" >
                        
                    </div>
                    <div class="form-group">
                        <div class="col-sm-12">
                            <input type="hidden" name="change_password_note">
                            <button class="btn btn-success" type="submit" onclick="change_password()">Update Password</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Column -->
    <!-- Column -->
    <div class="col-lg-8 col-xlg-9 col-md-7">
        <div class="card">
            <div class="card-block">
                <form class="form-horizontal form-material" id="edit_profile_form">
                    <div class="form-group">
                        <label class="col-md-12 font-weight-bold">Firstname :</label>
                        <div class="col-md-12">
                            <input name="firstname" type="text" value="<?php echo $get_profile_info->Firstname; ?>" class="form-control form-control-line">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12 font-weight-bold">Lastname :</label>
                        <div class="col-md-12">
                            <input name="lastname" type="text" value="<?php echo $get_profile_info->Lastname; ?>" class="form-control form-control-line">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="example-email" class="col-md-12 font-weight-bold">Email :</label>
                        <div class="col-md-12">
                            <input name="email" type="email" value="<?php echo $get_profile_info->EmailAddress; ?>" class="form-control form-control-line" name="example-email" id="example-email">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12 font-weight-bold">Username :</label>
                        <div class="col-md-12">
                            <input name="username" type="text" value="<?php echo $get_profile_info->Username; ?>" class="form-control form-control-line">
                        </div>
                    </div>
                    <div class="form-group mb-3">
                        <label class="col-md-12 font-weight-bold">Phone No :</label>
                        <div class="col-md-12">
                            <input name="phone" type="text" placeholder="" value="<?php echo $get_profile_info->PhoneNumber; ?>" class="form-control form-control-line">
                        </div>
                    </div>
                    <div class="px-3 pb-3" id="edit_profile_response"></div>
                    <div class="form-group">
                        <div class="col-sm-12">
                            <input type="hidden" name="update_profile_note">
                            <button class="btn btn-success" type="submit" onclick="update_profile()">Update Profile</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Column -->
    <!-- Column -->
    <div class="col-lg-12 col-xlg-12 col-md-12">
        <div class="card">
            <div >
                <p class="p-2 lead"><span class="fa fa-bulding"></span> School Profile</p>
            </div>
            <div class="card-block">
                <?php 
                    $logo_profile_photo="";
                    if($get_profile_info->UserType=="school_staff" and $get_profile_info->Position=="School Owner"){
                ?>
                        <div class="text-center mb-5">
                            <a href="#" data-toggle="collapse" data-target="#add_school_logo_container" id="logo_profilePhotoContainer">
                                <?php
                                    
                                    if(!empty($get_profile_info->SchoolLogo)){
                                        $logo_profile_photo=$get_profile_info->SchoolLogo;
                                        if(file_exists("../../images/school_logo/".$get_profile_info->SchoolLogo)){
                                ?>
                                    <img id="logo_profile_picture" class="mt-2" src="<?php echo "../images/school_logo/".$get_profile_info->SchoolLogo; ?>" alt="Logo" style="max-height: 150px;" /></span> </a>
                                <?php
                                        }
                                    }else{
                                        $logo_profile_photo="logo".$get_profile_info->SchoolID.".png";
                                        echo "<span class='fas fa-image fa-5x'></span>";
                                    }
                                ?>
                            </a>
                            
                            <div class="collapse p-3" style="border:1px solid #EEEEEE;" id="add_school_logo_container">
                                <p class="font-weight-bold">Update Logo</p>
                                <div id="changeLogoPhotoResponse"></div>
                                <div class="input-group text-center">
                                    <label class="input-group-append pt-2">Select Image &nbsp; : &nbsp;</label>
                                    <input type="file" name="logo_upload_image" id="logo_upload_image" class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>

                        <form class="form-horizontal form-material" id="edit_school_info_form">
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Name :</label>
                                <div class="col-md-12">
                                    <input type="text" name="school_name" value="<?php echo $get_profile_info->SchoolName; ?>" class="form-control form-control-line">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Name Initials :</label>
                                <div class="col-md-12">
                                    <input type="text" name="school_name_initials" value="<?php echo $get_profile_info->SchoolNameInitials; ?>" class="form-control form-control-line">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">MOTO :</label>
                                <div class="col-md-12">
                                    <input type="text" name="school_moto" value="<?php echo $get_profile_info->SchoolMoto; ?>" class="form-control form-control-line">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">MISSION STATEMENT :</label>
                                <div class="col-md-12">
                                    <input type="text" name="school_mission_statement" value="<?php echo $get_profile_info->SchoolMissionStatement; ?>" class="form-control form-control-line">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Email :</label>
                                <div class="col-md-12">
                                    <input type="email" name="school_email_address" value="<?php echo $get_profile_info->SchoolEmailAddress; ?>" class="form-control form-control-line">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Telephone 1 :</label>
                                <div class="col-md-12">
                                    <input type="tel" value="<?php echo $get_profile_info->SchoolTelephone1; ?>" class="form-control form-control-line" name="school_telephone1" id="school_telephone1">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Telephone 2 :</label>
                                <div class="col-md-12">
                                    <input type="tel" value="<?php echo $get_profile_info->SchoolTelephone2; ?>" class="form-control form-control-line" name="school_telephone2" id="school_telephone2">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Phone number 1 :</label>
                                <div class="col-md-12">
                                    <input type="tel" value="<?php echo $get_profile_info->SchoolPhoneNumber1; ?>" class="form-control form-control-line" name="school_phonenumber1" id="school_phonenumber1">
                                </div>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Phone number 2 :</label>
                                <div class="col-md-12">
                                    <input type="tel" value="<?php echo $get_profile_info->SchoolPhoneNumber2; ?>" class="form-control form-control-line" name="school_phonenumber2" id="school_phonenumber2">
                                </div>
                            </div>
                            <div class="px-3 pb-3" id="edit_school_info_response">
                                
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <input type="hidden" name="edit_school_info_note">
                                    <button class="btn btn-success" onclick="update_school_info()">Update School Profile</button>
                                </div>
                            </div>
                        </form>
                <?php 
                    }else{
                ?>
                        <div class="text-center mb-5">
                            <span>
                                <?php
                                    if(!empty($get_profile_info->SchoolLogo)){
                                        if(file_exists("../../images/school_logo/".$get_profile_info->SchoolLogo)){
                                ?>
                                    <img id="school_logo_img" class="mt-2" src="<?php echo "../images/school_logo/".$get_profile_info->SchoolLogo; ?>" alt="Logo" style="max-height: 150px;" /></span> </a>
                                <?php
                                        }
                                    }else{
                                        echo "<span class='fas fa-image fa-5x'></span>";
                                    }
                                ?>
                            </span>
                        </div>

                        <div class="form-horizontal form-material">
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Name </label>
                                <div class="col-md-12">
                                   <?php echo $get_profile_info->SchoolName; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Name Initials </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolNameInitials; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">MOTO </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolMoto; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-12 font-weight-bold">School Email </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolEmailAddress; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Telephone 1 </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolTelephone1; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Telephone 2 </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolTelephone2; ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Phone number 1 </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolPhoneNumber1; ?>
                                </div>
                            </div>
                            <div class="form-group mb-3">
                                <label for="example-email" class="col-md-12 font-weight-bold">School Phone number 2 </label>
                                <div class="col-md-12">
                                    <?php echo $get_profile_info->SchoolPhoneNumber2; ?>
                                </div>
                            </div>
                            
                        </div>
                <?php
                    }
                ?>
                        
                        
            </div>
        </div>
    </div>
    <!-- Column -->
</div>

<div id="uploadlogoimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
          <div class="modal-header d-flex justify-content-between">
            <h4 class="modal-title">Upload & Crop Image</h4>
            <button type="button" class="close btn btn-danger" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body">
            <div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo2" style="width:300px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <br />
              <br />
              <br/>
              <button class="btn btn-success text-light crop_logo_image">Crop & <br>Upload Image</button>
          </div>
        </div>
          </div>
      </div>
    </div>
</div>

<div id="uploadimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
          <div class="modal-header d-flex justify-content-between">
            <h4 class="modal-title">Upload & Crop Image</h4>
            <button type="button" class="close btn btn-danger" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body">
            <div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo" style="width:300px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <br />
              <br />
              <br/>
              <button class="btn btn-success text-light crop_image">Crop & <br>Upload Image</button>
          </div>
        </div>
          </div>
      </div>
    </div>
</div>

<script>  
$(document).ready(function(){
    $image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    $image_crop.croppie('result', {
      type: 'canvas',
      size: "viewport", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/profile/profile_handler.php",
        type: "POST",
        data:{"image": response},
        
            cache: false,
           
        success:function(data)
        { 
          $('#uploadimageModal').modal('hide');
          if(data==1){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-success'>Your profile picture updated</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)

            //.................
            d=new Date();

            if(document.getElementById("profile_picture")!==null){
              $("#profile_picture").attr("src","../images/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }else{
              $("#profilePhotoContainer").html("<img id='profile_picture' max-height='600px' class='mr-1 shadow rounded-circle thumbnail p-1 hand_cursor' data-toggle='collapse' data-target='#profile_pic_form_container'>")
              $("#profile_picture").attr("src","../images/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }

            if(document.getElementById("sub_profile_picture")!==null){
              $("#sub_profile_picture").attr("src","../images/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }else{
              $("#profilePhotoSubContainer").html("<img id='sub_profile_picture' class='rounded-circle' width='54px' data-toggle='collapse' data-target='#profile_pic_form_container'>")
              $("#sub_profile_picture").attr("src","../images/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }

          }else if(data==0){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-danger'>Failed to update your Profile</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)
          }
          //$('#uploaded_image').html(data);
        }
      });
    })
  });





  $image_crop2 = $('#image_demo2').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });


  //upload logo
  $('#logo_upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop2.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadlogoimageModal').modal('show');
  });

  $('.crop_logo_image').click(function(event){
    $image_crop2.croppie('result', {
      type: 'canvas',
      size: "viewport", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/profile/profile_handler.php",
        type: "POST",
        data:{"logo_image": response},
        
            cache: false,
           
        success:function(data)
        { 
           
          $('#uploadlogoimageModal').modal('hide');
          if(data==1){
            $("#changeLogoPhotoResponse").html("<p id='changeLogoPhotoResponseMin' class='alert alert-success'>Your logo is updated</p>");
            $("#changeLogoPhotoResponseMin").fadeOut(5000,"swing",null)

            //.................
            d=new Date();

            if(document.getElementById("logo_profile_picture")!==null){
              $("#logo_profile_picture").attr("src","../images/school_logo/"+"<?php echo $logo_profile_photo ?>"+"?timestamp"+d.getTime())
            }else{
              $("#logo_profilePhotoContainer").html("<img id='logo_profile_picture' max-height='600px' class='mx-auto shadow rounded-circle thumbnail p-1 hand_cursor my-0' data-toggle='collapse' data-target='#logo_profile_pic_form_container'>")
              $("#logo_profile_picture").attr("src","../images/school_logo/"+"<?php echo $logo_profile_photo ?>"+"?timestamp"+d.getTime())
            }

          }else if(data==0){
            $("#changeLogoPhotoResponse").html("<p id='changeLogoPhotoResponseMin' class='alert alert-danger'>Failed to update your logo</p>");
            $("#changeLogoPhotoResponseMin").fadeOut(5000,"swing",null)
          }
          //$('#uploaded_image').html(data);
        }
      });
    })
  });

});  
</script>