<?php
    require_once("../../session_check.php");
    require_once("../../../classes/main_classes.php");

    if($sign_in_status=="out"){
       die("<p class='alert alert-warning'>Access denied, this maybe because the login session has expired. Please try refleshing the page.<p>");
    }

    //OBJECTS
    $retrieveObj=new RETRIEVE();

    //get user information
    $get_users=$retrieveObj->retriever("Staff JOIN Users ON Users.UserId=Staff.UserId WHERE SchoolID='".$_SESSION["user_details"]["SchoolID"]."' and Staff.Position='Teacher'","*","fetchAll");

    //get modules
    $get_subjects=$retrieveObj->retriever("Subjects","*","fetchAll");

?>
<!-- ============================================================== -->
<!-- Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<div class="row page-titles">
    <div class="col-md-12 col-12 align-self-center">
        <h3 class="text-themecolor">Manage Teachers</h3>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Manage Teachers</a></li>
            <li class="breadcrumb-item"><a href="#!" onclick="teacher_subject_allocation()">Teachers Subject Allocation</a></li>
            <li class="breadcrumb-item active">Subject Allocation Form</li>
        </ol>
    </div>
    <div class="col-md-7 col-4 align-self-center">
        <!--a href="https://themewagon.com/themes/bootstrap-4-responsive-admin-template/" class="btn waves-effect waves-light btn-danger pull-right hidden-sm-down"></a-->
    </div>
</div>
<!-- ============================================================== -->
<!-- End Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<!-- Row -->
<div class="row">
    <!-- Column -->
    <div class="col-sm-12 col-lg-12">
        <div class="card">
            <div class="card-header text-center lead bg-light mb-3 ">
                Teacher Subject Allocation Form
            </div>
            <div class="card-body">
                <form class="form-horizontal form-material" id="allocate_subject_to_teacher_form">
                     <div class="form-group">
                        <label for="user" class="col-md-12 font-weight-bold">Teacher</label>
                        <div class="col-md-12" style="position: absolute !important;z-index: 999999 !important;">
                            <select name="allocate_subject_to_teacher_note" id="user-select-state" placeholder="Search user" >
                                <option value="">Select a teacher...</option>
                                <?php
                                    if($get_users!="1020"){
                                        foreach ($get_users as $key => $user) {
                                ?>
                                    <option value="<?php echo $user->StaffID ?>"><?php echo $user->Firstname." ".$user->Lastname; ?></option>
                                <?php
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group mt-5">
                        <label for="subject" class="col-md-12 font-weight-bold">Subject</label>
                        <div class="col-md-12" style="position: absolute !important;z-index: 9999 !important;">
                            <select class="form-control" name="subject" id="subject-select-state">
                                <option selected="selected" disabled="disabled">Select Subject</option>
                                <?php
                                    if($get_subjects!="1020"){
                                        foreach ($get_subjects as $subject) {
                                ?>
                                        <option value="<?php echo $subject->SubjectId; ?>"><?php echo $subject->SubjectName; ?></option>
                                <?php
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group mt-5">
                        <label for="form" class="col-md-12 font-weight-bold">Select Form</label>
                        <div class="col-md-12" >
                            <select class="form-control" id="form" name="form">
                                <option selected disabled>Form</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5">5</option>
                                <option value="6">6</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="form" class="col-md-12 font-weight-bold">Select Term</label>
                        <div class="col-md-12" >
                            <select class="form-control" id="term" name="term">
                                <option selected disabled>Term</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="form" class="col-md-12 font-weight-bold">Academic Year</label>
                        <div class="col-md-12" >
                            <input class="form-control form-control-line" type="text" name="academic_year" id="academic_year" placeholder="e.g 2021">
                        </div>
                    </div>
                    <div id="allocate_subject_to_teacher_response" class="px-3 mb-3"></div>
                    <div class="form-group mt-5">
                        <div class="col-sm-12 text-right">
                            
                            <button class="btn btn-primary" type="submit" onclick="allocate_subject_to_teacher()"><span class="fa fa-plus"></span> Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>     

<script type="text/javascript">
  $(document).ready(function () {
      $('#user-select-state').selectize({
          sortField: 'text'
      });
      $('#subject-select-state').selectize({
          sortField: 'text'
      });
  });
</script>
