<?php 
	use Shuchkin\SimpleXLSX;
	require_once("../../classes/main_classes.php");
    require_once("../../classes/main_functions.php");
	require_once("../session_check.php");

	if($sign_in_status=="out" or $user_id==null){
        die("<p class='alert alert-warning'>Security error, this may be bacause your login session has expired</p>");
    }

    //OBJECTS
	$retrieveObj=new RETRIEVE();
	$insertObj=new INSERT();
	$rowcountObj=new ROWCOUNT();
	$updateObj=new UPDATE();
	$deleteObj=new DELETE();
	$sendemailObj=new SEND_EMAIL();
	$rootdirget=new ROOTDIRGET();
	$allrowcountObj=new ALLROWCOUNT();
	//$imagehandleObj=new IMAGEHANDLE();
	$logObj=new LOG();

	$mailer_r_path="../../";

	//get root dir
	$root_dir=$rootdirget->root_dir_getter();

	if(isset($_POST["user_logout_note"])){
		try{
			unset($_SESSION['swb_admin_in_email']);
			unset($_SESSION['swb_admin_in_id']);
			unset($_SESSION['swb_admin_in_type']);
			session_destroy();
			echo 1;
		}catch(Exception $e){
			echo 0;
		}
	}

	//UPDATE PRIVACY POLICY
	if(isset($_POST['privacy_policy_update_note'])){
	    if(empty($_POST['privacy_policy'])){
	        die("<p class='alert alert-warning'>Enter Privacy policy</p>");
	    }

	    $privacy_policy=addslashes($_POST['privacy_policy']);

	    //check if there us a privacy policy
	    $check_privacy_policy=$rowcountObj->rowcounter("privacy_policy","*","privacy_policy_id_name","customer");
	    if($check_privacy_policy>=1){
	        //update
	        $update=$updateObj->updater("privacy_policy","privacy_policy='$privacy_policy'","privacy_policy_id_name","customer");

	        if($update==1){
	            echo 1;
	        }else{
	            echo 0;
	        }
	    }else{
	        //insert
	        $fields=array("privacy_policy","privacy_policy_id_name");
	        $data=array($privacy_policy,"customer");

	        $insert=$insertObj->inserter("privacy_policy",$fields,$data);

	        if($insert==1){
	            echo 1;
	        }else{
	            echo 0;
	        }
	    }    
	}

	//UPDATE TERMS AND CONDITIONS
	if(isset($_POST['terms_and_conditions_update_note'])){
	    if(empty($_POST['terms_and_conditions'])){
	        die("<p class='alert alert-warning'>Enter Terms and conditions</p>");
	    }else if(empty($_POST['terms_type'])){
	        die("<p class='alert alert-warning'>Something went wrong, please try again later.</p>");
	    }

	    $terms_and_conditions=addslashes($_POST['terms_and_conditions']);
	    $terms_type=addslashes($_POST['terms_type']);

	    //check if there are terms and conditions
	    $check_terms_and_conditions=$rowcountObj->rowcounter("terms_and_conditions","*","terms_and_conditions_id_name",$terms_type);
	    if($check_terms_and_conditions>=1){
	        //update
	        $update=$updateObj->updater("terms_and_conditions","terms_and_conditions='$terms_and_conditions'","terms_and_conditions_id_name",$terms_type);

	        if($update==1){
	            echo 1;
	        }else{
	            echo 0;
	        }
	    }else{
	        //insert
	        $fields=array("terms_and_conditions","terms_and_conditions_id_name");
	        $data=array($terms_and_conditions,$terms_type);

	        $insert=$insertObj->inserter("terms_and_conditions",$fields,$data);

	        if($insert==1){
	            echo 1;
	        }else{
	            echo 0;
	        }
	    }    
	}

	if(isset($_POST["change_password_note"])){
		//Update password
		if(isset($_POST['Cpassword'])){
			$Cpassword=$_POST["Cpassword"];
			$Npassword=$_POST["Npassword"];
			$Rpassword=$_POST["Rpassword"];

			$hashPassword=$retrieveObj->retriever("users","password","UserId",$user_id,"fetch");
			$hashPassword=$hashPassword->password;

			
			if(empty($Cpassword) or empty($Npassword) or empty($Rpassword)){
				echo "<p class='alert alert-warning text-center p-2'> Fill all the fields to continue</p>";
			}else{
				$Cpassword=$_POST["Cpassword"];
				
				
				if(password_verify($Cpassword,$hashPassword)){
					if(password_verify($Npassword,$hashPassword)){
						die("<p class='alert alert-warning p-2'>Password not changed, New and Current password are equal</p>");
					}

					//
					if($Npassword==$Rpassword){
						$Npassword=password_hash($_POST["Npassword"],PASSWORD_DEFAULT);
						$changePass=$updateObj->updater("users","password='$Npassword'","user_id",$user_id);
						if($changePass==1){
							echo "<p class='alert alert-success text-center p-2'> password changed successfully!</p>";
						}else{
							echo "<p class='alert alert-danger text-center p-2'> Failed to change password, try again later</p>";
						}
						
					}else{
						echo "<p class='alert alert-warning text-center p-2'> passwords do not match!</p>";
					}

				}else{
					echo "<p class='alert alert-danger text-center p-2'> Your current password is wrong!</p>";

				}
			}
		}	
	}

	//EDIT PROFILE
	if(isset($_POST["edit_profile_note"])){
		if(empty($_POST["firstname"]) or empty($_POST["lastname"]) or empty($_POST["email"])){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$phone=addslashes($_POST["phone"]);
		$email=addslashes($_POST["email"]);

		$data="Firstname='$firstname',Lastname='$lastname',PhoneNumber='$phone',EmailAddress='$email'";

		$update=$updateObj->updater("users",$data,"UserId",$user_id);
		

		if($update=="1"){
			$_SESSION["ulendowathu_admin_in_email"]=$email;
			echo 1;
		}else if("entry_exists"){
			die("<p class='alert alert-warning'>The email or phone number you enter is in use by another count</p>");
		}else{
			echo 0;
		}

	}

	//ADD DESIGN
	if(isset($_POST["add_testimonial_note"]))
	{

		if(empty($_POST["t_fullname"])){
			die("<p class='alert alert-warning'>Enter fullname.</p>");
		}else if(empty($_POST["t_message"])){
			die("<p class='alert alert-warning'>Enter message.</p>");
		}else if(!isset($_POST["testimonial_image"]) or empty($_POST["testimonial_image"])){
			die("<p class='alert alert-warning'>Select photo.</p>");
		}

		$testimonial_image = $_POST["testimonial_image"];
		$t_fullname = addslashes($_POST["t_fullname"]);
		$t_position = addslashes($_POST["t_position"]);
		$t_institution = addslashes($_POST["t_institution"]);
		$t_url = addslashes($_POST["t_url"]);
		$t_message = addslashes($_POST["t_message"]);
		
		$image_array_1 = explode(";", $testimonial_image);

		$image_array_2 = explode(",", $image_array_1[1]);

		$testimonial_image = base64_decode($image_array_2[1]);

		$imageNameDir="../../img/testimonials/";
		$imageName = "testimonial".str_replace("-", "_",date("Y-m-d")."".time()).'.png';

		//check if directory exist
		if (!file_exists("../../img/testimonials/")) {
		    mkdir("../../img/testimonials/", 0777,true);
		    chmod("../../img/testimonials/", 0777);
		} 

		if(!file_put_contents($imageNameDir.$imageName, $testimonial_image)){
			die(0);
		}

		$fields=array(
			"UserId",
			"t_fullname",
			"t_position",
			"t_institution",
			"t_url",
			"t_message",
			"t_photo"
		);
		$data=array(
			$user_id,
			$t_fullname,
			$t_position,
			$t_institution,
			$t_url,
			$t_message,
			$imageName
		);

		$insert=$insertObj->inserter("testimonial",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	//EDIT DESIGN
	if(isset($_POST["edit_testimonial_note"]))
	{
		if(empty($_POST["t_fullname"])){
			die("<p class='alert alert-warning'>Enter fullname.</p>");
		}else if(empty($_POST["t_message"])){
			die("<p class='alert alert-warning'>Enter message.</p>");
		}

		$testimonial_id = $_POST["edit_testimonial_note"];
		$t_fullname = addslashes($_POST["t_fullname"]);
		$t_position = addslashes($_POST["t_position"]);
		$t_institution = addslashes($_POST["t_institution"]);
		$t_url = addslashes($_POST["t_url"]);
		$t_message = addslashes($_POST["t_message"]);

		$data="t_fullname='$t_fullname',t_position='$t_position',t_institution='$t_institution',t_url='$t_url',t_message='$t_message'";

		$update=$updateObj->updater("testimonial",$data,"testimonial_id",$testimonial_id);

		if($update=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	//UPDATE PRIMARY DESIGN IMAGE
	if(isset($_POST["update_primary_testimonial_image"]))
	{
		$data = $_POST["update_primary_testimonial_image"];
		$testimonial_id = addslashes($_POST["testimonial_id"]);

		$get_testimonial_info=$retrieveObj->retriever("testimonial","*","testimonial_id",$testimonial_id,"fetch");

		if($get_testimonial_info=="1020"){
			die("<p class='alert alert-warning'>Something went wrong, try again later.</p>");
		}

		$image_array_1 = explode(";", $data);

		$image_array_2 = explode(",", $image_array_1[1]);

		$data = base64_decode($image_array_2[1]);

		$imageNameDir="../../img/testimonials/";
		$imageName = $get_testimonial_info->t_photo;

		//check if directory exist
		if (!file_exists("../../img/testimonials/")) {
		    mkdir("../../img/testimonials/", 0777,true);
		    chmod("../../img/testimonials/", 0777);
		} 

		if(file_put_contents($imageNameDir.$imageName, $data)){
			echo 1;
		}else{
			die("<p class='alert alert-warning'>Something went wrong, try again later.</p>");
		}
		
	}

	//DELETE TESTIMONIAL
	if(isset($_POST["delete_testimonial_note"])){
		$testimonial_id=addslashes($_POST["delete_testimonial_note"]);

		$get_testimonial=$retrieveObj->retriever("testimonial","*","testimonial_id",$testimonial_id,"fetch");

		if($get_testimonial!="1020"){
			if(file_exists("../../img/testimonials/".$get_testimonial->t_photo)){
				unlink("../../img/testimonials/".$get_testimonial->t_photo);
			}

			//delete testimonial from database
			$delete=$deleteObj->deleter("testimonial","testimonial_id",$testimonial_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else{
			echo 0;
		}
	}

	if(isset($_POST["contact_message_reply_note"])){
		if(empty($_POST["subject"])){
			die("<p class='alert alert-warning'>Enter subject.</p>");
		}else if(empty($_POST["message"])){
			die("<p class='alert alert-warning'>Enter message.</p>");
		}
		$contact_message_id=addslashes($_POST["contact_message_reply_note"]);
		$subject=addslashes($_POST["subject"]);
		$message=addslashes($_POST["message"]);
		$email_to=addslashes($_POST["email"]);

		$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject,$message,$email_to);

		if($send_email=="1"){
			$fields=array("contact_message_id","UserId","contact_messages_reply_subject","contact_messages_reply_message");
			$data=array($contact_message_id,$user_id,$subject,$message);

			$insert=$insertObj->inserter("contact_messages_reply",$fields,$data);
			if($insert=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else{
			echo 0;
		}
	}

	if(isset($_POST["delete_message_reply_note"])){
		$contact_messages_reply_id=addslashes($_POST["delete_message_reply_note"]);

		//delete property from database
		$delete=$deleteObj->deleter("contact_messages_reply","contact_messages_reply_id",$contact_messages_reply_id);
		if($delete=="1"){
			echo 1;
		}else if($delete=="delete_restricted"){
			echo "<p class='alert alert-warning'>You cannot delete this reply, the reply is associated with some important data</p>";
		}else{
			echo 0;
		}
		
	}

	//DELETE CONTACT MESSAGE
	if(isset($_POST["delete_contact_message_note"])){
		$d_cm_id=addslashes($_POST["delete_contact_message_note"]);
	
		//delete contact message from database
		$delete=$deleteObj->deleter("contact_messages","contact_message_id",$d_cm_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	//DELETE REGISTER REQUEST
	if(isset($_POST["delete_register_request_note"])){
		$d_rq_id=addslashes($_POST["delete_register_request_note"]);

		$get_register_request=$retrieveObj->retriever("SchoolRegisterRequests","*","SchoolRegisterRequestId",$d_rq_id,"fetch");

		if($get_register_request=="1020"){
			echo 0;
			die();
		}

		//delete register request from database
		$delete=$deleteObj->deleter("SchoolRegisterRequests","SchoolRegisterRequestId",$d_rq_id);
		if($delete=="1"){
			$deleteObj->deleter("Users","UserId",$get_register_request->UserId);
			$deleteObj->deleter("Schools","UserId",$get_register_request->UserId);
			echo 1;
		}else{
			echo 0;
		}
	}

	//ACCEPT SCHOOL REGISTRATION REQUEST NOTE
	if(isset($_POST["accept_school_register_request_note"])){
		$SchoolRegisterRequestId=addslashes($_POST['accept_school_register_request_note']);

		$get_register_request=$retrieveObj->retriever("SchoolRegisterRequests
			JOIN Users ON Users.UserId=SchoolRegisterRequests.UserId
			JOIN Schools ON Schools.SchoolID=SchoolRegisterRequests.SchoolID
			","*","SchoolRegisterRequestId",$SchoolRegisterRequestId,"fetch");

		if($get_register_request=="1020"){
			echo 0;
			die();
		}

		//ACCEPT
		$update=$updateObj->updater("SchoolRegisterRequests","Status='ACCEPTED'","SchoolRegisterRequestId",$SchoolRegisterRequestId);
		if($update=="1"){
			//SEND EMAILS
			if(!empty($get_register_request->EmailAddress)){ //send email
				$subject_="School Registration Request Accepted";
				$body_="
					<p>Hello ".$get_register_request->Firstname." ".$get_register_request->Lastname.",</p>
					<p>Your request to register a school, ".$get_register_request->SchoolName." on SchoolWeb has been accepted.
					</p>
					<p>You can now <a href='".$root_dir."/login.php'>Login</a> to your panel to manage your school.</p>
				
					<p>Regards,</p>
					<p>SchoolWeb Team</p>
				";
				$email_to=$get_register_request->EmailAddress;
				$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);	
			}


			//SEND EMAILS TO ADMINS
			//get all admins
			$get_admins=$retrieveObj->retriever("Users 
				JOIN UserTypes ON UserTypes.UserId=Users.UserId
				JOIN UserType ON UserTypes.UserTypeId=UserType.UserTypeId WHERE (UserType.UserType='su_admin' or UserType.UserType='admin')","*","fetchAll");

			//Logged in admin info
			$get_my_info=$retrieveObj->retriever("Users","*","UserId",$user_id,"fetch");

			

			if($get_admins!="1020"){
				foreach ($get_admins as $key => $admin_) {
					$verifier_name="";
					if($admin_->UserId==$get_my_info->UserId){
						$verifier_name="You have ";
					}else{
						$verifier_name=$get_my_info->firstname." ".$get_my_info->lastname." has ";
					}
					$subject2_="School Registration Request Accepted";
					$body2_="
						<p>Dear ".$admin_->Firstname." ".$admin_->Lastname.",</p>
						<p> $verifier_name accepted a request from ".$get_register_request->Firstname." ".$get_register_request->Lastname." to register a school, ".$get_register_request->SchoolName.", on SchoolWeb.<br>
						</p>
						<p><a href='".$root_dir."/login.php'>Login</a> to your panel for details</p>
					
						<p>Regards,</p>
						<p>SchoolWeb System</p>
					";
					$email_to2=$admin_->EmailAddress;
					$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject2_,$body2_,$email_to2);	
				}	
			}

			echo 1;
		}else{
			echo 0;
		}
	}

	//DECLINE SCHOOL REGISTRATION REQUEST NOTE
	if(isset($_POST["decline_school_register_request_note"])){
		if(empty($_POST['decline_reason'])){
			die("<p class='alert alert-warning'>Provide a reason for declining.</p>");
		}
		$SchoolRegisterRequestId=addslashes($_POST['decline_school_register_request_note']);
		$decline_reason=addslashes($_POST['decline_reason']);

		$get_register_request=$retrieveObj->retriever("SchoolRegisterRequests
			JOIN Users ON Users.UserId=SchoolRegisterRequests.UserId
			JOIN Schools ON Schools.SchoolID=SchoolRegisterRequests.SchoolID
			","*","SchoolRegisterRequestId",$SchoolRegisterRequestId,"fetch");

		if($get_register_request=="1020"){
			echo 0;
			die();
		}

		//ACCEPT
		$update=$updateObj->updater("SchoolRegisterRequests","Status='DECLINED',DeclineReason='$decline_reason'","SchoolRegisterRequestId",$SchoolRegisterRequestId);
		if($update=="1"){
			//SEND EMAILS
			if(!empty($get_register_request->EmailAddress)){ //send email
				$subject_="School Registration Declined";
				$body_="
					<p>Hello ".$get_register_request->Firstname." ".$get_register_request->Lastname.",</p>
					<p>Your request to register a school, ".$get_register_request->SchoolName." on SchoolWeb has been declined.
					</p>
					<p>You can now <a href='".$root_dir."/login.php'>Login</a> to your panel to manage your school.</p>
				
					<p>Regards,</p>
					<p>SchoolWeb Team</p>
				";
				$email_to=$get_register_request->EmailAddress;
				$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$email_to);	
			}


			//SEND EMAILS TO ADMINS
			//get all admins
			$get_admins=$retrieveObj->retriever("Users 
				JOIN UserTypes ON UserTypes.UserId=Users.UserId
				JOIN UserType ON UserTypes.UserTypeId=UserType.UserTypeId WHERE (UserType.UserType='su_admin' or UserType.UserType='admin')","*","fetchAll");

			//Logged in admin info
			$get_my_info=$retrieveObj->retriever("Users","*","UserId",$user_id,"fetch");

			

			if($get_admins!="1020"){
				foreach ($get_admins as $key => $admin_) {
					$verifier_name="";
					if($admin_->UserId==$get_my_info->UserId){
						$verifier_name="You have ";
					}else{
						$verifier_name=$get_my_info->firstname." ".$get_my_info->lastname." has ";
					}
					$subject2_="School Registration Request Declined";
					$body2_="
						<p>Dear ".$admin_->Firstname." ".$admin_->Lastname.",</p>
						<p> $verifier_name declined a request from ".$get_register_request->Firstname." ".$get_register_request->Lastname." to register a school, ".$get_register_request->SchoolName.", on SchoolWeb.<br>
						</p>
						<p><a href='".$root_dir."/login.php'>Login</a> to your panel for details</p>
					
						<p>Regards,</p>
						<p>SchoolWeb System</p>
					";
					$email_to2=$admin_->EmailAddress;
					$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject2_,$body2_,$email_to2);	
				}	
			}

			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["add_user_note"])){
		if(empty($_POST["firstname"])){
			die("<p class='alert alert-warning'>Enter firstname</p>");
		}else if(empty($_POST["lastname"])){
			die("<p class='alert alert-warning'>Enter lastname</p>");
		}else if(empty($_POST["username"])){
			die("<p class='alert alert-warning'>Enter username</p>");
		}else if(empty($_POST["email"])){
			die("<p class='alert alert-warning'>Enter email</p>");
		}else if(empty($_POST["phone"])){
			die("<p class='alert alert-warning'>Enter phone number</p>");
		}else if(empty($_POST["user_type"])){
			die("<p class='alert alert-warning'>Select user type</p>");
		}if(empty($_POST["password"])){
			die("<p class='alert alert-warning'>Enter Password</p>");
		}else if(empty($_POST["rpassword"])){
			die("<p class='alert alert-warning'>Re-enter password</p>");
		}else if($_POST["password"]!=$_POST["rpassword"]){
			die("<p class='alert alert-warning'>Passwords do not match</p>");
		}else if(strlen($_POST["password"])<8){
			die("<p class='alert alert-warning'>Your password is too short, make sure it is at least 8 characters long</p>");
		}

		$email="";

		$get_user_type=$retrieveObj->retriever("UserType","*","UserTypeId",$_POST["user_type"],"fetch");
		if($get_user_type=="1020"){
			echo 0;
			die();
		}
		
		//GET VALUES
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$username=addslashes($_POST["username"]);
		$phone=addslashes($_POST["phone"]);
		$email=addslashes($_POST["email"]);
		$user_type=addslashes($_POST["user_type"]);

		$password=addslashes($_POST["password"]);

		$chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*_";
		$password = "{jlungo-hash}" . base64_encode(pack("H*", sha1($password)));

		$fields=array("Firstname","Lastname","Username","EmailAddress","PhoneNumber","Password");
		$data=array($firstname,$lastname,$username,$email,$phone,$password);
			

		$create_account=$insertObj->inserter("Users",$fields,$data);
		if($create_account=="1"){
			//set role
			
			$get_user_id=$retrieveObj->retriever("Users","*","EmailAddress",$email,"fetch");
			if($get_user_id!="1020"){
				//insert type
				$fields2=array("UserId","UserTypeId");
				$data2=array($get_user_id->UserId,$user_type);

				$create_account2=$insertObj->inserter("UserTypes",$fields2,$data2);
				if($create_account2=="1"){
					echo 1;
				}else{
					//failed
					$deleteObj->deleter("Users","EmailAddress",$email);
					echo 0;
				}
			}else{
				//failed
				$deleteObj->deleter("users","phone",$phone);
				echo 0;
			}
		}else if($create_account=="entry_exists"){
			echo "<p class='alert alert-warning'>Another user is using the email address or phone number you entered</p>";
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_user_note"])){
		$another_user_id=addslashes($_POST["edit_user_note"]);

		//VALIDATION
		if(empty($_POST["firstname"])){
			die("<p class='alert alert-warning'>Enter firstname</p>");
		}else if(empty($_POST["lastname"])){
			die("<p class='alert alert-warning'>Enter lastname</p>");
		}else if(empty($_POST["username"])){
			die("<p class='alert alert-warning'>Enter username</p>");
		}else if(empty($_POST["email"])){
			die("<p class='alert alert-warning'>Enter email</p>");
		}else if(empty($_POST["phone"])){
			die("<p class='alert alert-warning'>Enter number</p>");
		}else if(empty($_POST["user_type"])){
			die("<p class='alert alert-warning'>Select user type</p>");
		}

		$email="";

		//GET VALUES
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$Username=addslashes($_POST["username"]);
		$phone=addslashes($_POST["phone"]);
		$email=addslashes($_POST["email"]);
		$user_type=addslashes($_POST["user_type"]);

		
		$data="Firstname='$firstname',Lastname='$lastname',Username='$Username',EmailAddress='$email',PhoneNumber='$phone'";

		$update=$updateObj->updater("Users",$data,"UserId",$another_user_id);

		if($update=="1"){
			$data2="UserTypeId='$user_type'";

			$update2=$updateObj->updater("UserTypes",$data2,"UserId",$another_user_id);

			if($update=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else if ($update=="0"){
			echo 0;
		}else if($update=="entry_exists"){
			die("<p class='alert alert-warning'>The email you entered is being used by another user</p>");
		}else{
			die("<p class='alert alert-warning'>Something went wrong, please try again later</p>");
		}
	}

	if(isset($_POST["delete_user_note"])){
		$d_user_id=addslashes($_POST["delete_user_note"]);

		$delete=$updateObj->updater("Users","UserStatus='Inactive'","UserId",$d_user_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	//DEACTIVATE USER
	if(isset($_POST["deactivate_user_note"])){
		$d_user_id=addslashes($_POST["deactivate_user_note"]);

		//delete property from database
		$delete=$updateObj->updater("Users","UserStatus='InActive'","UserId",$d_user_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["activate_user_note"])){
		$d_user_id=addslashes($_POST["activate_user_note"]);

		//delete property from database
		$activate=$updateObj->updater("Users","UserStatus='Active'","UserId",$d_user_id);
		if($activate=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["permanently_delete_user_note"])){
		$d_user_id=addslashes($_POST["permanently_delete_user_note"]);

		//delete property from database
		$delete=$deleteObj->deleter("Users","UserId",$d_user_id);
		if($delete=="1"){
			echo 1;
		}else if($delete=="delete_restricted"){
			echo "<p class='alert alert-warning'>You cannot delete this user, the user is associated with some important data</p>";
		}else{
			echo 0;
		}
		
	}

	//DEACTIVATE SCHOOOL
	if(isset($_POST["deactivate_school_note"])){
		$d_school_id=addslashes($_POST["deactivate_school_note"]);

		//delete property from database
		$delete=$updateObj->updater("Schools","SchoolStatus='InActive'","SchoolId",$d_school_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["activate_school_note"])){
		$d_school_id=addslashes($_POST["activate_school_note"]);

		//delete property from database
		$activate=$updateObj->updater("Schools","SchoolStatus='Active'","SchoolId",$d_school_id);
		if($activate=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["permanently_delete_school_note"])){
		$d_school_id=addslashes($_POST["permanently_delete_school_note"]);

		//delete property from database
		$delete=$deleteObj->deleter("Schools","SchoolId",$d_school_id);
		if($delete=="1"){
			echo 1;
		}else if($delete=="delete_restricted"){
			echo "<p class='alert alert-warning'>You cannot delete this school, the school is associated with some important data</p>";
		}else{
			echo 0;
		}
	}

	//ADD STUDENT
   if(isset($_POST["add_school_student_note"])){
      $add_students_result=0;
      $school_id=addslashes($_POST["add_school_student_note"]);
      if(isset($_FILES["add_students_excel"])){
        $students_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["add_students_excel"]["tmp_name"]) ) {
          $students_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($students_array)<3){
          die("<p class='alert alert-warning'>Please add at least one student in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        $row = 1;
        //VALIDATE EXCEL
          $add_students_loopcount=0;
          foreach ($students_array as $data) {
              $add_students_loopcount+=1;
              if($add_students_loopcount==1){
                //validate info line
                if(empty($data[0]) or trim($data[0]) !="STUDENT ADDITION TEMPLATE (Please do not delete any row or swap any rows)"){
                  die("<p class='alert alert-warning'>Please use a valid excel template downloaded here.<p>");
                }
                continue;
              }else if($add_students_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="Username" or
                  trim($data[1])!="Firstname" or
                  trim($data[2])!="Lastname" or
                  trim($data[3])!="Middlenames" or
                  trim($data[4])!="Gender(M/F)" or
                  trim($data[5])!="Date of Birth (yyyy-mm-dd)" or
                  trim($data[6])!="Village" or
                  trim($data[7])!="TA" or
                  trim($data[8])!="District" or
                  trim($data[9])!="Enrollment Year(e.g 2010)" or
                  trim($data[10])!="Form of Entry" or
                  trim($data[11])!="Term of Entry" or
                  trim($data[12])!="Current Form" or
                  trim($data[13])!="Student Type" 
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter username for student on line $add_students_loopcount.<p>");
              }else if(empty($data[1])){
                die("<p class='alert alert-warning'>Enter firstname for student on line $add_students_loopcount.<p>");
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter lastname for student on line $add_students_loopcount.<p>");
              }else if(empty($data[3])){
                //pass on middlename
              }else if(empty($data[4])){
                die("<p class='alert alert-warning'>Enter gender for student on line $add_students_loopcount.<p>");
              }else if($data[4]!="M" and $data[4]!="F"){
                die("<p class='alert alert-warning'>Enter a valid gender(M/F) for student on line $add_students_loopcount.<p>");
              }else if(empty($data[5])){
                die("<p class='alert alert-warning'>Enter date of birth for student on line $add_students_loopcount.<p>");
              }else if(empty($data[6])){
                //pass on village
              }else if(empty($data[7])){
                //pass on TA
              }else if(empty($data[8])){
                //pass on District
              }else if(empty($data[9])){
                die("<p class='alert alert-warning'>Enter enrollment year for student on line $add_students_loopcount.<p>");
              }else if(empty($data[10])){
                die("<p class='alert alert-warning'>Enter form of entry for student on line $add_students_loopcount.<p>");
              }else if(empty($data[11])){
                //pass form term of entry
              }else if(empty($data[12])){
                die("<p class='alert alert-warning'>Enter current form for student on line $add_students_loopcount.<p>");
              }else if(empty($data[13])){
                die("<p class='alert alert-warning'>Enter student type form for student on line $add_students_loopcount.<p>");
              }

              //validate username
              if(!empty($data[0])){
                $check_username=$rowcountObj->rowcounter("Users","*","Username",$data[0]);
                if($check_username>0){
                  die("<p class='alert alert-warning'>Username \"".$data[0]."\" for the student at line on line $add_students_loopcount, is already in use by another user.<p>");
                }
              }

              //validate dob
              if(!empty($data[5])){
                $test_date = $data[5];
                $test_date = new DateTime($test_date);
                $test_date=$test_date->format('Y-m-d');
                $test_arr  = explode('-', $test_date);
                if (checkdate($test_arr[1], $test_arr[0], $test_arr[2])) {
                    die("<p class='alert alert-warning'>Enter a valid date on line $add_students_loopcount.<p>");
                }
              }

              

              //validate enrollment year
              if(!empty($data[9])){
                if($data[9]>date("Y")){
                  die("<p class='alert alert-warning'>Enter a valid enrollment year on line $add_students_loopcount.<p>");
                }
              }

              //validate term of entry
              if(!empty($data[10])){
                if($data[10]<1 or $data[10]>6){
                  die("<p class='alert alert-warning'>Enter a valid form of entry for student on line $add_students_loopcount.<p>");
                }
              }

              //validate enrollment year
              if(!empty($data[11])){
                if($data[11]<1 or $data[11]>3){
                  die("<p class='alert alert-warning'>Enter a valid term of entry for student on line $add_students_loopcount.<p>");
                }
              }

              //validate current form
              if(!empty($data[12])){
                if($data[12]<1 or $data[12]>6){
                  die("<p class='alert alert-warning'>Enter a valid current form for student on line $add_students_loopcount.<p>");
                }
              }

              //validate student type
              if(!empty($data[13])){
                if($data[13]!="Day" and $data[13]!="Night"){
                  die("<p class='alert alert-warning'>Enter a valid student type for student on line $add_students_loopcount.<p>");
                }
              }
          }
        /*VALIDATE EXCEL*/

        //ADD STUDENTS
        $add_students_loopcount=0;
        foreach ($students_array as $data) {
            $add_students_loopcount+=1;
            if($add_students_loopcount<=2){
              continue;
            }
            
            $username=addslashes($data[0]);
            $firstname=addslashes($data[1]);
            $lastname=addslashes($data[2]);
            $middlenames=addslashes($data[3]);
            $gender=addslashes($data[4]);
            $date_of_birth=addslashes($data[5]);

            $village = addslashes($data[6]);
            $TA = addslashes($data[7]);
            $district = addslashes($data[8]);
            $enrollment_year = addslashes($data[9]);
            $form_of_entry = addslashes($data[10]);
            $term_of_entry = addslashes($data[11]);
            $current_form = addslashes($data[12]);
            $student_type = addslashes($data[13]);

            $fields=array("Username","Firstname","Lastname","Middlenames","Gender","DateOfBirth","Village","TraditionalAuthority","District");
            $data=array($username,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$village,$TA,$district);

            $fields2=array("EnrollmentYear","TermOfEntry","FormOfEntry","StudentType","CurrentForm");
            $data2=array($enrollment_year,$term_of_entry,$form_of_entry,$student_type,$current_form);

            $add_students_result=add_student_helper($fields,$data,$fields2,$data2,$school_id);
          
        }
        //ADD STUDENTS

      }else{
          if(empty($_POST["username"])){
             die("<p class='alert alert-warning'>Enter username.<p>");
          }else if(empty($_POST["firstname"])){
             die("<p class='alert alert-warning'>Enter firstname.<p>");
          }else if(empty($_POST["lastname"])){
             die("<p class='alert alert-warning'>Enter lastname.<p>");
          }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
             die("<p class='alert alert-warning'>Select gender.<p>");
          }else if(empty($_POST["date_of_birth"])){
             die("<p class='alert alert-warning'>Enter date of birth.<p>");
          }else if(empty($_POST["enrollment_year"])){
             die("<p class='alert alert-warning'>Enter enrollment year.<p>");
          }else if(empty($_POST["current_form"])){
             die("<p class='alert alert-warning'>Enter current form.<p>");
          }else if(empty($_POST["student_type"])){
             die("<p class='alert alert-warning'>Enter student type.<p>");
          }

          $username=addslashes($_POST["username"]);
          $firstname=addslashes($_POST["firstname"]);
          $lastname=addslashes($_POST["lastname"]);
          $StudentIdNumber=addslashes($_POST["StudentIdNumber"]);
          $middlenames=addslashes($_POST["middlenames"]);
          $gender=addslashes($_POST["gender"]);
          $date_of_birth=addslashes($_POST["date_of_birth"]);
          $enrollment_year = addslashes($_POST["enrollment_year"]);
          $current_form = addslashes($_POST["current_form"]);
          $form_of_entry = addslashes($_POST["form_of_entry"]);
          $student_type = addslashes($_POST["student_type"]);

          $fields=array("Username","Firstname","Lastname","Middlenames","Gender","DateOfBirth");
          $data=array($username,$firstname,$lastname,$middlenames,$gender,$date_of_birth);

          $fields2=array("StudentIdNumber","EnrollmentYear","FormOfEntry","StudentType","CurrentForm");
          $data2=array($StudentIdNumber,$enrollment_year,$form_of_entry,$student_type,$current_form);

          $add_students_result=add_student_helper($fields,$data,$fields2,$data2,$school_id);
      }

      if($add_students_result=="entry_exists"){
        die("<p class='alert alert-warning'>The username entered is already in use by another user.<p>");
      }else if($add_students_result>0){
        echo 1;
      }
   }

   //ADD STAFF
   if(isset($_POST["add_school_staff_note"])){
      $add_staff_result=0;
      $school_id=addslashes($_POST["add_school_staff_note"]);

      if(isset($_FILES["add_staff_excel_"])){
        $staff_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["add_staff_excel_"]["tmp_name"]) ) {
          $staff_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($grades_array)<3){
          die("<p class='alert alert-warning'>Please add at least one staff in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        //VALIDATE EXCEL
          $add_staff_loopcount=0;
          foreach ($staff_array as $data) {
              $add_staff_loopcount+=1;
              if($add_staff_loopcount==1){
                //validate info line
                if(empty($data[0]) or trim($data[0]) !="STAFF ADDITION TEMPLATE (Please do not delete any row or swap any rows)"){
                  die("<p class='alert alert-warning'>Please use a valid excel template downloaded here.<p>");
                }
                continue;
              }else if($add_staff_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="Username" or
                  trim($data[1])!="Firstname" or
                  trim($data[2])!="Lastname" or
                  trim($data[3])!="Middlenames" or
                  trim($data[4])!="Title" or
                  trim($data[5])!="Gender(M/F)" or
                  trim($data[6])!="Date of Birth (yyyy-mm-dd)" or
                  trim($data[7])!="Village" or
                  trim($data[8])!="TA" or
                  trim($data[9])!="District" or
                  trim($data[10])!="Position" or
                  trim($data[11])!="Highest Qualification" or
                  trim($data[12])!="Date Start Employment" or
                  trim($data[13])!="Date End Employment" 
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter username for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[1])){
                die("<p class='alert alert-warning'>Enter firstname for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter lastname for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[3])){
                //pass on middlename
              }else if(empty($data[4])){
                die("<p class='alert alert-warning'>Enter title for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[5])){
                die("<p class='alert alert-warning'>Enter gender for staff on line $add_staff_loopcount.<p>");
              }else if($data[5]!="M" and $data[5]!="F"){
                die("<p class='alert alert-warning'>Enter a valid gender(M/F) for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[6])){
                die("<p class='alert alert-warning'>Enter date of birth for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[7])){
                //pass on village
              }else if(empty($data[8])){
                //pass on TA
              }else if(empty($data[9])){
                //pass on District
              }else if(empty($data[10])){
                die("<p class='alert alert-warning'>Enter position for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[11])){
                die("<p class='alert alert-warning'>Enter highest qualification for staff on line $add_staff_loopcount.<p>");
              }else if(empty($data[12])){
                //pass date started employment
              }else if(empty($data[13])){
                //pass date end employment
              }

              //validate username
              if(!empty($data[0])){
                $check_username=$rowcountObj->rowcounter("Users","*","Username",$data[0]);
                if($check_username>0){
                  die("<p class='alert alert-warning'>Username \"".$data[0]."\" for the staff at line on line $add_staff_loopcount, is already in use by another user.<p>");
                }
              }

              //validate dob
              if(!empty($data[5])){
                $test_date = $data[5];
                $test_date = new DateTime($test_date);
                $test_date=$test_date->format('Y-m-d');
                $test_arr  = explode('-', $test_date);
                if (checkdate($test_arr[1], $test_arr[0], $test_arr[2])) {
                    die("<p class='alert alert-warning'>Enter a valid date on line $add_students_loopcount.<p>");
                }
              }

              //validate position
              if(!empty($data[10])){
                if(
                  $data[10]!="School Owner" and
                  $data[10]!="Head Master" and
                  $data[10]!="Deputy Head Master" and
                  $data[10]!="Teacher" and
                  $data[10]!="Accountant" and
                  $data[10]!="Cleaner" and
                  $data[10]!="Guard"
                ){
                  die("<p class='alert alert-warning'>Enter a valid position on line $add_staff_loopcount.<p>");
                }
              }

              //validate start employment
              if(!empty($data[12])){
                $test_date = $data[12];
                $test_arr  = explode('/', $test_date);
                if (checkdate($test_arr[1], $test_arr[2], $test_arr[0])) {
                    die("<p class='alert alert-warning'>Enter a valid date start employment (YYYY/MM/DD) on line $add_staff_loopcount.<p>");
                }
              }

              //validate start employment
              if(!empty($data[13])){
                $test_date = $data[13];
                $test_arr  = explode('/', $test_date);
                if (checkdate($test_arr[1], $test_arr[2], $test_arr[0])) {
                    die("<p class='alert alert-warning'>Enter a valid date end employment (YYYY/MM/DD) on line $add_staff_loopcount.<p>");
                }
              }
          }
        /*VALIDATE EXCEL*/


         
        //ADD STAFF
          $add_staff_loopcount=0;
          foreach ($staff_array as $data) {
              $add_staff_loopcount+=1;
              if($add_staff_loopcount<=2){
                continue;
              }

              $username=addslashes($data[0]);
              $firstname=addslashes($data[1]);
              $lastname=addslashes($data[2]);
              $middlenames=addslashes($data[3]);
              $title=addslashes($data[4]);
              $gender=addslashes($data[5]);
              $date_of_birth=addslashes($data[6]);
              $village=addslashes($data[7]);
              $TA = addslashes($data[8]);
              $district = addslashes($data[9]);
              $position=addslashes($data[10]);
              $highest_qualification=addslashes($data[11]);
              $start_employment=addslashes($data[12]);
              $end_employment=addslashes($data[13]);

              $fields=array("Username","Firstname","Lastname","Middlenames","Title","Gender","DateOfBirth","Village","TraditionalAuthority","District");
              $data=array($username,$title,$firstname,$lastname,$middlenames,$gender,$date_of_birth,$village,$TA,$district);

              $fields2=array("Position","HighestQualification","DateStartEmployment","DateEndEmployment");
              $data2=array($position,$highest_qualification,$start_employment,$end_employment);

              $add_staff_result=add_staff_helper($fields,$data,$fields2,$data2,$school_id);
          }
           
        
      }else{
        if(empty($_POST["username"])){
           die("<p class='alert alert-warning'>Enter username.<p>");
        }else if(empty($_POST["title"])){
           die("<p class='alert alert-warning'>Enter title.<p>");
        }else if(empty($_POST["firstname"])){
           die("<p class='alert alert-warning'>Enter firstname.<p>");
        }else if(empty($_POST["lastname"])){
           die("<p class='alert alert-warning'>Enter lastname.<p>");
        }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
           die("<p class='alert alert-warning'>Select gender.<p>");
        }else if(empty($_POST["date_of_birth"])){
           die("<p class='alert alert-warning'>Enter date of birth.<p>");
        }

        $username=addslashes($_POST["username"]);
        $title=addslashes($_POST["title"]);
        $firstname=addslashes($_POST["firstname"]);
        $lastname=addslashes($_POST["lastname"]);
        $position=addslashes($_POST["position"]);
        $middlenames=addslashes($_POST["middlenames"]);
        $gender=addslashes($_POST["gender"]);
        $date_of_birth=addslashes($_POST["date_of_birth"]);
        $highest_qualification=addslashes($_POST["highest_qualification"]);

        $fields=array("Username","Title","Firstname","Lastname","Middlenames","Gender","DateOfBirth");
        $data=array($username,$title,$firstname,$lastname,$middlenames,$gender,$date_of_birth);

        $fields2=array("HighestQualification","Position");
        $data2=array($highest_qualification,$position);

        $add_staff_result=add_staff_helper($fields,$data,$fields2,$data2,$school_id);
      }

      if($add_staff_result=="entry_exists"){
        die("<p class='alert alert-warning'>The username entered is already in use by another user.<p>");
      }else if($add_staff_result>0){
        echo 1;
      }
   }

   //EDIT STUDENT
   if(isset($_POST["edit_school_student_note"])){
      if(empty($_POST["username"])){
         die("<p class='alert alert-warning'>Enter username.<p>");
      }else if(empty($_POST["firstname"])){
         die("<p class='alert alert-warning'>Enter firstname.<p>");
      }else if(empty($_POST["lastname"])){
         die("<p class='alert alert-warning'>Enter lastname.<p>");
      }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
         die("<p class='alert alert-warning'>Select gender.<p>");
      }else if(empty($_POST["date_of_birth"])){
         die("<p class='alert alert-warning'>Enter date of birth.<p>");
      }

      $username=addslashes($_POST["username"]);
      $firstname=addslashes($_POST["firstname"]);
      $lastname=addslashes($_POST["lastname"]);
      $StudentIdNumber=addslashes($_POST["StudentIdNumber"]);
      $middlenames=addslashes($_POST["middlenames"]);
      $gender=addslashes($_POST["gender"]);
      $date_of_birth=addslashes($_POST["date_of_birth"]);
      $StudentUserId=$_POST["edit_school_student_note"];

      //UPDATE TO USERS
      $data="username='$username',firstname='$firstname',lastname='$lastname',middlenames='$middlenames',gender='$gender',DateOfBirth='$date_of_birth'";

      $update=$updateObj->updater("Users",$data,"UserId",$StudentUserId);

      if($update=="1"){
      	$data2="StudentIdNumber='$StudentIdNumber'";
      	if(empty($_POST["$StudentIdNumber"])){
      		$data2="StudentIdNumber=NULL";
      	}

    	$update2=$updateObj->updater("Students",$data2,"UserId",$StudentUserId);

        if($update2=="1"){
          echo 1;
        }else{
          echo 0;
        }
      }else{
         echo 0;
      }
   }

   //EDIT STAFF
   if(isset($_POST["edit_school_staff_note"])){
      if(empty($_POST["username"])){
         die("<p class='alert alert-warning'>Enter username.<p>");
      }else if(empty($_POST["title"])){
         die("<p class='alert alert-warning'>Enter title.<p>");
      }else if(empty($_POST["firstname"])){
         die("<p class='alert alert-warning'>Enter firstname.<p>");
      }else if(empty($_POST["lastname"])){
         die("<p class='alert alert-warning'>Enter lastname.<p>");
      }else if(!isset($_POST["gender"]) or empty($_POST["gender"])){
         die("<p class='alert alert-warning'>Select gender.<p>");
      }else if(empty($_POST["date_of_birth"])){
         die("<p class='alert alert-warning'>Enter date of birth.<p>");
      }

      $username=addslashes($_POST["username"]);
      $title=addslashes($_POST["title"]);
      $firstname=addslashes($_POST["firstname"]);
      $lastname=addslashes($_POST["lastname"]);
      $position=addslashes($_POST["position"]);
      $middlenames=addslashes($_POST["middlenames"]);
      $gender=addslashes($_POST["gender"]);
      $date_of_birth=addslashes($_POST["date_of_birth"]);
      $highest_qualification=addslashes($_POST["highest_qualification"]);
      $AUserId=addslashes($_POST["edit_school_staff_note"]);
      $AStaffID=addslashes($_POST["StaffID"]);

      $data="Username='$username',Title='$title',Firstname='$firstname',Lastname='$lastname',Middlenames='$middlenames',Gender='$gender',DateOfBirth='$date_of_birth'";

      
      $update=$updateObj->updater("Users",$data,"UserId",$AUserId);

      if($update=="1"){
         $get_recent_inserted_staff=$retrieveObj->retriever("Users WHERE Username='$username' ORDER BY UserId DESC","*","fetch");

         $data2="Position='$position',HighestQualification='$highest_qualification'";

         $update2=$updateObj->updater("Staff",$data2,"StaffID",$AStaffID);

         if($update2=="1"){
            echo 1;
         }else{
            echo 0;
         }
            
      }else{
         echo 0;
      }
   }

   //ADD ANNOUNCEMENT
    if(isset($_POST["add_school_announcement_note"])){
    	$school_id=addslashes($_POST["add_school_announcement_note"]);
    	//VALIDATION
    	if(empty($_POST["a_title"])){
    		die("<p class='alert alert-warning'>Enter the title</p>");
    	}else if(empty($_POST["a_body"])){
    		die("<p class='alert alert-warning'>Enter the body</p>");
    	}

    	$a_title=addslashes($_POST["a_title"]);
    	$a_body=addslashes($_POST["a_body"]);

    	$fields=array("SchoolID","StaffID","Heading","Announcement");
    	$data=array($school_id,$school_id,$a_title,$a_body);

    	$insert=$insertObj->inserter("Announcements",$fields,$data);

    	if($insert=="1"){
    		echo 1;
    	}else{
    		echo 0;
    	}
    }

    //EDIT ANNOUNCEMENT
    if(isset($_POST["edit_school_announcement_note"])){
    	//VALIDATION
    	if(empty($_POST["a_title"])){
    		die("<p class='alert alert-warning'>Enter the title</p>");
    	}else if(empty($_POST["a_body"])){
    		die("<p class='alert alert-warning'>Enter the body</p>");
    	}

    	$a_title=addslashes($_POST["a_title"]);
    	$a_body=addslashes($_POST["a_body"]);
    	$a_id=addslashes($_POST["edit_school_announcement_note"]);

    	$data="Heading='$a_title',Announcement='$a_body'";

    	$update=$updateObj->updater("Announcements",$data,"AnnouncementID",$a_id);

    	if($update=="1"){
    		echo 1;
    	}else{
    		echo 0;
    	}
    }


    //DELETE ANNOUNCEMENT
    if(isset($_POST["delete_school_announcement_note"])){
    	$a_id=addslashes($_POST["delete_school_announcement_note"]);

    	$delete=$deleteObj->deleter("Announcements","AnnouncementID",$a_id);

    	if($delete=="1"){
    		echo 1;
    	}else{	
    		echo 0;
    	}
    }










/*SCHOOLS FUNCTIONS*/

    //REGISTER STUDENTS
    if(isset($_POST["register_students_note"])){
      if(empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form of study.</p>");
      }else if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }
      $students_list=$_POST["register_students_list"];
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=date("Y");
      $SchoolID=addslashes($_POST["SchoolID"]);

      $already_registered=0;
      $total_registered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Year_Record WHERE StudentId='".$students_list[$i]."' AND SchoolID='$SchoolID' AND Year = '$academic_year'  AND FormOfStudy='$form_of_study'","*");
                                        
        if($check_student < 1){
            $fields=array('StudentId','SchoolId','Year','FormOfStudy');
            $data=array($students_list[$i],$SchoolID,$academic_year,$form_of_study);

            $insert=$insertObj->inserter('Student_Year_Record',$fields,$data);
            if($insert=="1"){
              //UPDATE STUDENT CURRENT FORM
              $updateObj->updater('Students',"CurrentForm='$form_of_study'","StudentId",$students_list[$i]);
              $total_registered++;
            }
        }else{
            $already_registered++;
        }
      }

      if($total_registered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_registered student/s have been registered successfully to form $form_of_study. ";
          if($already_registered>0){
            echo "$already_registered student/s were already registered. ";
          }
        echo "</p>";
      }else{
        if($already_registered>0){
          echo "<p class='alert alert-warning'>$already_registered student/s were already registered.</p>";
        }else{
          echo 0;
        }
      }
    }

    //DEREGISTER STUDENTS
    if(isset($_POST["deregister_students_note"])){
      /*if(empty($_POST["form"])){
        die("<p class='alert alert-warning'>Select form of study.</p>");
      }*/

      if(!isset($_POST["register_students_list"])){
        die("<p class='alert alert-warning'>Please selected at least one student.</p>");
      }

      $students_list=$_POST["register_students_list"];
      $form_of_study=addslashes($_POST["form"]);
      $academic_year=addslashes($_POST["academic_year"]);
      $SchoolID=addslashes($_POST["SchoolID"]);

      $already_deregistered=0;
      $total_deregistered=0;
      for ($i=0; $i < count($students_list); $i++) { 
        $check_student = $allrowcountObj->allrowcounter("Student_Year_Record WHERE StudentId='".$students_list[$i]."' AND SchoolID='$SchoolID' AND Year = '$academic_year' AND FormOfStudy='$form_of_study'","*");
                                        
        if($check_student > 0){
            $delete=$deleteObj->deleter('Student_Year_Record',"FormOfStudy='$form_of_study' and Year='$academic_year' and  StudentId",$students_list[$i]);
            if($delete=="1"){
              $total_deregistered++;
            }
        }else{
            $already_deregistered++;
        }
      }

      if($total_deregistered>0){
        echo "<p class='alert alert-success'>";
          echo "$total_deregistered student/s have been deregistered successfully to form $form_of_study. ";
          if($already_deregistered>0){
            echo "$already_deregistered student/s were already deregistered. ";
          }
        echo "</p>";
      }else{
        if($already_deregistered>0){
          echo "<p class='alert alert-warning'>$already_deregistered student/s were already deregistered.</p>";
        }else{
          echo 0;
        }
      }
    }


    //REGISTER STUDENT TO SUBJECT
    if(isset($_POST["register_student_subject_note"]) and $_POST["rssn"]!="all"){
      if(empty($_POST["SubjectId"]) or empty($_POST["StudentId"])){
        die("<p class='alert alert-warning'>Something went wrong, please try again later.</p>");
      }
      $student=$_POST["StudentId"];
      $subject=addslashes($_POST["SubjectId"]);
      $register_status=addslashes($_POST["register_student_subject_note"]);
      $Form=addslashes($_POST["Form"]);
      $Term=addslashes($_POST["Term"]);
      $SchoolID=addslashes($_POST["SchoolID"]);

      $getStudentInfo=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId","*","StudentId",$student,"fetch");
      $getSubjectInfo=$retrieveObj->retriever("Subjects","*","SubjectId",$subject,"fetch");

      if($getStudentInfo=="1020"){
        die(0);
      }
      //$term=$getStudentInfo->TermOfStudy;
      $form_of_study=$Form;
      $academic_year=date("Y");

      $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$student."' AND SchoolID='$SchoolID' AND AcademicYear = '$academic_year' AND Term='$Term' AND FormOfStudy='$form_of_study' AND SubjectId='$subject'","*");
      if($register_status=="on"){ //register student to subject                            
        if($check_student < 1){
            $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
            $data=array($student,$SchoolID,$form_of_study,$academic_year,$Term,$subject);

            $insert=$insertObj->inserter('Student_Term_Subjects',$fields,$data);
            if($insert=="1"){
              echo "<p class='alert alert-success'>".$getStudentInfo->Firstname." is now registered to ".$getSubjectInfo->SubjectName.".</p>";
            }
        }else{ 
            echo "<p class='alert alert-warning'>".$getStudentInfo->Firstname." is already registered to ".$getSubjectInfo->SubjectName.".</p>";
        }
      }else{  //deregister student to subject
        if($check_student > 0){
            $delete=$deleteObj->deleter('Student_Term_Subjects',"FormOfStudy='$form_of_study' and AcademicYear='$academic_year' and SubjectId='$subject' and Term='$Term' and  StudentId",$student);
            if($delete=="1"){
              echo "<p class='alert alert-success'>".$getStudentInfo->Firstname." is now deregistered to ".$getSubjectInfo->SubjectName.".</p>";
            }
        }else{
            echo "<p class='alert alert-warning'>".$getStudentInfo->Firstname." is already deregistered to ".$getSubjectInfo->SubjectName.".</p>";
        }
      }
    }

    //REGISTER STUDENT TO SUBJECT
    if(isset($_POST["register_student_subject_note"]) and $_POST["rssn"]=="all"){
      $subject=addslashes($_POST["SubjectId"]);
      $register_status=addslashes($_POST["register_student_subject_note"]);
      $Form=addslashes($_POST["Form"]);
      $Term=addslashes($_POST["Term"]);
      $SchoolID=addslashes($_POST["SchoolID"]);

      $rssn_result=0;
      $rssn_result_a=0;

      $get_students=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId","*","CurrentForm='$Form' and SchoolID",$SchoolID,"fetchAll");

      foreach ($get_students as $student) {
        $getSubjectInfo=$retrieveObj->retriever("Subjects","*","SubjectId",$subject,"fetch");

        //$term=$getStudentInfo->TermOfStudy;
        $form_of_study=$Form;
        $academic_year=date("Y");

        $check_student = $allrowcountObj->allrowcounter("Student_Term_Subjects WHERE StudentId='".$student->StudentId."' AND SchoolID='$SchoolID' AND AcademicYear = '$academic_year' AND Term='$Term' AND FormOfStudy='$form_of_study' AND SubjectId='$subject'","*");
        if($register_status=="on"){ //register student to subject                            
          if($check_student < 1){
              $fields=array('StudentId','SchoolId','FormOfStudy','AcademicYear','Term','SubjectId');
              $data=array($student->StudentId,$SchoolID,$form_of_study,$academic_year,$Term,$subject);

              $insert=$insertObj->inserter('Student_Term_Subjects',$fields,$data);
              if($insert=="1"){
                //echo "<p class='alert alert-success'>".$student->Firstname." is now registered to ".$getSubjectInfo->SubjectName.".</p>";
                $rssn_result+=1;
              }
          }else{ 
              //echo "<p class='alert alert-warning'>".$student->Firstname." is already registered to ".$getSubjectInfo->SubjectName.".</p>";
              $rssn_result_a+=1;
          }
        }else{  //deregister student to subject
          if($check_student > 0){
              $delete=$deleteObj->deleter('Student_Term_Subjects',"FormOfStudy='$form_of_study' and AcademicYear='$academic_year' and SubjectId='$subject' and Term='$Term' and  StudentId",$student->StudentId);
              if($delete=="1"){
                //echo "<p class='alert alert-success'>".$student->Firstname." is now deregistered to ".$getSubjectInfo->SubjectName.".</p>";
                $rssn_result+=1;
              }
          }else{
              //echo "<p class='alert alert-warning'>".$student->Firstname." is already deregistered to ".$getSubjectInfo->SubjectName.".</p>";
              $rssn_result_a+=1;
          }
        }
      }

      if($rssn_result>0){
        echo 1;
      }else if($rssn_result_a>0){
        echo 2;
      }else{
        echo 0;
      }

    }

    if(isset($_POST["grade_entry_note"])){
      $result=0;
      $Subject=addslashes($_POST["Subject"]);
      $AcademicYear=addslashes($_POST["AcademicYear"]);
      $FormOfStudy=addslashes($_POST["FormOfStudy"]);
      $Term=addslashes($_POST["Term"]);
      $SchoolID=addslashes($_POST["SchoolID"]);

      if(isset($_FILES["grade_entry_excel_"])){
        $grades_array=array();
        include("../../assets/vendors/simplexlsx/src/SimpleXLSX.php");
        if ($xlsx = SimpleXLSX::parse($_FILES["grade_entry_excel_"]["tmp_name"]) ) {
          $grades_array=$xlsx->rows();
        } else {
          die("<p class='alert alert-warning'>Reading excel file failed.<p>");
        }

        if(count($grades_array)<4){
          die("<p class='alert alert-warning'>Please add at least on student in your excel file and also make sure you are using a valid excel template you got from the button below.<p>");
        }

        $row = 1;
        //VALIDATE EXCEL
          $add_grades_loopcount=0;
          foreach ($grades_array as $data) {
              $add_grades_loopcount+=1;
              if($add_grades_loopcount==1){
                continue;
              }else if($add_grades_loopcount==2){
                //validate header
                if(
                  trim($data[0])!="GRADES ENTRY TEMPLATE"
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }else if($add_grades_loopcount==3){
                //validate header
                if(
                  trim($data[0])!="StudentIDNumber" or
                  trim($data[1])!="Student Name" or
                  trim($data[2])!="Continuous Assessment" or
                  trim($data[3])!="Final Exam" or
                  trim($data[4])!="Comment"
                ){
                  die("<p class='alert alert-warning'>Please use a valid excel template you got from the button below.<p>");
                }
                continue;
              }
              
              if(empty($data[0])){
                die("<p class='alert alert-warning'>Enter StudentIDNumber for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[1])){
                //pass student name
              }else if(empty($data[2])){
                die("<p class='alert alert-warning'>Enter Continuous Assessment for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[3])){
                die("<p class='alert alert-warning'>Enter Final Exam for student on line $add_grades_loopcount.<p>");
              }else if(empty($data[4])){
                //pass comment
              }

              //check if the student is registered to the subject
              $get_student=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId JOIN Student_Term_Subjects ON Student_Term_Subjects.StudentId=Students.StudentId WHERE Student_Term_Subjects.SubjectId='$Subject' AND AcademicYear='$AcademicYear' AND Term='$Term' AND Student_Term_Subjects.FormOfStudy='$FormOfStudy' AND StudentIdNumber='".$data[0]."' AND Student_Term_Subjects.SchoolID='$SchoolID'","*","fetch");

              if($get_student=="1020"){
                die("<p class='alert alert-warning'>The student on line $add_grades_loopcount is not registered to the selected subject for the particular class and term and year.<p>");
              }
          }
        /*VALIDATE EXCEL*/

        //ADD GRADES
        $add_grades_loopcount=0;
        foreach ($grades_array as $data) {
            $add_grades_loopcount+=1;
            if($add_grades_loopcount<=2){
              continue;
            }
            
            $StudentIDNumber=addslashes($data[0]);
            $ContinuousAssessment=addslashes($data[2]);
            $FinalExam=addslashes($data[3]);
            $Comment=addslashes($data[4]);

            $get_student=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId JOIN Student_Term_Subjects ON Student_Term_Subjects.StudentId=Students.StudentId WHERE Student_Term_Subjects.SubjectId='$Subject' AND AcademicYear='$AcademicYear' AND Term='$Term' AND Student_Term_Subjects.FormOfStudy='$FormOfStudy' AND StudentIdNumber='".$data[0]."' AND Student_Term_Subjects.SchoolID='$SchoolID'","*","fetch");
            if($get_student=="1020"){
              continue;
            }

            $total_grade=(float)$ContinuousAssessment+(float)$FinalExam;
            
            $data=" ContinuousAssessmentGrade = '$ContinuousAssessment', EndOfSemesterGrade = '$FinalExam', TeacherComments = '$Comment' ,TotalGrade='$total_grade'";

            $update=$updateObj->updater("Student_Term_Subjects",$data,"SchoolID = '$SchoolID' AND StudentId = '".$get_student->StudentId."' AND FormOfStudy = '$FormOfStudy' AND AcademicYear = '$AcademicYear' AND Term = '$Term' AND SubjectId",$Subject);

            if($update=="1"){
              $result+=1;
            }
          
        }
        //ADD GRADES

      }else{
        $ContinuousAssessment=$_POST["ContinuousAssessment"];
        $Comment=$_POST["Comment"];
        $FinalExam=$_POST["FinalExam"];
        $StudentId=$_POST["StudentId"];

        for ($i=0; $i < count($FinalExam) ; $i++) { 
          $total_grade=(float)$ContinuousAssessment[$i]+(float)$FinalExam[$i];
          
          $data=" ContinuousAssessmentGrade = '".$ContinuousAssessment[$i]."', EndOfSemesterGrade = '".$FinalExam[$i]."', TeacherComments = '".$Comment[$i]."' ,TotalGrade='".$total_grade."'";

          $update=$updateObj->updater("Student_Term_Subjects",$data,"SchoolID = '$SchoolID' AND StudentId = '".$StudentId[$i]."' AND FormOfStudy = '$FormOfStudy' AND AcademicYear = '$AcademicYear' AND Term = '$Term' AND SubjectId",$Subject);

          if($update=="1"){
            $result+=1;
          }
        }
      }

      if($result>0){
        echo 1;
      }else{
        echo 0;
      }
    }

    if(isset($_POST["update_grading_method_note"])){
    	$GradingType=addslashes($_POST["GradingType"]);
    	$Form=addslashes($_POST["update_grading_method_note"]);
    	$SchoolID=addslashes($_POST["SchoolID"]);

    	if(empty($_POST["GradingType"])){
    		die("<p class='alert alert-warning'>Select grading type</p>");
    	}

    	$check_if_exist=$rowcountObj->rowcounter("FormGradingTypes","*","SchoolID",$SchoolID);

    	$result=0;
    	if($check_if_exist>=1){
    		//update
    		$result=$updateObj->updater("FormGradingTypes","GradingType='$GradingType'","SchoolID='$SchoolID' and Form",$Form);
    	}else{
    		//insert
    		$fields=array("GradingType","Form","SchoolID");
    		$data=array($GradingType,$Form,$SchoolID);

    		$result=$insertObj->inserter("FormGradingTypes",$fields,$data);
    	}

    	if($result>0){
	        echo 1;
      	}else{
	        echo 0;
      	}
    }
/*SCHOOLS FUNCTIONS*/
?>