<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  
  $get_user=$retrieveObj->retriever("users","*","UserId",$user_id,"fetch");
  if($get_user=="1020"){
    die("<p class='alert alert-warning'> Sorry something went wrong, try again later</p>");
  }

  //get user profile picture
    $profile_img=$retrieveObj->retriever("users","photo_id","UserId",$user_id,"fetch");

?>
<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Profile
    <!--<br><span class="font-weight-normal"></span>-->
  </h3>
</div>
<div class="row">
  <div class="col-xl-8">
    <div class="card">
      <div class="card-header">
        <div class="row align-items-center">
          <div class="col-12">
            <h5 class="mb-0">Edit profile </h5>
          </div>
        </div>
      </div>
      <div class="card-body">
        <form id="edit_profile_form">
          <h6 class="heading-small text-muted mb-4">User information</h6>
          <div class="pl-lg-4">
            <div class="row">
              <div class="col-lg-6">
                <div class="form-group">
                  <label class="form-control-label" for="input-first-name">First name</label>
                  <input type="text" id="input-first-name" name="firstname" class="form-control" placeholder="First name" value="<?php echo $get_user->Firstname; ?>">
                </div>
              </div>
              <div class="col-lg-6">
                <div class="form-group">
                  <label class="form-control-label" for="input-last-name">Last name</label>
                  <input type="text" id="input-last-name" name="lastname" class="form-control" placeholder="Last name" value="<?php echo $get_user->Lastname; ?>">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-6">
                <div class="form-group">
                  <label class="form-control-label" for="input-phone-number">Phone number</label>
                  <input type="text" id="input-phone-number" name="phone" class="form-control" placeholder="Phone number" value="<?php echo $get_user->PhoneNumber; ?>">
                </div>
              </div>
              <div class="col-lg-6">
                <div class="form-group">
                  <label class="form-control-label" for="input-email">Email address</label>
                  <input type="email" id="input-email" name="email" class="form-control" placeholder="Email address" value="<?php echo $get_user->EmailAddress; ?>">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-12">
                <div class="form-group" id="edit_profile_response"></div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-12">
                <input type="hidden" name="edit_profile_note">
                <button type="submit" class="btn bg_cprimary_color text-light btn-block enter-btn" onclick="edit_profile()">Update</button>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <div class="col-xl-4">
    <div class="card card-profile">
      <p class="text-center py-3" id="profilePhotoContainer">
          <?php
              if($get_user->photo_id==""){
                $profile_photo="photo".$get_user->UserId.".png";
                  echo '<span class="nav-link" href="#"><i class="fas fa-user fa-5x text_secondary_color hand_cursor" data-toggle="collapse" data-target="#profile_pic_form_container"></i></span>';
              }else{
                $profile_photo=$get_user->photo_id;
                  echo '<img id="profile_picture" src="../img/profile_pictures/'.$get_user->photo_id.'?'.date("Y-m-d").time().'" max-height="600px" class="mr-1 shadow rounded-circle thumbnail p-1 hand_cursor" data-toggle="collapse" data-target="#profile_pic_form_container">';
              }
          ?>
      </p>
      
      <div class="card-footer collapse" id="profile_pic_form_container">
        <div id="changePhotoResponse"></div>
                <input class="" type="file" id="upload_image" name="upload_image">
      </div>
      <div class="card-body pt-0">
        <div class="text-center">
          <h5 class="h5">
            <?php echo $get_user->Firstname." ",$get_user->Lastname; ?>
          </h5>
          <div class="h6 font-weight-300">
            <?php echo $get_user->EmailAddress; ?>
          </div>
          <hr class="my-4">
          <div class="h5">
            <a href="#change-password" class="text_cprimary_color" data-toggle="collapse" data-target="#change_password_container"> CHANGE PASSWORD</a>
          </div>
        </div>
      </div>
      
      <div class="card-body pt-0 collapse" id="change_password_container">
        <form id="change_password_form">
          <div class="form-group">
            <div>
              <label>Current password</label>
            </div>
            <div>
              <input class="form-control " type="password" name="Cpassword">
            </div>
          </div>
          <div class="form-group">
            <div>
              <label>New password</label>
            </div>
            <div>
              <input class="form-control " type="password" name="Npassword">
            </div>
          </div>
          <div class="form-group">
            <div>
              <label>Re-enter new password</label>
            </div>
            <div>
              <input class="form-control " type="password" name="Rpassword">
            </div>
          </div>
          <div class="form-group" id="change_password_response">
            
          </div>
          <div class="form-group">
            <div class="text-center">
              <input type="hidden" name="change_password_note">
              <button type="submit" class="btn bg_cprimary_color text-light btn-block enter-btn" onclick="change_password()">Update</button>
            </div>
          </div>
        </form>
      </div>
      <div>
        &nbsp;
      </div>
    </div>
  </div>
</div>


<div id="uploadimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
          <div class="modal-header d-flex justify-content-between">
            <h4 class="modal-title">Upload & Crop Image</h4>
            <button type="button" class="close btn btn-danger" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body">
            <div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo" style="width:300px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <br />
              <br />
              <br/>
              <button class="btn btn-success crop_image">Crop & <br>Upload Image</button>
          </div>
        </div>
          </div>
      </div>
    </div>
</div>


<script>  
$(document).ready(function(){

  $image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    $image_crop.croppie('result', {
      type: 'canvas',
      size: "viewport", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/profile/upload.php",
        type: "POST",
        data:{"image": response},
        
            cache: false,
           
        success:function(data)
        { 
          $('#uploadimageModal').modal('hide');
          if(data==1){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-success'>Your profile picture updated</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)

            //.................
            d=new Date();

            if(document.getElementById("profile_picture")!==null){
              $("#profile_picture").attr("src","../img/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }else{
              $("#profilePhotoContainer").html("<img id='profile_picture' max-height='600px' class='mr-1 shadow rounded-circle thumbnail p-1 hand_cursor' data-toggle='collapse' data-target='#profile_pic_form_container'>")
              $("#profile_picture").attr("src","../img/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }

            if(document.getElementById("sub_profile_picture")!==null){
              $("#sub_profile_picture").attr("src","../img/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }else{
              $("#profilePhotoSubContainer").html("<img id='sub_profile_picture' class='nav-profile-img' data-toggle='collapse' data-target='#profile_pic_form_container'>")
              $("#sub_profile_picture").attr("src","../img/profile_pictures/"+"<?php echo $profile_photo ?>"+"?timestamp"+d.getTime())
            }

          }else if(data==0){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-danger'>Failed to update your Profile</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)
          }
          //$('#uploaded_image').html(data);
        }
      });
    })
  });

});  
</script>
