<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_register_requests=$retrieveObj->retriever("SchoolRegisterRequests
    JOIN Schools ON Schools.SchoolID=SchoolRegisterRequests.SchoolID
    JOIN Users ON Users.UserId=SchoolRegisterRequests.UserId","*","fetchAll");
?>
<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Register Requests
  </h3>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
      <div class="card-header bg-white px-0 border_0">
        <div class="font-weight-bold">Register Requests</div>
        <div class="row">
          <div class="col-md-12" id="register_requests_response"></div>
        </div>
      </div>
      <div class="card-body p-2">
        <!-- Projects table -->
        <table class="table table-responsive" id="register_request_table">
          <thead class="text-dark">
            <tr>
              <th scope="col">Fullname</th>
              <th scope="col">School Name</th>
              <!--<th scope="col">School Email</th>-->
              <th scope="col">School Phone</th>
              <th scope="col">Request Date</th>
              <th scope="col">Options</th>
            </tr>
          </thead>
          <tbody>
            <?php
            if($get_register_requests!="1020"){
              $element_id="element_id";
                foreach ($get_register_requests as $register_request) {
                  $element_id=$element_id."Ot";
          ?>  
              <tr id="<?php echo $element_id ?>"> 
                <td>
                  <?php 
                    echo $register_request->Firstname." ".$register_request->Lastname;
                  ?>
                </td>
                <td>
                  <?php 
                    echo $register_request->SchoolName;
                  ?>
                </td>
                <!--<td>
                  <a href="mailto:<?php echo $register_request->SchoolEmailAddress ?>">
                    <u>
                      <?php 
                        echo $register_request->SchoolEmailAddress;
                      ?>
                    </u>
                  </a>
                </td>-->
                <td>
                  <a href="tel:<?php echo $register_request->SchoolPhoneNumber1 ?>">
                    <u>
                      <?php 
                        echo $register_request->SchoolPhoneNumber1;
                      ?>
                    </u>
                  </a>
                </td>
                <td>
                  <span style="display:none;"><?php echo strtotime($register_request->RequestTime) ?></span>
                  <?php echo date("M j, Y", strtotime($register_request->RequestTime))."<br> @".date("H:i A", strtotime($register_request->RequestTime)); ?>
                </td>
                <td id="<?php echo $element_id.'Dbtn' ?>">
                    <div class="">
                      <a href="#register-request-details-view" title="Details" class="btn btn-sm hand_cursor text-light btn-primary my-1 px-2" onclick="register_request_details_view(<?php echo $register_request->SchoolRegisterRequestId ?>)"><span class="fas fa-info-circle"></span></a>

                      <?php
                        if($user_in_type=="su_admin"){
                      ?>
                        <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                            <input type="hidden" name="delete_register_request_note" value="<?php echo $register_request->SchoolRegisterRequestId; ?>">
                            <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_register_request('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','register_requests_response')" type="submit" title="Delete" class="btn btn-sm text-light hand_cursor btn-danger my-1 px-2"><span class="fas fa-times"></span></button>
                        </form>
                      <?php
                        }
                      ?>
                      
                    </div>  
                    
                </td>
              </tr>
            <?php
                }
              }
            ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#register_request_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ],
      order: [[3, 'desc']],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });
  })
</script>