<?php
	require_once("../classes/main_classes.php");

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	$root_dir_getObj=new ROOTDIRGET();
	$root_dir=$root_dir_getObj->root_dir_getter();

	//ERROR MESSAGE TEMPLATE
	function error_message_fun($error_message){
		return '<link href="../user/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
            <p class="text-center p-4">
                <img src="../assets/img/logos/swb_logo.png" alt="LOGO" style="max-height: 86px;">
            </p>
            <div class="container">
                <div class="alert alert-danger text-center py-3">'.$error_message.'</div>
                <p class="text-center pt-2 text-light">Redirecting...</p>
            </div>
        </body>';
	}

	if (session_status() == PHP_SESSION_NONE) {
	  session_start();
	}
	
	$error_redir_index="";

	if(isset($_SESSION["user_details"])){ //CHECK IF THE USER IS LOGGED IN
		if($_SESSION["user_details"]["UserType"]=="school_staff" or ($_SESSION["user_details"]["UserType"]=="student")){
			
		}else{
			echo error_message_fun("Access denied, make sure you are logged in.");
			header( "refresh:5;url=$root_dir" );
			die();	
		}
		$error_redir_index="../users/index.php";
	}else{
		echo error_message_fun("Access denied, make sure you are logged in.");
		header( "refresh:5;url=$root_dir" );
		die();	
	}

	//CHECK IF THE RECORD INFOR WAS POSTED
	if(!isset($_POST["StudentId"]) or !isset($_POST["form"]) or !isset($_POST["term"]) or !isset($_POST["year"])){
		echo error_message_fun("Invalid request. Redirecting...");
		header( "refresh:5;url=$error_redir_index" );
		die();
	}

	$StudentId=addslashes($_POST["StudentId"]);
	$form=addslashes($_POST["form"]);
	$term=addslashes($_POST["term"]);
	$year=addslashes($_POST["year"]);

	$get_student=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId","*","StudentId",$StudentId,"fetch");
	if($get_student=="1020"){
		echo error_message_fun("Something went wrong. Redirecting...");
		header( "refresh:5;url=$error_redir_index" );
		die();
	}

	require_once("student_record_pdf.php");

	require_once "../assets/vendors/mpdf/vendor/autoload.php";
	
	$file_name="Student Record for ".$get_student->Firstname."_".$get_student->Lastname."_Form".$form."_Term".$term."_$year".".pdf";


	$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4']);
	$mpdf->WriteHTML(student_record_pdf_var($StudentId,$form,$term,$year));
	ob_clean();
	$mpdf->Output($file_name, 'I');
?>