<!DOCTYPE html>
<html lang="en">
<head>

<!-- meta tags -->
<meta charset="utf-8">
<meta name="keywords" content="bootstrap 5, premium, multipurpose, sass, scss, saas, software" />
<meta name="description" content="HTML5 Template" />
<meta name="author" content="www.themeht.com" />
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Title -->
<title>Home - School Web</title>

<!-- favicon icon -->
<link rel="shortcut icon" href="assets/img/logos/swb_logo.png" />

<!-- inject css start -->

<!--== bootstrap -->
<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />

<link href="https://fonts.googleapis.com/css?family=Ubuntu:300,300i,400,400i,500,500i,700,700i" rel="stylesheet">

<!--== animate -->
<link href="css/animate.css" rel="stylesheet" type="text/css" />

<!--== fontawesome -->
<link href="css/fontawesome-all.css" rel="stylesheet" type="text/css" />

<!--== line-awesome -->
<link href="css/line-awesome.min.css" rel="stylesheet" type="text/css" />

<!--== magnific-popup -->
<link href="css/magnific-popup/magnific-popup.css" rel="stylesheet" type="text/css" />

<!--== owl-carousel -->
<link href="css/owl-carousel/owl.carousel.css" rel="stylesheet" type="text/css" />

<!--== base -->
<link href="css/base.css?<?php echo date("Y-m-d").time() ?>" rel="stylesheet" type="text/css" />

<!--== shortcodes -->
<link href="css/shortcodes.css" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="assets/css/universal.css?<?php echo time(); ?>" />

<!--== default-theme -->
<link href="css/style.css?<?php echo date("Y-m-d").time() ?>" rel="stylesheet" type="text/css" />

<!--== responsive -->
<link href="css/responsive.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="assets/css/universal.css?<?php echo date("Y-m-d").time() ?>">

<!-- inject css end -->

</head>

<body class="home-2">

<!-- page wrapper start -->

<div class="page-wrapper">

<!-- preloader start -->

<div id="ht-preloader">
  <div class="loader clear-loader">
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-wrap-text">
      <div class="text">
        <span>S</span>
        <span>C</span>
        <span>H</span>
        <span>O</span>
        <span>O</span>
        <span>L</span>
        <span></span>
        <span>W</span>
        <span>E</span>
        <span>B</span>
      </div>
    </div>
  </div>
</div>

<!-- preloader end -->


<!--header start-->

<?php include("main_header.php"); ?>

<!--header end-->


<!--hero section start-->

<section class="fullscreen-banner banner p-0" data-bg-img="images/pattern/01.png" id="home">
  <div class="hero-bg">
    <img class="img-fluid" src="images/bg/04.png" alt="">
  </div>
  <div class="align-center p-0">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-7 col-md-12 img-side">
          <div id="carouselExampleDark" class="carousel carousel-dark slide" data-bs-ride="carousel">
            <div class="carousel-indicators home-carousel-indicators">
              <button type="button" data-bs-target="#carouselExampleDark" data-bs-slide-to="0" class=" active" aria-current="true" aria-label="Slide 1"></button>
              <button type="button" data-bs-target="#carouselExampleDark" data-bs-slide-to="1" class="" aria-label="Slide 2"></button>
              <button type="button" data-bs-target="#carouselExampleDark" data-bs-slide-to="2" class="" aria-label="Slide 3"></button>
            </div>
            <div class="carousel-inner">
              <div class="carousel-item active" data-bs-interval="10000">
                <img src="images/bg/home-slider-1.png" class="d-block w-100" alt="...">
                <div class="carousel-caption d-none d-md-block">
                  <h5 class="home-carousel-title shadow">School Admin Dashboard</h5>
                  <!--<p>Some representative placeholder content for the first slide.</p>-->
                </div>
              </div>
              <div class="carousel-item" data-bs-interval="2000">
                <img src="images/bg/home-slider-2.png" class="d-block w-100" alt="...">
                <div class="carousel-caption d-none d-md-block">
                  <h5 class="home-carousel-title shadow">Students Overview</h5>
                  <!--<p>Some representative placeholder content for the second slide.</p>-->
                </div>
              </div>
              <div class="carousel-item">
                <img src="images/bg/home-slider-3.png" class="d-block w-100" alt="...">
                <div class="carousel-caption d-none d-md-block">
                  <h5 class="home-carousel-title shadow">Subject Registration</h5>
                  <!--<p>Some representative placeholder content for the third slide.</p>-->
                </div>
              </div>
            </div>
            <!--<button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleDark" data-bs-slide="prev">
              <span class="carousel-control-prev-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleDark" data-bs-slide="next">
              <span class="carousel-control-next-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Next</span>
            </button>-->
          </div>
          <!--<img class="img-fluid" src="images/mackbook/macbook.png" alt="">-->
        </div>
      </div>
    </div>
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-5 col-md-12 mt-5 mt-lg-0 ms-auto">
          <h1 class="mb-4 fw-normal wow fadeInUp" data-wow-duration="1.5s">The Power of <span class="fw-bold text-uppercase">SchoolWeb</span> <!--A Complete <span class="fw-bold text-uppercase">Software</span> Based Website--></h1>
          <p class="lead mb-4 wow fadeInUp" data-wow-duration="2s" data-wow-delay="0.3s">
            SchoolWeb sofware has several excellent features that you can get in one bundle once you register. These include student records, school timetables, teacher subject allocation, student school reports emailing or texts to parents/guardians etc. 
          </p>
          <a class="btn btn-theme wow fadeInUp" data-wow-duration="3s" data-wow-delay="0.5s" href="register.php" data-text="Register School"> 
            <span>R</span>
            <span>e</span>
            <span>s</span>
            <span>t</span>
            <span>e</span>
            <span>r</span>
            <span> </span>
            <span>S</span>
            <span>c</span>
            <span>h</span>
            <span>o</span>
            <span>o</span>
            <span>l</span>
          </a>
          <a class="btn btn-dark wow fadeInUp" data-wow-duration="3s" data-wow-delay="0.5s" href="about.php" data-text="Learn More"> <span>L</span><span>e</span><span>a</span><span>r</span><span>n</span>
            <span> </span><span>M</span><span>o</span><span>r</span><span>e</span>
          </a>
        </div>
      </div>
    </div>
  </div>
  <div class="round-shape"></div>
</section>

<!--hero section end-->

<section class="text-center pt-0" id="about-section">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-6 col-md-10">
        <div class="section-title">
          <div class="title-effect">
            <div class="bar bar-top"></div>
            <div class="bar bar-right"></div>
            <div class="bar bar-bottom"></div>
            <div class="bar bar-left"></div>
          </div>
          <h6>How It Work</h6>
          <h2 class="title">Three Simple Step To Get Started</h2>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-4 col-md-12">
        <div class="work-process">
          <div class="box-loader"> <span></span>
            <span></span>
            <span></span>
          </div>
          <div class="step-num-box">
            <div class="step-icon"><span><i class="fas fa-pen-alt text-dark"></i></span>
            </div>
            <div class="step-num">01</div>
          </div>
          <div class="step-desc">
          <h4>Create account</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="work-process">
          <div class="box-loader"> <span></span>
            <span></span>
            <span></span>
          </div>
          <div class="step-num-box">
            <div class="step-icon"><span><i class="fas fa-lightbulb text-dark"></i></span>
            </div>
            <div class="step-num">02</div>
          </div>
          <div class="step-desc">
          <h4>Wait for approval</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="work-process">
          <div class="step-num-box">
            <div class="step-icon"><span><i class="fas fa-user-cog text-dark"></i></span>
            </div>
            <div class="step-num">03</div>
          </div>
          <div class="step-desc">
          <h4>Manage your school</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!--body content start-->

<div class="page-content">

<!--about start-->

<section>
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6 col-md-12 order-lg-1">
        <img class="img-fluid w-100" src="images/illustrations/grades-illustration.png" alt="">
      </div>
      <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
        <div class="section-title mb-3">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-info"></i>
          </div>
          <h2>You dont need to calculate grades manually</h2>
        </div>
        <p class="lead">School Web automatically calculates grades and turn them to letters grades or points for you.</p>
        <a class="btn btn-theme btn-circle" href="index.php#features" data-text="See Features"> <span>S</span><span>e</span><span>e</span><span> </span>
          <span>F</span>
          <span>e</span>
          <span>a</span>
          <span>t</span>
          <span>u</span>
          <span>r</span>
          <span>e</span>
          <span>s</span>
        </a>
        <!--<a class="btn btn-dark btn-circle" href="#" data-text="Learn More"> <span>L</span><span>e</span><span>a</span><span>r</span><span>n</span>
          <span> </span><span>M</span><span>o</span><span>r</span><span>e</span>
        </a>-->
      </div>
    </div>
  </div>
</section>

<!--about end-->


<!--about start-->

<section class="bg-effect position-relative custom-py-2" id="about">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6 col-md-12 image-column">
        <div class="blink-img">
          <img class="img-fluid blinkblink" src="images/pattern/04.png" alt="">
        </div>
        <div id="carouselExampleDark2" class="carousel carousel-dark slide" data-bs-ride="carousel">
          <div class="carousel-indicators home-carousel-indicators">
            <button type="button" data-bs-target="#carouselExampleDark2" data-bs-slide-to="0" class=" active" aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#carouselExampleDark2" data-bs-slide-to="1" class="" aria-label="Slide 2"></button>
            <button type="button" data-bs-target="#carouselExampleDark2" data-bs-slide-to="2" class="" aria-label="Slide 3"></button>
            <button type="button" data-bs-target="#carouselExampleDark2" data-bs-slide-to="3" class="" aria-label="Slide 4"></button>
            <button type="button" data-bs-target="#carouselExampleDark2" data-bs-slide-to="4" class="" aria-label="Slide 5"></button>
          </div>
          <div class="carousel-inner">
            <div class="carousel-item active" data-bs-interval="10000">
              <img src="images/about/grade-entry-table.png" class="d-block w-100" alt="...">
              <div class="carousel-caption d-none d-md-block">
                <!--<h5 class="home-carousel-title text-light">Grade entry</h5>-->
              </div>
            </div>
            <div class="carousel-item" data-bs-interval="2000">
              <img src="images/about/grade-entry.png" class="d-block w-100" alt="...">
              <div class="carousel-caption d-none d-md-block">
                <!--<h5 class="home-carousel-title text-light">Grade entry</h5>-->
              </div>
            </div>
            <div class="carousel-item">
              <img src="images/about/register-students.png" class="d-block w-100" alt="...">
              <div class="carousel-caption d-none d-md-block">
                <!--<h5 class="home-carousel-title text-light">Register students</h5>-->
              </div>
            </div>
            <div class="carousel-item">
              <img src="images/about/staff-overview.png" class="d-block w-100" alt="...">
              <div class="carousel-caption d-none d-md-block">
                <!--<h5 class="home-carousel-title text-light">Staff</h5>-->
              </div>
            </div>
            <div class="carousel-item">
              <img src="images/about/announcements.png" class="d-block w-100" alt="...">
              <div class="carousel-caption d-none d-md-block">
                <!--<h5 class="home-carousel-title text-light">Announcements</h5>-->
              </div>
            </div>
          </div>
          
          <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleDark2" data-bs-slide="prev">
            <span class="carousel-control-prev-icon fas fa-angle-left fa-3x text-primary" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleDark2" data-bs-slide="next">
            <span class="carousel-control-next-icon fas fa-angle-right fa-3x text-primary" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
          </button>
        </div>
        <!--<img class="img-fluid" src="images/about/about-image-1.png" alt="">-->
      </div>
      <div class="col-lg-5 col-md-12 mt-5 mt-lg-0 ms-auto">
        <div class="section-title mb-3">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-info"></i>
          </div>
          <h2>Simple School Management.</h2>
        </div>
        <p class="lead">School Web has all you need to manage your School.</p>
        <ul class="custom-li list-unstyled list-icon-2 d-inline-block">
          <li>Grade management</li>
          <li>Student management</li>
          <li>Staff Records</li>
          <li>Announcements</li>
          <li>Assessment</li>
          
          
        </ul>
      </div>
    </div>
  </div>
</section>

<!--about end-->

<!--timeline start-->

<section class="position-relative overflow-hidden" id="features">
  <canvas id="canvas"></canvas>
  <div class="container">
    <div class="row">
      <div class="col-lg-12 col-md-12">
        <div class="timeline-wrap">
          <ul class="timeline timeline--first list-unstyled">
            <li class="timeline-title">
              <!--<h2>2019</h2>-->
              <h2>Features</h2>
            </li>
            <li class="timeline-inner timeline-left py-0">
              <div class="timeline-content">
                <h3>Student registration</h3>
                <p>Register students to a class or students to a subject.</p>
              </div>
            </li>
            <li class="timeline-inner timeline-right py-0">
              <div class="timeline-content">
                <h3>Assessment</h3>
                <p>Simple grade entry and automatic grade processing.</p>
              </div>
            </li>
            <li class="timeline-inner timeline-left py-0">
              <div class="timeline-content">
                <h3>Student record management</h3>
                <p>Keep and track your student records.</p>
              </div>
            </li>
          </ul>
        </div>
        <div class="timeline-wrap pb-5">
          <ul class="timeline list-unstyled">
            <li class="timeline-inner timeline-right py-0">
              <div class="timeline-content">
                <h3>Staff record management</h3>
                <p>Keep and track your staff records.</p>
              </div>
            </li>
            <li class="timeline-inner timeline-left py-0">
              <div class="timeline-content">
                <h3>Announcements</h3>
                <p>Post announcements to students/parents.</p>
              </div>
            </li>
            <li class="timeline-inner timeline-right pt-0">
              <div class="timeline-content">
                <h3>Student and Teachers Panel</h3>
                <p>School web has teachers' and students' panel.</p>
              </div>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>

<!--timeline end-->


<!--feature start-->

<!--<section class="position-relative overflow-hidden text-center">
  <div class="bg-animation">
    <img class="zoom-fade" src="images/pattern/03.png" alt="">
  </div>
  <div class="container">
    <div class="row">
      <div class="col-lg-8 col-md-12 mx-auto">
        <div class="section-title">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-cubes"></i>
          </div>
          <h2 class="title">Our Exciting feature And Service</h2>
          <p>Softino Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderi</p>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-4 col-md-6">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/06.png" alt="">
          </div>
          <div class="featured-title">
            <h5>Design</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 mt-5 mt-md-0">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/07.png" alt="">
          </div>
          <div class="featured-title">
            <h5>Drag And Drop</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/08.png" alt="">
          </div>
          <div class="featured-title">
            <h5>High Resolution</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 mt-5">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/04.png" alt="">
          </div>
          <div class="featured-title">
            <h5>App integration</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 mt-5">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/03.png" alt="">
          </div>
          <div class="featured-title">
            <h5>Marketing</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 mt-5">
        <div class="featured-item style-4">
          <div class="featured-icon">
            <img class="img-fluid" src="images/feature/09.png" alt="">
          </div>
          <div class="featured-title">
            <h5>Helping Support</h5>
          </div>
          <div class="featured-desc">
            <p>Top quality Software services, labore et dolore magna ali qua Lorem ipsum dolor sit amet.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>-->

<!--feature end-->


<!--step start-->

<!--<section class="position-relative overflow-hidden">
  <div class="morph-wrap">
  <svg class="morph" width="1400" height="770" viewBox="0 0 1400 770">
    <path d="M 262.9,252.2 C 210.1,338.2 212.6,487.6 288.8,553.9 372.2,626.5 511.2,517.8 620.3,536.3 750.6,558.4 860.3,723 987.3,686.5 1089,657.3 1168,534.7 1173,429.2 1178,313.7 1096,189.1 995.1,130.7 852.1,47.07 658.8,78.95 498.1,119.2 410.7,141.1 322.6,154.8 262.9,252.2 Z"/>
  </svg>
</div>
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-5 col-md-12 image-column">
        <img class="img-fluid" src="images/about/03.png" alt="">
      </div>
      <div class="col-lg-6 col-md-12 ms-auto mt-5 mt-lg-0">
        <div class="section-title">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-info"></i>
          </div>
          <h2 class="title">Three Simple Step To Started Working Process</h2>
        </div>
        <div class="work-process style-2">
          <div class="step-num-box">
            <div class="step-icon"><span><i class="la la-lightbulb-o"></i></span>
            </div>
            <div class="step-num">01</div>
          </div>
          <div class="step-desc">
          <h4>Research Project</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
        <div class="work-process style-2 mt-5">
          <div class="step-num-box">
            <div class="step-icon"><span><i class="la la-rocket"></i></span>
            </div>
            <div class="step-num">02</div>
          </div>
          <div class="step-desc">
          <h4>Targeting</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
        <div class="work-process style-2 mt-5">
          <div class="step-num-box">
            <div class="step-icon"><span><i class="la la-check-square"></i></span>
            </div>
            <div class="step-num">03</div>
          </div>
          <div class="step-desc">
          <h4>Result</h4>
          <p class="mb-0">Nostrud exercitat ullamco lorem ipsum dolor sit amet, consece adipising elit, sed doeo eiusmod</p>
        </div>
        </div>
      </div>
    </div>
  </div>
</section>-->

<!--step end-->


<!--team start-->

<!--<section class="position-relative overflow-hidden bg-effect">
  <div class="container-fluid p-0">
    <div class="row align-items-center">
      <div class="col-xl-4 col-lg-4 col-md-12 ms-auto ps-5 ps-xl-0">
        <div class="section-title mb-3">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-users"></i>
          </div>
          <h2 class="title">Meet Our Expert team member will ready for your service</h2> 
          <p class="mb-0">Leverage agile frameworks to provide a robust synopsis for high level</p>
        </div>
      </div>
      <div class="col-xl-7 col-lg-8 col-md-12">
        <div class="owl-carousel no-pb owl-nav2" data-dots="false" data-nav="true" data-items="2" data-sm-items="1" data-autoplay="true">
          <div class="item">
            <div class="team-member style-2">
              <div class="team-images">
                <img class="img-fluid rounded box-shadow" src="images/team/01.jpg" alt=""> <a class="team-link" href="team-single.html"><i class="la la-external-link"></i></a>
              </div>
              <div class="team-description"> <span>Manager</span>
                <h5>Jemy Lusto</h5> 
                <div class="social-icons social-colored circle team-social-icon">
                  <ul>
                    <li class="social-facebook"><a href="#"><i class="fab fa-facebook-f"></i></a>
                    </li>
                    <li class="social-twitter"><a href="#"><i class="fab fa-twitter"></i></a>
                    </li>
                    <li class="social-gplus"><a href="#"><i class="fab fa-google-plus-g"></i></a>
                    </li>
                    <li class="social-linkedin"><a href="#"><i class="fab fa-linkedin-in"></i></a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="team-member style-2">
              <div class="team-images">
                <img class="img-fluid rounded box-shadow" src="images/team/02.jpg" alt=""> <a class="team-link" href="team-single.html"><i class="la la-external-link"></i></a>
              </div>
              <div class="team-description"> <span>Manager</span>
                <h5>Tom Roadse</h5> 
                <div class="social-icons social-colored circle team-social-icon">
                  <ul>
                    <li class="social-facebook"><a href="#"><i class="fab fa-facebook-f"></i></a>
                    </li>
                    <li class="social-twitter"><a href="#"><i class="fab fa-twitter"></i></a>
                    </li>
                    <li class="social-gplus"><a href="#"><i class="fab fa-google-plus-g"></i></a>
                    </li>
                    <li class="social-linkedin"><a href="#"><i class="fab fa-linkedin-in"></i></a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="team-member style-2">
              <div class="team-images">
                <img class="img-fluid rounded box-shadow" src="images/team/03.jpg" alt=""> <a class="team-link" href="team-single.html"><i class="la la-external-link"></i></a>
              </div>
              <div class="team-description"> <span>Manager</span>
                <h5>Lana Dior</h5> 
                <div class="social-icons social-colored circle team-social-icon">
                  <ul>
                    <li class="social-facebook"><a href="#"><i class="fab fa-facebook-f"></i></a>
                    </li>
                    <li class="social-twitter"><a href="#"><i class="fab fa-twitter"></i></a>
                    </li>
                    <li class="social-gplus"><a href="#"><i class="fab fa-google-plus-g"></i></a>
                    </li>
                    <li class="social-linkedin"><a href="#"><i class="fab fa-linkedin-in"></i></a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="team-member style-2">
              <div class="team-images">
                <img class="img-fluid rounded box-shadow" src="images/team/04.jpg" alt=""> <a class="team-link" href="team-single.html"><i class="la la-external-link"></i></a>
              </div>
              <div class="team-description"> <span>Manager</span>
                <h5>James Lynn</h5> 
                <div class="social-icons social-colored circle team-social-icon">
                  <ul>
                    <li class="social-facebook"><a href="#"><i class="fab fa-facebook-f"></i></a>
                    </li>
                    <li class="social-twitter"><a href="#"><i class="fab fa-twitter"></i></a>
                    </li>
                    <li class="social-gplus"><a href="#"><i class="fab fa-google-plus-g"></i></a>
                    </li>
                    <li class="social-linkedin"><a href="#"><i class="fab fa-linkedin-in"></i></a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>-->

<!--team end-->

<!--clients start-->

<section class="custom-mt-15 grey-bg z-index-0 custom-pt-18 pb-3">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="owl-carousel" data-dots="false" data-items="4" data-md-items="3" data-sm-items="2" data-margin="30" data-autoplay="true">
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/07.png" alt="">
            </div>
          </div>
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/08.png" alt="">
            </div>
          </div>
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/09.png" alt="">
            </div>
          </div>
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/10.png" alt="">
            </div>
          </div>
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/11.png" alt="">
            </div>
          </div>
          <div class="item">
            <div class="clients-logo">
              <img class="img-fluid d-inline" src="images/client/12.png" alt="">
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!--clients end-->

<!--pricing start-->

<section class="dark-bg position-relative overflow-hidden" id="pricing">
  <div class="bg-animation">
    <img class="zoom-fade" src="images/pattern/03.png" alt="">
  </div>
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-md-12">
        <div class="section-title">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-money"></i>
          </div>
          <h2 class="title">Choose affordable prices</h2>
          <p class="text-white">Softino Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderi</p>
        </div>
      </div>
    </div>
    <div class="row align-items-center">
      <div class="col-lg-4 col-md-12">
        <div class="price-table style-2">
          <div class="price-inside">Starter</div>
          <div class="price-header">
            <div class="price-value">
              <h2><span>$</span>20</h2>
              <span>Per Term</span>
            </div>
            <h3 class="price-title">Starter</h3> 
          </div>
          <div class="price-list">
            <ul class="list-unstyled">
              <li>15 Analytics Compaign</li>
              <li>Unlimited Site licenses</li>
              <li>1 Database</li>
              <li>10 Free Optimization</li>
              <li>Html5 + Css3</li>
              <li>24/7 Customer Support</li>
            </ul>
          </div>
          <a class="btn btn-theme btn-circle mt-4" href="#" data-text="Purchase Now"> <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
            <span> </span><span>N</span><span>o</span><span>w</span>
          </a>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="price-table style-2 active">
          <div class="price-inside">Premium</div>
          <div class="price-header">
            <div class="price-value">
              <h2><span>$</span>50</h2>
              <span>Per Term</span>
            </div>
            <h3 class="price-title">Premium</h3> 
          </div>
          <a class="btn btn-theme btn-circle my-4" href="#" data-text="Purchase Now"> <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
            <span> </span><span>N</span><span>o</span><span>w</span>
          </a>
          <div class="price-list">
            <ul class="list-unstyled">
              <li>15 Analytics Compaign</li>
              <li>Unlimited Site licenses</li>
              <li>1 Database</li>
              <li>10 Free Optimization</li>
              <li>Html5 + Css3</li>
              <li>24/7 Customer Support</li>
            </ul>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="price-table style-2">
          <div class="price-inside">Professional</div>
          <div class="price-header">
            <div class="price-value">
              <h2><span>$</span>70</h2>
              <span>Per Term</span>
            </div>
            <h3 class="price-title">Professional</h3> 
          </div>
          <div class="price-list">
            <ul class="list-unstyled">
              <li>15 Analytics Compaign</li>
              <li>Unlimited Site licenses</li>
              <li>1 Database</li>
              <li>10 Free Optimization</li>
              <li>Html5 + Css3</li>
              <li>24/7 Customer Support</li>
            </ul>
          </div>
          <a class="btn btn-theme btn-circle mt-4" href="#" data-text="Purchase Now"> <span>P</span><span>u</span><span>r</span><span>c</span><span>h</span><span>a</span><span>s</span><span>e</span>
            <span> </span><span>N</span><span>o</span><span>w</span>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!--pricing end-->

<!--testimonial start-->

<section class="grey-bg position-relative overflow-hidden" data-bg-img="images/pattern/01.png" id="testimonials">
  <div class="wave-shape">
    <img class="img-fluid" src="images/bg/03.png" alt="">
  </div>
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-md-12">
        <div class="section-title">
          <div class="title-effect">
            <div class="bar bar-top"></div>
            <div class="bar bar-right"></div>
            <div class="bar bar-bottom"></div>
            <div class="bar bar-left"></div>
          </div>
          <h6>Testimonial</h6>
          <h2 class="title">You Can See our users feedback What You Say?</h2> 
        </div>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-md-12">
        <div id="testimonial-1" class="testimonial-carousel carousel slide" data-bs-ride="carousel" data-bs-interval="2500">
          <!-- Wrapper for slides -->
          <div class="row align-items-center">
            <div class="col-lg-7 col-md-12">
              <div class="carousel-inner">
                <div class="carousel-item active">
                  <div class="testimonial style-1">
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Professional recommended and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>Head master</label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="carousel-item">
                  <div class="testimonial style-1">
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Recommended Professional and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>Teacher</label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="carousel-item">
                  <div class="testimonial style-1">
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Consectetur Recommended Professional and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>Head Master</label>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- End Item -->
              </div>
              <!-- End Carousel Inner -->
            </div>
            <div class="col-lg-5 col-md-12 mt-5 mt-lg-0">
              <div class="controls">
                <div class="anti-01-holder"><div class="anti-01"></div></div>
                <div class="anti-02-holder"><div class="anti-02"></div></div>
                <div class="anti-03-holder"><div class="anti-03"></div></div>
                <ul class="nav">
                  <li data-bs-target="#testimonial-1" data-bs-slide-to="0" class="active">
                    <a href="#">
                      <img class="img-fluid" src="images/testimonial/teacher-1.jpg" alt="">
                    </a>
                  </li>
                  <li data-bs-target="#testimonial-1" data-bs-slide-to="1">
                    <a href="#">
                      <img class="img-fluid" src="images/testimonial/teacher-2.jpg" alt="">
                    </a>
                  </li>
                  <li data-bs-target="#testimonial-1" data-bs-slide-to="2">
                    <a href="#">
                      <img class="img-fluid" src="images/testimonial/teacher-3.jpg" alt="">
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </div>
  </div>
</section>

<!--testimonial end-->




<!--testimonial start-->

<!--<section class="position-relative overflow-hidden text-center">
  <canvas id="confetti"></canvas>
  <div class="container">
    <div class="row">
      <div class="col-xl-6 col-lg-8 col-md-10 mx-auto">
        <div class="section-title">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-question-circle"></i>
          </div>
          <h2 class="title">You Can See our clients feedback What You Say?</h2> 
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div id="testimonial-2" class="testimonial-carousel carousel slide testimonial-2" data-bs-ride="carousel" data-bs-interval="2500">
          <!-- Wrapper for slides --
          <div class="row">
            <div class="col-md-8 mx-auto">
              <div class="carousel-inner">
                <div class="carousel-item active">
                  <div class="testimonial style-2">
                    <div class="testimonial-img">
                      <img class="img-fluid zoom-fade" src="images/testimonial/01.jpg" alt="">
                    </div>
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Professional recommended and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>CEO of Softino</label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="carousel-item">
                  <div class="testimonial style-2">
                    <div class="testimonial-img">
                      <img class="img-fluid zoom-fade" src="images/testimonial/02.jpg" alt="">
                    </div>
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Recommended Professional and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, Consectetur adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>CEO of Softino</label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="carousel-item">
                  <div class="testimonial style-2">
                    <div class="testimonial-img">
                      <img class="img-fluid zoom-fade" src="images/testimonial/03.jpg" alt="">
                    </div>
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Professional Recommended crofessional and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, adipisicing elit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>CEO of Softino</label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="carousel-item">
                  <div class="testimonial style-2">
                    <div class="testimonial-img">
                      <img class="img-fluid zoom-fade" src="images/testimonial/04.jpg" alt="">
                    </div>
                    <div class="testimonial-content">
                      <div class="testimonial-quote"><i class="la la-quote-left"></i>
                      </div>
                      <p>Consectetur Recommended Professional and great experience, Nam pulvinar vitae neque et porttitor, Praesent sed nisi eleifend, adipisicing elitelit, sed do eiusmodas temporo incididunt Praesent sed nisi eleifend, Consectetur adipisicing elit,</p>
                      <div class="testimonial-caption">
                        <h5>Lana Roadse</h5>
                        <label>CEO of Softino</label>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- End Item --
              </div>
              <!-- End Carousel Inner --
            </div>
          </div>
          <div class="controls">
            <ul class="nav">
              <li data-bs-target="#testimonial-2" data-bs-slide-to="0" class="active">
                <a href="#">
                  <img class="img-fluid" src="images/testimonial/01.jpg" alt="">
                </a>
              </li>
              <li data-bs-target="#testimonial-2" data-bs-slide-to="1">
                <a href="#">
                  <img class="img-fluid" src="images/testimonial/02.jpg" alt="">
                </a>
              </li>
              <li data-bs-target="#testimonial-2" data-bs-slide-to="2">
                <a href="#">
                  <img class="img-fluid" src="images/testimonial/03.jpg" alt="">
                </a>
              </li>
              <li data-bs-target="#testimonial-2" data-bs-slide-to="3">
                <a href="#">
                  <img class="img-fluid" src="images/testimonial/04.jpg" alt="">
                </a>
              </li>
            </ul>
          </div>
        </div>
        <!-- End Carousel --
      </div>
    </div>
  </div>
</section>-->

<!--testimonial end-->


<!--counter start-->

<!--<section class="position-relative">
  <div class="hexagon-bg">
    <div class="hexagon"></div>
    <div class="hexagon"></div>
    <div class="hexagon"></div>
    <div class="hexagon"></div>
  </div>
  <div class="container">
    <div class="row">
      <div class="col-lg-3 col-md-6">
        <div class="counter">
          <div class="counter-icon">
          <img class="img-fluid" src="images/counter/01.png" alt="">
        </div>
        <div class="counter-desc">
         <span class="count-number" data-to="2304" data-speed="10000">2304</span>
          <h5>Project Done</h5>
        </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 mt-5 mt-md-0">
        <div class="counter">
          <div class="counter-icon">
          <img class="img-fluid" src="images/counter/02.png" alt="">
        </div>
        <div class="counter-desc">
         <span class="count-number" data-to="3585" data-speed="10000">3585</span>
          <h5>Success Rate</h5>
        </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 mt-5 mt-lg-0">
        <div class="counter">
          <div class="counter-icon">
          <img class="img-fluid" src="images/counter/03.png" alt="">
        </div>
        <div class="counter-desc">
         <span class="count-number" data-to="1365" data-speed="10000">1365</span>
          <h5>Awards</h5>
        </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 mt-5 mt-lg-0">
        <div class="counter">
          <div class="counter-icon">
          <img class="img-fluid" src="images/counter/04.png" alt="">
        </div>
        <div class="counter-desc">
         <span class="count-number" data-to="4328" data-speed="10000">4328</span>
          <h5>Happy Client</h5>
        </div>
        </div>
      </div>
    </div>
  </div>
</section>-->

<!--counter end-->


<!--blog start-->

<!--<section class="position-relative overflow-hidden">
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-md-12">
        <div class="section-title">
          <div class="title-effect title-effect-2">
            <div class="ellipse"></div> <i class="la la-btc"></i>
          </div>
          <h2 class="title">Creative Blogs</h2>
          <p>Softino Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderi</p>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-4 col-md-12">
        <div class="post">
          <div class="post-image">
            <img class="img-fluid h-100 w-100" src="images/blog/01.jpg" alt=""> <a class="post-categories" href="#">Photo</a>
          </div>
          <div class="post-desc">
            <div class="post-meta">
              <ul class="list-inline">
                <li><i class="la la-calendar me-1"></i> 23 Jan, 2019</li>
                <li><i class="la la-user me-1"></i> By ThemeHt</li>
              </ul>
            </div>
            <div class="post-title">
              <h4><a href="blog-single.html">Softino Performance Based Software</a></h4>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="post">
          <div class="post-image">
            <img class="img-fluid h-100 w-100" src="images/blog/02.jpg" alt=""> <a class="post-categories" href="#">Photo</a>
          </div>
          <div class="post-desc">
            <div class="post-meta">
              <ul class="list-inline">
                <li><i class="la la-calendar me-1"></i> 23 Jan, 2019</li>
                <li><i class="la la-user me-1"></i> By ThemeHt</li>
              </ul>
            </div>
            <div class="post-title">
              <h4><a href="blog-single.html">latest Software design in features</a></h4>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-12 mt-5 mt-lg-0">
        <div class="post">
          <div class="post-image">
            <img class="img-fluid h-100 w-100" src="images/blog/03.jpg" alt=""> <a class="post-categories" href="#">Photo</a>
          </div>
          <div class="post-desc">
            <div class="post-meta">
              <ul class="list-inline">
                <li><i class="la la-calendar me-1"></i> 23 Jan, 2019</li>
                <li><i class="la la-user me-1"></i> By ThemeHt</li>
              </ul>
            </div>
            <div class="post-title">
              <h4><a href="blog-single.html">All Powerful Design feature In Softino</a></h4>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>-->

<!--blog end-->

</div>

<!--body content end--> 


<!--footer start-->

<?php include("main_footer.php"); ?>

<!--footer end-->


</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-go-up-in-web"></i></a></div>

<!--back-to-top end-->

 
<!-- inject js start -->

<!--== jquery -->
<script src="js/theme.js"></script>

<!--== owl-carousel -->
<script src="js/owl-carousel/owl.carousel.min.js"></script> 

<!--== magnific-popup --> 
<script src="js/magnific-popup/jquery.magnific-popup.min.js"></script>

<!--== counter -->
<script src="js/counter/counter.js"></script> 

<!--== countdown -->
<script src="js/countdown/jquery.countdown.min.js"></script> 

<!--== canvas -->
<script src="js/canvas.js"></script>

<!--== confetti -->
<script src="js/confetti.js"></script>

<!--== step animation -->
<script src="js/snap.svg.js"></script>
<script src="js/step.js"></script>

<!--== contact-form -->
<script src="js/contact-form/contact-form.js"></script>

<!--== wow -->
<script src="js/wow.min.js"></script>

<!--== theme-script -->
<script src="js/theme-script.js"></script>

<script src="assets/js/universal.js?<?php echo time(); ?>"></script>
<script src="assets/js/js.js?<?php echo time(); ?>"></script>

<!-- inject js end -->

</body>

</html>