<?php
	require_once("classes/main_classes.php");

	//OBJECTS
	$retrieveObj=new RETRIEVE();
?>

<!DOCTYPE html>
<html>
	<head>
		<title>Register - School Web</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<meta name="format-detection" content="telephone=no">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<!-- Fonts-->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
		<link rel="stylesheet" type="text/css" href="assets/fonts/themify-icons/themify-icons.css">
		<!-- Vendors-->
		<link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap/css/bootstrap-grid.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/magnific-popup/magnific-popup.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/owl.carousel/owl.carousel.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/_jquery/jquery.min.css">
		<!-- <link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap4/bootstrap-grid.min.css"> -->
		<!-- <link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap4/bootstrap-grid.min.css"> -->
		<!-- App & fonts-->
		<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,300i,400,400i,700,700i&amp;amp;subset=latin-ext">
		<link rel="stylesheet" type="text/css" href="assets/css/main.css"><!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<![endif]-->
		<link rel="stylesheet" type="text/css" href="assets/css/register.css">
		<link rel="stylesheet" type="text/css" href="assets/css/universal.css">
	</head>
	
	<body>
		<div class="container register-container">
      <div class="row">
        <div class="col-md-3 ads text-center">
        	<a href="index.php" class="btn">
        		<img class="shadow rounded-circle " src="assets/img/logos/swb_logo.png" alt="" style="max-height: 100px;" />
        	</a>
            <h5 class="my-2">About SchoolWeb</h5>
            <p>
            	SchoolWeb is highly acclaimed school data management software. Make your school data management easy with SchoolWeb. Make your school world class! 
            </p>
            
        </div>
        <div class="col-md-9 register-form">
          <!--div class="profile-img mt-2">
            <span class="fas fa-user fa-3x"></span>
          </div-->
          <h4 class="text-center mt-4">Register a school</h4>
          <p class="text-center">Registration is FREE*. Register Now.</p>
          <div class="text-center mb-2">
          	<a href="#!" class="text-primary" id="user_information_link" onclick="user_information_content_view()">Your Information</a>
          	|
          	<a href="#!" class="text-dark" id="school_information_link" onclick="school_information_content_view()">School Information</a>
          </div>
          <form id="register_school_form">
          	<!--User Information-->
          	<div class="row" id="user_information_content">
          		<div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="email" class="form-control" name="email" id="email" placeholder="Email*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="tel" class="form-control" name="phone" id="phone" placeholder="Phone*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="username" id="username" placeholder="Username*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="firstname" id="firstname" placeholder="First name*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="lastname" id="lastname" placeholder="Last name*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <select name="gender" id="gender">
	              	<option selected disabled>Gender</option>
	              	<option value="M">Male</option>
	              	<option value="F">Female</option>
	              </select>
	            </div>
	            
	            <div class="col-md-12" id="user_information_content_response">
	            	
	            </div>
	            <div class="col-md-12">
	            	<p class="text-danger py-2">*Note: This account is for only those who own a school.</p>
		            <div class="form-group mt-2 text-center">
		              <a href="#!" class="btn btn-primary btn-lg" onclick="school_information_content_view()">NEXT</a>
		            </div>
		            <div class="form-group mt-2 text-center">
		              Already have an account ? <a class="text-primary" href="login.php">Login</a>
		            </div>
	            </div>
          	</div>
          	<!--School Information-->
          	<div class="row" style="display: none;" id="school_information_content">
          		<div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="school_name" id="school_name" placeholder="School Name*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="school_name_initials" id="school_name_initials" placeholder="School Name Initials">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="school_email" id="school_email" placeholder="School Email*">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="tel" class="form-control" name="school_telphone" id="school_telphone" placeholder="School Telephone">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <input type="text" class="form-control" name="school_phone_number" id="school_phone_number" placeholder="School phone number">
	            </div>
	            <div class="form-group col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
	              <select name="school_type" id="school_type">
	              	<option selected disabled>School Type*</option>
	              	<?php
	              		$get_school_types=$retrieveObj->retriever("SchoolTypes","*","fetchAll");

	              		if($get_school_types!="1020"){
	              			foreach ($get_school_types as $school_type) {
	              	?>
	              			<option value="<?php echo $school_type->TypeID ?>"><?php echo $school_type->Type ?></option>
	              	<?php
	              			}
	              		}
	              	?>
	              </select>
	            </div>
	            <div class="input-group col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
	            	<input type="checkbox" name="terms_and_conditions">
	            	<label class="input-group-append mb-2">&nbsp; I agree with the <a href="terms_and_conditions.php" class="text-primary" target="_blank">Terms and Conditions</a></label> 
	            </div>
	            <div class="col-md-12" >
	            	<p class="text-danger py-2">*Note: This account is for only those who own a school.</p>
	            </div>
	            <div class="col-md-12" id="school_information_content_response">
	            	
	            </div>

	            <div class="col-md-12">
	            	<input type="hidden" name="register_school_note">
		            <div class="form-group mt-2 d-flex justify-content-between">
		              <a href="#!" class="btn btn-primary btn-lg" onclick="user_information_content_view()"> BACK</a>
		              <button type="submit" class="btn btn-primary btn-lg" onclick="register_school()">FINISH</button>
		            </div>
		            <div class="form-group mt-2 text-center">
		              Already have an account ? <a class="text-primary" href="login.php">Login</a>
		            </div>
	            </div>
          	</div>
          </form>
        </div>
      </div>
    </div>
		<!-- Vendors-->
		<script type="text/javascript" src="assets/vendors/jquery/jquery.min.js"></script>
		<script type="text/javascript" src="assets/vendors/imagesloaded/imagesloaded.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/isotope-layout/isotope.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countdown/jquery.countdown.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countTo/jquery.countTo.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countUp/jquery.countup.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.matchHeight/jquery.matchHeight.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.mb.ytplayer/jquery.mb.YTPlayer.min.js"></script>
		<script type="text/javascript" src="assets/vendors/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script type="text/javascript" src="assets/vendors/masonry-layout/masonry.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/owl.carousel/owl.carousel.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.waypoints/jquery.waypoints.min.js"></script>
		<script type="text/javascript" src="assets/vendors/menu/menu.min.js"></script>
		<script type="text/javascript" src="assets/vendors/smoothscroll/SmoothScroll.min.js"></script>
		<!-- App-->
		<script type="text/javascript" src="assets/js/main.js?<?php echo date("Y-m-d").time() ?>"></script>

		<script type="text/javascript" src="assets/js/universal.js?<?php echo date("Y-m-d").time() ?>"></script>
		<script type="text/javascript" src="assets/js/js.js?<?php echo date("Y-m-d").time() ?>"></script>
	</body>
</html>