<?php
  require_once("classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $rowcountObj=new ROWCOUNT();

  //PAGE LOCATION VARIABLES
  $plv_home=" active ";
  $plv_products="";
  $plv_miscellaneous_goods="";
  $plv_blog="";
  $plv_about="";
  $plv_contact="";

  $get_latest_news=$retrieveObj->retriever("blog JOIN blog_categories ON blog_categories.b_category_id=blog.b_category_id ORDER BY b_id DESC LIMIT 3","*","fetchAll");
?>




<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Provama</title>
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <meta content="Product value making, Provama, Prof Stanley Chindikani Msiska" name="keywords">
  <meta content="Product value making. Established in 2020 by Prof Stanley Chindikani Msiska. Provama is an innovation, product and service development and delivery company that deals with creation of value to wide range of natural, agricultural, food, chemical and biological products; converting them into products of higher value." name="description">

  <!-- Favicons -->
  <link href="img/provama_logo.png" rel="icon">
  

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,400i,600,700|Raleway:300,400,400i,500,500i,700,800,900" rel="stylesheet">

  <!-- Bootstrap CSS File -->
  <link href="lib/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="lib/bootstrap/css/custom_bootstrap.css" rel="stylesheet">

  <!-- Libraries CSS Files -->
  <link href="lib/nivo-slider/css/nivo-slider.css" rel="stylesheet">
  <link href="lib/owlcarousel/owl.carousel.css" rel="stylesheet">
  <link href="lib/owlcarousel/owl.transitions.css" rel="stylesheet">
  <link href="lib/font-awesome/css/font-awesome.min.css" rel="stylesheet">
  <link href="lib/animate/animate.min.css" rel="stylesheet">
  <link href="lib/venobox/venobox.css" rel="stylesheet">

  <!-- Nivo Slider Theme -->
  <link href="css/nivo-slider-theme.css" rel="stylesheet">

  <!-- Main Stylesheet File -->
  <link href="css/style.css" rel="stylesheet">

  <!-- Responsive Stylesheet File -->
  <link href="css/responsive.css" rel="stylesheet">

  <!-- =======================================================
    Theme Name: eBusiness
    Theme URL: https://bootstrapmade.com/ebusiness-bootstrap-corporate-template/
    Author: BootstrapMade.com
    License: https://bootstrapmade.com/license/
  ======================================================= -->
</head>

<body data-spy="scroll" data-target="#navbar-example">

  <div id="preloader"></div>

  <?php include("main_header.php"); ?>

  <!-- Start Slider Area -->
  <div id="home" class="slider-area">
    <div class="bend niceties preview-2">
      <div id="ensign-nivoslider" class="slides">
        <img src="img/slider/slider1.jpg" alt="" title="#slider-direction-1" />
        <!--img src="img/slider/slider2.jpg" alt="" title="#slider-direction-2" />
        <img src="img/slider/slider3.jpg" alt="" title="#slider-direction-3" /-->
      </div>

      <!-- direction 1 -->
      <div id="slider-direction-1" class="slider-direction slider-one">
        <div class="container">
          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="slider-content">
                <!-- layer 1 -->
                <div class="layer-1-1 hidden-xs wow slideInDown" data-wow-duration="2s" data-wow-delay=".2s">
                  <h2 class="title1">Product Value Creation </h2>
                </div>
                <!-- layer 2 -->
                <div class="layer-1-2 wow slideInUp" data-wow-duration="2s" data-wow-delay=".1s">
                  <h1 class="title2">Creating higher value form various products.</h1>
                </div>
                <!-- layer 3 -->
                <div class="layer-1-3 hidden-xs wow slideInUp" data-wow-duration="2s" data-wow-delay=".2s">
                  <a class="ready-btn right-btn page-scroll" href="#products">Products</a>
                  <a class="ready-btn page-scroll" href="about.php">Learn More</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- direction 2 -->
      <!--div id="slider-direction-2" class="slider-direction slider-two">
        <div class="container">
          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="slider-content text-center">
                <!-- layer 1 --
                <div class="layer-1-1 hidden-xs wow slideInUp" data-wow-duration="2s" data-wow-delay=".2s">
                  <h2 class="title1">The Best Business Information </h2>
                </div>
                <!-- layer 2 --
                <div class="layer-1-2 wow slideInUp" data-wow-duration="2s" data-wow-delay=".1s">
                  <h1 class="title2">We're In The Business Of Get Quality Business Service</h1>
                </div>
                <!-- layer 3 --
                <div class="layer-1-3 hidden-xs wow slideInUp" data-wow-duration="2s" data-wow-delay=".2s">
                  <a class="ready-btn right-btn page-scroll" href="#services">See Services</a>
                  <a class="ready-btn page-scroll" href="#about">Learn More</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div-->

      <!-- direction 3 --
      <div id="slider-direction-3" class="slider-direction slider-two">
        <div class="container">
          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="slider-content">
                <!-- layer 1 --
                <div class="layer-1-1 hidden-xs wow slideInUp" data-wow-duration="2s" data-wow-delay=".2s">
                  <h2 class="title1">The Best business Information </h2>
                </div>
                <!-- layer 2 --
                <div class="layer-1-2 wow slideInUp" data-wow-duration="2s" data-wow-delay=".1s">
                  <h1 class="title2">Helping Business Security  & Peace of Mind for Your Family</h1>
                </div>
                <!-- layer 3 --
                <div class="layer-1-3 hidden-xs wow slideInUp" data-wow-duration="2s" data-wow-delay=".2s">
                  <a class="ready-btn right-btn page-scroll" href="#services">See Services</a>
                  <a class="ready-btn page-scroll" href="#about">Learn More</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div-->
    </div>
  </div>
  <!-- End Slider Area -->

  <!-- Start Service area -->
  <section id="products">
    <div id="services" class="services-area area-padding">
      <div class="container">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="section-headline services-head text-center">
              <h2>Products</h2>
            </div>
          </div>
        </div>
        <div class="row text-center">
          <div class="services-contents">
            <!-- Start Left services -->
            <div class="col-md-4 col-sm-4 col-xs-12">
              <div class="about-move">
                <div class="services-details">
                  <div class="single-services">
                    <a class="services-icon" href="food_products.php">
                        <img src="img/icons/food_product.png" style="max-height: 40px;" alt="Food products icon">
                      </a>
                    <h4><a href="food_products.php">Food products</a></h4>
                    <p>
                      Beverages, cooking oil, porridges, biscuits, cookies etc.
                    </p>
                  </div>
                </div>
                <!-- end about-details -->
              </div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <div class="about-move">
                <div class="services-details">
                  <div class="single-services">
                    <a class="services-icon" href="chemical_products.php">
                        <img src="img/icons/chemical_product.png" style="max-height: 40px;" alt="Food products icon">
                      </a>
                    <h4><a href="chemical_products.php">Chemical products</a></h4>
                    <p>
                      Cosmetics, fertilizer, soaps, liquid dish washer, shammpoo, fertilizer blending, lotion ,etc.
                    </p>
                  </div>
                </div>
                <!-- end about-details -->
              </div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <!-- end col-md-4 -->
              <div class=" about-move">
                <div class="services-details">
                  <div class="single-services">
                    <a class="services-icon" href="tech_products.php">
                        <img src="img/icons/tech_product.png" style="max-height: 40px;" alt="Food products icon">
                      </a>
                    <h4><a href="tech_products.php">Tech products</a></h4>
                    <p>
                      Tools and equipment innovation and fabrication like alcohol detector, gnut flour making machine, duster, etc.
                    </p>
                  </div>
                </div>
                <!-- end about-details -->
              </div>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12">
              <hr>
              <!-- end col-md-4 -->
              <div class=" about-move">
                <div class="services-details">
                  <div class="single-services">
                    <a class="services-icon" href="miscellaneous_goods.php">
                        <img src="img/icons/cargo.png" style="max-height: 40px;" alt="Food products icon">
                      </a>
                    <h4><a href="miscellaneous_goods.php">Miscellaneous goods</a></h4>
                    <p>
                      We are not limited to other goods like shoes, clothes, etc.
                    </p>
                  </div>
                </div>
                <!-- end about-details -->
              </div>
            </div>
          </div>
        </div>
        
      </div>
    </div>
  </section>
    
  <!-- End Service area -->

  <!-- Start About area -->
  <div id="about" class="about-area area-padding">
    <div class="container">
      <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
          <div class="section-headline text-center">
            <h2>MISSION & VISION</h2>
          </div>
        </div>
      </div>
      <div class="row">
        <!-- single-well start-->
        <div class="col-md-6 col-sm-6 col-xs-12">
          <div class="well-left">
            <div class="single-well">
              <a href="#">
                  <img src="img/vision.jpg" alt="">
                </a>
            </div>
          </div>
        </div>
        <!-- single-well end-->
        <div class="col-md-6 col-sm-6 col-xs-12">
          <div class="well-middle">
            <div class="single-well">
              <h6>MISSION</h6>
              <p>
                Provama’s mission is to facilitate Malawi’s and Africa’s economic growth and transformation through value addition to resources by transforming them into more valuable products that can contribute more to life and be sold at higher prices.
              </p>
              <h6>OUR VISION</h6>
              <p>
                The vision of Provama is to be Malawi’s leading company in products making, value addition and service delivery by 2025 and be global leader in products value addition and service delivery by 2030.
              </p>
            </div>
          </div>
        </div>
        <!-- End col-->
      </div>
    </div>
  </div>
  <!-- End About area -->

  <!-- Start Blog Area -->
  <div id="blog" class="blog-area">
    <div class="blog-inner area-padding">
      <div class="blog-overly"></div>
      <div class="container ">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="section-headline text-center">
              <h2>Latest News</h2>
            </div>
          </div>
        </div>
        <div class="row">
          <?php
            if($get_latest_news!="1020"){
              foreach ($get_latest_news as $latest_news) {
          ?>
                <!-- Start Left Blog -->
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <div class="single-blog">
                    <div class="single-blog-img">
                      <a href="blog.html">
                          <img src="img/blogs/<?php echo $latest_news->b_image ?>" alt="">
                        </a>
                    </div>
                    <div class="blog-meta">
                      <span class="comments-type">
                          <i class="fa fa-comment-o"></i>
                          <a href="#"><?php echo $rowcountObj->rowcounter("blog_comments","*","b_id",$latest_news->b_id); ?> comment/s</a>
                        </span>
                      <span class="date-type">
                          <i class="fa fa-calendar"></i>
                          <?php
                            echo date("M j, Y", strtotime($latest_news->b_date_posted)) ;
                            echo " / ";
                            echo date("H:i A", strtotime($latest_news->b_date_posted)) ;
                          ?>
                        </span>
                    </div>
                    <div class="blog-text">
                      <h4>
                          <a href="blog.php?read_more=<?php echo $latest_news->b_id; ?>" ><?php echo $latest_news->b_title ?></a>
                      </h4>
                      <div class="view-6-lines text-justify">
                        <?php echo $latest_news->b_body ?>
                      </div>
                    </div>
                    <span>
                        <a href="blog.php?read_more=<?php echo $latest_news->b_id; ?>" class="ready-btn">Read more</a>
                      </span>
                  </div>
                  <!-- Start single blog -->
                </div>
                <!-- End Left Blog-->
          <?php
              }
            }
          ?>
        </div>
      </div>
    </div>
  </div>
  <!-- End Blog -->

  <?php include("main_footer.php"); ?>

  <a href="#" class="back-to-top"><i class="fa fa-chevron-up"></i></a>

  <!-- JavaScript Libraries -->
  <script src="lib/jquery/jquery.min.js"></script>
  <script src="lib/bootstrap/js/bootstrap.min.js"></script>
  <script src="lib/owlcarousel/owl.carousel.min.js"></script>
  <script src="lib/venobox/venobox.min.js"></script>
  <script src="lib/knob/jquery.knob.js"></script>
  <script src="lib/wow/wow.min.js"></script>
  <script src="lib/parallax/parallax.js"></script>
  <script src="lib/easing/easing.min.js"></script>
  <script src="lib/nivo-slider/js/jquery.nivo.slider.js" type="text/javascript"></script>
  <script src="lib/appear/jquery.appear.js"></script>
  <script src="lib/isotope/isotope.pkgd.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD8HeI8o-c1NppZA-92oYlXakhDPYR7XMY"></script>

  <!-- Contact Form JavaScript File -->
  <script src="contactform/contactform.js"></script>

  <script src="js/main.js"></script>
  <script src="js/universal.js?<?php echo date("Y-m-d").time() ?>"></script> 
  <script src="js/js.js?<?php echo date("Y-m-d").time() ?>"></script> 
</body>

</html>
