<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_miscellaneous_goods=$retrieveObj->retriever("miscellaneous_goods 
			JOIN miscellaneous_good_images ON miscellaneous_good_images.mg_id=miscellaneous_goods.mg_id
			WHERE miscellaneous_goods.mg_status='deleted' and miscellaneous_good_images.mg_image_type='primary_image'
			GROUP BY miscellaneous_goods.mg_id ORDER BY miscellaneous_goods.mg_id DESC","DISTINCT *","fetchAll");
?>


<h4 class="page-title">
	<span class="la la-cubes"></span>
	Miscellaneous
</h4>
<p><a href="#" class="bold" onclick="miscellaneous_goods_view()">Miscellaneous good</a> <span class="fas fa-angle-right"></span> Removed miscellaneous goods</p>
<div class="row">
	<div class="col-md-12 mb-3">
		<p class="font-weight-bold mb-2 text-right">
			<span>
				<a href="#!" class="text-primary font-weight-normal mx-2" onclick="add_miscellaneous_good_view()"><span class="fas fa-plus"></span> Add miscellaneous good</a>
	          <a href="#!" class="text-danger font-weight-normal mx-2" onclick="miscellaneous_goods_trash_view()"><span class="fas fa-trash"></span> Removed miscellaneous goods</a>
			</span>  
 		</p>
 		<table class="table table-head-bg-primary mt-4" id="miscellaneous_goods_table">
			<thead>
				<tr>
          <th scope="col">Photo</th>
          <th scope="col">Name</th>
          <th scope="col">Price</th>
          <th scope="col">Date added</th>
          <th scope="col"></th>
        </tr>
			</thead>
			<tbody>
				<?php
                    
          if($get_miscellaneous_goods!="1020"){
            $element_id="element_id";
              foreach ($get_miscellaneous_goods as $miscellaneous_good) {
                $element_id=$element_id."Ot";
        ?>  
            <tr id="<?php echo $element_id ?>">         
              <td class="text-center">
                <?php
                  if(!empty($miscellaneous_good->mg_image)){
                    echo $image='<img class="m-1" style="max-height:40px;" src="../img/miscellaneous_goods/'.$miscellaneous_good->mg_image.'?timestamp'.time().'" alt="miscellaneous good img"/>';
                  }else{
                    echo "<span class='fas fa-cube fa-2x'></span>";
                  }
                ?>
              </td>
              <td>
                <?php 
                  echo $miscellaneous_good->mg_name;
                ?>
              </td>
              <td>
                <?php 
                  echo $miscellaneous_good->mg_price;
                ?>
              </td>
              <td>
                <?php 
                  echo date("d-m-Y H:i:s", strtotime($miscellaneous_good->mg_date_added));
                ?>
              </td>
              <td id="<?php echo $element_id.'Dbtn' ?>">
                 	<div class="">
                      <form id="<?php echo 'R'.$element_id.'formI' ?>" class="mb-0 hand_cursor" style="display: inline;">
                          <input type="hidden" name="restore_miscellaneous_good_note" value="<?php echo $miscellaneous_good->mg_id; ?>">
                          <button id="<?php echo $element_id.'Rbtn' ?>" onclick="restore_miscellaneous_good('<?php echo 'R'.$element_id.'formI' ?>','<?php echo $element_id; ?>','r_miscellaneous_good_response')" type="submit" title="Restore" class="btn btn-success hand_cursor"><span class="fas fa-sync"></span> Restore</button>
                      </form>
                      <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                          <input type="hidden" name="delete_miscellaneous_good_note" value="<?php echo $miscellaneous_good->mg_id; ?>">
                          <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_miscellaneous_good('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','r_miscellaneous_good_response')" type="submit" title="Delete" class="btn btn-danger hand_cursor"><span class="fas fa-times "></span> Delete</button>
                      </form>
                      
                    </div>       
              </td>
            </tr>
          <?php
              }
            }
          ?>
				
			</tbody>
		</table>
	</div>
</div>
<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#miscellaneous_goods_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ]
    });
  })
</script>