<?php
    require_once("../session_check.php");

    if($sign_in_status=="in"){
        header("../location:index.php");
    }

    include("../../classes/main_classes.php");

    //OBJECTS
    $retrieveObj=new RETRIEVE();

    $email="";
    $key="";
    if(isset($_GET['email']) and !empty($_GET['email']) and isset($_GET['key']) and !empty($_GET['key']) and isset($_GET['reset_password_note']) and empty($_POST['reset_password_note'])){
        $email=addslashes($_GET['email']);
        $key=$_GET['key'];

        //get user
        $get_token=$retrieveObj->retriever("password_reset","*","email","$email","password_reset_id","DESC","fetch");
        if($get_token=="1020"){
            die("<p class='alert alert-warning'>Something went wrong, restarting the password reset process</p>");
        }else{ 
            $token_expdate=$get_token->expdate;
            $current_date_time=date("Y-m-d H:i:s");

            if($token_expdate<$current_date_time){//check token expirely
                die("<p class='alert alert-warning'>This password reset token has expired, click <a href='../forgot_password.php'>HERE</a> to request another one.</p>");
            }
        }

        //check if the key is valid
        $table_token=$get_token->token;
        if($table_token!=$key){
            die("<p class='alert alert-warning'>Something went wrong, Try restarting the password reset process</p>");
        }
    }else{
        die("<p class='alert alert-warning'>Something went wrong, Try restarting the password reset process</p>");
    }
    
?>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <title>Administrators Reset Password - Raising Value</title>
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i">
    <link rel="stylesheet" href="../assets/css/ready.css">
    <link rel="stylesheet" href="../assets/css/demo.css">
    <link rel="stylesheet" href="../assets/css/main.css">
    <link href="../../lib/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="../../lib/simditor-2.3.28/site/assets/styles/simditor.css" />
    <link href="../../lib/croppie/croppie.css" rel="stylesheet">
    <link href="../../css/universal.css" rel="stylesheet">
    <link href="../../img/raising_value_logo.png" rel="icon">
</head>
<body class="bg-light">
    <div class="wrapper">
        <div class="mx-auto" style="max-width: 500px">
            <div class="card mt-5">
                <div class="card-header">
                    <div class="text-center">
                        <a href="../../index.php">
                            <img src="../img/raising_value_logo.png" alt="raising value logo" title="Raising Value" style="max-width: 160px;">
                        </a>
                    </div>
                    <div class="card-title text-center mt-3">Admin Reset Password</div>
                </div>
                <div class="card-body">
                     <form id="reset_password_form">
                        <div class="form-group">
                            <label for="password">New Password</label>
                            <input type="password" class="form-control" id="password" name="password" placeholder="New Password">
                        </div>
                        <div class="form-group">
                            <label for="repeat_password">Repeat Password</label>
                            <input type="password" class="form-control" id="repeat_password" name="repeat_password" placeholder="Repeat Password">
                        </div>
                        <div id="reset_password_response"></div>
                        <div class="form-group text-center">
                            <input type="hidden" name="reset_password_note" value="<?php echo $key ?>">
                            <input type="hidden" name="email" value="<?php echo $email ?>">
                            <button class="btn btn-primary btn-block" onclick="admin_reset_password_()">
                                Submit
                            </button>
                        </div>
                        <div class="form-group text-center">
                            <a href="../login.php">
                                Login
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
<script src="../assets/js/core/jquery.3.2.1.min.js"></script>
<script src="../assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
<script src="../assets/js/core/popper.min.js"></script>
<script src="../assets/js/core/bootstrap.min.js"></script>
<script src="../assets/js/plugin/chartist/chartist.min.js"></script>
<script src="../assets/js/plugin/chartist/plugin/chartist-plugin-tooltip.min.js"></script>
<script src="../assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>
<script src="../assets/js/plugin/bootstrap-toggle/bootstrap-toggle.min.js"></script>
<script src="../assets/js/plugin/jquery-mapael/jquery.mapael.min.js"></script>
<script src="../assets/js/plugin/jquery-mapael/maps/world_countries.min.js"></script>
<script src="../assets/js/plugin/chart-circle/circles.min.js"></script>
<script src="../assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>
<script src="../assets/js/ready.min.js"></script>
<script src="../../lib/datatables/jquery.dataTables.min.js"></script>
<script src="../../lib/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" src="../../lib/simditor-2.3.28/site/assets/scripts/module.js"></script>
<script type="text/javascript" src="../../lib/simditor-2.3.28/site/assets/scripts/hotkeys.js"></script>
<script type="text/javascript" src="../../lib/simditor-2.3.28/site/assets/scripts/uploader.js"></script>
<script type="text/javascript" src="../../lib/simditor-2.3.28/site/assets/scripts/simditor.js"></script>

<script type="text/javascript" src="../../lib/croppie/croppie.js"></script>

<script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js"></script>

<!--script src="assets/js/demo.js"></script-->
<script src="../../js/universal.js?<?php echo date("Y-m-d").time() ?>"></script> 
<script src="../js/js.js?<?php echo date("Y-m-d").time() ?>"></script> 

</html>