<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  if(!isset($_POST["view_type"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $view_type=addslashes($_POST["view_type"]);

  $where_values="";

  if($view_type=="all"){
    $where_values="";
  }else{
  	$where_values=" blog_categories.b_category_id='$view_type' and ";
  }

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $rowcountObj=new ROWCOUNT();

  $get_blogs=$retrieveObj->retriever("blog JOIN blog_categories ON blog.b_category_id=blog_categories.b_category_id ","*"," $where_values blog.b_status","active","fetchAll");

  $get_blog_categories=$retrieveObj->retriever("blog_categories ORDER BY b_category_name","*","fetchAll");

?>


<h4 class="page-title">
	<span class="fas fa-blog"></span>
	Blog
</h4>
<div class="row">
	<div class="col-md-12 mb-3">
		<p class="font-weight-bold mb-2 d-flex justify-content-between">
			<span>
				<select class="btn btn-primary" onchange="blog_viewII()" id="blogs_view_type">
					<option disabled>Blog categories</option>
					<option value="all" <?php echo ($view_type=="all") ? " selected " : " " ?> >All</option>
					<?php
						if($get_blog_categories!="1020"){
							$b_category_selected_status="";

							foreach ($get_blog_categories as $blog_category) {
								if($view_type!="all" and $blog_category->b_category_id==$view_type){
									$b_category_selected_status="selected";
								}else{
									$b_category_selected_status="";
								}
						?>
								<option <?php echo $b_category_selected_status; ?> value="<?php echo $blog_category->b_category_id; ?>"><?php echo $blog_category->b_category_name; ?></option>
						<?php
							}
						}
					?>
				</select>
			</span>
			<span>
				<a href="#!" class="text-primary font-weight-normal mx-2" onclick="add_blog_info_view()"><span class="fas fa-plus"></span> Add blog post</a>
				<a href="#!" class="text-primary font-weight-normal mx-2" onclick="blog_categories_view()"><span class="fas fa-list"></span> Blog Categories</a>
	          <a href="#!" class="text-danger font-weight-normal mx-2" onclick="blogs_trash_view()"><span class="fas fa-trash"></span> Removed blog posts</a>
			</span>  
 		</p>
		<table class="table table-head-bg-primary mt-4" id="blogs_table">
			<thead>
				<tr>
                  <th scope="col">Title</th>
                  <th scope="col">Date posted</th>
                  <th scope="col">Last date edited</th>
                  <th scope="col">Comments</th>
                  <th scope="col"></th>
                </tr>
			</thead>
			<tbody>
				<?php
		          if($get_blogs!="1020"){
		            $element_id="element_id";
		              foreach ($get_blogs as $blog) {
		                $element_id=$element_id."Ot";
		        ?>  
		            <tr id="<?php echo $element_id ?>">         
		              <td>
		                <?php 
		                  echo $blog->b_title;
		                ?>
		              </td>
		              <td>
		                <?php 
		                  echo date("d-m-Y H:i:s", strtotime($blog->b_date_posted));
		                ?>
		              </td>
		              <td>
		                <?php 
		                	if(!empty($blog->b_last_date_edited)){
		                		echo date("d-m-Y H:i:s", strtotime($blog->b_last_date_edited));
		                	}
		                  		
		                ?>
		              </td>
		              <td>
		              	<a href="#!" onclick="blog_post_comments_view(<?php echo $blog->b_id ?>)">
			                <?php 
			                  //get comments count
			                  echo $comments_count=$rowcountObj->rowcounter("blog_comments","*","b_id",$blog->b_id);
			                ?>
		                </a>
		              </td>
		              <td id="<?php echo $element_id.'Dbtn' ?>">
		                  <div class="">
		                    <button title="Edit" class="btn btn-success hand_cursor" onclick="edit_blog_view(<?php echo $blog->b_id ?>)"><span class="fas fa-edit"></span> Edit </button>
		                    <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
		                        <input type="hidden" name="remove_blog_note" value="<?php echo $blog->b_id; ?>">
		                        <button id="<?php echo $element_id.'Rbtn' ?>" onclick="remove_blog('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','remove_blog_response')" type="submit" title="Remove" class="btn btn-warning hand_cursor"><span class="fas fa-trash"></span> Remove</button>
		                    </form>
		                    
		                  </div>       
		              </td>
		            </tr>
		          <?php
		              }
		            }
		          ?>
			</tbody>
		</table>
	</div>
</div>
<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#blogs_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ]
    });
  })
</script>