<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  if(!isset($_POST["view_type"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $view_type=addslashes($_POST["view_type"]);

  $where_values="";

  if($view_type=="food_product"){
    $where_values=" and products.p_category='food_product' ";
  }else if($view_type=="chemical_product"){
    $where_values=" and products.p_category='chemical_product' ";
  }else if($view_type=="tech_product"){
    $where_values=" and products.p_category='tech_product' ";
  }else if($view_type=="all"){
    $where_values="";
  }

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_products=$retrieveObj->retriever("products 
			JOIN product_images ON product_images.p_id=products.p_id
			WHERE products.p_status='active' $where_values and product_images.p_image_type='primary_image'
			GROUP BY products.p_id ORDER BY products.p_id DESC","DISTINCT *","fetchAll");
?>

<h4 class="page-title">
	<span class="la la-cubes"></span>
	Products
</h4>
<div class="row">
	<div class="col-md-12 mb-3">
		<p class="font-weight-bold mb-2 d-flex justify-content-between">
			<span>
				<select class="btn btn-primary" id="products_view_type" onchange="products_viewII()">
					<option selected disabled>Product categories</option>
					<option value="all">All</option>
					<option value="food_product">Food products</option>
					<option value="chemical_product">Chemical products</option>
					<option value="tech_product">Tech products</option>
				</select>
			</span>
			<span>
				<a href="#!" class="text-primary font-weight-normal mx-2" onclick="add_product_info_view()"><span class="fas fa-plus"></span> Add product</a>
	          <a href="#!" class="text-danger font-weight-normal mx-2" onclick="products_trash_view()"><span class="fas fa-trash"></span> Removed products</a>
			</span>  
 		</p>
    <div id="remove_product_response">
      
    </div>
 		<table class="table table-head-bg-primary mt-4" id="products_table">
			<thead>
				<tr>
          <th scope="col">Photo</th>
          <th scope="col">Product name</th>
          <th scope="col">Product category</th>
          <th scope="col">Product price</th>
          <th scope="col">Date added</th>
          <th scope="col"></th>
        </tr>
			</thead>
			<tbody>
				<?php
                    
          if($get_products!="1020"){
            $element_id="element_id";
              foreach ($get_products as $product) {
                $element_id=$element_id."Ot";
        ?>  
            <tr id="<?php echo $element_id ?>">         
              <td class="text-center">
                <?php
                  if(!empty($product->p_image)){
                    echo $image='<img class="m-1" style="max-height:40px;" src="../img/products/'.$product->p_image.'?timestamp'.time().'" alt="Product img"/>';
                  }else{
                    echo "<span class='fas fa-cube fa-2x'></span>";
                  }
                ?>
              </td>
              <td>
                <?php 
                  echo $product->p_name;
                ?>
              </td>
              <td>
                <?php 
                  echo $product->p_category;
                ?>
              </td>
              <td>
                <?php 
                  echo $product->p_price;
                ?>
              </td>
              <td>
                <?php 
                  echo date("d-m-Y H:i:s", strtotime($product->p_date_added));
                ?>
              </td>
              <td id="<?php echo $element_id.'Dbtn' ?>">
                  <div class="">
                    <button title="Edit" class="btn btn-success hand_cursor" onclick="edit_product_view(<?php echo $product->p_id ?>)"><span class="fas fa-edit"></span> Edit </button>
                    <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                        <input type="hidden" name="remove_product_note" value="<?php echo $product->p_id; ?>">
                        <button id="<?php echo $element_id.'Rbtn' ?>" onclick="remove_product('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','remove_product_response')" type="submit" title="Remove" class="btn btn-warning hand_cursor"><span class="fas fa-trash"></span> Remove</button>
                    </form>
                    
                  </div>       
              </td>
            </tr>
          <?php
              }
            }
          ?>
				
			</tbody>
		</table>
	</div>
</div>
<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#products_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [5]} 
      ]
    });
  })
</script>