<?php
	$session_path="../../session_check.php";
	$classes="../../classes/main_classes.php";

	require_once($session_path);
	require_once($classes);

	if($user_id==null){
	    echo "<p class='alert alert-warning'>You are not logged in</p>";
	}

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	//get vehicles purchesed by cutomer
	$get_vehicles=$retrieveObj->retriever("vehicle 
      JOIN vehicle_make ON vehicle_make.v_make_id=vehicle.v_make_id 
      JOIN vehicle_type ON vehicle_type.v_type_id=vehicle.v_type_id 
      JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id 
      JOIN vehicle_sold ON vehicle_sold.v_id=vehicle.v_id
      JOIN users ON vehicle_sold.user_id=users.user_id WHERE vehicle_sold.user_id='$user_id' GROUP BY vehicle.v_id","*","fetchAll");

?>



<p class="text_primary_color font-weight-bold mb-1">Vehicle Purchases</p>
<div class="bg-white rounded pb-3 shadow-sm">
    <p class="laed px-3 py-2 text-light bg-dark"> Purchases</p>

    <div class="container-fluid">

    	<table class="table table-borderless table-responsive-lg" id="vehicle_purchases_table">
	    	<thead>
	    		<tr>
	    			<th>Image</th>
	    			<th>Vehicle name</th>
	    			<th>Type</th>
	    			<th>Make</th>
	    			<th>Price</th>
	    			<th>Date Purchased</th>
	    			<th></th>
	    		</tr>
	    	</thead>
	    	<tbody>
	    		<?php
	    			if($get_vehicles!="1020"){
	    				foreach ($get_vehicles as $vehicle) {
	    		?>
						<tr>	    		
	    					<td class="">
	    						<img style="max-height: 50px;" class="img-fluid" src="img/vehicles/<?php echo $vehicle->image."?timestamp".time() ?>" alt="Image" />
	    					</td>
	    					<td class="py-3"><?php echo $vehicle->v_name ?></td>
	    					<td class="py-3"><?php echo $vehicle->v_type ?></td>
	    					<td class="py-3"><?php echo $vehicle->v_make ?></td>
	    					<td class="py-3"><?php echo $vehicle->v_price ?></td>
	    					<td class="py-3">
	    						<?php echo date("d-m-Y H:i:s", strtotime($vehicle->v_sold_date)); ?>
	    					</td>
	    					<td>
	    						<?php
									$for_pdf_details_var='
										<div class="text-center mt-3">
											<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
										</div>
										<div class="text-center mt-3 h3">Purchased Vehicle</div>
										<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

										<div class="container">
											<div style="width:100%" style="p-2">
												<img class="" style="height:300px;" src="../img/vehicles/'.$vehicle->image.'?timestamp'.time().'"/>
											</div>
											<div style="width:100%" style="p-2">
												<table class="table table-borderless">
													<tr>
														<td><strong>Vehicle name</strong></td>
														<td>'.$vehicle->v_name.'</td>
													</tr>
													<tr>
														<td><strong>Vehicle Type</strong></td>
														<td>'.$vehicle->v_type .'</td>
													</tr>
													<tr>
														<td><strong>Vehicle Make</strong></td>
														<td>'.$vehicle->v_make.'</td>
													</tr>
													<tr>
														<td><strong>Vehicle Model</strong></td>
														<td>'.$vehicle->v_model.'</td>
													</tr>
													<tr>
														<td><strong>Vehicle Price</strong></td>
														<td>MKW'.$vehicle->v_price.'</td>
													</tr>
													
													<tr>
														<td><strong>Date Purchased</strong></td>
														<td>'.$vehicle->v_sold_date.'</td>
													</tr>
													<tr>
														<td><strong>Buyer Info</strong></td>
														<td>
															<p><strong>full name : </strong>'.$vehicle->firstname.' '.$vehicle->lastname.'</p>
															<p><strong>email : </strong>'.$vehicle->email.'</p>
															<p><strong>phone : </strong>'.$vehicle->phone.'</p>
														</td>
													</tr>
												</table>
											</div>
											<div class="col-md-12">
												<p><strong>Desctiption</strong></p>
												<p>'.$vehicle->v_description.'</p>
											</div>
										</div>
									';

									$strI = serialize($for_pdf_details_var);
									$pdfDataDetails = urlencode($strI);

								?>
	    						<form action="file_generators/pdf_generator.php" method="POST" target="_blank">
					                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
									<input type="hidden" name="downloadBtn">
					                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
					            </form> 
	    					</td>
	    				</tr>
	    		<?php
	    				}
	    			}
	    		?>
	    	</tbody>
	    </table>
    </div>
	    

</div>	


<script>  
 $(document).ready(function(){  
     var table = $('#vehicle_purchases_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [6]} 
      ]
    }); 
 });  
 </script> 