<?php
	$session_path="../../session_check.php";
	$classes="../../../classes/main_classes.php";

	require_once($session_path);
	require_once($classes);

	if($sign_in_status=="out"){
	    die("<p class='alert alert-warning'>You are not logged in</p>");
	}
 
	if(!isset($_POST['r_id'])){
		echo "<p class='alert alert-warning'>Invalid request</p>";
	}
	$r_id=addslashes($_POST["r_id"]);

	//OBJECTS
	$retrieveObj=new RETRIEVE();
	$rowcountObj=new ROWCOUNT();

	//get realestates purchesed by cutomer
	$get_realestate=$retrieveObj->retriever("realestate 
      JOIN realestate_images ON realestate_images.r_id=realestate.r_id 
      WHERE realestate.r_id='$r_id'","*","fetch");
  $realestate_image=$get_realestate->image;
?>
<div class="text-left">
    <button class="btn" onclick="available_realestate_properties()"><span class="fas fa-arrow-left"></span> Back</button>
</div>
<p class="text-center lead">Edit Realestate property</p>
<nav>
  <div class="nav nav-tabs" id="nav-tab" role="tablist">
    <a class="nav-item nav-link active text-dark" id="nav-info-tab" data-toggle="tab" href="#nav-info" role="tab" aria-controls="nav-info" aria-selected="true">Information</a>
    <a class="nav-item nav-link text-dark" id="nav-info-tab" data-toggle="tab" href="#nav-a-status" role="tab" aria-controls="nav-a-status" aria-selected="true">Availability status</a>
    <a class="nav-item nav-link text-dark" id="nav-main-image-tab" data-toggle="tab" href="#nav-main-image" role="tab" aria-controls="nav-main-image" aria-selected="false">Main image</a>
    <a class="nav-item nav-link text-dark" id="nav-other-images-tab" data-toggle="tab" href="#nav-other-images" role="tab" aria-controls="nav-other-images" aria-selected="false">Supporting images</a>
  </div>
</nav>
<div class="tab-content" id="nav-tabContent">
  <div class="tab-pane fade show active py-2" id="nav-info" role="tabpanel" aria-labelledby="nav-info-tab">
  	
  			<form id="edit_realestate_basic_info_form">
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="realestate_type">Type</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <?php
                //get types
                $get_types=$retrieveObj->retriever("realestate_type","*","fetchAll");

                if($get_types!="1020"){

              ?>
              <select class="form-control" name="realestate_type">
              <?php
                $select_type_status="";
                foreach ($get_types as $type) {
                  if($type->r_type_id==$get_realestate->r_type_id){
                    $select_type_status="selected";
                  }else{
                    $select_type_status="";
                  }
            ?>
                  <option <?php echo $select_type_status ?> value='<?php echo $type->r_type_id ?>'><?php echo $type->r_type; ?></option>
            <?php
                }
              ?>
              </select>
            <?php 
              }else{
                echo "<p class='alert alert-warning'>Please add realestate types to continue</p>";
              } 
            ?>
            </div>
          </div>

          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="realestate_offer_type">Offer type</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <select class="form-control" name="realestate_offer_type" id="realestate_offer_type" onchange="set_realestate_price_fields_('on_add',<?php echo $get_realestate->r_id ?>)">
                <?php
                  $for_sale_selected_status="";
                  $for_rent_selected_status="";

                  if($get_realestate->r_offer_type=="for_sale"){
                    $for_sale_selected_status="selected";
                    $for_rent_selected_status="";
                  }else if($get_realestate->r_offer_type=="for_rent"){
                    $for_sale_selected_status="";
                    $for_rent_selected_status="selected";
                  }
                ?>
                <option <?php echo $for_sale_selected_status; ?> value="for_sale">For sale</option>
                <option <?php echo $for_rent_selected_status; ?> value="for_rent">For Rent</option>
              </select>
            </div>
          </div>
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="realestate_price_container">
              <?
              if($get_realestate->r_offer_type=="for_rent"){
                  //get price per day
                  $price_per_day="";
                  $get_realestate_price_per_day=$retrieveObj->retriever("realestate_book","*","r_id",$r_id,"fetch");
                  if($get_realestate_price_per_day!="1020"){
                    $price_per_day=$get_realestate_price_per_day->r_price_per_day;
                  }
             ?>

              <div class="row my-2">
                <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
                  <label for="realestate_price">Price per month(MKW)</label>
                </div>
                <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
                  <input class="form-control" type="number" name="realestate_price" id="realestate_price" value="<?php echo $get_realestate->r_price ?>">
                </div>
              </div>
            
              <div class="row my-2">
                <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
                  <label for="realestate_price_per_day">Price per day(MKW) <small class="text-info">optional</small></label>
                </div>
                <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
                  <input class="form-control" type="number" name="realestate_price_per_day" id="realestate_price_per_day" value="<?php echo $price_per_day ?>">
                </div>
              </div>
              
             <?php
              }else{
             ?>
                
                <div class="row my-2" >
                  <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="realestate_price">Price (MKW)</label>
                  </div>
                  <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
                    <input class="form-control" type="number" name="realestate_price" id="realestate_price" value="<?php echo $get_realestate->r_price ?>">
                  </div>
                </div>
                  
             <?php
              }
            ?>
            </div>
                
          </div>
          <div class="row my-3 rounded">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
              <div class="p-2 shadow-sm">
                <label for="realestate_address">Address</label>
                <textarea class="form-control" name="realestate_address" id="realestate_address"><?php echo $get_realestate->r_address ?></textarea>
              </div>  
            </div>
          </div>
          <div class="row my-3 rounded">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
              <div class="p-2 shadow-sm">
                <label for="realestate_description">Description</label>
                <textarea class="form-control" name="realestate_description" id="realestate_description"><?php echo $get_realestate->r_description ?></textarea>
              </div>
            </div>
          </div>
          <div id="edit_realestate_basic_info_response">
            
          </div>
          <div class="py-3 text-right">
            <input type="hidden" name="edit_realestate_basic_info_note">
            <input type="hidden" name="r_id" value="<?php echo $get_realestate->r_id ?>">
            <button class="btn bg_primary_color text-light ml-auto" type="submit" onclick="edit_realestate_basic_info()"><span class="fas fa-save"></span> Save </button>
          </div>
        </form>
  	
  </div>
  <div class="tab-pane fade py-4 text-center" id="nav-a-status" role="tabpanel" aria-labelledby="nav-a-status-tab">
        <div class="text-left" >
          <?php
            $checkboxStatusAvailable="";
            $checkboxStatusSold="";
            $checkboxStatusRented="";
            $checkboxStatusReserved="";
            $checkboxStatusBooked="";
            if($get_realestate->r_status=="available"){
              $checkboxStatusAvailable="checked";
              $checkboxStatusSold="";
              $checkboxStatusRented="";
              $checkboxStatusReserved="";
              $checkboxStatusBooked="";
            }else if($get_realestate->r_status=="not_available"){
              $checkboxStatusAvailable="";
              $checkboxStatusSold="";
              $checkboxStatusRented="";
              $checkboxStatusReserved="";
              $checkboxStatusBooked="";
            }else if($get_realestate->r_status=="sold"){
              $checkboxStatusAvailable="";
              $checkboxStatusSold="checked";
              $checkboxStatusRented="";
              $checkboxStatusReserved="";
              $checkboxStatusBooked="";
            }else if($get_realestate->r_status=="rent"){
              $checkboxStatusAvailable="";
              $checkboxStatusSold="";
              $checkboxStatusRented="checked";
              $checkboxStatusReserved="";
              $checkboxStatusBooked="";
            }else if($get_realestate->r_status=="reserved"){
              $checkboxStatusAvailable="";
              $checkboxStatusSold="";
              $checkboxStatusRented="";
              $checkboxStatusReserved="checked";
              $checkboxStatusBooked="";
            }else if($get_realestate->r_status=="booked"){
              $checkboxStatusAvailable="";
              $checkboxStatusSold="";
              $checkboxStatusRented="";
              $checkboxStatusReserved="";
              $checkboxStatusBooked="checked";
            }
          ?>
          <label class='switch' >
            <div class="input-group">
              <input class="mx-2" <?php echo $checkboxStatusAvailable ?> type='radio' id='realestate_status_available' name='realestate_status_name' value="available" onclick='pre_setRealestateStatus(<?php echo $get_realestate->r_id; ?>)'>
              <label class="input-group-append my-2" for="realestate_status_available">Available</label>
            </div>

            <div class="input-group">
              <input class="mx-2" <?php echo $checkboxStatusSold ?> type='radio' id='realestate_status_sold' name='realestate_status_name' value="sold"  onclick='pre_setRealestateStatus(<?php echo $get_realestate->r_id; ?>)'>
              <label class="input-group-append my-2" for="realestate_status_sold">Sold</label>
            </div>

            <div>
              <div class="input-group">
                <input class="mx-2" <?php echo $checkboxStatusRented ?> type='radio' id='realestate_status_rented' name='realestate_status_name' value="rent"  onclick='pre_setRealestateStatus(<?php echo $get_realestate->r_id; ?>)'>
                <label class="input-group-append my-2" for="realestate_status_rented">Rented</label>
              </div>

              <div class="row my-1 px-5" id="set_realestate_rent_form" style="display: none;">
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 bg-white p-2">
                  <p class="mb-0">Information</p>
                  <hr>
                  <form id="set_rent_customer_information_form">
                    <div class="row">
                      <div class="col-12 col-sm-12 col-md-12 col-lg-12 my-1" id="set_realestate_rent_response">
                        
                      </div>
                      <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Email</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <input class="form-control" type="text" name="email">
                      </div>
                      <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Price per month(MKW)</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <input class="form-control" type="text" name="price" value="<?php echo $get_realestate->r_price ?>">
                      </div>
                      <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Rent start date</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <input class="form-control" type="date" name="r_rented_date" >
                      </div>
                      <div class="col-12 col-sm-12 col-md-12 col-lg-12 my-1 text-right">
                        <input type="hidden" name="property_id" value="<?php echo $r_id ?>">
                        <input type="hidden" name="set_realestate_rent_book_note" value="set_rent">
                        <button class="btn btn-primary" onclick="set_realestate_rent_book('set_rent_customer_information_form','set_realestate_rent_response')">Submit</button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>

            </div>
              
            
            <div>
              <div class="input-group">
                <input class="mx-2" <?php echo $checkboxStatusBooked ?> type='radio' id='realestate_status_booked' name='realestate_status_name' value="booked"  onclick='pre_setRealestateStatus(<?php echo $get_realestate->r_id; ?>)'>
                <label class="input-group-append my-2" for="realestate_status_booked">Booked</label>
              </div>

              <div class="row my-1 px-5" id="set_realestate_booked_form" style="display: none;">
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 bg-white p-2">
                  <p class="mb-0">Information</p>
                  <hr>
                  <form id="set_book_customer_information_form">
                    <div class="row">
                      <div class="col-12 col-sm-12 col-md-12 col-lg-12 my-1" id="set_realestate_book_response">
                        
                      </div>
                      <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Email</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <input class="form-control" type="text" name="email">
                      </div>
                      <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Price per day(MKW)</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <?php
                          $get_realestate_price_per_day=$retrieveObj->retriever("realestate_book","*","r_id",$get_realestate->r_id,"fetch");
                          $realestate_price_per_day="";
                          if($get_realestate_price_per_day!="1020"){
                            $realestate_price_per_day=$get_realestate_price_per_day->r_price_per_day;
                          }
                        ?>
                        <input class="form-control" type="text" name="price" value="<?php echo $realestate_price_per_day ?>">
                      </div>
                       <div class="col-12 col-sm-4 col-md-3 col-lg-3 mb-1">
                        <label class="mt-2">Book start date</label>
                      </div>
                      <div class="col-12 col-sm-8 col-md-9 col-lg-9 mb-1">
                        <input class="form-control" type="date" name="r_book_date_from" >
                      </div>
                      <div class="col-12 col-sm-12 col-md-12 col-lg-12 my-1 text-right">
                        <input type="hidden" name="property_id" value="<?php echo $r_id ?>">
                        <input type="hidden" name="set_realestate_rent_book_note" value="set_book">
                        <button class="btn btn-primary" onclick="set_realestate_rent_book('set_book_customer_information_form','set_realestate_book_response')">Submit</button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
              

            <div class="input-group">

              <input class="mx-2" <?php echo $checkboxStatusReserved ?> type='radio' id='realestate_status_reserved' name='realestate_status_name' value="reserved"  onclick='pre_setRealestateStatus(<?php echo $get_realestate->r_id; ?>)'>
              <label class="input-group-append my-2" for="realestate_status_reserved">Reserved</label>
              <input type="hidden" id="radio-previous" name="radio-previous" value="<?php echo $get_realestate->r_status ?>" />
            </div>
            <span class='slider round'></span>
          </label>
        </div>
      
  </div>
  <div class="tab-pane fade py-2 text-center" id="nav-main-image" role="tabpanel" aria-labelledby="nav-main-image-tab">
  	<span class="hand_cursor mx-auto" data-toggle="collapse" data-target="#update_profile_container" id="profilePhotoContainer">
        <?php 
          if(!empty($get_realestate->image)){
            echo '<img id="realestate_picture" src="../img/realestates/'.$get_realestate->image.'" alt="..." style="max-height:250px" class="rounded mb-2 img-thumbnail" > ';
          }else{
            echo "<span class='fas fa-image fa-5x text-dark bg-light shadow-sm rounded border border-white' style='padding:8px 10px;'></span>";
          }
        ?>
    </span>
	<div id="update_profile_container" class="collapse" >
		<span class="btn btn-dark btn-file my-1">
		    Browse...<input type="file" id="upload_image">
		</span>
	</div>
	<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
		<div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo" style="width:350px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <button class="btn btn-block btn-primary crop_image my-1">Update</button>
          </div>
        </div>
	</div>
  </div>
  <div class="tab-pane fade py-2" id="nav-other-images" role="tabpanel" aria-labelledby="nav-other-images-tab">
  	<div class="container-fluid">
  		<p class="text-right">
        <form class="text-right" id="add_realestate_supporting_image_form" enctype="multipart/form-data">
          <input type="hidden" name="add_realestate_supporting_image_note" value="<?php echo $r_id ?>">
          <a class="btn btn-file text-primary hand_cursor" href="#!">
            <span class="fas fa-plus"></span> 
              add supporting image
              <input type="file" multiple name="upload_other_images[]" id="upload_other_images" onchange="add_realestate_supporting_images(<?php echo $r_id ?>)">
          </a>
        </form>
    			
  		</p>
      <div id="add_supporting_image_response">
        
      </div>
  		<div id="supporting_images_container">
  			
  		</div>
	    	
    </div>
  </div>
</div>



<script>  
  $(document).ready(function(){
    var editor = new Simditor({
        textarea: $('#realestate_description')
        //optional options
      });
  })
  //........
	
	var realestate_image='<?php echo $realestate_image ?>';
$(document).ready(function(){
	view_realestate_supporting_images(<?php echo $r_id ?>)

  var d=new Date();
  var upload_btn_action=$(this).text();
  var image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:119,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageContainer').show();
    $('html, body').animate({
        scrollTop: $("#uploadimageContainer").offset().top
    }, 1000);
  });

  $('.crop_image').click(function(event){
    $.LoadingOverlay("show");
  	upload_btn_action=$(this).text();
    image_crop.croppie('result', {
      type: 'canvas',
      size: "original", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/realestate/upload_realestate_main_image_edit.php",
        type: "POST",
        data:{"image": response,r_id:<?php echo $r_id ?>},
        
        cache: false,
           
        success:function(data)
        { 
          
          $.LoadingOverlay("hide", true); 
          //$('#uploadimageContainer').modal('hide');
          if(data==1){
          	$("#realestate_picture").attr("src","../img/realestates/"+realestate_image+"?timestamp"+d.getTime())
          	$("#uploadimageContainer").hide()
          }
        }
      });
    })
  });

});  
</script>

