<?php
  require_once("../../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  
  $get_profile_info=$retrieveObj->retriever("users","*","user_id",$user_id,"fetch");

  if($get_profile_info=="1020"){
    die("<p class='alert alert-warning'>Something went wrong</p>");
  }
?>

<style type="text/css">
  .profile-head {
    transform: translateY(5rem)
  }


</style>

<div class="row">
    <div class="col-md-12 mx-auto">
        <!-- Profile widget -->
        <div class="bg-white rounded overflow-hidden">
            <div class="px-4 pt-0 pb-4 bg_primary_color">
                <div class="media align-items-end profile-head">
                    <div class="profile mr-3 mb-4"> 
                      <span class="hand_cursor mx-auto" data-toggle="collapse" data-target="#update_profile_container" id="profilePhotoContainer">
                        <?php 
                          if(!empty($get_profile_info->photo)){
                            echo '<img id="profile_picture" src="img/profile_pictures/'.$get_profile_info->photo.'" alt="..." width="130px" class="rounded mb-2 img-thumbnail" > ';
                          }else{
                            echo "<span class='fas fa-user fa-5x text-dark bg-light shadow-sm rounded border border-white' style='padding:8px 10px;'></span>";
                          }
                        ?>
                      </span>
                      <div id="update_profile_container" class="collapse" >
                        <span class="btn btn-dark btn-file my-1">
                            Browse...<input type="file" id="upload_image">
                        </span>
                      </div>
                    </div>
                    <div class="media-body mb-5 text-white">
                        <h5 class="mt-0 mb-0"><?php echo $get_profile_info->firstname." ".$get_profile_info->lastname;  ?></h5>
                        <p class="small mb-4"> 
                          <?php 
                            if(!empty($get_profile_info->address)){
                              echo '<i class="fas fa-map-marker-alt mr-2"></i>'.$get_profile_info->address;
                            }
                            
                          ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="bg-light p-4 text-center mt-3 row" id="profile_info_container">
              
            </div>
        </div>
    </div>
</div>

<div id="uploadimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Upload & Crop Image</h4>
          </div>
          <div class="modal-body">
            <div class="row">
                <div class="col-md-8 text-center">
                  <div id="image_demo" style="width:350px; margin-top:30px"></div>
                </div>
                <div class="col-md-4" style="padding-top:30px;">
                  <br />
                  <br />
                  <br/>
                  <button class="btn btn-success crop_image">Crop & Upload Image</button>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          </div>
      </div>
    </div>
</div>

<script>  
$(document).ready(function(){

  $("#profile_info_container").load("includes_/profile/read_profile.php");

  var image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    image_crop.croppie('result', {
      type: 'canvas',
      size: "viewport", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/profile/upload.php",
        type: "POST",
        data:{"image": response},
        
            cache: false,
           
        success:function(data)
        { 
          $('#uploadimageModal').modal('hide');
          if(data==1){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-success'>Your profile picture updated</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)

            //.................
            d=new Date();

            if(document.getElementById("profile_picture")!=null){
              $("#profile_picture").attr("src",".../../img/profile_pictures/photo"+<?php echo $user_id ?>+".png?timestamp"+d.getTime())
            }else{
              $("#profilePhotoContainer").html("<img id='profile_picture' height='130px' class='mr-1' data-toggle='collapse' data-target='#update_profile_container'>")
              $("#profile_picture").attr("src",".../../img/profile_pictures/photo"+<?php echo $user_id ?>+".png?timestamp"+d.getTime())
            }

            if(document.getElementById("sub_profile_picture")!=null){
              $("#sub_profile_picture").attr("src",".../../img/profile_pictures/photo"+<?php echo $user_id ?>+".png?timestamp"+d.getTime())
            }else{
              $("#profilePhotoSubContainer").html("<img id='sub_profile_picture' class='rounded-circle' height='30px' data-toggle='collapse' data-target='#update_profile_container'>")
              $("#sub_profile_picture").attr("src",".../../img/profile_pictures/photo"+<?php echo $user_id ?>+".png?timestamp"+d.getTime())
            }
            //.........................
          }else if(data==0){
            $("#changePhotoResponse").html("<p id='changePhotoResponseMin' class='alert alert-danger'>Failed to update your Profile</p>");
            $("#changePhotoResponseMin").fadeOut(5000,"swing",null)
          }
          //$('#uploaded_image').html(data);
        }
      });
    })
  });

});  
</script>