<?php
  require_once("session_check.php");
  require_once("classes/main_classes.php");

  if(!isset($_SESSION['current_location'])){
    echo "<script>
      var current_location='index.php'
    </script>";
  }else{
    echo "<script>
      var current_location='".$_SESSION['current_location']."'
    </script>";

    unset($_SESSION["current_location"]);
  }
    

   $geoPlugin_array = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?geoplugin_countryName=Malawi') );
  //$geoPlugin_array = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?ip=41.70.127.255'));

   if($geoPlugin_array==null){
      ob_clean();
      die("<p class='alert alert-warning'>Sorry, something went wrong, try again later</p>");
   }

  $retrieveObj=new RETRIEVE();
	//generate token
    $token_random = rand(1000, 10000);
    $business_name = "replace with your business name no spaces";
    $date = date("Y-m-d");
    $token_id = $business_name.$token_random.$date;

    $amount_to_be_paid=$_SESSION["amount_to_be_paid"];
    $property_type=$_SESSION["property_type"];
    $property_id=$_SESSION["property_id"];

    //convert kwacha to dollar
    $amount_to_be_paid_in_kwacha=$amount_to_be_paid;
    $amount_to_be_paid=$amount_to_be_paid/$geoPlugin_array["geoplugin_currencyConverter"];
    $amount_to_be_paid=number_format((float)$amount_to_be_paid, 2, '.', '');

    $kwacha_from_dollar=$geoPlugin_array["geoplugin_currencyConverter"];

    //get property image
    $get_property_info="";
    $property_image="";
    if($property_type=="vehicle"){
      $get_property_info=$retrieveObj->retriever("vehicle JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id","*","vehicle.v_status='available' and vehicle_images.image_type='primary_image' and vehicle_images.v_id",$property_id,"fetch");
      $property_image="img/vehicles/".$get_property_info->image."?timestamp".time();
    }else if($property_type=="realestate"){
      $get_property_info=$retrieveObj->retriever("realestate  
        JOIN realestate_images ON realestate_images.r_id=realestate.r_id","*","realestate.r_id='$property_id' and realestate_images.image_type='primary_image' and realestate_images.r_id",$property_id,"fetch");
      $property_image="img/realestates/".$get_property_info->image."?timestamp".time();
    }else if($property_type=="auction"){
      $get_property_info=$retrieveObj->retriever("auction 
      JOIN auction_images ON auction_images.a_id=auction.a_id","*","auction.a_id",$property_id,"fetch");
      $property_image="img/auctions/".$get_property_info->image."?timestamp".time();
    }

    
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=yes">
    <title>SGW</title>
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="css/scrolling-nav.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=ABeeZee">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto+Slab:300,400">
    <!--link rel="stylesheet" href="assets/fonts/font-awesome.min.css"-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
    <link rel="stylesheet" href="assets/fonts/ionicons.min.css">
    <link rel="stylesheet" href="assets/css/--mp--Animated-Service-Box-1.css">
    <link rel="stylesheet" href="assets/css/--mp--Animated-Service-Box.css">
    <link rel="stylesheet" href="assets/css/DA_About.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-1.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-2.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-3.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-4.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-5.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer.css">
    <link rel="stylesheet" href="assets/css/Features-Clean.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.1.1/aos.css">
    <link rel="stylesheet" href="assets/css/Login-Animate.css">
    <link rel="stylesheet" href="assets/css/Login-screen.css">
    <link rel="stylesheet" href="assets/css/sticky-dark-top-nav-with-dropdown.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/services.css">
    <link rel="stylesheet" href="css/universal.css">
    <link href="assets/croppie/croppie.css" rel="stylesheet">

    <script
      src="https://www.paypal.com/sdk/js?client-id=Acd0PHjsyaPHFd6jAdYfZ45yq7q5xu6c3DApTGsTOUUjpbr4ZLcT_Np2x1qgIk_cSA7TrokIB-iRY8iE&currency=USD"> // Required. Replace SB_CLIENT_ID with your sandbox client ID.
    </script>
</head>

<body class="container bg-light" style="font-family: Roboto, sans-serif;">
  <div class="row mx-5 mt-2 p-3 bg-light shadow rounded mx-auto" style="max-width: 400px;">
  <!--div class="row mx-5 mt-2 p-3 bg-light shadow rounded mx-auto" style="max-width: 800px;"-->
    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
      <p class="text-center">
        <img class="mx-auto" id="main_logo_img" src="assets/img/sgw_logo.png" style="width: 172px;">
      </p>
      <p class="text-center lead text-dark">Payment Form</p>
    </div>
    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
      <div class="row" id="paypal_response_main">
          <div class="col-12 col-sm-12 col-md-12 col-lg-12">
              <?php
                  if(!empty($property_image)){
              ?>
                  <img class="img-fluid rounded img-thumbnail" src="<?php echo $property_image ?>" alt="Image" />
              <?php
                  }else{
                      echo "<p class='text-center'><span class='fas fa-car fa-5x'></span></p>";
                  }
              ?>
              
              <?php
                if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="rent"){
              ?>
                <div class="my-1 row f_d_info">
                  <div class="col-12 col-sm-5 col-md-4 col-lg-4">
                    <label class="mt-2">Rent period</label>
                  </div>
                  <div class="col-12 col-sm-6 col-md-8 col-lg-8">
                    <select class="form-control" id="rent_period" onchange="set_rent_period()">
                      <option value="1">30 days</option>
                      <option value="2">60 days</option>
                      <option value="3">90 days</option>
                    </select>
                  </div>
                </div>
                <div class="my-1 row f_d_info">
                  <div class="col-12 col-sm-12 col-md-4 col-lg-4">
                    <label class="mt-2">Price</label>
                  </div>
                  <div class="col-12 col-sm-12 col-md-6 col-lg-6 mt-2 d-flex justify-content-between">
                    <div>
                      $ <span class="" id="rent_price_container"></span>
                    </div>
                    <small class="font-weight-bold">
                      MKW<span id="rent_price_container_mk"><?php echo $amount_to_be_paid_in_kwacha ?></span>
                    </small>
                  </div>
                </div>
                
              <?php
                }
              ?>

              <?php
                if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="book"){
              ?>
                <div class="my-1 row f_d_info">
                  <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                    <label class="mt-2">Number of days</label>
                  </div>
                  <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                    <input class="form-control" id="book_period" value="1"  oninput="set_book_period()" />
                  </div>
                </div>
                <div class="my-1 row f_d_info">
                  <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                    <label class="mt-2">Price</label>
                  </div>
                  <div class="col-12 col-sm-12 col-md-6 col-lg-6 mt-2 d-flex justify-content-between">
                    <div>
                      $ <span class="" id="book_price_container"></span>
                    </div>
                    <small class="font-weight-bold" >
                      MKW<span id="book_price_container_mk"><?php echo $amount_to_be_paid_in_kwacha ?></span>
                    </small>
                  </div>
                </div>
                
              <?php
                }
              ?>
          </div>

          <div class="col-12 col-sm-12 col-md-12 col-lg-12 text-center" >
            <?php
              if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="rent"){
                //get rent start date
                $get_rent_start_date=$retrieveObj->retriever("realestate_rented","*","r_id",$property_id,"fetch");
            ?>
              <div class="my-1 input-group">
                <label class="input-group-append mt-1">Rent start date &nbsp;</label>
                <input class="form-control" type="date" name="rent_start_date" id="rent_start_date" required onchange="set_rent_paypal_button()" disabled value="<?php echo date('Y-m-d', strtotime($get_rent_start_date->r_rent_expirely_date)) ?>">
              </div>
            <?php
              }
            ?>

            <?php
              if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="book"){
                //get rent start date
                    $get_book_start_date=$retrieveObj->retriever("realestate_booked","*","r_id",$property_id,"fetch");
            ?>
              <div class="my-1 input-group">
                <label class="input-group-append mt-1">Book from &nbsp;</label>
                <input class="form-control" type="date" name="book_start_date" id="book_start_date" required onchange="set_book_paypal_button()" disabled value="<?php echo date('Y-m-d', strtotime($get_book_start_date->r_book_date_to)) ?>">
              </div>
            <?php
              }
            ?>
          </div>

          <div class="col-12 col-sm-12 col-md-12 col-lg-12 text-left" id="paypal_response_id">
            
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-12 text-center my-2 " id="paypal_button_container">
                <div id="paypal-button-container" class="mx-auto "></div>
                  <script>
                    paypal.Buttons({
                      createOrder: function(data, actions) {
                        // This function sets up the details of the transaction, including the amount and line item details.
                        return actions.order.create({
                          "intent": "CAPTURE",
                          purchase_units: [{
                            amount: {
                              value: '<?php echo $amount_to_be_paid ?>'
                            }
                          }]
                        });
                      },
                      onApprove: function(data, actions) {
                        // This function captures the funds from the transaction.
                        return actions.order.capture().then(function(capture_) {
                          // This function shows a transaction success message to your buyer.
                          //alert('Transaction completed by ' + details.payer.name.given_name);

                          var rent_period="";
                          var book_period="";
                          var rent_start_date="";
                          var book_start_date="";

                          if(document.getElementById("rent_period")!=null){
                            rent_period=$("#rent_period").val();
                          }
                          if(document.getElementById("book_period")!=null){
                            book_period=$("#book_period").val();
                          }
                          if(document.getElementById("rent_start_date")!=null){
                            rent_start_date=$("#rent_start_date").val();
                          }
                          if(document.getElementById("book_start_date")!=null){
                            book_start_date=$("#book_start_date").val();
                          }
                          $.LoadingOverlay("show"); 
                          $.ajax({
                              url: "includes_/payments/paypal/paypal.php", 
                              type: "POST",
                              
                              data:  {
                                capture_:capture_,
                                rent_period:rent_period,
                                book_period:book_period,
                                rent_start_date:rent_start_date,
                                book_start_date:book_start_date
                              },
                                  success: function(resp) {
                                    if(resp==1){
                                      $("#paypal_response_main").html('<p class="text-center lead alert alert-primary">Payment successfull, Thank you for choosing us.</p><p class="text-center my-2 text-dark">Redirecting...</p>');
                                      $.LoadingOverlay("hide", true);
                                      setTimeout(function(){ 
                                        /*if(current_location=="realestate"){
                                          window.location.href= "realestate.php";
                                        }else if(current_location=="auction"){
                                          window.location.href= "auction.php";
                                        }else if(current_location=="vehicle"){
                                          window.location.href= "vehicle.php";
                                        }else{
                                          window.location.href= "customer.php";
                                        }*/
                                        window.location.href= "customer.php";
                                      }, 3000);
                                    }else{
                                      $("#paypal_response_id").html(resp);
                                    }
                                  },
                                  error: function(xhr, status, error) {
                                    //alert(error.Message);
                                  }
                            });
                        });
                      }
                    }).render('#paypal-button-container');
                    //This function displays Smart Payment Buttons on your web page.
                  </script>
          </div>
      </div>
    </div>
          
    
  </div>

</body>
<script src="assets/js/jquery.min.js"></script>
<script src="assets/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/jquery-easing/jquery.easing.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js"></script>

<script type="text/javascript">
   function tester(){
      setTimeout(function(){ 
          $("#transact").hide();
          $("#complete_transaction").show();
          $(".f_d_info").hide();
      }, 5000);
  }; 

  function set_rent_period(){
    var r_days=$("#rent_period").val();
    //$("#rent_start_date").val("")

    $("#amount").val( r_days*"<?php echo $amount_to_be_paid ?>")
    $("#rent_price_container").html(parseFloat(r_days*"<?php echo $amount_to_be_paid?>").toFixed(2));
    $("#rent_price_container_mk").html(r_days*"<?php echo $amount_to_be_paid_in_kwacha?>");

    $("#paypal_button_container").load("paypal_payment_button.php",{
      rent_pay_note:r_days
    });
  }

  function set_book_period(){
    var r_days=$("#book_period").val();
    //$("#book_start_date").val("")

    $("#amount").val( r_days*"<?php echo $amount_to_be_paid ?>")
    $("#book_price_container").html(parseFloat(r_days*"<?php echo $amount_to_be_paid?>").toFixed(2));
    $("#book_price_container_mk").html(r_days*"<?php echo $amount_to_be_paid_in_kwacha?>");

    $("#paypal_button_container").load("paypal_payment_button.php",{
      book_pay_note:r_days
    });
  }

  function set_book_paypal_button(){
    if(document.getElementById("book_start_date")!=null){
      if(document.getElementById("book_start_date").value!="" && document.getElementById("book_period").value!="" && document.getElementById("book_period").value!=0){
        $("#paypal-button-container").removeClass("disabledElement");
      }else{
        $("#paypal-button-container").addClass("disabledElement");
      }
    }
  }

  function set_rent_paypal_button(){
    if(document.getElementById("rent_start_date")!=null){
      if(document.getElementById("rent_start_date").value!=""){
        $("#paypal-button-container").removeClass("disabledElement");
      }else{
        $("#paypal-button-container").addClass("disabledElement");
      }
    }
  }


  var activity='<?php echo $_SESSION["activity"] ?>';
  $(document).ready(function(){
    if(activity=="rent"){
      $("#amount").val("<?php echo 1*$amount_to_be_paid ?>")
      $("#rent_price_container").html("<?php echo money_format("%!n", 1*$amount_to_be_paid)?>");
      //$("#paypal-button-container").addClass("disabledElement");
    }

    if(activity=="book"){
      $("#amount").val("<?php echo 1*$amount_to_be_paid ?>")
      $("#book_price_container").html("<?php echo money_format("%!n", 1*$amount_to_be_paid)?>");
      //$("#paypal-button-container").addClass("disabledElement");
    }
    //onchange
  })
</script>

