<?php
	require_once("../../classes/main_classes.php");
	require_once("../session_check.php");
	require_once("../../includes_/mailer_data.php");
	

	if($sign_in_status=="out" or $user_id==null){
        die("<p class='alert alert-warning'>Security error, this may be bacause your login session has expired</p>");
    }

	//OBJECTS
	$retrieveObj=new RETRIEVE();
	$insertObj=new INSERT();
	$rowcountObj=new ROWCOUNT();
	$updateObj=new UPDATE();
	$deleteObj=new DELETE();
	$sendemailObj=new SEND_EMAIL();
	$root_dir_getObj=new ROOTDIRGET();

	$mailer_r_path="../../";

	//get root dir
	$root_dir=$root_dir_getObj->root_dir_getter();

	//send email
	function send_verify_email($email,$password){
		global $rowcountObj;
		global $insertObj;
		global $deleteObj;
		global $updateObj;
		global $retrieveObj;
		global $sendemailObj;
		global $root_dir;
		global $mailer_r_path;

		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$email = filter_var($email, FILTER_VALIDATE_EMAIL);

		if (!$email) {
		   die("<p>Invalid email address please type a valid email address!</p>");
		}

	   $expFormat = mktime(
	   	date("H"), date("i"), date("s"), date("m") ,date("d")+1, date("Y")
	   );
		$expDate = date("Y-m-d H:i:s",$expFormat);
		$key = password_hash((string)(2418*2).$email, PASSWORD_DEFAULT);

		//$addKey = substr(md5(uniqid(rand(),1)),3,10);
		//$key = $key . $addKey;
		// Insert Temp Table
		$fields=array("email","token","expdate");
		$data=array($email,$key,$expDate);
		$insert_token=$insertObj->inserter("users_account_verification",$fields,$data);

		if($insert_token!=1){
			die("<p class='alert alert-warning'>Something went wrong, try again later</p>");
		}
		 
		$output='<p>Dear '.$email.',</p>'
			;
		$output.='<p>Your account has been created at <a href="$root_dir">SGW</a>. Use the link below to verigy your account</p>';
		$output.='<p>Email : '.$email.'</p>';
		$output.='<p>Password : '.$password.'</p>';
		$output.='<p align="center">	
			<a href="'.$root_dir.'/includes_/account_verification.php?email='.$email.'&key='.$key.'&verify_email_note="">KEY='.$key.'</a>
		</p>'; 
		$output.='<p>
		The verification session will expire after 1 day for security reasons.</p>';
		$output.='<p>If your email is not verified in 24 hours, your account will be deleted automatically.</p>';   
		$output.='<p>Regards,</p>';
		$output.='<p><strong>SGW Auctioneers & Estate Agents TEAM</strong></p>';
		$body = $output; 
		$subject = "Verify Your Email Address - SGW Auctioneers & Estate Agents";
		 
		$email_to = $email;
		
	    $send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject,$body,$email_to);
	    

		if($send_email=="1"){
			return 1;
		}else{
			return 0;
		}
	}

	if(isset($_POST["user_signout_note"])){
		try{
			unset($_SESSION['sgw_admin_in_email']);
			unset($_SESSION['sgw_admin_in_id']);
			unset($_SESSION['sgw_admin_in_type']);
			session_destroy();
			echo 1;
		}catch(Exception $e){
			echo 0;
		}
	}



	if(isset($_POST["add_realestate_basic_info_note"])){
		if(empty($_POST["realestate_type"]) or empty($_POST["realestate_offer_type"]) or empty($_POST["realestate_price"]) or empty(strip_tags($_POST["realestate_address"])) or empty(strip_tags($_POST["realestate_description"]))){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		

		$realestate_type=addslashes($_POST["realestate_type"]);
		$realestate_offer_type=addslashes($_POST["realestate_offer_type"]);
		$realestate_price=addslashes($_POST["realestate_price"]);
		$realestate_address=addslashes($_POST["realestate_address"]);
		$realestate_description=addslashes($_POST["realestate_description"]);

		$fields=array("r_type_id","r_offer_type","r_price","r_address","r_description","added_by");
		$data=array($realestate_type,$realestate_offer_type,$realestate_price,$realestate_address,$realestate_description,$user_id);

		$insert=$insertObj->inserter("realestate",$fields,$data);

		if($insert=="1"){
			$realestate_price_per_day="";
			if(isset($_POST["realestate_price_per_day"]) and !empty($_POST["realestate_price_per_day"])){
				$realestate_price_per_day=addslashes($_POST["realestate_price_per_day"]);

				//get latest inserted field
				$get_latest=$retrieveObj->retriever("realestate","r_id","added_by",$user_id,"r_id","DESC","fetch");
				$new_r_id=$get_latest->r_id;

				//insert price per month
				$fieldsII=array("r_id","r_price_per_day");
				$dataII=array($new_r_id,$realestate_price_per_day);

				//insert to book
				$insertII=$insertObj->inserter("realestate_book",$fieldsII,$dataII);

				if($insertII!="1"){
					die("error");
				}
			}
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["add_vehicle_basic_info_note"])){
		if(empty($_POST["vehicle_name"]) or empty($_POST["vehicle_type"]) or empty($_POST["vehicle_make"]) or empty($_POST["vehicle_model"]) or empty($_POST["vehicle_year"]) or empty(strip_tags($_POST["vehicle_description"]))){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$vehicle_name=addslashes($_POST["vehicle_name"]);
		$vehicle_type=addslashes($_POST["vehicle_type"]);
		$vehicle_make=addslashes($_POST["vehicle_make"]);
		$vehicle_model=addslashes($_POST["vehicle_model"]);
		$vehicle_year=addslashes($_POST["vehicle_year"]);
		$vehicle_description=addslashes($_POST["vehicle_description"]);

		$fields=array("v_name","v_type_id","v_make_id","v_model","v_year","v_description","added_by");
		$data=array($vehicle_name,$vehicle_type,$vehicle_make,$vehicle_model,$vehicle_year,$vehicle_description,$user_id);

		$insert=$insertObj->inserter("vehicle",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["edit_realestate_basic_info_note"])){
		if(empty($_POST["realestate_type"]) or empty($_POST["realestate_offer_type"]) or empty($_POST["realestate_price"]) or empty(strip_tags($_POST["realestate_address"])) or empty(strip_tags($_POST["realestate_description"]))){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$realestate_type=addslashes($_POST["realestate_type"]);
		$realestate_offer_type=addslashes($_POST["realestate_offer_type"]);
		$realestate_price=addslashes($_POST["realestate_price"]);
		$realestate_address=addslashes($_POST["realestate_address"]);
		$realestate_description=addslashes($_POST["realestate_description"]);

		$r_id=addslashes($_POST["r_id"]);

		$data="r_type_id='$realestate_type',r_offer_type='$realestate_offer_type',r_price='$realestate_price',r_address='$realestate_address',r_description='$realestate_description'";

		$update=$updateObj->updater("realestate",$data,"r_id",$r_id);

		if($update=="1"){
			$realestate_price_per_day="";
			if(isset($_POST["realestate_price_per_day"]) and !empty($_POST["realestate_price_per_day"])){
				$realestate_price_per_day=addslashes($_POST["realestate_price_per_day"]);

				//check if price per day already exist
				$check_ppd_existence=$rowcountObj->rowcounter("realestate_book","*","r_id",$r_id);

				if($check_ppd_existence>=1){
					//update
					$dataII="r_price_per_day='$realestate_price_per_day'";

					//update to book
					$updateII=$updateObj->updater("realestate_book",$dataII,"r_id",$r_id);

					if($updateII!="1"){
						die("error");
					}
				}else{
					//insert price per month
					$fieldsII=array("r_id","r_price_per_day");
					$dataII=array($r_id,$realestate_price_per_day);

					//insert to book
					$insertII=$insertObj->inserter("realestate_book",$fieldsII,$dataII);

					if($insertII!="1"){
						die("error");
					}
				}
			}

			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_vehicle_basic_info_note"])){
		if(empty($_POST["vehicle_name"]) or empty($_POST["vehicle_type"]) or empty($_POST["vehicle_make"]) or empty($_POST["vehicle_model"]) or empty($_POST["vehicle_year"]) or empty(strip_tags($_POST["vehicle_description"]))){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$vehicle_name=addslashes($_POST["vehicle_name"]);
		$vehicle_type=addslashes($_POST["vehicle_type"]);
		$vehicle_make=addslashes($_POST["vehicle_make"]);
		$vehicle_model=addslashes($_POST["vehicle_model"]);
		$vehicle_year=addslashes($_POST["vehicle_year"]);
		
		$vehicle_description=addslashes($_POST["vehicle_description"]);

		$v_id=addslashes($_POST["v_id"]);

		$data="v_name='$vehicle_name',v_type_id='$vehicle_type',v_make_id='$vehicle_make',v_model='$vehicle_model',v_year='$vehicle_year',v_description='$vehicle_description'";

		$update=$updateObj->updater("vehicle",$data,"v_id",$v_id);

		if($update=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}


	if(isset($_POST["add_realestate_other_images_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
	$get_r=$retrieveObj->retriever("realestate join realestate_type ON realestate_type.r_type_id=realestate.r_type_id","*","realestate.added_by",$user_id,"realestate.r_id","DESC","fetch");

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/realestates/";
			$imageName = "r_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    if(move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName)){

		    }else{
		    	die(0);
		    }

		    $fields=array("r_id","image","image_type");
			$data=array($get_r->r_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("realestate_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["add_vehicle_other_images_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
	$get_v=$retrieveObj->retriever("vehicle join vehicle_type ON vehicle_type.v_type_id=vehicle.v_type_id","*","vehicle.added_by",$user_id,"vehicle.v_id","DESC","fetch");

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/vehicles/";
			$imageName = "v_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    if(move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName)){

		    }else{
		    	die(0);
		    }

		    $fields=array("v_id","image","image_type");
			$data=array($get_v->v_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("vehicle_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["add_realestate_supporting_image_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$r_id=addslashes($_POST["add_realestate_supporting_image_note"]);

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/realestates/";
			$imageName = "r_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("r_id","image","image_type");
			$data=array($r_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("realestate_images",$fields,$data);
		}
		echo 1;
	}
	if(isset($_POST["add_vehicle_supporting_image_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$v_id=addslashes($_POST["add_vehicle_supporting_image_note"]);

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/vehicles/";
			$imageName = "v_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("v_id","image","image_type");
			$data=array($v_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("vehicle_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["remove_realestate_supporting_image_note"])){
		$r_image_id=addslashes($_POST["remove_realestate_supporting_image_note"]);

		//get photo name
		$get_image=$retrieveObj->retriever("realestate_images","*","r_image_id",$r_image_id,"fetch");

		$image_name=$get_image->image;

		$delete=$deleteObj->deleter("realestate_images","r_image_id",$r_image_id);

		if($delete==1){
			unlink("../../img/realestates/".$image_name);
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["remove_vehicle_supporting_image_note"])){
		$v_image_id=addslashes($_POST["remove_vehicle_supporting_image_note"]);

		//get photo name
		$get_image=$retrieveObj->retriever("vehicle_images","*","v_image_id",$v_image_id,"fetch");

		$image_name=$get_image->image;

		$delete=$deleteObj->deleter("vehicle_images","v_image_id",$v_image_id);

		if($delete==1){
			unlink("../../img/vehicles/".$image_name);
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["remove_realestate_property_note"])){
		$r_id=addslashes($_POST["remove_realestate_property_note"]);

		//delete images
		$get_images_info=$retrieveObj->retriever("realestate_images","*","r_id",$r_id,"fetchAll");
		
		if($get_images_info!="1020"){
			foreach ($get_images_info as $image_info) {
				$image_name=$image_info->image;
				if(file_exists("../../img/realestates/".$image_name)){
					unlink("../../img/realestates/".$image_name);
				}
				
			}
			//delete property from database
			$delete=$deleteObj->deleter("realestate","r_id",$r_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}
	if(isset($_POST["remove_vehicle_property_note"])){
		$v_id=addslashes($_POST["remove_vehicle_property_note"]);

		//delete images
		$get_images_info=$retrieveObj->retriever("vehicle_images","*","v_id",$v_id,"fetchAll");
		
		if($get_images_info!="1020"){
			foreach ($get_images_info as $image_info) {
				$image_name=$image_info->image;
				if(file_exists("../../img/vehicles/".$image_name)){
					unlink("../../img/vehicles/".$image_name);
				}
				
			}
			//delete property from database
			$delete=$deleteObj->deleter("vehicle","v_id",$v_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}
	if(isset($_POST["remove_auction_property_note"])){
		$a_id=addslashes($_POST["remove_auction_property_note"]);

		//delete images
		$get_images_info=$retrieveObj->retriever("auction_images","*","a_id",$a_id,"fetchAll");
		
		if($get_images_info!="1020"){
			foreach ($get_images_info as $image_info) {
				$image_name=$image_info->image;
				if(file_exists("../../img/auctions/".$image_name)){
					unlink("../../img/auctions/".$image_name);
				}
				
			}
			//delete property from database
			$delete=$deleteObj->deleter("auction","a_id",$a_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}

	if(isset($_POST["remove_auction_bid_property_note"])){
		$a_bid_id=addslashes($_POST["remove_auction_bid_property_note"]);
		
		//delete property from database
		$delete=$deleteObj->deleter("auction_bid","a_bid_id",$a_bid_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
	}

	if(isset($_POST["add_realestate_type_note"])){
		$realestate_type=addslashes($_POST["realestate_type"]);

		$fields=array("r_type");
		$data=array($realestate_type);

		$insert=$insertObj->inserter("realestate_type",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}

	if(isset($_POST["add_vehicle_type_note"])){
		$vehicle_type=addslashes($_POST["vehicle_type"]);

		$fields=array("v_type");
		$data=array($vehicle_type);

		$insert=$insertObj->inserter("vehicle_type",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}
	if(isset($_POST["add_vehicle_make_note"])){
		$vehicle_make=addslashes($_POST["vehicle_make"]);

		$fields=array("v_make");
		$data=array($vehicle_make);

		$insert=$insertObj->inserter("vehicle_make",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}



	if(isset($_POST["edit_realestate_type_note"])){
		$realestate_type=addslashes($_POST["realestate_type"]);
		$r_type_id=addslashes($_POST["edit_realestate_type_note"]);
		
		$data="r_type='$realestate_type'";

		$update=$updateObj->updater("realestate_type",$data,"r_type_id",$r_type_id);

		if($update=="1"){
			echo 1;
		}else if($update=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}
	if(isset($_POST["edit_vehicle_type_note"])){
		$vehicle_type=addslashes($_POST["vehicle_type"]);
		$v_type_id=addslashes($_POST["edit_vehicle_type_note"]);
		
		$data="v_type='$vehicle_type'";

		$update=$updateObj->updater("vehicle_type",$data,"v_type_id",$v_type_id);

		if($update=="1"){
			echo 1;
		}else if($update=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}
	if(isset($_POST["edit_vehicle_make_note"])){
		$vehicle_make=addslashes($_POST["vehicle_make"]);
		$v_make_id=addslashes($_POST["edit_vehicle_make_note"]);
		
		$data="v_make='$vehicle_make'";

		$update=$updateObj->updater("vehicle_make",$data,"v_make_id",$v_make_id);

		if($update=="1"){
			echo 1;
		}else if($update=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}
	}

	if(isset($_POST["remove_realestate_type_note"])){
		$r_type_id=addslashes($_POST["remove_realestate_type_note"]);

		$delete=$deleteObj->deleter("realestate_type","r_type_id",$r_type_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
	}

	if(isset($_POST["remove_vehicle_type_note"])){
		$v_type_id=addslashes($_POST["remove_vehicle_type_note"]);

		$delete=$deleteObj->deleter("vehicle_type","v_type_id",$v_type_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
	}
	if(isset($_POST["remove_vehicle_make_note"])){
		$v_make_id=addslashes($_POST["remove_vehicle_make_note"]);

		$delete=$deleteObj->deleter("vehicle_make","v_make_id",$v_make_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
	}

	//..........
	if(isset($_POST["update_commission_percentage_note"])){
		if(empty($_POST["update_commission_percentage_note"])){
			die("<p class='alert alert-warning'>Enter commission percentage</p>");
		}

		$commission_percentage=addslashes($_POST["update_commission_percentage_note"]);

		//check if exists
		$get_cp=$retrieveObj->retriever("auction_config","*","config_name","commission_percentage","fetch");
		if($get_cp=="1020"){
			//insert
			$fields=array("config_name","config_value");
			$data=array("commission_percentage",$commission_percentage);

			$insert=$insertObj->inserter("auction_config",$fields,$data);
			if($insert=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else{
			//update
			$data="config_value='$commission_percentage'";

			$update=$updateObj->updater("auction_config",$data,"config_name","commission_percentage");

			if($update=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}

	if(isset($_POST["update_max_bidding_period_note"])){
		if(empty($_POST["update_max_bidding_period_note"])){
			die("<p class='alert alert-warning'>Enter Maximum bidding period</p>");
		}

		$max_bidding_period=addslashes($_POST["update_max_bidding_period_note"]);

		//check if exists
		$get_cp=$retrieveObj->retriever("auction_config","*","config_name","max_bidding_period","fetch");
		if($get_cp=="1020"){
			//insert
			$fields=array("config_name","config_value");
			$data=array("max_bidding_period",$max_bidding_period);

			$insert=$insertObj->inserter("auction_config",$fields,$data);
			if($insert=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else{
			//update
			$data="config_value='$max_bidding_period'";

			$update=$updateObj->updater("auction_config",$data,"config_name","max_bidding_period");

			if($update=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}

	if(isset($_POST["update_max_property_reservation_period_note"])){
		if(empty($_POST["update_max_property_reservation_period_note"])){
			die("<p class='alert alert-warning'>Enter maximum reservation period</p>");
		}

		$max_property_reservation_period=addslashes($_POST["update_max_property_reservation_period_note"]);

		//check if exists
		$get_cp=$retrieveObj->retriever("realestate_config","*","config_name","max_property_reservation_period","fetch");
		if($get_cp=="1020"){
			//insert
			$fields=array("config_name","config_value");
			$data=array("max_property_reservation_period",$max_property_reservation_period);

			$insert=$insertObj->inserter("realestate_config",$fields,$data);
			if($insert=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}else{
			//update
			$data="config_value='$max_property_reservation_period'";

			$update=$updateObj->updater("realestate_config",$data,"config_name","max_property_reservation_period");

			if($update=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
	}

	if(isset($_POST["delete_vehicle_enquiry_note"])){
		$v_enquiry_id=addslashes($_POST["delete_vehicle_enquiry_note"]);

		
		//delete property from database
		$delete=$deleteObj->deleter("vehicle_enquiries","v_enquiry_id",$v_enquiry_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
	}

	if(isset($_POST["delete_realestate_enquiry_note"])){
		$r_enquiry_id=addslashes($_POST["delete_realestate_enquiry_note"]);

		
		//delete property from database
		$delete=$deleteObj->deleter("realestate_enquiries","r_enquiry_id",$r_enquiry_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
	}

	if(isset($_POST["delete_auction_enquiry_note"])){
		$a_enquiry_id=addslashes($_POST["delete_auction_enquiry_note"]);

		
		//delete property from database
		$delete=$deleteObj->deleter("auction_enquiries","a_enquiry_id",$a_enquiry_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
	}

	if(isset($_POST['setVehicleStatusNote'])){
		$v_id=addslashes($_POST['v_id']);
		$status_selected=addslashes($_POST['status_selected']);

		if($status_selected=="available" or $status_selected=="sold"){
			echo $updateObj->updater("vehicle","v_status='$status_selected'","v_id",$v_id);
		}
	}

	if(isset($_POST['setAuctionStatusNote'])){
		$a_id=addslashes($_POST['a_id']);
		$status_selected=addslashes($_POST['status_selected']);

		if($status_selected=="available" or $status_selected=="sold"){
			echo $updateObj->updater("auction","a_status='$status_selected'","a_id",$a_id);
		}
	}

	if(isset($_POST['setRealestateStatusNote'])){
		$r_id=addslashes($_POST['r_id']);
		$status_selected=addslashes($_POST['status_selected']);

		//get current status
		$get_current_status=$retrieveObj->retriever("realestate","r_status","r_id",$r_id,"fetch");

		if($get_current_status->r_status=="reserved" and $status_selected!="reserved"){
			$deleteObj->deleter("realestate_reserved","r_id",$r_id);
		}


		if($status_selected=="available" or $status_selected=="sold" or $status_selected=="rent" or $status_selected=="booked" or $status_selected=="reserved"){
			$update = $updateObj->updater("realestate","r_status='$status_selected'","r_id",$r_id);

			if($update=="1"){
				if($status_selected=="reserved"){
					$get_max_property_reservation_period=$retrieveObj->retriever("realestate_config","*","config_name","max_property_reservation_period","fetch");
					$max_property_reservation_period="";
				    if($get_max_property_reservation_period!="1020"){
				    	$max_property_reservation_period=$get_max_property_reservation_period->config_value;
				    }else{
				    	die("<p class='alert alert-alert'>Sorry,Currently we can not reserve this property for you</p>");
				    }
					//insert to reserved
					$fields=array("r_id","r_reserved_date","max_reserve_period");
					$data=array($r_id,date("Y-m-d H:i:s"),$max_property_reservation_period);

					$insertObj->inserter("realestate_reserved",$fields,$data);
					echo 1;
				}else{
					echo 1;
				}
			}
		}
	}

	if(isset($_POST["set_realestate_rent_book_note"])){
		//VALIDATION
		if(empty($_POST["email"])){
			die("<p class='alert alert-warning'> Enter email</p>");
		}else if(isset($_POST["price"]) and empty($_POST["price"])){
			die("<p class='alert alert-warning'> Enter Price</p>");
		}


		$email=addslashes($_POST["email"]);
		$r_id=addslashes($_POST["property_id"]);
		$set_action=addslashes($_POST["set_realestate_rent_book_note"]);

		//check if a user is already registered
		if($rowcountObj->rowcounter("users","*","email",$email)>=1){
			//continue
		}else{

			//create user account
			$random_password=uniqid();
			$password=password_hash($random_password, PASSWORD_DEFAULT);
			$fields=array("email","password");
			$data=array($email,$password);

			$insert=$insertObj->inserter("users",$fields,$data);

			if($insert=="1"){
			//get user id
				$get_user=$retrieveObj->retriever("users","*","users.email",$email,"user_id","DESC","fetch");
				$get_user_id=$get_user->user_id;

				$get_user_id=$retrieveObj->retriever("users","*","email",$email,"fetch");
				if( $get_user_id!="1020"){
					$get_role_id=$retrieveObj->retriever("user_role","*","user_role","customer","fetch");
					//insert role
					$fields2=array("user_id","role_id");
					$data2=array($get_user_id->user_id,$get_role_id->role_id);

					$create_account2=$insertObj->inserter("user_roles",$fields2,$data2);
					if($create_account2=="1"){
						//send email
						$send_verification_email=send_verify_email($email,$random_password);
			 		    if($send_verification_email==0) {
			 		        $deleteObj->deleter("users","user_id",$get_user_id->user_id);
			 		        die("<p class='alert alert-warning'>Something went wrong, try again later please try again later</p>");
			 		    }else if($send_verification_email==1){
							//pass
						}
					}else{
						//failed
						$deleteObj->deleter("users","email",$email);
						echo 0;
					}
				}else{
					//failed
					$deleteObj->deleter("users","email",$email);
					echo 0;
				}
			}else if ($insert=="0"){
				echo 0;
			}else if($insert=="entry_exists"){
				die("<p class='alert alert-warning'>The email you entered is already registered by another user</p>");
			}else{
				die("<p class='alert alert-warning'>Something went wrong, please try again later</p>");
			}
		}

		//assign rent or book
		if($set_action=="set_rent"){
			$current_date_time = date('Y-m-d H:i:s');
			$r_price = addslashes($_POST["price"]);

			//VALIDATION
			if(empty($_POST["r_rented_date"])){
				die("<p class='alert alert-warning'> Rent start date</p>");
			}
			$r_rented_date = addslashes($_POST["r_rented_date"]);

			//get user id
			$get_user_id=$retrieveObj->retriever("users","user_id","email",$email,"fetch");
			$user_id=$get_user_id->user_id;

			//check if r_id already exist
			if($rowcountObj->rowcounter("realestate_rented","*","r_id",$r_id)>=1){
				//update
				if($updateObj->updater("realestate_rented","
						user_id='$user_id',
						r_rented_date='$r_rented_date',
						r_rent_expirely_date='$r_rented_date'
					","r_id",$r_id)==1)
				{
					//pass
				}else{
					die(0);
				}
			}else{
				//insert to realestate_rent
				$fields = array("r_id" , "user_id","r_rented_date","r_rent_expirely_date");
				$data=array($r_id,$user_id,$r_rented_date,$r_rented_date);

				$insert=$insertObj->inserter("realestate_rented",$fields,$data);
				//insert
				if($insert=="1"){
					//pass
				}else{
					die(0);
				}
			}

			//update realestate
			if($updateObj->updater("realestate","r_status='rent',r_price='$r_price'","r_id",$r_id)=="1"){
				//send email
				$subject = "REALESTATE RENT OFFER";
				$body = 
				"
					<p>You have a rent offer. Accept the offer By <a href='$root_dir'>Logging in</a> and making payment in your dashboard</p>
					<p>Regards,</p>
					<p><strong>SGW Auctioneers & Estate Agents TEAM</strong></p>
				";
				$sendemailObj->phpmailer_send($mailer_r_path,$subject,$body,$email);

				echo 1;
			}else{
				//delete user from realestate rent
				$deleteObj->deleter("realestate_rent","r_id='$r_id' and user_id",$user_id);
				die(0);
			}
			
		}else if($set_action=="set_book"){
			$current_date_time = date('Y-m-d H:i:s');
			$r_price = addslashes($_POST["price"]);

			//VALIDATION
			if(empty($_POST["r_book_date_from"])){
				die("<p class='alert alert-warning'> Book start date</p>");
			}
			$r_book_date_from = addslashes($_POST["r_book_date_from"]);

			//get user id
			$get_user_id=$retrieveObj->retriever("users","user_id","email",$email,"fetch");
			$user_id=$get_user_id->user_id;

			//check if price per day already exist
				$check_ppd_existence=$rowcountObj->rowcounter("realestate_book","*","r_id",$r_id);

				if($check_ppd_existence>=1){
					//update
					$dataII="r_price_per_day='$r_price'";

					//update to book
					$updateII=$updateObj->updater("realestate_book",$dataII,"r_id",$r_id);

					if($updateII!="1"){
						die("error");
					}
				}else{
					//insert price per month
					$fieldsII=array("r_id","r_price_per_day");
					$dataII=array($r_id,$r_price);

					//insert to book
					$insertII=$insertObj->inserter("realestate_book",$fieldsII,$dataII);

					if($insertII!="1"){
						die("error");
					}
				}

			//check if r_id already exist
			if($rowcountObj->rowcounter("realestate_booked","*","r_id",$r_id)>=1){
				//update
				if($updateObj->updater("realestate_booked","
						user_id='$user_id',
						r_book_date_from='$r_book_date_from',
						r_book_date_to='$r_book_date_from'
					","r_id",$r_id)==1)
				{
					//pass
				}else{
					die(0);
				}
			}else{
				//insert to realestate_booked
				$fields = array("r_id" , "user_id","r_book_date_from","r_book_date_to");
				$data=array($r_id,$user_id,$r_book_date_from,$r_book_date_from);

				$insert=$insertObj->inserter("realestate_booked",$fields,$data);
				//insert
				if($insert=="1"){
					//pass
				}else{
					die(0);
				}
			}

			//update realestate
			if($updateObj->updater("realestate","r_status='booked'","r_id",$r_id)=="1" ){
				//send email
				$subject = "REALESTATE BOOK OFFER";
				$body = 
				"
					<p>You have a realestate book offer. Accept the offer By <a href='$root_dir'>Logging in</a> and making payment in your dashboard</p>
					<p>Regards,</p>
					<p><strong>SGW Auctioneers & Estate Agents TEAM</strong></p>
				";
				$sendemailObj->phpmailer_send($mailer_r_path,$subject,$body,$email);

				echo 1;
			}else{
				//delete user from realestate rent
				$deleteObj->deleter("realestate_rent","r_id='$r_id' and user_id",$user_id);
				die(0);
			}
		}
	}


	$current_date_time=date("Y-m-d H:i:s");

	if(isset($_POST["add_bid_basic_info_note"])){
		//VALIDATE
		if(empty($_POST["item_name"]) or empty($_POST["item_description"]) or empty($_POST["bid_start_price"]) or empty($_POST["bid_start_date"]) or empty($_POST["bid_start_time"]) or empty($_POST["bid_end_date"]) or empty($_POST["bid_end_time"])){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		


		$item_name=addslashes($_POST["item_name"]);
		$item_description=addslashes($_POST["item_description"]);
		$bid_start_price=addslashes($_POST["bid_start_price"]);
		$bid_start_date=addslashes($_POST["bid_start_date"]);
		$bid_start_time=addslashes($_POST["bid_start_time"]);
		$bid_end_date=addslashes($_POST["bid_end_date"]);
		$bid_end_time=addslashes($_POST["bid_end_time"]);



		//process bid start and end date-time
		$bid_start_date=$bid_start_date." ".$bid_start_time;
		$bid_end_date=$bid_end_date." ".$bid_end_time;
		$a_bid_status="";
		//Date validation
		if($bid_start_date>$bid_end_date){
			die("<p class='alert alert-warning'>Bid end date and time can not be later than bid start date and time</p>");
		}else if($bid_start_date<$current_date_time){
			die("<p class='alert alert-warning'>Bid start date and time should be later than current time</p>");
		}

		//validate if the dates are within max bidding period
			$max_bidding_period="";
		    //get max bidding period
		    $get_max_bidding_period=$retrieveObj->retriever("auction_config","*","config_name","max_bidding_period","fetch");
		    if($get_max_bidding_period!="1020"){
		    	$max_bidding_period=$get_max_bidding_period->config_value;
		    }
			$get_date_diff1=strtotime($bid_start_date);
			$get_date_diff2=strtotime($bid_end_date);
			$diff_from_dates = $get_date_diff2 - $get_date_diff1;
			$bidding_hours = $diff_from_dates / ( 60 * 60 );

			if($bidding_hours>$max_bidding_period){
				die("<p class='alert alert-warning'>Hours between dates and time you entered exceed maximum bidding period, the maximum bidding period id $max_bidding_period</p>");
			}

			//get commission percentage
			$commission_percentage="";
		    //get max bidding period
		    $get_commission_percentage=$retrieveObj->retriever("auction_config","*","config_name","commission_percentage","fetch");
		    if($get_commission_percentage!="1020"){
		    	$commission_percentage=$get_commission_percentage->config_value;
		    }

		if($current_date_time==$bid_start_date){
			$a_bid_status="running";
		}else{
			$a_bid_status="pending";
		}


		$fields=array("a_name","a_description","a_bid_start_price","a_bid_start_date","a_bid_end_date","user_id","a_bid_status","expected_commission_percentage");
		$data=array($item_name,$item_description,$bid_start_price,$bid_start_date,$bid_start_date,$user_id,$a_bid_status,$commission_percentage);

		$insert=$insertObj->inserter("auction",$fields,$data);

		if($insert=="1"){
			//get last inserted data by the user
			echo 1;
		}else if($insert=="0" or $insert=="" or $insert=="entry_exists"){
			echo $insert;
		}

	}
	if(isset($_POST["edit_bid_basic_info_note"])){
		//VALIDATE
		if(empty($_POST["item_name"]) or empty($_POST["item_description"]) or empty($_POST["bid_start_price"]) or empty($_POST["bid_start_date"]) or empty($_POST["bid_start_time"]) or empty($_POST["bid_end_date"]) or empty($_POST["bid_end_time"])){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$item_name=addslashes($_POST["item_name"]);
		$item_description=addslashes($_POST["item_description"]);
		$bid_start_price=addslashes($_POST["bid_start_price"]);
		$bid_start_date=addslashes($_POST["bid_start_date"]);
		$bid_start_time=addslashes($_POST["bid_start_time"]);
		$bid_end_date=addslashes($_POST["bid_end_date"]);
		$bid_end_time=addslashes($_POST["bid_end_time"]);
		$a_id=addslashes($_POST["a_id"]);



		//process bid start and end date-time
		$bid_start_date=$bid_start_date." ".$bid_start_time;
		$bid_end_date=$bid_end_date." ".$bid_end_time;
		$a_bid_status="";
		//Date validation
		$get_current_bid_dates=$retrieveObj->retriever("auction","*","a_id",$a_id,"fetch");
		$current_start_date=$get_current_bid_dates->a_bid_start_date;
		if($bid_start_date>$bid_end_date){
			die("<p class='alert alert-warning'>Bid end date and time can not be later than bid start date and time</p>");
		}else if($bid_start_date<$current_start_date){
			die("<p class='alert alert-warning'>Bid start date and time should be equal to or later than current bid date and time</p>");
		}

		if($current_date_time==$bid_start_date){
			$a_bid_status="running";
		}else if($current_date_time<$bid_start_date){
			$a_bid_status="pending";
		}else{
			$a_bid_status="closed";
		}


		$data="a_name='$item_name',a_description='$item_description',a_bid_start_price='$bid_start_price',a_bid_start_date='$bid_start_date',a_bid_end_date='$bid_start_date',user_id='$user_id',a_bid_status='$a_bid_status'";

		$update=$updateObj->updater("auction",$data,"a_id",$a_id);

		if($update=="1"){
			//get last inserted data by the user
			echo 1;
		}else if($update=="0" or $update=="" or $update=="entry_exists"){
			echo $update;
		}

	}

	if(isset($_POST["add_bid_item_other_images_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$get_a=$retrieveObj->retriever("auction","*","user_id",$user_id,"a_id","DESC","fetch");

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/auctions/";
			$imageName = "a_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("a_id","image","image_type");
			$data=array($get_a->a_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("auction_images",$fields,$data);
		}
		echo 1;
	}
if(isset($_POST["add_auction_supporting_image_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$a_id=addslashes($_POST["add_auction_supporting_image_note"]);

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/auctions/";
			$imageName = "a_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("a_id","image","image_type");
			$data=array($a_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("auction_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["remove_auction_supporting_image_note"])){
		$a_image_id=addslashes($_POST["remove_auction_supporting_image_note"]);

		//get photo name
		$get_image=$retrieveObj->retriever("auction_images","*","a_image_id",$a_image_id,"fetch");
		$image_name=$get_image->image;

		$delete=$deleteObj->deleter("auction_images","a_image_id",$a_image_id);

		if($delete==1){
			unlink("../../img/auctions/".$image_name);
			echo 1;
		}else{
			echo 0;
		}
	}


?>