<?php
	require_once("../../session_check.php");
    require_once("../../../classes/main_classes.php");

    //OBJECTS
    $retrieveObj=new RETRIEVE();
?>


<p class="text-center lead font-weight-bold"> Add Real estate property</p>
<div id="add_realestate_item_container" class="bg-white rounded p-3 shadow-sm">
	<p class="text-center lead font-weight-bold"> <small class="text-muted">Basic information</small></p>
	<div id="response">
		<hr class="mx-auto mb-4" style="max-width: 80%">
	</div>

	<form id="add_realestate_basic_info_form">
		<div class="row my-2">
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="realestate_type">Type</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<?php
					//get types
					$get_types=$retrieveObj->retriever("realestate_type","*","fetchAll");

					if($get_types!="1020"){

				?>
				<select class="form-control" name="realestate_type">
				<?php
					foreach ($get_types as $type) {
			?>
						<option value='<?php echo $type->r_type_id ?>'><?php echo $type->r_type; ?></option>
			<?php
					}
				?>
				</select>
			<?php 
				}else{
					echo "<p class='alert alert-warning'>Please add realestate types to continue</p>";
				} 
			?>
			</div>
		</div>

		<div class="row my-2">
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="realestate_offer_type">Offer type</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<select class="form-control" name="realestate_offer_type" name="realestate_offer_type" id="realestate_offer_type" onchange="set_realestate_price_fields('on_add')">
					<option value="for_sale">For sale</option>
					<option value="for_rent">For Rent</option>
				</select>
			</div>
		</div>
		<div class="row">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="realestate_price_container">
				<div class="row my-2" >
					<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
						<label for="realestate_date">Price (MKW)</label>
					</div>
					<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
						<input class="form-control" type="number" name="realestate_price" id="realestate_price">
					</div>
				</div>
			</div>
		</div>
		<div class="row my-3 rounded">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
				<div class="p-2 shadow-sm">
					<label for="realestate_address">Address</label>
					<textarea class="form-control" name="realestate_address" id="realestate_address"></textarea>
				</div>	
			</div>
		</div>
		
		<div class="row my-3 rounded">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
				<div class="p-2 shadow-sm">
					<label for="realestate_description">Description</label>
					<textarea class="form-control" name="realestate_description" id="realestate_description"></textarea>
				</div>
			</div>
		</div>
		<div id="add_realestate_basic_info_response">
			
		</div>
		<div class="py-3 text-right">
			<input type="hidden" name="add_realestate_basic_info_note">
			<button class="btn bg_primary_color text-light ml-auto" type="submit" onclick="add_realestate_basic_info()">Next <span class="fas fa-arrow-right"></span></button>
		</div>
	</form>
</div>

<script type="text/javascript">
	$(document).ready(function(){
		var editor = new Simditor({
		    textarea: $('#realestate_description')
		    //optional options
		  });
	})
</script>
	