<?php
	$country_dial_codes = file_get_contents('../data/country_dial_codes.json');
	$country_dial_codes = json_decode($country_dial_codes, true); // decode the JSON into an associative array
	$current_location=$_POST["current_location"];
?>
<style type="text/css">
.divider-text {
    position: relative;
    text-align: center;
    margin-top: 15px;
    margin-bottom: 15px;
}
.divider-text span {
    padding: 7px;
    font-size: 12px;
    position: relative;   
    z-index: 2;
}
.divider-text:after {
    content: "";
    position: absolute;
    width: 100%;
    border-bottom: 1px solid #ddd;
    top: 55%;
    left: 0;
    z-index: 1;
}

.btn-facebook {
    background-color: #405D9D;
    color: #fff;
}
.btn-twitter {
    background-color: #42AEEC;
    color: #fff;
}
</style>

<div class="card" >
	<article class="card-body mx-auto " style="width:100%; border:0px;">
		<h4 class="card-title mt-3 text-center">Create Account</h4>
		<hr>
		
		<form id="user_signup_form">
			<div class="form-group input-group">
				<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-user"></i> </span>
				 </div>
		        <input required name="firstname" class="form-control" placeholder="Firstname" type="text">
		    </div> <!-- form-group// -->
		    <div class="form-group input-group">
				<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-user"></i> </span>
				 </div>
		        <input required name="lastname" class="form-control" placeholder="Lastname" type="text">
		    </div> <!-- form-group// -->
		    <div class="form-group input-group">
		    	<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-envelope"></i> </span>
				 </div>
		        <input required name="email" class="form-control" placeholder="Email address" type="email">
		    </div> <!-- form-group// -->
		    <div class="form-group input-group">
		    	<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-phone"></i> </span>
				</div>
				<select required class="custom-select" style="max-width: 160px;" name="phone_code"> 
					<?php
						foreach ($country_dial_codes as $dial_code) {
							$dial_code_selected="";
							if($dial_code["dial_code"]=="+265"){
								$dial_code_selected="selected";
							}else{
								$dial_code_selected="";
							}
							echo '<option '.$dial_code_selected.' data-countryCode="'.$dial_code["code"].'" value="'.$dial_code["dial_code"].'" >'.$dial_code["name"].' ('.$dial_code["dial_code"].')</option>';
						}
					?>
					 
				</select>
		    	<input required name="phone" class="form-control" placeholder="Phone number" type="tel">
		    </div> <!-- form-group// -->
		    <div class="form-group input-group">
		    	<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-building"></i> </span>
				</div>
				<textarea required class="form-control" placeholder="Address" name="address"></textarea>
			</div> <!-- form-group end.// -->
		    <div class="form-group input-group">
		    	<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-lock"></i> </span>
				</div>
		        <input required class="form-control" placeholder="Create password" type="password" name="password">
		    </div> <!-- form-group// -->
		    <div class="form-group input-group">
		    	<div class="input-group-prepend">
				    <span class="input-group-text"> <i class="fa fa-lock"></i> </span>
				</div>
		        <input required class="form-control" placeholder="Repeat password" type="password" name="rpassword">
		    </div> <!-- form-group// -->  
		    <div class="text-center" id="user_signup_response"></div>                                    
		    <div class="form-group">
		    	<input type="hidden" name="user_signup_note">
		        <button type="submit" class="btn btn-block bg_primary_color text-light" onclick="sign_up('<?php echo $current_location ?>')"> Create Account  </button>
		    </div> <!-- form-group// -->      
		    <p class="text-center text-dark">Have an account? <a href="#" onclick="signin_view('<?php echo $current_location ?>')" class="text-primary">Log In</a> </p>                                                                 
		</form>
	</article>
</div> <!-- card.// -->