<?php
	require_once("session_check.php");

	$geoPlugin_array = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?geoplugin_countryName=Malawi') );
    //$geoPlugin_array = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?ip=41.70.127.255'));

	if($geoPlugin_array==null){
	    ob_clean();
	    die("<p class='alert alert-warning'>Sorry, something went wrong, try again later</p>");
	}

	$amount_to_be_paid=$_SESSION["amount_to_be_paid"];

	//convert kwacha to dollar
    $amount_to_be_paid_in_kwacha=$amount_to_be_paid;
    $amount_to_be_paid=$amount_to_be_paid/$geoPlugin_array["geoplugin_currencyConverter"];
    $amount_to_be_paid=number_format((float)$amount_to_be_paid, 2, '.', '');

    $rent_pay_note="";
	$book_pay_note="";
	if(isset($_POST["rent_pay_note"])){
		$rent_pay_note=addslashes($_POST["rent_pay_note"]);
		$amount_to_be_paid=$amount_to_be_paid*(float)$rent_pay_note;
	}else if(isset($_POST["book_pay_note"])){
		$book_pay_note=addslashes($_POST["book_pay_note"]);
		$amount_to_be_paid=$amount_to_be_paid*(float)$book_pay_note;
	}else{
		die("<p class='alert alert-warning'>Something went wrong</p>");
	}
?>


<div id="paypal-button-container" class="mx-auto disabledElement"></div>

    <script>
      paypal.Buttons({
        createOrder: function(data, actions) {
          // This function sets up the details of the transaction, including the amount and line item details.
          return actions.order.create({
            "intent": "CAPTURE",
            purchase_units: [{
              amount: {
                value: '<?php echo $amount_to_be_paid ?>'
              }
            }]
          });
        },
        onApprove: function(data, actions) {
          // This function captures the funds from the transaction.
          return actions.order.capture().then(function(capture_) {
            // This function shows a transaction success message to your buyer.
            //alert('Transaction completed by ' + details.payer.name.given_name);

            var rent_period="";
            var book_period="";
            var rent_start_date="";
            var book_start_date="";

            if(document.getElementById("rent_period")!=null){
              rent_period=$("#rent_period").val();
            }
            if(document.getElementById("book_period")!=null){
              book_period=$("#book_period").val();
            }
            if(document.getElementById("rent_start_date")!=null){
              rent_start_date=$("#rent_start_date").val();
            }
            if(document.getElementById("book_start_date")!=null){
              book_start_date=$("#book_start_date").val();
            }

            $.ajax({
                url: "includes_/payments/paypal/paypal.php", 
                type: "POST",
                
                data:  {
                  capture_:capture_,
                  rent_period:rent_period,
                  book_period:book_period,
                  rent_start_date:rent_start_date,
                  book_start_date:book_start_date
                },
                    success: function(resp) {
                      if(resp==1){
                        $("#paypal_response_main").html('<p class="text-center lead alert alert-primary">Payment successfull, Thank you for choosing us.</p><p class="text-center my-2 text-dark">Redirecting...</p>');
                        setTimeout(function(){ 
                          /*if(current_location=="realestate"){
                            window.location.href= "realestate.php";
                          }else if(current_location=="auction"){
                            window.location.href= "auction.php";
                          }else if(current_location=="vehicle"){
                            window.location.href= "vehicle.php";
                          }else{
                            window.location.href= "customer.php";
                          }*/
                          window.location.href= "customer.php";
                        }, 3000);
                      }else{
                        $("#paypal_response_id").html(resp);
                      }
                    },
                    error: function(xhr, status, error) {
                      //alert(error.Message);
                    }
              });
          });
        }
      }).render('#paypal-button-container');
      //This function displays Smart Payment Buttons on your web page.

      $(document).ready(function(){
        set_book_paypal_button()
        set_rent_paypal_button()
      })
    </script>