<?php
    require_once("session_check.php");
    require_once("classes/main_classes.php");
    $current_location="vehicle";
    $current_date=date("Y-m-d");

    //OBJECTS
    $insertObj=new INSERT();
    $updateObj=new UPDATE();
    $retrieveObj=new RETRIEVE();
    $deleteObj=new DELETE();
    $rowcountObj=new ROWCOUNT();
    $allrowcountObj=new ALLROWCOUNT();

    //GET VEHICLE MAKE
    $get_vehicle_makes=$retrieveObj->retriever("vehicle_make","*","fetchAll");

    //GET VEHICLE TYPES
    $get_vehicle_types=$retrieveObj->retriever("vehicle_type","*","fetchAll");

    //TREADING VEHICLES
    $get_trending_vehicles=$retrieveObj->retriever("vehicle 
      JOIN vehicle_make ON vehicle_make.v_make_id=vehicle.v_make_id 
      JOIN vehicle_type ON vehicle.v_type_id=vehicle.v_type_id 
      JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id WHERE vehicle.v_status='available' and vehicle_images.image_type='primary_image' GROUP BY vehicle.v_id ORDER BY vehicle.v_views DESC LIMIT 12","*","fetchAll");

?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="We have different types of vehicles at affordable prices. We are the best vehicle dealers in Malawi.">
     <meta name="keywords" content="SGW, SGW Malawi, Vehicle Dealer, Car Dealer, Car Seller, Vehicle Seller, Malawi best Vehicle Dealer, Malawi best car Seller">

    <title>SGW Vehicle Dealer</title>

    <!-- Bootstrap CSS CDN -->
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.1.1/aos.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-1.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-2.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-3.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-4.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-5.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer.css">
    <link href="assets/croppie/croppie.css" rel="stylesheet">
    <!-- Our Custom CSS -->
    <link rel="stylesheet" href="css/vehicle.css">
    <link rel="stylesheet" href="css/universal.css">
    <link rel="stylesheet" href="css/ex_items.css">

    <!-- Font Awesome JS -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=ABeeZee">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto+Slab:300,400">
    <!--link rel="stylesheet" href="assets/fonts/font-awesome.min.css"-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css" media="screen">

</head>

<body>
    <?php include("main_nav.php"); ?>
    <div class="wrapper" id="page-top">
        <!-- Sidebar Holder -->
        <nav id="sidebar" class="shadow bg-dark">
            <div class="" style="height: 100vh; overflow-y: auto;" id="inner_v_sidebar">
            <ul class="list-unstyled components py-0">
                <p class="mb-0 py-1" style="background-color: black;"><small class="font-weight-bold">Vehicle By Make</small></p>
                <li class="">
                    <a href="#vehicle_main_section" class="py-1 js-scroll-trigger d-flex  justify-content-between" onclick="view_vehicles_by_make('all_')">
                        <strong> All</strong>
                        <span class="font-weight-bold"><?php echo $allrowcountObj->allrowcounter("vehicle_make JOIN vehicle ON vehicle.v_make_id=vehicle.v_make_id WHERE vehicle.v_status='available' GROUP BY vehicle.v_id","DISTINCT *"); ?></span>
                    </a>
                </li>
                <?php
                    if($get_vehicle_makes!="1020"){
                        foreach ($get_vehicle_makes as $make) {
                ?>
                            <li class="text-light ">
                                <a href="#vehicle_main_section " class="py-1 js-scroll-trigger d-flex justify-content-between pr-2" onclick="view_vehicles_by_make(<?php echo $make->v_make_id; ?>)">
                                    <small class="pt-2"><span class=""></span><?php echo $make->v_make;  ?></small>
                                    <p class="mb-0 p-0">
                                        <span class="badge text-light" style="background-color: black;">
                                            <?php echo $allrowcountObj->allrowcounter("vehicle_make JOIN vehicle ON vehicle.v_make_id=vehicle.v_make_id WHERE vehicle.v_status='available' and vehicle.v_make_id='$make->v_make_id' GROUP BY vehicle.v_id","DISTINCT *"); ?>
                                        </span>
                                    </p>
                                </a>
                                
                            </li>
                <?php
                        }
                    }else{
                        echo "";
                    }
                ?>
            </ul>
             <ul class="list-unstyled components py-0">
                <p class="mb-0 py-1" style="background-color: black;"><small class="font-weight-bold">Vehicle By Body Type</small></p>
                <li class="">
                    <a href="#vehicle_main_section" class="py-1 js-scroll-trigger d-flex justify-content-between" onclick="view_vehicles_by_type('all_')">
                        <strong> All</strong>
                        <span class="font-weight-bold" >
                            <?php echo $allrowcountObj->allrowcounter("vehicle_type JOIN vehicle ON vehicle.v_type_id=vehicle.v_type_id WHERE vehicle.v_status='available' GROUP BY vehicle.v_id","DISTINCT *"); ?>
                        </span>
                    </a>
                </li>
                <?php
                    if($get_vehicle_makes!="1020"){
                        foreach ($get_vehicle_types as $type) {
                ?>
                            <li class="text-light">
                                <a href="#vehicle_main_section" class="py-1 js-scroll-trigger  d-flex justify-content-between pr-2" onclick="view_vehicles_by_type(<?php echo $type->v_type_id; ?>)">
                                    <small class="pt-2"><span class=""></span><?php echo $type->v_type;  ?></small>
                                    <p class="mb-0 p-0">
                                        <span class="badge text-light" style="background-color: black;">
                                            <?php echo $allrowcountObj->allrowcounter("vehicle_type JOIN vehicle ON vehicle.v_type_id=vehicle.v_type_id WHERE vehicle.v_status='available' and vehicle.v_type_id='$type->v_type_id' GROUP BY vehicle.v_id","DISTINCT *"); ?>
                                        </span>
                                    </p>
                                </a>
                                    
                            </li>
                <?php
                        }
                    }else{
                        echo "";
                    }
                ?>
            </ul>

            <!--ul class="list-unstyled CTAs">
                <li>
                    <a href="https://bootstrapious.com/tutorial/files/sidebar.zip" class="download">Download source</a>
                </li>
                <li>
                    <a href="https://bootstrapious.com/p/bootstrap-sidebar" class="article">Back to article</a>
                </li>
            </ul-->
        </div>
        </nav>

        <!-- Page Content Holder -->
        <div id="content" class="p-0">
            <nav class="navbar navbar-expand-md navbar-light bg-light mb-0 mx-2 pb-0" >
                <div class="d-flex w-50 order-0">
                    <button type="button" id="sidebarCollapse" class="navbar-btn">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
                <!--div class="navbar-collapse collapse justify-content-center order-2" id="collapsingNavbar">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a class="nav-link js-scroll-trigger text_primary_color" href="#vehicles">vehicle</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link js-scroll-trigger text_primary_color" href="#sale">Sale</a>
                        </li>
                    </ul>
                </div>
                <span class="navbar-text small text-truncate mt-1 w-50 text-right order-1 order-md-last"></span-->
            </nav>
            
            <div class="mx-2">
                <!--VEHICLE LIST-->
                <section >
                    <!--div class="container mb-3 bg-light shadow-sm px-3">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="text-center py-2">Trending <b></b></h4>
                                <hr class="bg_primary_color mx-auto mt-1 mb-4" style="max-width: 70px;border:1px solid rgba(14,11,162,0.95);">
                                <div id="myCarousel" class="carousel slide" data-ride="carousel" data-interval="4000">
                                <!-- Carousel indicators --
                                <ol class="carousel-indicators mx-auto" style="max-width: 80px !important;">
                                    <li data-target="#myCarousel" data-slide-to="0" class=" active" style="background-color: black !important"></li>
                                    <li data-target="#myCarousel" data-slide-to="1" class="" style="background-color: black !important"></li>
                                    <li data-target="#myCarousel" data-slide-to="2" class="" style="background-color: black !important"></li>
                                </ol>   
                                <!-- Wrapper for carousel items --
                                <div class="carousel-inner rounded px-2">
                                    <?php
                                        if($get_trending_vehicles!="1020"){
                                            //create a slider
                                            $trending_vehicles_count=count($get_trending_vehicles);
                                            $trending_vehicles_slide_count=ceil($trending_vehicles_count/4);
                                            
                                            for ($i=1; $i <=$trending_vehicles_slide_count ; $i++) { 
                                                if($i==1){
                                                    $trending_vehicles_slide_status="active";
                                                }else{
                                                    $trending_vehicles_slide_status="";
                                                }
                                        ?>
                                                <div class="item carousel-item <?php echo $trending_vehicles_slide_status ?>">
                                                    <div class="row">
                                                        <?php
                                                            $trending_vehicle_loop_count=0;
                                                            foreach ($get_trending_vehicles as $trending_vehicle) {
                                                                $trending_vehicle_loop_count++;
                                                        ?>
                                                                <div class="col-sm-3 shadow-sm">
                                                                    <div class="thumb-wrapper">
                                                                        <div class="img-box">
                                                                            <?php
                                                                                if(!empty($trending_vehicle->image)){
                                                                            ?>
                                                                                <img class="img-fluid" src="img/vehicles/<?php echo $trending_vehicle->image."?timestamp".time() ?>" alt="Image" />
                                                                            <?php
                                                                                }else{
                                                                                    echo "<p class='text-center'><span class='fas fa-car fa-5x'></span></p>";
                                                                                }
                                                                            ?>
                                                                        </div>
                                                                        <div class="thumb-content text-center">
                                                                            <h6><?php echo $trending_vehicle->v_name; ?> <span class="card-notify-year"><?php echo $trending_vehicle->v_year; ?></span></h6>
                                                                            <p class="item-price"><span>MWK <?php echo money_format("%!n", $trending_vehicle->v_price);?></p>
                                                                            <h5><span class="fas fa-honda"></span> <?php echo $trending_vehicle->v_make; ?></h5>
                                                                        </div>  
                                                                        <p class="text-center">
                                                                            <button  class="btn px-4 bg_primary_color text-light rounded-pill shadow-sm btn-sm" data-toggle="modal" data-target="#universalModalXl" onclick="vehicle_details_view(<?php echo $trending_vehicle->v_id; ?>)">
                                                                                <span class="fas fa-eye"></span> 
                                                                                View
                                                                            </button>
                                                                        </p>                    
                                                                    </div>
                                                                </div>

                                                        <?php
                                                                array_shift($get_trending_vehicles);
                                                                if($trending_vehicle_loop_count%4==0){
                                                                    break;
                                                                }
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                        <?php
                                            }
                                        }
                                    ?>
                                    
                                </div>
                                <!-- Carousel controls --
                                <a class="carousel-control left carousel-control-prev rounded" style="background-color: rgba(0,0,0,0.1); list-style-type: max-height:40px !important; max-width: 20px !important;" href="#myCarousel" data-slide="prev">
                                    <i class="fa fa-angle-left" style="color: black;"></i>
                                </a>
                                <a class="carousel-control right carousel-control-next rounded" style="background-color: rgba(0,0,0,0.1); list-style-type: max-height:40px !important; max-width: 20px !important;" href="#myCarousel" data-slide="next">
                                    <i class="fa fa-angle-right" style="color: black;"></i>
                                </a>
                            </div>
                            </div>
                        </div>
                    </div-->


                    <div class="p-2 shadow-sm" id="vehicle_main_section">
                        
                    </div>
                </section>

                    <?php
                        //get sold items
                      $current_date_minus_month=date('Y-m-d', strtotime($current_date. "-30 days"));
                      $get_vehicle_details=$retrieveObj->retriever("vehicle 
                          JOIN vehicle_type ON vehicle_type.v_type_id=vehicle.v_type_id 
                          JOIN vehicle_make ON vehicle_make.v_make_id=vehicle.v_make_id 
                          JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id 
                          WHERE vehicle_images.image_type='primary_image' and vehicle.v_status='sold' GROUP BY vehicle.v_id ORDER BY vehicle.v_id DESC","DISTINCT *","fetchAll");

                        if($get_vehicle_details!="1020"){
                    ?>
                    <div class="container-fluid shadow">
                        <div class="col-md-12 text-center h2 py-3">
                           ~ Previous sold vehicles ~
                        </div>
                        <div id="carouselExample" class="carousel slide" data-ride="carousel" data-interval="9000">
                            <div class="carousel-inner row w-100 mx-auto" role="listbox">
                                
                                <?php
                                    $sold_loop_count=0;
                                    foreach ($get_vehicle_details as $vehicle_detail) {
                                        $sold_loop_count+=1;
                                  ?>
                                        <div class="carousel-item col-md-3 <?php if($sold_loop_count==1){echo "active";} ?>">
                                            <div class="panel panel-default">
                                                <div class="panel-thumbnail">
                                                    <a href="#" title="image 2" class="thumb">
                                                    <?php
                                                    if(!empty($vehicle_detail->image)){
                                                    ?>
                                                        <a href="<?php echo 'img/vehicles/'.$vehicle_detail->image.'?timestamp'.time() ?>" class="fancybox" rel="ligthbox">
                                                              <?php 
                                                                  echo '<img style="max-height:130px;" class="m-1 img-fluid" src="img/vehicles/'.$vehicle_detail->image.'?timestamp'.time().'" alt="Image" />';  

                                                              ?>
                                                             
                                                        </a>
                                                    <?php
                                                        }else{
                                                            echo "<p class='text-center'><span class='fas fa-car fa-5x'></span></p>";
                                                        }
                                                    ?>
                                                    </a>

                                                    <p class="text-lead mt-2  mb-0 text-dark text-center">
                                                        <small class="font-weight-bold"><?php echo $vehicle_detail->v_name ?></small>
                                                    </p>
                                                
                                                    <div class="text-center my-2">
                                                        <span><?php echo $vehicle_detail->v_make?></span>
                                                    </div>
                                                </div>
                                            
                                            </div>
                                            
                                        </div>
                                  <?php
                                    }
                                  ?>
                            </div>
                            <a class="carousel-control-prev" href="#carouselExample" role="button" data-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="sr-only">Previous</span>
                            </a>
                            <a class="carousel-control-next text-faded" href="#carouselExample" role="button" data-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="sr-only">Next</span>
                            </a>
                        </div>
                    </div>
                    <?php
                      }
                    ?>
            </div>

            <div class="d-flex flex-column sticky-footer-wrapper mx-2">
                <nav>
                </nav>
                <main class="flex-fill">
                </main>
                
            </div>

        </div>
    </div>
    
    <?php include("footer.php"); ?>

    

    <!-- Modal -->
    <div id="universalModal" class="modal fade" role="dialog" style="z-index:9999">
          <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
              </div>
              <div class="modal-body" id="universalModalBody">
                
              </div>
            </div>
          </div>
        </div>
        <!-- Modal -->
        <div id="universalModalLg" class="modal fade" role="dialog" style="z-index:9999">
          <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
              </div>
              <div class="modal-body" id="universalModalLgBody">
                
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div id="universalModalXl" class="modal fade" role="dialog" style="z-index:9999">
          <div class="modal-dialog modal-xl">
            <!-- Modal content-->
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
              </div>
              <div class="modal-body" id="universalModalXlBody">
                
              </div>
            </div>
          </div>
        </div>
    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
      <i class="fas fa-angle-up"></i>
    </a>

    <!-- jQuery CDN - Slim version (=without AJAX) -->
    <script src="assets/js/jquery.min.js"></script>
   
    <!-- Popper.JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
    <!-- Bootstrap JS -->
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/jquery-easing/jquery.easing.min.js"></script>
    <script type="text/javascript" src="assets/croppie/croppie.js"></script>
    <script src="js/universal.js?<?php echo date("Y-m-d").time() ?>"></script>
    <script src="js/vehicle.js?<?php echo date("Y-m-d").time() ?>"></script>
    <script type="text/javascript" src="https://www.netsoftmoney.com/api/api2.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.js?<?php echo date("Y-m-d").time() ?>"></script>

    <div id="paypal-button-container"></div>

    <script type="text/javascript" src="js/ex_items.js?<?php echo date("Y-m-d").time() ?>"></script>
    <script type="text/javascript">
        //load all cars on main section
        function load_vehicle_main_section(){
            loading("vehicle_main_section");
            $("#vehicle_main_section").load("includes_/vehicle/vehicles.php");
        }
        $(document).ready(function () {
            load_vehicle_main_section();


            $('#sidebarCollapse').on('click', function () {
                $('#sidebar').toggleClass('active');
                $(this).toggleClass('active');

                if(document.getElementById("inner_v_sidebar")!=null){
                    if($(".sidebar").hasClass("active")){
                        $("#MultiCarousel").css({ 'transform': 'translateX(0px)', 'width': ex_width_var });
                    }else{
                        $("#MultiCarousel").css({ 'transform': 'translateX(0px)', 'width': ex_width_var });
                    }
                  }
            });

            $("#vehicle_nav_link").addClass("bg-white");
            $("#vehicle_nav_link").addClass("rounded-pill");
            $("#vehicle_nav_link").addClass("shadow-sm");
        });
    </script>

    <script type="text/javascript">
          //loading_overlay_onload()
          $(document).ready(function(){
      
            //fancy box
            $(".fancybox").fancybox({
                  openEffect: "none",
                  closeEffect: "none"
              });
              
              $(".zoom").hover(function(){
              
              $(this).addClass('transition');
            }, function(){
                  
              $(this).removeClass('transition');
            });
          });
    </script>
    


</body>

</html>