var allowed_file_size 	= "1048576"; //1 MB allowed file size
//var allowed_file_types 	= [ 'image/png', 'image/gif', 'image/jpeg', 'image/pjpeg', 
//							'application/x-zip-compressed', 'application/pdf', 'application/msword', 
//							'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
//							]; //Allowed file types
var allowed_file_types 	= [ 'image/png', 'image/jpeg', 'image/jpg']; //Allowed file types
var allowed_file_attachment_types = [
                                    'application/pdf'                                    
                                    ]; //Allowed file types
var border_color 		= "#C2C2C2"; //initial input border color
var maximum_files 		= 1; //Maximum number of files allowed

//=======================================================================================================================


/*******************************
ADD CATEGORY
********************************
*/
function addCategory(){
     $(document).ready(function() {
        $("#btn_cat").attr("disabled", "disabled");

            var category_name = $('#category_name').val();


            if(category_name !="" ){


            $.ajax({
                url: "operations/handler.php",
                method: "POST",
                data: {
                    category_name: category_name

                },
                cache: false,
                success: function(data) {
                    
                    if(data == 1){
                        $('#response').html("<br><br><p class='alert alert-success'><small style='color:black; background:green;'>Category added</small></p>");
                         $("#btn_cat").removeAttr("disabled");
                    }else{
                        $('#response').html("<br><br><p class='alert alert-warning'><small style='color:black; background:red;'>Category not added</small><p/>");
                    }
                    
                    
                   
                }
        });
        }else{
            alert("Fill all required fields...");
            $("#submitDepart").removeAttr("disabled");
        }

    });
}

/*******************************
ADD PRODUCTS
********************************
*/
function addProduct(){
     $('#product_form').one('submit', function(event){  
        event.preventDefault();  

        proceed = true;
	
	//simple input validation
	$($(this).find("input[data-required=true], textarea[data-required=true], select[data-required=true]")).each(function(){
            if(!$.trim($(this).val())){ //if this field is empty 
                $(this).css('border-color','red'); //change border color to red   
                proceed = false; //set do not proceed flag
            }           
	}).on("input", function(){ //change border color to original
		 $(this).css('border-color', border_color);
	});
	
	//check file size and type before upload, works in all modern browsers
	if(window.File && window.FileReader && window.FileList && window.Blob){
		var total_files_size = 0;
		if(this.elements['file_attach'].files.length > maximum_files){
            $('#response').html( "<br><br><p class='alert alert-warning'><small style='color:red;'>Can not select more than "+maximum_files+" file(s)</small></p>");
            proceed = false;			
		}
		$(this.elements['file_attach'].files).each(function(i, ifile){
			if(ifile.value !== ""){ //continue only if file(s) are selected
                if(allowed_file_types.indexOf(ifile.type) === -1){ //check unsupported file
                    $('#response').html(ifile.name + " is not allowed!");
                    proceed = false;
                }
             total_files_size = total_files_size + ifile.size; //add file size to total size
			}
		}); 
       if(total_files_size > allowed_file_size){ 
            $('#response').html("<br><br><p class='alert alert-warning'><small style='color:red;'>Make sure total file size is less than 1 MB!</small></p>");
            proceed = false;
        }
	}
	
	var post_url = "operations/handler.php"; //get form action url
	var request_method = "POST"; //get form GET/POST method
	var form_data = new FormData(this); //Creates new FormData object
	
	//if everything's ok, continue with Ajax form submit
	if(proceed){ 
		$.ajax({ //ajax form submit
			url : post_url,
			type: request_method,
			data : form_data,
			
			contentType: false,
			cache: false,
			processData:false
		}).done(function(data){ //fetch server "json" messages when done
			if(data == 1){
                $('#response').html("<br><br><p class='alert alert-success'><small style='color:black; background:green;'>Product added</small></p>");
            }else{
                $('#response').html("<br><br><p class='alert alert-warning'><small style='color:black; background:red;'>Product not added</small></p>");
            }
//            $('#response').html(data);
		});
	}

        
  });
}